/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.model;

import com.haiyisoft.ep.common.db.Column;
import com.haiyisoft.ep.common.db.DataSetUtil;
import com.haiyisoft.ep.common.db.Record;
import com.haiyisoft.ep.common.db.dataset.ClientDataSet;
import com.haiyisoft.ep.common.db.dataset.DBQuery;
import com.haiyisoft.ep.common.db.dataset.DataSet;
import com.haiyisoft.ep.common.model.PageInfo;
import com.haiyisoft.ep.common.model.QueryParamList;
import com.haiyisoft.ep.exception.BaseRunException;
import com.haiyisoft.ep.exception.FrameworkException;
import com.haiyisoft.ep.framework.ui.struts2.model.AjaxDataWrap;
import com.haiyisoft.ep.framework.util.AjaxDataSetUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.struts2.json.annotations.JSON;
import org.codehaus.jackson.map.ObjectMapper;

public class AjaxDataSetWrap
extends AjaxDataWrap<Record> {
    private List<Record> oriDataList = new ArrayList<Record>();
    protected DataSet dataSet;

    @JSON(serialize=false)
    public List<Record> getOriDataList() {
        return this.oriDataList;
    }

    public void setOriDataList(List<Record> oriDataList) {
        this.oriDataList = oriDataList;
    }

    @JSON(serialize=false)
    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
        if (dsName != null && this.dataSet == null) {
            this.dataSet = DataSetUtil.createClientDataSet((String)dsName);
            this.dataSet.setCacheFlag(true);
        }
    }

    @JSON(name="formDataList")
    public List<Record> getDataList() {
        return super.getDataList();
    }

    @JSON(name="formData")
    public Record getData() {
        return (Record)super.getData();
    }

    @JSON(serialize=false)
    public ClientDataSet getClientDataSet() {
        if (this.dataSet == null) {
            new FrameworkException("\u7ed3\u679c\u96c6\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\u5f53\u524d\u6570\u636e\u96c6\u540d\u79f0\u4e3a\uff1a" + this.dsName + "\uff0c\u8bf7\u68c0\u67e5\uff01").handle();
        }
        return (ClientDataSet)this.dataSet;
    }

    @JSON(serialize=false)
    public int getTotalCount() {
        return this.dataList.size();
    }

    public int retrieve(Object ... args) {
        return this.retrieve(null, args);
    }

    public int retrieve(QueryParamList params, Object ... args) {
        ArrayList customExtParam;
        String extendQuery = null;
        ArrayList extParam = new ArrayList();
        String extSortString = null;
        ClientDataSet queryDataSet = this.getClientDataSet();
        ArrayList queryExtParamList = new ArrayList();
        extendQuery = AjaxDataSetUtil.dealQueryParamExtend((QueryParamList)params, (Column[])queryDataSet.getQuery().getColumns(), queryExtParamList);
        if (extendQuery != null) {
            queryDataSet.appendWhereStatement(extendQuery, queryExtParamList, true);
        }
        if ((extendQuery = AjaxDataSetUtil.dealCommonQueryExtend((Map)this.query, extParam, (Column[])queryDataSet.getQuery().getColumns())) != null) {
            queryDataSet.appendWhereStatement(extendQuery, extParam, true);
        }
        if (this.queryClause != null && (extendQuery = AjaxDataSetUtil.dealCustomQueryExtend((String)this.queryClause, customExtParam = new ArrayList(), (Column[])queryDataSet.getQuery().getColumns())) != null) {
            queryDataSet.appendWhereStatement(extendQuery, customExtParam, true);
        }
        if ((extSortString = AjaxDataSetUtil.dealCustomSortExtend((String)this.getSortString())) != null) {
            queryDataSet.appendSortStatement(extSortString);
        }
        if (this.getPageInfo() != null && this.getPageInfo().getRowOfPage() > 0) {
            queryDataSet.setPageMode(true);
            queryDataSet.setPageInfo(this.getPageInfo());
        }
        queryDataSet.executeQuery(args);
        this.setPageInfo(queryDataSet.getPageInfo());
        this.dataList = queryDataSet.getDataList();
        if (this.dataList.size() > 0) {
            this.data = (Record)this.dataList.get(0);
        }
        return this.dataList.size();
    }

    public int update() {
        return this.getClientDataSet().update();
    }

    public int update(boolean reset) {
        return this.getClientDataSet().update(reset);
    }

    public Record addRecord() {
        ClientDataSet queryDataSet = this.getClientDataSet();
        int index = queryDataSet.addRecord();
        this.data = queryDataSet.getRecordByIndex(index);
        return (Record)this.data;
    }

    public Record getRecordByIndex(int index) {
        if (index <= this.dataList.size() - 1) {
            return (Record)this.dataList.get(index);
        }
        return null;
    }

    public void resetData() {
        this.insertList.clear();
        this.updateList.clear();
        this.deleteList.clear();
        this.data = null;
    }

    @Override
    public void prepare(String dwName, int dataSize, Map<String, Object> parameters, Class<Record> elementClass) {
        if (parameters.get(String.valueOf(dwName) + ".dsName") != null && ((String[])parameters.get(String.valueOf(dwName) + ".dsName")).length > 0) {
            this.setDsName(((String[])parameters.get(String.valueOf(dwName) + ".dsName"))[0]);
            parameters.remove(String.valueOf(dwName) + ".dsName");
        }
        if (parameters.get(String.valueOf(dwName) + ".jsonData") != null && ((String[])parameters.get(String.valueOf(dwName) + ".jsonData")).length > 0) {
            String jsonData = ((String[])parameters.get(String.valueOf(dwName) + ".jsonData"))[0];
            parameters.remove(String.valueOf(dwName) + ".jsonData");
            this.convertJsonData(jsonData);
        }
    }

    @Override
    public void convertJsonData(String jsonData) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        try {
            Map map = (Map)objectMapper.readValue(jsonData, Map.class);
            if (map.get("dsName") != null && !"".equals(map.get("dsName"))) {
                this.setDsName(map.get("dsName").toString());
            }
            Column[] columns = this.getClientDataSet().getQuery().getColumns();
            BasicDynaClass dynaClass = new BasicDynaClass("result", null, (DynaProperty[])columns);
            if (map.get("oriDataList") != null && !"".equals(map.get("oriDataList"))) {
                this.oriDataList = AjaxDataSetUtil.toObjectList((String)objectMapper.writeValueAsString(map.get("oriDataList")), (ObjectMapper)objectMapper, (BasicDynaClass)dynaClass);
                this.getClientDataSet().setOriDataList(this.oriDataList);
            }
            if (map.get("dataList") != null && !"".equals(map.get("dataList"))) {
                this.dataList = AjaxDataSetUtil.toObjectList((String)objectMapper.writeValueAsString(map.get("dataList")), (ObjectMapper)objectMapper, (BasicDynaClass)dynaClass);
                this.getClientDataSet().setDataList(this.dataList);
                if (map.get("needUpdate") != null && "Y".equals(map.get("needUpdate"))) {
                    this.genDelRecords();
                    this.genInsertRecords();
                    this.genUpdateRecords();
                }
            }
            if (map.get("data") != null && !"".equals(map.get("data"))) {
                Map dataMap = (Map)objectMapper.readValue(objectMapper.writeValueAsString(map.get("data")), Map.class);
                this.data = AjaxDataSetUtil.convertMapToRecord((Map)dataMap, (BasicDynaClass)dynaClass);
            }
            if (map.get("pageInfo") != null && !"".equals(map.get("pageInfo"))) {
                this.setPageInfo((PageInfo)objectMapper.readValue(objectMapper.writeValueAsString(map.get("pageInfo")), PageInfo.class));
            }
            if (map.get("query") != null && !"".equals(map.get("query"))) {
                this.setQuery((Map)objectMapper.readValue(objectMapper.writeValueAsString(map.get("query")), Map.class));
            }
            if (map.get("sortString") != null && !"".equals(map.get("sortString"))) {
                this.setSortString(map.get("sortString").toString());
            }
            if (map.get("queryClause") != null && !"".equals(map.get("queryClause"))) {
                this.setQueryClause(map.get("queryClause").toString());
            }
        }
        catch (Exception e) {
            new BaseRunException("\u8f6c\u6362JSON\u683c\u5f0f\u7684\u6570\u636e\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)e).handle();
        }
    }

    private void genDelRecords() {
        for (Record oriRec : this.oriDataList) {
            Integer oriRowID = (Integer)oriRec.get("rowID");
            boolean exists = false;
            for (Record rec : this.dataList) {
                Integer rowID = (Integer)rec.get("rowID");
                if (oriRowID == null || rowID == null || !oriRowID.equals(rowID)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.deleteList.add(oriRec);
        }
    }

    private void genInsertRecords() {
        for (Record rec : this.dataList) {
            Integer rowID = (Integer)rec.get("rowID");
            boolean exists = false;
            for (Record oriRec : this.oriDataList) {
                Integer oriRowID = (Integer)oriRec.get("rowID");
                if (oriRowID == null || rowID == null || !oriRowID.equals(rowID)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.insertList.add(rec);
        }
    }

    private void genUpdateRecords() {
        DBQuery dbQuery = this.getClientDataSet().getQuery();
        block0: for (Record rec : this.dataList) {
            Integer rowID = (Integer)rec.get("rowID");
            for (Record oriRec : this.oriDataList) {
                Integer oriRowID = (Integer)oriRec.get("rowID");
                if (oriRowID == null || rowID == null || !oriRowID.equals(rowID)) continue;
                if (rec.updatableEquals(oriRec, dbQuery.getColumns(), dbQuery.getUpdatableTable())) continue block0;
                this.updateList.add(rec);
                continue block0;
            }
        }
    }
}

