/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.interceptors;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.security.AcceptedPatternsChecker;
import com.opensymphony.xwork2.security.ExcludedPatternsChecker;
import com.opensymphony.xwork2.util.ClearableValueStack;
import com.opensymphony.xwork2.util.MemberAccessValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;

public class ParametersInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LogManager.getLogger(ParametersInterceptor.class);
    protected static final int PARAM_NAME_MAX_LENGTH = 100;
    private int paramNameMaxLength = 100;
    private boolean devMode = false;
    protected boolean ordered = false;
    private ValueStackFactory valueStackFactory;
    private ExcludedPatternsChecker excludedPatterns;
    private AcceptedPatternsChecker acceptedPatterns;
    static final Comparator<String> rbCollator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int l2;
            int l1 = ParametersInterceptor.countOGNLCharacters(s1);
            return l1 < (l2 = ParametersInterceptor.countOGNLCharacters(s2)) ? -1 : (l2 < l1 ? 1 : s1.compareTo(s2));
        }
    };

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject
    public void setExcludedPatterns(ExcludedPatternsChecker excludedPatterns) {
        this.excludedPatterns = excludedPatterns;
    }

    @Inject
    public void setAcceptedPatterns(AcceptedPatternsChecker acceptedPatterns) {
        this.acceptedPatterns = acceptedPatterns;
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }

    private static int countOGNLCharacters(String s) {
        int count = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '.' || c == '[') {
                ++count;
            }
            --i;
        }
        return count;
    }

    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (!(action instanceof NoParameters)) {
            ActionContext ac = invocation.getInvocationContext();
            HttpParameters parameters = this.retrieveParameters(ac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting params {}", (Object)this.getParameterLogMap(parameters));
            }
            if (parameters != null) {
                Map contextMap = ac.getContextMap();
                try {
                    ReflectionContextState.setCreatingNullObjects((Map)contextMap, (boolean)true);
                    ReflectionContextState.setDenyMethodExecution((Map)contextMap, (boolean)true);
                    ReflectionContextState.setReportingConversionErrors((Map)contextMap, (boolean)true);
                    ValueStack stack = ac.getValueStack();
                    this.setParameters(action, stack, parameters);
                }
                finally {
                    ReflectionContextState.setCreatingNullObjects((Map)contextMap, (boolean)false);
                    ReflectionContextState.setDenyMethodExecution((Map)contextMap, (boolean)false);
                    ReflectionContextState.setReportingConversionErrors((Map)contextMap, (boolean)false);
                }
            }
        }
        return invocation.invoke();
    }

    protected HttpParameters retrieveParameters(ActionContext ac) {
        return ac.getParameters();
    }

    protected void addParametersToContext(ActionContext ac, Map<String, ?> newParams) {
    }

    protected void setParameters(Object action, ValueStack stack, HttpParameters parameters) {
        boolean memberAccessStack;
        TreeMap<Object, Parameter> acceptableParameters;
        HttpParameters params;
        if (this.ordered) {
            params = HttpParameters.create().withComparator(this.getOrderedComparator()).withParent(parameters).build();
            acceptableParameters = new TreeMap(this.getOrderedComparator());
        } else {
            params = HttpParameters.create().withParent(parameters).build();
            acceptableParameters = new TreeMap();
        }
        for (String name : params.keySet()) {
            Parameter parameter = params.get((Object)name);
            if (!this.isAcceptableParameter(name, action)) continue;
            acceptableParameters.put(name, parameter);
        }
        ValueStack newStack = this.valueStackFactory.createValueStack(stack);
        boolean clearableStack = newStack instanceof ClearableValueStack;
        if (clearableStack) {
            ((ClearableValueStack)newStack).clearContextValues();
            Map context = newStack.getContext();
            ReflectionContextState.setCreatingNullObjects((Map)context, (boolean)true);
            ReflectionContextState.setDenyMethodExecution((Map)context, (boolean)true);
            ReflectionContextState.setReportingConversionErrors((Map)context, (boolean)true);
            context.put("com.opensymphony.xwork2.ActionContext.locale", stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale"));
        }
        if (memberAccessStack = newStack instanceof MemberAccessValueStack) {
            MemberAccessValueStack accessValueStack = (MemberAccessValueStack)newStack;
            accessValueStack.setAcceptProperties(this.acceptedPatterns.getAcceptedPatterns());
            accessValueStack.setExcludeProperties(this.excludedPatterns.getExcludedPatterns());
        }
        boolean goWithButtonFlag = true;
        for (Map.Entry entry : acceptableParameters.entrySet()) {
            String name = (String)entry.getKey();
            Parameter value = (Parameter)entry.getValue();
            if ("goWithButtonFlag".equals(name)) {
                String s = value.getValue();
                goWithButtonFlag = Boolean.valueOf(s);
                continue;
            }
            try {
                newStack.setParameter(name, value.getObject());
            }
            catch (RuntimeException e) {
                if (!this.devMode) continue;
                this.notifyDeveloperParameterException(action, name, e.getMessage());
            }
        }
        if (clearableStack && stack.getContext() != null && newStack.getContext() != null && goWithButtonFlag) {
            stack.getContext().put("com.opensymphony.xwork2.ActionContext.conversionErrors", newStack.getContext().get("com.opensymphony.xwork2.ActionContext.conversionErrors"));
        }
        this.addParametersToContext(ActionContext.getContext(), acceptableParameters);
    }

    protected void notifyDeveloperParameterException(Object action, String property, String message) {
        String developerNotification = "Unexpected Exception caught setting '" + property + "' on '" + action.getClass() + ": " + message;
        if (action instanceof TextProvider) {
            TextProvider tp = (TextProvider)action;
            developerNotification = tp.getText("devmode.notification", "Developer Notification:\n{0}", new String[]{developerNotification});
        }
        LOG.error(developerNotification);
        if (action instanceof ValidationAware) {
            Collection messages = ((ValidationAware)action).getActionMessages();
            messages.add(message);
            ((ValidationAware)action).setActionMessages(messages);
        }
    }

    protected boolean isAcceptableParameter(String name, Object action) {
        ParameterNameAware parameterNameAware;
        ParameterNameAware parameterNameAware2 = parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        return this.acceptableName(name) && (parameterNameAware == null || parameterNameAware.acceptableParameterName(name));
    }

    protected Comparator<String> getOrderedComparator() {
        return rbCollator;
    }

    protected String getParameterLogMap(HttpParameters parameters) {
        if (parameters == null) {
            return "NONE";
        }
        StringBuilder logEntry = new StringBuilder();
        for (String name : parameters.keySet()) {
            logEntry.append(String.valueOf(name));
            logEntry.append(" => ");
            logEntry.append(parameters.get((Object)name).getValue());
        }
        return logEntry.toString();
    }

    protected boolean acceptableName(String name) {
        boolean accepted;
        boolean bl = accepted = this.isWithinLengthLimit(name) && !this.isExcluded(name) && this.isAccepted(name);
        if (this.devMode && accepted) {
            LOG.debug("Parameter [{}] was accepted and will be appended to action!", (Object)name);
        }
        return accepted;
    }

    protected boolean isWithinLengthLimit(String name) {
        boolean matchLength;
        boolean bl = matchLength = name.length() <= this.paramNameMaxLength;
        if (!matchLength) {
            LOG.debug("Parameter [{}] is too long, allowed length is [{}]", (Object)name, (Object)String.valueOf(this.paramNameMaxLength));
        }
        return matchLength;
    }

    protected boolean isAccepted(String paramName) {
        AcceptedPatternsChecker.IsAccepted result = this.acceptedPatterns.isAccepted(paramName);
        if (result.isAccepted()) {
            return true;
        }
        LOG.debug("Parameter [{}] didn't match accepted pattern [{}]!", (Object)paramName, (Object)result.getAcceptedPattern());
        return false;
    }

    protected boolean isExcluded(String paramName) {
        ExcludedPatternsChecker.IsExcluded result = this.excludedPatterns.isExcluded(paramName);
        if (result.isExcluded()) {
            LOG.debug("Parameter [{}] matches excluded pattern [{}]!", (Object)paramName, (Object)result.getExcludedPattern());
            return true;
        }
        return false;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setAcceptParamNames(String commaDelim) {
        this.acceptedPatterns.setAcceptedPatterns(commaDelim);
    }

    public void setExcludeParams(String commaDelim) {
        this.excludedPatterns.setExcludedPatterns(commaDelim);
    }
}

