/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.file;

import com.haiyisoft.ep.framework.exception.BaseConfirmException;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.LocaleProviderFactory;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.Parameter;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.apache.struts2.util.ContentTypeMatcher;

public class FileUploadInterceptor
extends org.apache.struts2.interceptor.FileUploadInterceptor {
    protected static final Logger LOG = LoggerFactory.getLogger(FileUploadInterceptor.class);
    private static final long serialVersionUID = -4764627478894962478L;
    private ContentTypeMatcher matcher;
    private Container container;

    @Inject
    public void setMatcher(ContentTypeMatcher matcher) {
        this.matcher = matcher;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    public void setAllowedExtensions(String allowedExtensions) {
        this.allowedExtensionsSet = TextParseUtil.commaDelimitedStringToSet((String)allowedExtensions);
    }

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypesSet = TextParseUtil.commaDelimitedStringToSet((String)allowedTypes);
    }

    public void setMaximumSize(Long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        String allowedExtensions;
        String allowedTypes;
        String maxiSize;
        MultiPartRequestWrapper multiWrapper;
        ActionContext ac = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        if (!(request instanceof MultiPartRequestWrapper)) {
            if (LOG.isDebugEnabled()) {
                ActionProxy proxy = invocation.getProxy();
                LOG.debug(this.getTextMessage("struts.messages.bypass.request", new String[]{proxy.getNamespace(), proxy.getActionName()}), new String[0]);
            }
            return invocation.invoke();
        }
        ValidationAware validation = null;
        Object action = invocation.getAction();
        if (action instanceof ValidationAware) {
            validation = (ValidationAware)action;
        }
        if ((multiWrapper = (MultiPartRequestWrapper)request).hasErrors() && validation != null) {
            TextProvider textProvider = this.getTextProvider(action);
            for (LocalizedMessage error : multiWrapper.getErrors()) {
                String errorMessage = textProvider.hasKey(error.getTextKey()) ? textProvider.getText(error.getTextKey(), Arrays.asList(error.getArgs())) : textProvider.getText("struts.messages.error.uploading", error.getDefaultMessage());
                validation.addActionError(errorMessage);
            }
        }
        boolean selfMaxiSize = false;
        boolean selfAllowedTypesSet = false;
        boolean selfAllowedExtensionsSet = false;
        if (this.maximumSize == null && (maxiSize = ServletActionContext.getRequest().getParameter("maxiSize")) != null && !"".equals(maxiSize)) {
            this.maximumSize = Long.valueOf(maxiSize);
            selfMaxiSize = true;
        }
        if (!(this.allowedTypesSet != null && this.allowedTypesSet.size() != 0 || (allowedTypes = ServletActionContext.getRequest().getParameter("allowedTypes")) == null || "".equals(allowedTypes))) {
            this.allowedTypesSet = TextParseUtil.commaDelimitedStringToSet((String)allowedTypes);
            selfAllowedTypesSet = true;
        }
        if (!(this.allowedExtensionsSet != null && this.allowedExtensionsSet.size() != 0 || (allowedExtensions = ServletActionContext.getRequest().getParameter("allowedExtensions")) == null || "".equals(allowedExtensions))) {
            this.allowedExtensionsSet = TextParseUtil.commaDelimitedStringToSet((String)allowedExtensions);
            selfAllowedExtensionsSet = true;
        }
        Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            String inputName = (String)fileParameterNames.nextElement();
            Object[] contentType = multiWrapper.getContentTypes(inputName);
            if (this.isNonEmpty(contentType)) {
                Object[] fileName = multiWrapper.getFileNames(inputName);
                if (this.isNonEmpty(fileName)) {
                    UploadedFile[] files = multiWrapper.getFiles(inputName);
                    if (files == null || files.length <= 0) continue;
                    ArrayList<UploadedFile> acceptedFiles = new ArrayList<UploadedFile>(files.length);
                    ArrayList<Object> acceptedContentTypes = new ArrayList<Object>(files.length);
                    ArrayList<Object> acceptedFileNames = new ArrayList<Object>(files.length);
                    String contentTypeName = String.valueOf(inputName) + "ContentType";
                    String fileNameName = String.valueOf(inputName) + "FileName";
                    int index = 0;
                    while (index < files.length) {
                        if (this.acceptFile(action, files[index], (String)fileName[index], (String)contentType[index], inputName, validation)) {
                            acceptedFiles.add(files[index]);
                            acceptedContentTypes.add(contentType[index]);
                            acceptedFileNames.add(fileName[index]);
                        }
                        ++index;
                    }
                    if (acceptedFiles.isEmpty()) continue;
                    HashMap<String, Parameter.File> newParams = new HashMap<String, Parameter.File>();
                    newParams.put(inputName, new Parameter.File(inputName, (Object)acceptedFiles.toArray(new UploadedFile[acceptedFiles.size()])));
                    newParams.put(contentTypeName, new Parameter.File(contentTypeName, (Object)acceptedContentTypes.toArray(new String[acceptedContentTypes.size()])));
                    newParams.put(fileNameName, new Parameter.File(fileNameName, (Object)acceptedFileNames.toArray(new String[acceptedFileNames.size()])));
                    ac.getParameters().appendAll(newParams);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(this.getTextMessage(action, "struts.messages.invalid.file", new String[]{inputName}), new String[0]);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn(this.getTextMessage(action, "struts.messages.invalid.content.type", new String[]{inputName}), new String[0]);
        }
        String result = invocation.invoke();
        if (selfMaxiSize) {
            this.maximumSize = null;
        }
        if (selfAllowedExtensionsSet) {
            this.allowedExtensionsSet = Collections.emptySet();
        }
        if (selfAllowedTypesSet) {
            this.allowedTypesSet = Collections.emptySet();
        }
        return result;
    }

    protected boolean acceptFile(Object action, UploadedFile file, String filename, String contentType, String inputName, ValidationAware validation) {
        boolean fileIsAcceptable = false;
        if (file == null) {
            String errMsg = this.getTextMessage(action, "struts.messages.error.uploading", new String[]{inputName});
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(errMsg, new String[0]);
            }
        } else {
            if (this.maximumSize != null && this.maximumSize < file.length()) {
                String errMsg = this.getTextMessage(action, "struts.messages.error.file.too.large", new String[]{inputName, filename, file.getName(), "" + file.length(), this.getMaximumSizeStr(action)});
                if (validation != null) {
                    validation.addFieldError(inputName, errMsg);
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn(errMsg, new String[0]);
                }
                throw new BaseConfirmException("\u4e0a\u4f20\u7684\u6587\u4ef6\u592a\u5927\uff0c \u8bf7\u91cd\u65b0\u9009\u62e9\u2026\u2026");
            }
            if (!this.allowedTypesSet.isEmpty() && !this.containsItem(this.allowedTypesSet, contentType)) {
                String errMsg = this.getTextMessage(action, "struts.messages.error.content.type.not.allowed", new String[]{inputName, filename, file.getName(), contentType});
                if (validation != null) {
                    validation.addFieldError(inputName, errMsg);
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn(errMsg, new String[0]);
                }
                throw new BaseConfirmException("\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5bf9\uff0c \u8bf7\u91cd\u65b0\u9009\u62e9\u2026\u2026");
            }
            if (!this.allowedExtensionsSet.isEmpty() && !this.hasAllowedExtension(this.allowedExtensionsSet, filename)) {
                String errMsg = this.getTextMessage(action, "struts.messages.error.file.extension.not.allowed", new String[]{inputName, filename, file.getName(), contentType});
                if (validation != null) {
                    validation.addFieldError(inputName, errMsg);
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn(errMsg, new String[0]);
                }
                throw new BaseConfirmException("\u4e0a\u4f20\u7684\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u5bf9\uff0c \u8bf7\u91cd\u65b0\u9009\u62e9\u2026\u2026");
            }
            fileIsAcceptable = true;
        }
        return fileIsAcceptable;
    }

    private String getMaximumSizeStr(Object action) {
        return NumberFormat.getNumberInstance(this.getLocaleProvider(action).getLocale()).format(this.maximumSize);
    }

    private boolean hasAllowedExtension(Collection<String> extensionCollection, String filename) {
        if (filename == null) {
            return false;
        }
        String lowercaseFilename = filename.toLowerCase();
        for (String extension : extensionCollection) {
            if (!lowercaseFilename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItem(Collection<String> itemCollection, String item) {
        for (String pattern : itemCollection) {
            if (!this.matchesWildcard(pattern, item)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesWildcard(String pattern, String text) {
        Object o = this.matcher.compilePattern(pattern);
        return this.matcher.match(new HashMap(), text, o);
    }

    private boolean isNonEmpty(Object[] objArray) {
        boolean result = false;
        int index = 0;
        while (index < objArray.length && !result) {
            if (objArray[index] != null) {
                result = true;
            }
            ++index;
        }
        return result;
    }

    protected String getTextMessage(String messageKey, String[] args) {
        return this.getTextMessage((Object)this, messageKey, args);
    }

    protected String getTextMessage(Object action, String messageKey, String[] args) {
        if (action instanceof TextProvider) {
            return ((TextProvider)action).getText(messageKey, args);
        }
        return this.getTextProvider(action).getText(messageKey, args);
    }

    private TextProvider getTextProvider(Object action) {
        TextProviderFactory tpf = (TextProviderFactory)this.container.getInstance(TextProviderFactory.class);
        return tpf.createInstance(action.getClass());
    }

    private LocaleProvider getLocaleProvider(Object action) {
        LocaleProvider localeProvider;
        if (action instanceof LocaleProvider) {
            localeProvider = (LocaleProvider)action;
        } else {
            LocaleProviderFactory localeProviderFactory = (LocaleProviderFactory)this.container.getInstance(LocaleProviderFactory.class);
            localeProvider = localeProviderFactory.createLocaleProvider();
        }
        return localeProvider;
    }
}

