/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.dispatcher;

import com.haiyisoft.ep.framework.ui.struts2.dispatcher.FileStreamResult;
import com.opensymphony.xwork2.ActionInvocation;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class POIStreamResult
extends FileStreamResult {
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        OutputStream oOutput = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = (SXSSFWorkbook)invocation.getStack().findValue(finalLocation);
            HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            if (this.contentCharSet != null && !this.contentCharSet.equals("")) {
                oResponse.setContentType(String.valueOf(this.conditionalParse(this.contentType, invocation)) + ";charset=" + this.contentCharSet);
            } else {
                oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            }
            if (this.contentLength != null) {
                String _contentLength = this.conditionalParse(this.contentLength, invocation);
                int _contentLengthAsInt = -1;
                try {
                    _contentLengthAsInt = Integer.parseInt(_contentLength);
                    if (_contentLengthAsInt >= 0) {
                        oResponse.setContentLength(_contentLengthAsInt);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn("failed to recongnize " + _contentLength + " as a number, contentLength header will not be set", (Throwable)e);
                }
            }
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-Disposition", this.conditionalParseHeader(this.contentDisposition, invocation));
            }
            if (!this.allowCaching) {
                oResponse.addHeader("Pragma", "no-cache");
                oResponse.addHeader("Cache-Control", "no-cache");
            }
            oOutput = oResponse.getOutputStream();
            if (workbook != null) {
                workbook.write(oOutput);
            }
            oOutput.flush();
        }
        finally {
            if (workbook != null) {
                workbook.dispose();
            }
            if (oOutput != null) {
                oOutput.close();
            }
        }
    }
}

