/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2.action;

import com.emms.framework.monitor.msgsend.MonitorUtil;
import com.haiyisoft.ep.exception.BaseRunException;
import com.haiyisoft.ep.framework.conf.AppConfig;
import com.haiyisoft.ep.framework.exception.BaseConfirmException;
import com.haiyisoft.ep.framework.util.ApplicationUtil;
import com.haiyisoft.ep.log.LogUtil;
import com.haiyisoft.support.exception.ServiceCallException;
import com.haiyisoft.support.exception.ServicePromptException;
import com.opensymphony.xwork2.ActionSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public abstract class DispatchAction
extends ActionSupport {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogUtil.getFrameworkLoger();
    protected Class<? extends DispatchAction> clazz = ((Object)((Object)this)).getClass();
    protected String action;

    public String execute() throws Exception {
        if (this.action == null || this.action.trim().length() == 0) {
            this.action = "init";
        }
        return this.dispatchMethod();
    }

    public abstract String init() throws Exception;

    protected String dispatchMethod() throws Exception {
        Method method = null;
        try {
            method = this.getMethod(this.action);
        }
        catch (NoSuchMethodException ex) {
            logger.error((Object)"action\u5206\u6d3e\u65b9\u6cd5\u51fa\u9519!", (Throwable)ex);
            throw new BaseRunException("\u8c03\u7528\u7684action\u65b9\u6cd5:" + this.action + "\u4e0d\u5b58\u5728!", (Throwable)ex);
        }
        boolean canExecute = false;
        AppConfig appConfig = ApplicationUtil.getAppConfig();
        canExecute = appConfig.isRunInDebugMode() || !appConfig.isPerformSafetyMethodIntercept() ? true : true;
        String retStr = "none";
        if (canExecute) {
            try {
                retStr = (String)method.invoke((Object)this, new Object[0]);
            }
            catch (Exception ex) {
                String domainName = (String)ApplicationUtil.getAppConfig().getAppExtProp().get("instanceName");
                if (domainName == null || domainName.trim().length() == 0) {
                    domainName = "weblogic.Name";
                }
                String weblogicName = System.getProperty(domainName);
                String errorInfo = "";
                if (ex instanceof InvocationTargetException) {
                    Throwable causeEx = ex.getCause();
                    if (causeEx instanceof BaseConfirmException) {
                        throw (BaseConfirmException)causeEx;
                    }
                    if (causeEx instanceof ServicePromptException) {
                        throw (ServicePromptException)causeEx;
                    }
                    logger.error((Object)"\u901a\u8fc7\u53cd\u5c04\u673a\u5236\u8c03\u7528action\u65b9\u6cd5\u51fa\u9519!", (Throwable)ex);
                    if (causeEx instanceof ServiceCallException) {
                        MonitorUtil.recordUepError((Exception)ex, (String)causeEx.getMessage());
                        throw (ServiceCallException)causeEx;
                    }
                    errorInfo = "\u8c03\u7528action\u65b9\u6cd5\u51fa\u9519!\u51fa\u9519\u539f\u56e0:" + causeEx.getMessage() + "[WEB:" + weblogicName + "]";
                    MonitorUtil.recordUepError((Exception)ex, (String)errorInfo);
                    throw new BaseRunException(errorInfo, causeEx);
                }
                errorInfo = "\u8c03\u7528action\u65b9\u6cd5\u51fa\u9519!\u51fa\u9519\u539f\u56e0:" + ex.getMessage() + "[WEB:" + weblogicName + "]";
                MonitorUtil.recordUepError((Exception)ex, (String)errorInfo);
                throw new BaseRunException(errorInfo, (Throwable)ex);
            }
            this.dealBeforeResponse();
        }
        return retStr;
    }

    protected void dealBeforeResponse() {
    }

    protected Method getMethod(String name) throws NoSuchMethodException {
        Method method = this.clazz.getMethod(name, new Class[0]);
        return method;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

