/*
 * Decompiled with CFR 0.152.
 */
package com.haiyisoft.ep.framework.ui.struts2;

import com.haiyisoft.ep.common.model.BaseBean;
import com.haiyisoft.ep.common.model.FieldMetaData;
import com.haiyisoft.ep.common.model.QueryParamList;
import com.haiyisoft.ep.common.util.ClassUtils;
import com.haiyisoft.ep.common.util.ReflectionUtils;
import com.haiyisoft.ep.common.util.StringUtils;
import com.haiyisoft.ep.exception.BaseRunException;
import com.haiyisoft.ep.exception.FrameworkException;
import com.haiyisoft.ep.framework.model.DataWrap;
import com.haiyisoft.ep.framework.ui.struts2.action.BaseAction;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;

public class BeanActionUtil {
    private BeanActionUtil() {
    }

    public static <T extends BaseBean> List<T> getSelectedBean(DataWrap<T> dataWrap, String checkedValue) {
        ArrayList<BaseBean> selectedBeans = new ArrayList<BaseBean>();
        List list = dataWrap.getDataList();
        for (BaseBean bean : list) {
            if (checkedValue == null || !checkedValue.equals(bean.getChecked())) continue;
            selectedBeans.add(bean);
        }
        return selectedBeans;
    }

    public static <T extends BaseBean> List<T> getSelectedBean(DataWrap<T> dataWrap) {
        return BeanActionUtil.getSelectedBean(dataWrap, "1");
    }

    public static Class getDataWrapGenericClass(Class clazz, String selectedDataWrap) {
        if (selectedDataWrap == null || "".equals(selectedDataWrap.trim())) {
            return null;
        }
        String methodName = "get" + StringUtils.capitalize((String)selectedDataWrap);
        Method method = ClassUtils.getMethodIfAvailable((Class)clazz, (String)methodName, (Class[])new Class[0]);
        if (method == null) {
            return null;
        }
        Type genericType = method.getGenericReturnType();
        Class genericClass = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type resultType = type.getActualTypeArguments()[0];
            genericClass = resultType instanceof ParameterizedType ? (Class)((ParameterizedType)resultType).getRawType() : (Class)resultType;
        }
        return genericClass;
    }

    public static DataWrap getDataWrapByName(Object action, String selectedDataWrap) {
        if (selectedDataWrap == null || "".equals(selectedDataWrap.trim())) {
            return null;
        }
        String methodName = "get" + StringUtils.capitalize((String)selectedDataWrap);
        Method method = ClassUtils.getMethodIfAvailable(action.getClass(), (String)methodName, (Class[])new Class[0]);
        if (method == null) {
            return null;
        }
        Object result = ReflectionUtils.invokeMethod((Method)method, (Object)action);
        if (result instanceof DataWrap) {
            return (DataWrap)result;
        }
        return null;
    }

    public static boolean judgeEntityClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getAnnotation(Entity.class) != null;
    }

    public static QueryParamList getQueryParam(List<? extends FieldMetaData> metaDataList, Map<String, String> query) throws BaseRunException {
        QueryParamList paramList = new QueryParamList();
        if (query != null) {
            for (Map.Entry<String, String> e : query.entrySet()) {
                if (e.getValue() == null || e.getValue().equals("")) continue;
                String value = e.getValue().toString();
                value = value.trim();
                String thekey = e.getKey();
                if (thekey.indexOf("_LABEL") >= 0 || thekey.indexOf("_MASK") >= 0) continue;
                String relation = null;
                if (thekey.indexOf("LIKE") != -1) {
                    relation = "LIKE";
                    int index = value.indexOf("_");
                    if (index > -1) {
                        value = value.replaceAll("_", "\\_");
                    }
                    if (thekey.indexOf("_LIKE") != -1) {
                        thekey = BeanActionUtil.getCodeobject(thekey, "_LIKE");
                        value = "%" + value + "%";
                    } else if (thekey.indexOf("_LLIKE") != -1) {
                        thekey = BeanActionUtil.getCodeobject(thekey, "_LLIKE");
                        value = String.valueOf(value) + "%";
                    } else if (thekey.indexOf("_RLIKE") != -1) {
                        thekey = BeanActionUtil.getCodeobject(thekey, "_RLIKE");
                        value = "%" + value;
                    }
                }
                if (thekey.indexOf("_>=") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_>=");
                    relation = ">=";
                } else if (thekey.indexOf("_>") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_>");
                    relation = ">";
                } else if (thekey.indexOf("_gt") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_gt");
                    relation = ">";
                } else if (thekey.indexOf("_egt") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_egt");
                    relation = ">=";
                } else if (thekey.indexOf("_lt") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_lt");
                    relation = "<";
                } else if (thekey.indexOf("_<=") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_<=");
                    relation = "<=";
                } else if (thekey.indexOf("_<") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_<");
                    relation = "<";
                } else if (thekey.indexOf("_elt") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_elt");
                    relation = "<=";
                } else if (thekey.indexOf("_!=") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_!=");
                    relation = "<>";
                } else if (thekey.indexOf("_neq") != -1) {
                    thekey = BeanActionUtil.getCodeobject(thekey, "_neq");
                    relation = "<>";
                }
                Object theValue = value;
                if (metaDataList != null && !"LIKE".equals(relation)) {
                    for (FieldMetaData fieldMetaData : metaDataList) {
                        if (!thekey.equals(fieldMetaData.getName())) continue;
                        String type = fieldMetaData.getType();
                        theValue = BeanActionUtil.getValue(type, value);
                        break;
                    }
                }
                if (value == null || theValue == null) continue;
                if (relation == null) {
                    paramList.addParam(thekey, theValue);
                    continue;
                }
                paramList.addParam(thekey, theValue, relation);
            }
        }
        return paramList;
    }

    public static QueryParamList getQueryParam(String dataWrapName, BaseAction action) throws BaseRunException {
        QueryParamList paramList = new QueryParamList();
        DataWrap dataWrap = BeanActionUtil.getDataWrapByName((Object)action, dataWrapName);
        List<? extends FieldMetaData> metaDataList = null;
        try {
            metaDataList = action.getMetaData(dataWrapName);
        }
        catch (Exception e1) {
            new FrameworkException("\u83b7\u53d6" + dataWrapName + "\u5143\u6570\u636e\u51fa\u9519\uff01", (Throwable)e1).handle();
        }
        return BeanActionUtil.getQueryParam(metaDataList, dataWrap.getQuery());
    }

    private static Object getValue(String classtype, String invalue) {
        Object obj = null;
        try {
            if (classtype.equalsIgnoreCase("java.lang.String")) {
                obj = invalue;
            } else if (classtype.equalsIgnoreCase("java.math.BigDecimal")) {
                BigDecimal bigpara = new BigDecimal(invalue);
                obj = bigpara;
            } else if (classtype.equalsIgnoreCase("java.sql.Timestamp")) {
                if (invalue.indexOf(".") == -1) {
                    invalue = invalue.lastIndexOf(":") != -1 ? String.valueOf(invalue) + ".0" : String.valueOf(invalue) + " 00:00:00.0";
                }
                Timestamp timepara = Timestamp.valueOf(invalue);
                obj = timepara;
            } else if (classtype.equalsIgnoreCase("java.lang.Integer")) {
                Integer intpara = Integer.valueOf(invalue);
                obj = intpara;
            } else if (classtype.equalsIgnoreCase("java.lang.Long")) {
                Long longpara = Long.valueOf(invalue);
                obj = longpara;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    private static String getCodeobject(String theNameobject, String sub) {
        String thename = null;
        int idx = theNameobject.indexOf(sub);
        thename = idx > 0 ? theNameobject.substring(0, idx) : theNameobject;
        return thename;
    }
}

