/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.transasset;

import java.util.List;
import java.util.Map;
import nc.bs.ica.pub.util.BusinessUtil;
import nc.itf.ica.costitem.costitemdoc.ICostitemdocPubQueryService;
import nc.pub.fa.annotation.DomainTransfer;
import nc.pub.fa.annotation.DomainType;
import nc.pub.fa.card.DefaultChangeVOAdjust;
import nc.pub.fa.common.util.FAMultiLanguageUtil;
import nc.pub.fa.common.util.StringUtils;
import nc.vo.am.common.util.BillTypeUtils;
import nc.vo.am.common.util.MultiLanguageUtil;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.transasset.TransassetBodyVO;
import nc.vo.fa.transasset.TransassetHeadVO;
import nc.vo.fa.transasset.TransassetVO;
import nc.vo.ica.costitem.costitemdoc.CostitemdocVO;
import nc.vo.ica.transfer.transferitem.AggTransferitemVO;
import nc.vo.ica.transfer.transferitem.Objecttype;
import nc.vo.pf.change.ChangeVOAdjustContext;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.MultiLangText;

@DomainTransfer(value={DomainType.ICA})
public class ICAToTransassetVOChangeAdjust
extends DefaultChangeVOAdjust {
    @Override
    public AggregatedValueObject[] batchAdjustBeforeChange(AggregatedValueObject[] srcVOs, ChangeVOAdjustContext adjustContext) throws BusinessException {
        return this.createAggVOByBody(srcVOs);
    }

    @Override
    protected AggregatedValueObject[] createAggVOByBody(AggregatedValueObject[] srcVOs) {
        return BusinessUtil.groupingByFABody((AggTransferitemVO)((AggTransferitemVO)srcVOs[0]), (int)Objecttype.FIXEDASSETCARD.toIntValue());
    }

    @Override
    public AggregatedValueObject[] batchAdjustAfterChange(AggregatedValueObject[] srcVOs, AggregatedValueObject[] destVOs, ChangeVOAdjustContext adjustContext) throws BusinessException {
        TransassetVO[] transassetVOs;
        String projectProductVOMetaId = "5ddb85bf-415b-4a07-8c7f-cbafb340b431";
        String costitemdocVOMetaId = "311a5e9e-7348-4bce-808d-2240363d3b05";
        for (TransassetVO billVO : transassetVOs = (TransassetVO[])destVOs) {
            TransassetHeadVO parentVO = billVO.getParentVO();
            TransassetBodyVO[] bodyVOs = (TransassetBodyVO[])billVO.getChildrenVO();
            parentVO.setPk_org(bodyVOs[0].getPk_org());
            parentVO.setPk_org_v(bodyVOs[0].getPk_org_v());
            String pk_typeCode = BillTypeUtils.getPKByCode((String)bodyVOs[0].getBill_type_src());
            bodyVOs[0].setTransi_type_src(bodyVOs[0].getBill_type_src());
            bodyVOs[0].setPk_transitype_src(pk_typeCode);
            String pk_project = parentVO.getPk_project();
            for (TransassetBodyVO body : bodyVOs) {
                String multiLangName = FAMultiLanguageUtil.getCurrentMultiLanguageColumn((String)"asset_name");
                String pk = FAMultiLanguageUtil.getMultiLanguageValue((SuperVO)body, (String)"asset_name");
                if (StringUtils.isNotBlank((String)pk)) {
                    Map keyName = MultiLanguageUtil.getMultiLangObjByClassId((String[])new String[]{pk}, (String)projectProductVOMetaId);
                    MultiLangText name = (MultiLangText)keyName.get(pk);
                    body.setAsset_name(name.getText());
                    body.setAsset_name2(name.getText2());
                    body.setAsset_name3(name.getText3());
                    body.setAsset_name4(name.getText4());
                    body.setAsset_name5(name.getText5());
                    body.setAsset_name6(name.getText6());
                    continue;
                }
                List costitemdocVOs = ((ICostitemdocPubQueryService)AMProxy.lookup(ICostitemdocPubQueryService.class)).queryCostitemdocHeadsByPks(new String[]{pk_project});
                String vnameML = FAMultiLanguageUtil.getCurrentMultiLanguageColumn((String)"vname");
                String value = (String)((CostitemdocVO)costitemdocVOs.get(0)).getAttributeValue(vnameML);
                body.setAttributeValue(multiLangName, value);
            }
        }
        return transassetVOs;
    }
}

