/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.tbb;

import nc.itf.pubapp.pub.exception.IResumeException;
import nc.pub.fa.common.util.StringUtils;
import nc.vo.fa.tbb.ControlType;
import nc.vo.pub.BusinessException;
import nc.vo.tb.control.NtbCtlInfoVO;

public class BudgetControlException
extends BusinessException
implements IResumeException {
    private static final long serialVersionUID = 1L;
    private ControlType type;
    private String controlMsg;
    private String billType;

    public BudgetControlException(NtbCtlInfoVO ctlInfo) {
        this.init(ctlInfo);
    }

    public BudgetControlException(NtbCtlInfoVO ctlInfo, String tbillType) {
        this.billType = tbillType;
        this.init(ctlInfo);
    }

    private void init(NtbCtlInfoVO info) {
        StringBuffer msg = new StringBuffer();
        if (info != null && info.isControl()) {
            this.type = ControlType.Control;
            String[] seminfos = info.getControlInfos();
            for (int j = 0; j < seminfos.length; ++j) {
                msg.append("\n" + seminfos[j]);
            }
        } else if (info != null && info.isAlarm()) {
            this.type = ControlType.Alarm;
            String[] seminfos = info.getAlarmInfos();
            for (int j = 0; j < seminfos.length; ++j) {
                msg.append("\n" + seminfos[j]);
            }
        } else if (info != null && info.isMayBeControl()) {
            this.type = ControlType.MayBeControl;
            String[] seminfos = info.getFlexibleControlInfos();
            for (int j = 0; j < seminfos.length; ++j) {
                msg.append("\n" + seminfos[j]);
            }
        }
        if (StringUtils.isNotEmpty((String)this.billType)) {
            this.controlMsg = "HN".equals(this.billType) ? msg.toString() : this.type + "H-Z" + msg.toString();
        }
    }

    public String getMessage() {
        return this.controlMsg;
    }

    public ControlType getType() {
        return this.type;
    }

    public String getControlMsg() {
        return this.controlMsg;
    }

    public String getBusiExceptionType() {
        return "WarningCheck";
    }
}

