/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.tbb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nc.bs.logging.Logger;
import nc.itf.fa.service.ICategoryService;
import nc.itf.tb.control.IAccessableExtBusiVO;
import nc.md.MDBaseQueryFacade;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.pub.fa.common.consts.BudgetControlConst;
import nc.pub.fa.common.consts.BudgetDimensionConst;
import nc.pub.fa.tbb.tool.BudgetControlUtil;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.AccbookManager;
import nc.vo.am.manager.CurrencyManager;
import nc.vo.am.manager.CurrencyRateManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.bd.accessor.IBDData;
import nc.vo.fa.asset.AssetVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nc.vo.tb.control.DataRuleVO;

public class AssetBudgetCtlVO
implements IAccessableExtBusiVO,
Serializable {
    private static final long serialVersionUID = 1L;
    private DataRuleVO ruleVO = null;
    private AssetVO dataVO = null;

    public AssetBudgetCtlVO(DataRuleVO ruleVO, AssetVO dataVO) {
        this.ruleVO = ruleVO;
        this.dataVO = dataVO;
    }

    public String[] getAllUpLevels(String fieldname, String pk) throws Exception {
        if (fieldname.equals(BudgetDimensionConst.pk_category)) {
            return ((ICategoryService)AMProxy.lookup(ICategoryService.class)).queryAllParentByPK(this.getPKOrg(), pk);
        }
        if (fieldname.equals(BudgetDimensionConst.pk_mandept) || fieldname.equals(BudgetDimensionConst.pk_usedept)) {
            List data = GeneralAccessorFactory.getAccessor((String)"b26fa3cb-4087-4027-a3b6-c83ab2a086a9").getFatherDocs(this.getPKOrg(), pk, false);
            if (data == null || data.size() == 0) {
                return null;
            }
            ArrayList<String> deptkeys = new ArrayList<String>();
            for (IBDData dbdata : data) {
                deptkeys.add(dbdata.getPk());
            }
            return deptkeys.toArray(new String[0]);
        }
        return null;
    }

    public String[] getAttributesValue(String[] attrs) {
        String[] result = new String[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            result[i] = this.getAttributesValue(attrs[i]);
        }
        return result;
    }

    public String getAttributesValue(String attr) {
        Object result = null;
        if (ArrayUtils.indexOf((Object[])this.dataVO.getAttributeNames(), (Object)attr) > 0) {
            result = this.dataVO.getAttributeValue(attr);
        }
        if (attr.equals(BudgetControlConst.Asset_BusinessDate)) {
            result = this.dataVO.getBusiness_date();
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public String getBillType() {
        return this.ruleVO.getBilltype_code();
    }

    public String getBusiDate() {
        UFDate business_date = (UFDate)this.dataVO.getAttributeValue("business_date");
        return business_date.toString();
    }

    public String getBusiSys() {
        return BudgetControlConst.module_Ctl;
    }

    public String getBusiType() {
        return null;
    }

    public String getCurrency() {
        String pk_currency = null;
        String pk_accbook = (String)this.dataVO.getAttributeValue("pk_accbook");
        try {
            pk_currency = CurrencyManager.getCurrencyPKByAccbook((String)pk_accbook);
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
        return pk_currency;
    }

    public String getDateType() {
        String dateType = BudgetControlConst.Asset_BusinessDate;
        return dateType;
    }

    public String getDataType() {
        String dataType = this.ruleVO.getDataType();
        return dataType;
    }

    public String[] getHasLevelFlds() {
        return new String[]{BudgetDimensionConst.pk_category, BudgetDimensionConst.pk_mandept, BudgetDimensionConst.pk_usedept};
    }

    public String getPKGroup() {
        return this.dataVO.getPk_group();
    }

    public String getPKOrg() {
        return this.dataVO.getPk_org();
    }

    public String getPkNcEntity() {
        return null;
    }

    public boolean isUnInure() {
        return false;
    }

    public UFDouble[] getExeData(String direction, String obj, String extObj) {
        return null;
    }

    public UFDouble[] getExeData(String direction, String obj, String extObj, int curr_type, String pk_currency) {
        UFDouble[] ExeData = new UFDouble[]{UFDouble.ZERO_DBL, UFDouble.ZERO_DBL, UFDouble.ZERO_DBL, UFDouble.ZERO_DBL};
        UFDouble controlData = UFDouble.ZERO_DBL;
        if (StringUtils.isNotEmpty((String)obj) && obj.equals(BudgetControlConst.HAPPEN_VALUE)) {
            String fieldName = BudgetControlUtil.getTrueFielName(this.getBillType(), extObj);
            Object objvalue = this.dataVO.getAttributeValue(fieldName);
            if (objvalue != null) {
                controlData = new UFDouble(objvalue.toString());
            }
            if (this.ruleVO.isReadyDataReduce() || this.ruleVO.isRunDataReduce()) {
                controlData = UFDouble.ZERO_DBL.sub(controlData);
            }
            try {
                IBean bodyBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(this.dataVO.getClass().getName());
                IAttribute attri = bodyBean.getAttributeByName(fieldName);
                if (attri.getDataType().getTypeType() == 52) {
                    if (curr_type < 3) {
                        if (curr_type == 0) {
                            pk_currency = CurrencyManager.getGlobalDefaultCurrencyPK();
                        } else if (curr_type == 1) {
                            pk_currency = CurrencyManager.getLocalCurrencyPKByGroup((String)this.dataVO.getPk_group());
                        } else if (curr_type == 2) {
                            pk_currency = CurrencyManager.getLocalCurrencyPK((String)this.dataVO.getPk_org());
                        }
                        String pk_accbook = this.dataVO.getPk_accbook();
                        try {
                            String pk_exratescheme = AccbookManager.queryExrateSchemeByAccBookID((String)pk_accbook);
                            UFDate business_date = (UFDate)this.dataVO.getAttributeValue("business_date");
                            controlData = CurrencyRateManager.getAmountByScheme((String)pk_exratescheme, (String)this.getCurrency(), (String)pk_currency, (UFDouble)controlData, null, (UFDate)business_date, null);
                        }
                        catch (BusinessException e) {
                            Logger.error((Object)((Object)e));
                            ExceptionUtils.asBusinessRuntimeException((Throwable)e);
                        }
                    } else if (curr_type == 3 && !pk_currency.equals(this.getCurrency())) {
                        controlData = UFDouble.ZERO_DBL;
                    }
                }
            }
            catch (BusinessException e) {
                Logger.error((Object)((Object)e));
                ExceptionUtils.asBusinessRuntimeException((Throwable)e);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (i != curr_type) continue;
            ExeData[i] = controlData;
        }
        return ExeData;
    }
}

