/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.tbb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nc.bs.logging.Logger;
import nc.itf.fa.service.ICategoryService;
import nc.itf.tb.control.IAccessableExtBusiVO;
import nc.md.MDBaseQueryFacade;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.pub.fa.common.consts.BudgetControlConst;
import nc.pub.fa.common.consts.BudgetDimensionConst;
import nc.pub.fa.tbb.tool.BudgetControlUtil;
import nc.pubitf.bd.accessor.GeneralAccessorFactory;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.CurrencyManager;
import nc.vo.am.manager.CurrencyRateManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.bd.accessor.IBDData;
import nc.vo.fa.newasset.NewAssetBodyVO;
import nc.vo.fa.newasset.NewAssetHeadVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nc.vo.tb.control.DataRuleVO;

public class AppBudgetCtlVO
implements IAccessableExtBusiVO,
Serializable {
    private static final long serialVersionUID = 1L;
    private DataRuleVO ruleVO = null;
    private NewAssetHeadVO headVO = null;
    private NewAssetBodyVO bodyVO = null;

    public AppBudgetCtlVO(DataRuleVO ruleVO, NewAssetHeadVO headVO, NewAssetBodyVO bodyVO) {
        this.ruleVO = ruleVO;
        this.headVO = headVO;
        this.bodyVO = bodyVO;
    }

    public String[] getAllUpLevels(String fieldname, String pk) throws Exception {
        if (fieldname.equals(BudgetDimensionConst.pk_category)) {
            return ((ICategoryService)AMProxy.lookup(ICategoryService.class)).queryAllParentByPK(this.getPKOrg(), pk);
        }
        if (fieldname.equals(BudgetDimensionConst.pk_mandept) || fieldname.equals(BudgetDimensionConst.pk_usedept)) {
            List data = GeneralAccessorFactory.getAccessor((String)"b26fa3cb-4087-4027-a3b6-c83ab2a086a9").getFatherDocs(this.getPKOrg(), pk, false);
            if (data == null || data.size() == 0) {
                return null;
            }
            ArrayList<String> deptkeys = new ArrayList<String>();
            for (IBDData dbdata : data) {
                deptkeys.add(dbdata.getPk());
            }
            return deptkeys.toArray(new String[0]);
        }
        return null;
    }

    public String[] getAttributesValue(String[] attrs) {
        String[] result = new String[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            result[i] = this.getAttributesValue(attrs[i]);
        }
        return result;
    }

    public String getAttributesValue(String attr) {
        Object obj = null;
        if (ArrayUtils.indexOf((Object[])this.headVO.getAttributeNames(), (Object)attr) > 0) {
            obj = this.headVO.getAttributeValue(attr);
        } else if (ArrayUtils.indexOf((Object[])this.bodyVO.getAttributeNames(), (Object)attr) > 0) {
            obj = this.bodyVO.getAttributeValue(attr);
        }
        if (attr.equals(BudgetControlConst.APP_BusinessDate)) {
            obj = this.headVO.getBusiness_date().toString();
        }
        if (null == obj && attr.startsWith("def")) {
            obj = this.bodyVO.getAttributeValue(attr);
        }
        if (obj != null) {
            if (obj instanceof String) {
                String value = (String)obj;
                if (StringUtils.isNotEmpty((String)value)) {
                    return value;
                }
            } else {
                return obj.toString();
            }
        }
        return null;
    }

    public String getBillType() {
        return this.ruleVO.getBilltype_code();
    }

    public String getBusiDate() {
        UFDate business_date = this.headVO.getBusiness_date();
        return business_date.toString();
    }

    public String getBusiSys() {
        return BudgetControlConst.module_Ctl;
    }

    public String getBusiType() {
        return null;
    }

    public String getCurrency() {
        String pk_org = this.getPKOrg();
        String pk_currency = CurrencyManager.getLocalCurrencyPK((String)pk_org);
        return pk_currency;
    }

    public String getDataType() {
        String dataType = this.ruleVO.getDataType();
        return dataType;
    }

    public String getDateType() {
        String dateType = BudgetControlConst.APP_BusinessDate;
        return dateType;
    }

    public UFDouble[] getExeData(String direction, String obj, String extObj) {
        return null;
    }

    public UFDouble[] getExeData(String direction, String obj, String extObj, int curr_type, String pk_currency) {
        UFDouble[] ExeData = new UFDouble[]{UFDouble.ZERO_DBL, UFDouble.ZERO_DBL, UFDouble.ZERO_DBL, UFDouble.ZERO_DBL};
        UFDouble controlData = UFDouble.ZERO_DBL;
        if (StringUtils.isNotEmpty((String)obj) && obj.equals(BudgetControlConst.HAPPEN_VALUE)) {
            String fieldName = BudgetControlUtil.getTrueFielName(this.getBillType(), extObj);
            Object objvalue = this.bodyVO.getAttributeValue(fieldName);
            if (objvalue != null) {
                controlData = new UFDouble(objvalue.toString());
            }
            if (this.ruleVO.isReadyDataReduce() || this.ruleVO.isRunDataReduce()) {
                controlData = UFDouble.ZERO_DBL.sub(controlData);
            }
            try {
                IBean bodyBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(((Object)((Object)this.bodyVO)).getClass().getName());
                IAttribute attri = bodyBean.getAttributeByName(fieldName);
                if (attri.getDataType().getTypeType() == 52) {
                    if (curr_type < 3) {
                        if (curr_type == 0) {
                            pk_currency = CurrencyManager.getGlobalDefaultCurrencyPK();
                        } else if (curr_type == 1) {
                            pk_currency = CurrencyManager.getLocalCurrencyPKByGroup((String)this.headVO.getPk_group());
                        } else if (curr_type == 2) {
                            pk_currency = CurrencyManager.getLocalCurrencyPK((String)this.headVO.getPk_org());
                        }
                        UFDate business_date = (UFDate)this.headVO.getAttributeValue("business_date");
                        controlData = CurrencyRateManager.getOrgAmount((String)this.headVO.getPk_org(), (String)pk_currency, (UFDouble)controlData, (UFDate)business_date);
                    } else if (curr_type == 3 && !pk_currency.equals(this.getCurrency())) {
                        controlData = UFDouble.ZERO_DBL;
                    }
                }
            }
            catch (BusinessException e) {
                Logger.error((Object)((Object)e));
                ExceptionUtils.asBusinessRuntimeException((Throwable)e);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (i != curr_type) continue;
            ExeData[i] = controlData;
        }
        return ExeData;
    }

    public String[] getHasLevelFlds() {
        return new String[]{BudgetDimensionConst.pk_category, BudgetDimensionConst.pk_mandept, BudgetDimensionConst.pk_usedept};
    }

    public String getPKGroup() {
        return this.headVO.getPk_group();
    }

    public String getPKOrg() {
        return this.headVO.getPk_org();
    }

    public String getPkNcEntity() {
        return null;
    }

    public boolean isUnInure() {
        return false;
    }
}

