/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.ref;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.framework.core.util.ObjectCreator;
import nc.bs.logging.Logger;
import nc.impl.am.common.InSqlManager;
import nc.pub.fa.card.AssetStateConst;
import nc.pub.fa.card.AssetUseConst;
import nc.pub.fa.common.manager.DeptScaleManager;
import nc.pub.fa.common.util.CategoryCodeRuleUtil;
import nc.pub.fa.common.util.StringUtils;
import nc.ui.bd.ref.AbstractRefGridTreeBigDataModel;
import nc.ui.bd.ref.RefSearchFieldSetting;
import nc.ui.pub.beans.ValueChangedEvent;
import nc.vo.am.common.util.AMTimeZoneUtilsPrv;
import nc.vo.am.manager.AccbookManager;
import nc.vo.am.manager.CurrencyManager;
import nc.vo.am.scale.query.IDigitQueryVar;
import nc.vo.am.scale.query.ScaleObjFactory;
import nc.vo.am.scale.query.ScaleUtils;
import nc.vo.logging.Debug;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.format.FormatResult;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDateTime;
import nc.vo.pub.lang.UFDouble;

public class CardRefModel
extends AbstractRefGridTreeBigDataModel {
    private String pk_accbook = null;
    private UFBoolean haveNotReduceCondition = UFBoolean.TRUE;
    private UFBoolean oneReduceHave = UFBoolean.FALSE;
    private Boolean returnCardCode = Boolean.TRUE;
    private Boolean userDefWherePart = Boolean.TRUE;
    private String orgWherePart = null;

    public CardRefModel() {
        this.setClassData();
        HashMap<String, String> allFields = new HashMap<String, String>();
        for (int index = 0; index < this.getFieldCode().length; ++index) {
            allFields.put(this.getFieldCode()[index], this.getFieldName()[index]);
        }
        this.setBlurQueryTableName("fa_card");
        String[] defaultFields = new String[]{"card_code", "asset_code", "asset_name" + (this.getLangStrSuffix() == null ? "" : this.getLangStrSuffix())};
        RefSearchFieldSetting searchFields = new RefSearchFieldSetting(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003875"), allFields, defaultFields);
        this.setSearchFieldSetting(searchFields);
        this.resetFieldName();
        this.setResourceID("H1");
        this.setCommonDataTableName("fa_card");
        this.setCommonDataBasDocPkField("fa_card.pk_card");
        this.setMatchPkWithWherePart(true);
        this.setClassJoinValue("query");
        this.setRefQueryDlgClaseName("nc.ui.fa.ref.advance.AssetAdvanceQueryDLG");
        this.setFilterRefNodeName(new String[]{"\u8d22\u52a1\u7ec4\u7ec7"});
        this.reset();
    }

    public void reset() {
    }

    public String getRefNodeName() {
        return "\u5361\u7247\u53c2\u7167";
    }

    public String getRefTitle() {
        return NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003875");
    }

    public void filterValueChanged(ValueChangedEvent changedValue) {
        String[] pk_orgs = (String[])changedValue.getNewValue();
        if (pk_orgs != null && pk_orgs.length > 0) {
            this.setPk_org(pk_orgs[0]);
        }
    }

    private void setClassData() {
        this.setRefNodeName(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003875"));
        this.setRootName(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003882"));
        this.setClassFieldCode(new String[]{"cate_code", "cate_name", "catelevel", "pk_category", "pk_parent"});
        this.setFatherField("pk_parent");
        this.setChildField("pk_category");
        this.setClassJoinField("pk_category");
        this.setClassTableName("fa_category");
        this.setClassDefaultFieldCount(2);
        this.setClassDataPower(true);
        this.setClassWherePart(" dr = 0 and (pk_org = '" + this.getPk_org() + "' or pk_org = 'GLOBLE00000000000000' or pk_org = '" + this.getPk_group() + "')");
    }

    public String getCodingRule() {
        String levelRule = "2/2/2/2/2";
        try {
            levelRule = CategoryCodeRuleUtil.getCategoryCodeRule((String)this.getPk_group());
        }
        catch (BusinessException e) {
            Debug.error((Object)e.getMessage());
            Debug.error((Object)"\u672a\u53d6\u5230\u8d44\u4ea7\u7c7b\u522b\u7684\u7f16\u7801\u7ea7\u6b21");
        }
        return levelRule;
    }

    public String[] getFieldCode() {
        ArrayList<Object> fieldCodeList = new ArrayList<Object>(17);
        fieldCodeList.add("fa_card.card_code");
        fieldCodeList.add("fa_card.asset_code");
        fieldCodeList.add("fa_card.asset_name");
        String multiLang = this.getLangNameColume("org_dept.name");
        if (this.getLangStrSuffix() == null) {
            fieldCodeList.add(multiLang + " org_deptname");
        } else {
            fieldCodeList.add(multiLang);
        }
        fieldCodeList.add("fa_cardhistory.pk_usedept");
        multiLang = this.getLangNameColume("bd_psndoc.name");
        if (this.getLangStrSuffix() == null) {
            fieldCodeList.add(multiLang + " bd_psndocname");
        } else {
            fieldCodeList.add(multiLang);
        }
        fieldCodeList.add("fa_card.bar_code");
        fieldCodeList.add("fa_card.spec");
        fieldCodeList.add("fa_card.card_model");
        multiLang = this.getLangNameColume("fa_card.position");
        fieldCodeList.add(multiLang);
        fieldCodeList.add("fa_card.begin_date");
        multiLang = this.getLangNameColume("bd_project.project_name");
        fieldCodeList.add(multiLang);
        multiLang = this.getLangNameColume("bd_supplier.name");
        if (this.getLangStrSuffix() == null) {
            fieldCodeList.add(multiLang + " bd_suppliername");
        } else {
            fieldCodeList.add(multiLang);
        }
        multiLang = this.getLangNameColume("pam_addreducestyle.style_name");
        fieldCodeList.add(multiLang);
        multiLang = this.getLangNameColume("fa_usingstatus.status_name");
        fieldCodeList.add(multiLang);
        fieldCodeList.add("fa_cardhistory.localoriginvalue");
        fieldCodeList.add("fa_cardhistory.card_num");
        return fieldCodeList.toArray(new String[0]);
    }

    public String getRefCodeField() {
        if (this.returnCardCode.booleanValue()) {
            return "fa_card.card_code";
        }
        return "fa_card.asset_code";
    }

    public String getRefNameField() {
        if (this.m_strRefNameField == null && this.getFieldCode() != null && this.getFieldCode().length > 2) {
            this.m_strRefNameField = this.getFieldCode()[2];
        }
        return this.m_strRefNameField;
    }

    public String[] getFieldName() {
        ArrayList<String> fieldNameList = new ArrayList<String>(17);
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0260"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003887"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003878"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003127"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0000270"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0000260"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0002733"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0003448"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0001240"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0001427"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0001891"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0004165"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0000275"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0001369"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0000266"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("common", "UC000-0002601"));
        fieldNameList.add(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0182"));
        return fieldNameList.toArray(new String[0]);
    }

    public int getDefaultFieldCount() {
        return 7;
    }

    public String getPkFieldCode() {
        return " fa_cardhistory.pk_card ";
    }

    public String getTableName() {
        StringBuffer tableNames = new StringBuffer();
        tableNames.append(" fa_card ");
        tableNames.append(" inner join ");
        tableNames.append(" fa_cardhistory ");
        tableNames.append(" on fa_card.pk_card = fa_cardhistory.pk_card ");
        tableNames.append(" left join ");
        tableNames.append(" org_dept ");
        tableNames.append(" on fa_cardhistory.pk_mandept = org_dept.pk_dept ");
        tableNames.append(" left join ");
        tableNames.append(" pam_addreducestyle ");
        tableNames.append(" on fa_card.pk_addreducestyle = pam_addreducestyle.pk_addreducestyle ");
        tableNames.append(" left join ");
        tableNames.append(" fa_usingstatus ");
        tableNames.append(" on fa_cardhistory.pk_usingstatus = fa_usingstatus.pk_usingstatus ");
        tableNames.append(" left join ");
        tableNames.append(" bd_project ");
        tableNames.append(" on fa_cardhistory.pk_jobmngfil = bd_project.pk_project ");
        tableNames.append(" left join ");
        tableNames.append(" bd_psndoc ");
        tableNames.append(" on fa_card.pk_assetuser = bd_psndoc.pk_psndoc ");
        tableNames.append(" left join ");
        tableNames.append(" bd_supplier ");
        tableNames.append(" on fa_card.provider = bd_supplier.pk_supplier ");
        return tableNames.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWherePart() {
        StringBuffer whereSql = new StringBuffer();
        UFBoolean oldHaveNotReduceConditionValue = this.haveNotReduceCondition;
        try {
            String userWherePart;
            String orgwhere;
            if (this.isPKMatch()) {
                this.haveNotReduceCondition = UFBoolean.FALSE;
            }
            whereSql.append(" fa_card.dr = 0 and fa_cardhistory.dr = 0 ");
            if (this.getPk_org() != null && !this.getPk_org().equalsIgnoreCase("GLOBLE00000000000000") && this.getUserDefWherePart().booleanValue() && (orgwhere = this.getOrgWherePart()) != null && orgwhere.length() > 0) {
                whereSql.append(" and " + this.getOrgWherePart());
                if (this.haveNotReduceCondition.booleanValue()) {
                    if (this.pk_accbook != null) {
                        whereSql.append(" and pk_accbook = '" + this.pk_accbook + "'");
                        whereSql.append(" and fa_cardhistory.asset_state = 'exist'");
                        whereSql.append(" and fa_cardhistory.laststate_flag='Y'");
                    } else {
                        whereSql.append(" and fa_cardhistory.business_flag = '" + UFBoolean.TRUE + "'");
                        if (this.oneReduceHave.booleanValue()) {
                            whereSql.append(" and not exists (");
                            whereSql.append("select pk_card from fa_cardhistory fa_cardhistory2");
                            whereSql.append(" where dr = 0");
                            whereSql.append(" and fa_cardhistory2.asset_state in" + InSqlManager.getInSQLValue(AssetStateConst.getReduceStateList()));
                            whereSql.append(" and fa_cardhistory.pk_card = fa_cardhistory2.pk_card");
                            whereSql.append(")");
                        } else {
                            whereSql.append(" and exists (");
                            whereSql.append("select pk_card from fa_cardhistory fa_cardhistory2");
                            whereSql.append(" where dr = 0");
                            whereSql.append(" and fa_cardhistory2.laststate_flag='Y'");
                            whereSql.append(" and fa_cardhistory2.asset_state = 'exist'");
                            whereSql.append(" and fa_cardhistory.pk_card = fa_cardhistory2.pk_card");
                            whereSql.append(")");
                        }
                        whereSql.append(" and " + AssetStateConst.getNewestAssetSql(true));
                    }
                } else {
                    if (StringUtils.isNotEmpty((String)this.pk_accbook)) {
                        whereSql.append(" and pk_accbook = '" + this.pk_accbook + "'");
                    } else {
                        whereSql.append(" and fa_cardhistory.business_flag = '" + AssetUseConst.businessBook + "'");
                    }
                    whereSql.append(" and " + AssetStateConst.getNewestAssetSql(true));
                }
            }
            if (StringUtils.isNotEmpty((String)(userWherePart = super.getWherePart()))) {
                whereSql.append(" and " + userWherePart);
            }
        }
        finally {
            this.haveNotReduceCondition = oldHaveNotReduceConditionValue;
        }
        return whereSql.toString();
    }

    public void setOrgWherePart(String orgWherePart) {
        this.orgWherePart = orgWherePart;
    }

    public String getOrgWherePart() {
        if (StringUtils.isEmpty((String)this.orgWherePart)) {
            if (!InvocationInfoProxy.getInstance().getGroupId().equals(this.getPk_org())) {
                return "fa_card.pk_org = '" + this.getPk_org() + "'";
            }
            return "1=1";
        }
        return this.orgWherePart;
    }

    public String getDocJoinField() {
        return "fa_cardhistory.pk_category";
    }

    public String[] getHiddenFieldCode() {
        return new String[]{"fa_cardhistory.pk_card"};
    }

    public boolean isHiddenField(String fieldCode) {
        return Arrays.asList(this.getHiddenFieldCode()).contains(fieldCode.trim());
    }

    public Vector getData() {
        Vector datas = super.getData();
        if (null == datas || datas.isEmpty()) {
            return datas;
        }
        datas = this.formatBeginDate(datas);
        datas = this.dealMultiUseDept(datas);
        datas = this.dealMoneyScale(datas);
        return datas;
    }

    public Vector getConvertedData1(boolean isDataFromCache, Vector v, boolean isDefConverted) {
        Vector datas = super.getConvertedData(isDataFromCache, v, isDefConverted);
        return this.dealMultiUseDept(datas);
    }

    private Vector formatBeginDate(Vector datas) {
        if (datas == null || datas.isEmpty()) {
            return datas;
        }
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            Object begindate;
            Object tempData = datas.get(i);
            if (null == tempData) continue;
            Vector data = null;
            if (tempData instanceof Vector) {
                data = (Vector)tempData;
            }
            if (null == data || data.isEmpty() || data.size() == 0 || null == (begindate = data.get(10)) || null == begindate.toString() || begindate.toString().length() < 11) continue;
            try {
                Method m = Class.forName("nc.ui.format.NCFormater").getMethod("formatDate", Object.class);
                FormatResult newbegindates = (FormatResult)m.invoke(ObjectCreator.newInstance((String)"nc.ui.format.NCFormater"), new UFDateTime((String)begindate, AMTimeZoneUtilsPrv.getServerTimeZone()).getDate());
                data.set(10, newbegindates.getValue());
                continue;
            }
            catch (SecurityException e) {
                Logger.error((Object)e.getMessage());
                continue;
            }
            catch (NoSuchMethodException e) {
                Logger.error((Object)e.getMessage());
                continue;
            }
            catch (ClassNotFoundException e) {
                Logger.error((Object)e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                Logger.error((Object)e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.error((Object)e.getMessage());
                continue;
            }
            catch (InvocationTargetException e) {
                Logger.error((Object)e.getMessage());
            }
        }
        return datas;
    }

    private Vector dealMultiUseDept(Vector datas) {
        if (null == datas || datas.isEmpty() || datas.size() == 0) {
            return datas;
        }
        int size = datas.size();
        ArrayList<String> link_keyList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String link_key;
            Object pk_usedept;
            Object tempData = datas.get(i);
            if (null == tempData) continue;
            Vector data = null;
            if (tempData instanceof Vector) {
                data = (Vector)tempData;
            }
            if (null == data || data.isEmpty() || data.size() == 0 || null == (pk_usedept = data.get(4)) || null == (link_key = pk_usedept.toString()) || "".equals(link_key) || "".equals(link_key.trim()) || link_keyList.contains(link_key)) continue;
            link_keyList.add(link_key);
        }
        if (link_keyList.isEmpty()) {
            return datas;
        }
        Map linkKeyToUsedeptName = DeptScaleManager.getShowNameByLinkKey((String[])link_keyList.toArray(new String[0]));
        if (null == linkKeyToUsedeptName || linkKeyToUsedeptName.isEmpty()) {
            return datas;
        }
        for (int i = 0; i < size; ++i) {
            String useDeptName;
            String link_key;
            Object pk_usedept;
            Object tempData = datas.get(i);
            if (null == tempData) continue;
            Vector data = null;
            if (tempData instanceof Vector) {
                data = (Vector)tempData;
            }
            if (null == data || data.isEmpty() || data.size() == 0 || null == (pk_usedept = data.get(4)) || null == (link_key = pk_usedept.toString()) || "".equals(link_key) || "".equals(link_key.trim()) || null == (useDeptName = (String)linkKeyToUsedeptName.get(link_key)) || "".equals(useDeptName) || "".equals(useDeptName.trim())) continue;
            data.set(4, useDeptName);
        }
        return datas;
    }

    private Vector dealMoneyScale(Vector datas) {
        if (null == datas || datas.isEmpty() || datas.size() == 0) {
            return datas;
        }
        int digit = 2;
        int roundingMode = 4;
        if (null == this.pk_accbook || "".equals(this.pk_accbook) || "".equals(this.pk_accbook.trim())) {
            String tempAccbook = null;
            try {
                tempAccbook = AccbookManager.queryMainAccbookIDByFinanceOrg((String)this.getPk_org());
            }
            catch (BusinessException businessException) {
                // empty catch block
            }
            if (null != tempAccbook && !"".equals(tempAccbook) && !"".equals(tempAccbook.trim())) {
                try {
                    String pk_currency_accbook = CurrencyManager.getCurrencyPKByAccbook((String)tempAccbook);
                    IDigitQueryVar digitQuery = new ScaleObjFactory().getCurrTypeScaleObj();
                    digit = digitQuery.getDigit((Object)pk_currency_accbook, false);
                    roundingMode = digitQuery.getRoundingMode((Object)pk_currency_accbook, false);
                }
                catch (Exception e) {
                    digit = 2;
                    roundingMode = 4;
                    Logger.error((Object)e.getMessage());
                }
            }
        } else {
            try {
                String pk_currency_accbook = CurrencyManager.getCurrencyPKByAccbook((String)this.pk_accbook);
                IDigitQueryVar digitQuery = new ScaleObjFactory().getCurrTypeScaleObj();
                digit = digitQuery.getDigit((Object)pk_currency_accbook, false);
                roundingMode = digitQuery.getRoundingMode((Object)pk_currency_accbook, false);
            }
            catch (Exception e) {
                digit = 2;
                roundingMode = 4;
                Logger.error((Object)e.getMessage());
            }
        }
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            Object tempData = datas.get(i);
            if (null == tempData) continue;
            Vector data = null;
            if (tempData instanceof Vector) {
                data = (Vector)tempData;
            }
            if (null == data || data.isEmpty() || data.size() == 0) continue;
            UFDouble localoriginvalue = null;
            Object money = data.get(15);
            if (null == money) {
                localoriginvalue = UFDouble.ZERO_DBL;
            } else if (money instanceof UFDouble) {
                localoriginvalue = (UFDouble)money;
            } else if (money instanceof BigDecimal) {
                localoriginvalue = new UFDouble((BigDecimal)money);
            } else {
                try {
                    localoriginvalue = new UFDouble(money.toString());
                }
                catch (NumberFormatException e) {
                    localoriginvalue = UFDouble.ZERO_DBL;
                }
            }
            if (null == localoriginvalue) {
                localoriginvalue = UFDouble.ZERO_DBL;
            }
            localoriginvalue = ScaleUtils.setScale((UFDouble)localoriginvalue, (int)digit, (int)roundingMode);
            data.set(15, localoriginvalue);
        }
        return datas;
    }

    public void setPk_accbook(String pk_accbook) {
        this.pk_accbook = pk_accbook;
    }

    public String getPk_accbook() {
        return this.pk_accbook;
    }

    public void setReduce(UFBoolean reduce) {
        this.haveNotReduceCondition = reduce;
    }

    public void setOneReduceHave(UFBoolean oneReduceHave) {
        this.oneReduceHave = oneReduceHave;
    }

    public Boolean isReturnCardCode() {
        return this.returnCardCode;
    }

    public void setReturnCardCode(Boolean returnCardCode) {
        this.returnCardCode = returnCardCode;
    }

    public Boolean getUserDefWherePart() {
        return this.userDefWherePart;
    }

    public void setUserDefWherePart(Boolean userDefWherePart) {
        this.userDefWherePart = userDefWherePart;
    }

    public void setPk_org(String pk_org) {
        super.setPk_org(pk_org);
        this.setClassWherePart(" dr = 0 and (pk_org = '" + pk_org + "' or pk_org = 'GLOBLE00000000000000' or pk_org = '" + this.getPk_group() + "')");
    }

    public String getRefSql_QueryCommonData() {
        return null;
    }
}

