/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.fa.asset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import nc.pub.fa.card.DefaultChangeVOAdjust;
import nc.vo.ali.contract.leasecont.AggContractInVO;
import nc.vo.ali.contract.leasecont.ContractInBodyVO;
import nc.vo.ali.contract.leasecont.ContractInCalculationVO;
import nc.vo.ali.contract.leasecont.ContractInEquipVO;
import nc.vo.ali.contract.leasecont.ContractInHeadVO;
import nc.vo.ali.contract.leasecont.ContractRentVO;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.pf.change.ChangeVOAdjustContext;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;

public class ContractToAssetVOChangeAdjust
extends DefaultChangeVOAdjust {
    @Override
    public AggregatedValueObject[] batchAdjustBeforeChange(AggregatedValueObject[] srcVOs, ChangeVOAdjustContext adjustContext) throws BusinessException {
        AggregatedValueObject[] changeAfterVOs = null;
        String billtype = adjustContext.getDestBilltype();
        if (billtype.equals("H1")) {
            changeAfterVOs = this.createAggVOByBody(srcVOs);
        }
        return changeAfterVOs;
    }

    @Override
    protected AggregatedValueObject[] createAggVOByBody(AggregatedValueObject[] srcVOs) {
        ArrayList<AggContractInVO> srcVoList = new ArrayList<AggContractInVO>();
        AggContractInVO aggVo = null;
        for (AggregatedValueObject srcVo : srcVOs) {
            aggVo = (AggContractInVO)srcVo;
            if (ArrayUtils.isEmpty((Object[])aggVo.getTableVO("equip"))) continue;
            for (SuperVO superVO : aggVo.getTableVO("equip")) {
                ContractInEquipVO contractInEquipVO = (ContractInEquipVO)superVO;
                AggContractInVO addAggContractInVO = ContractToAssetVOChangeAdjust.createSingleAggContractInVO(aggVo, contractInEquipVO);
                srcVoList.add(addAggContractInVO);
            }
        }
        return srcVoList.toArray(new AggregatedValueObject[0]);
    }

    public static AggContractInVO createSingleAggContractInVO(AggContractInVO aggVO, String pk_contract_eq) {
        ContractInEquipVO[] contractInEquipVOs;
        for (ContractInEquipVO equipVO : contractInEquipVOs = (ContractInEquipVO[])aggVO.body("equip")) {
            if (!equipVO.getPk_contract_eq().equals(pk_contract_eq)) continue;
            return ContractToAssetVOChangeAdjust.createSingleAggContractInVO(aggVO, equipVO);
        }
        return null;
    }

    public static AggContractInVO createSingleAggContractInVO(AggContractInVO aggVO, ContractInEquipVO equipVO) {
        AggContractInVO newAggContractInVO = new AggContractInVO();
        ContractInHeadVO headVO = aggVO.getParentVO();
        String pk_contract_eq = equipVO.getPk_contract_eq();
        String pk_contract_b = equipVO.getPk_contract_b();
        ContractInBodyVO[] addBodyVos = (ContractInBodyVO[])Stream.of((ContractInBodyVO[])aggVO.getTableVO("bodyvos")).filter(vo -> vo != null).filter(vo -> vo.getPk_contract_b() != null).filter(vo -> vo.getPk_contract_b().equals(pk_contract_b)).toArray(ContractInBodyVO[]::new);
        Object[] addCalculationVos = (ContractInCalculationVO[])Stream.of((ContractInCalculationVO[])aggVO.getTableVO("calculation")).filter(vo -> vo != null).filter(vo -> vo.getPk_contract_eq() != null).filter(vo -> vo.getUse_calculate_renttax() != null).filter(vo -> vo.getPk_contract_eq().equals(pk_contract_eq)).toArray(ContractInCalculationVO[]::new);
        ContractRentVO[] addRentVos = (ContractRentVO[])Stream.of((ContractRentVO[])aggVO.getTableVO("pre_rent")).filter(vo -> vo != null).filter(vo -> vo.getPk_contract_b() != null).filter(vo -> vo.getPk_contract_b().equals(pk_contract_eq)).toArray(ContractRentVO[]::new);
        if (addRentVos.length == 0) {
            addRentVos = (ContractRentVO[])Stream.of((ContractRentVO[])aggVO.getTableVO("pre_rent")).filter(vo -> vo != null).filter(vo -> vo.getPk_contract_b() != null).filter(vo -> vo.getPk_contract_b().equals(pk_contract_b)).toArray(ContractRentVO[]::new);
        }
        newAggContractInVO.setParentVO((CircularlyAccessibleValueObject)headVO);
        newAggContractInVO.setChildrenVO((CircularlyAccessibleValueObject[])addBodyVos);
        Arrays.sort(addCalculationVos);
        newAggContractInVO.setTableVO("calculation", (CircularlyAccessibleValueObject[])addCalculationVos);
        newAggContractInVO.setTableVO("pre_rent", (CircularlyAccessibleValueObject[])addRentVos);
        newAggContractInVO.setTableVO("equip", (CircularlyAccessibleValueObject[])new ContractInEquipVO[]{equipVO});
        return newAggContractInVO;
    }
}

