/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.tbb.tool;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.bs.uap.lock.PKLock;
import nc.itf.tb.control.IAccessableBusiVO;
import nc.itf.tb.control.IBudgetControl;
import nc.ms.tb.control.BudgetControlCTLForShare;
import nc.ms.tb.control.UFndBdContext;
import nc.ms.tb.control.UFndCtrlContext;
import nc.pub.fa.common.consts.BudgetControlConst;
import nc.pub.fa.common.manager.VOManager;
import nc.pub.fa.common.util.UseDeptScaleUtils;
import nc.pub.fa.tbb.ctl.ControlProcessFactory;
import nc.pub.fa.tbb.ctl.IBudgetControlVOCreater;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.fa.newasset.NewAssetBodyVO;
import nc.vo.fa.tbb.BudgetControlException;
import nc.vo.fa.tbb.CheckUpdateType;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFDouble;
import nc.vo.tb.control.DataRuleVO;
import nc.vo.tb.control.NtbCtlInfoVO;
import nc.vo.tb.rule.IdCtrlschemeVO;

public class BudgetControlUtil {
    public static NtbCtlInfoVO checkUpdateExe(String billType, String actionCode, Object obj, CheckUpdateType type) throws BusinessException {
        NtbCtlInfoVO ctlInfo = null;
        String[] primaryKeys = null;
        try {
            Object[] delRuleVO = BudgetControlUtil.getIBudgetControl().queryControlTactics(billType, actionCode, true);
            if (ArrayUtils.isNotEmpty((Object[])delRuleVO)) {
                IBudgetControlVOCreater voCreater = ControlProcessFactory.getControlVOCreater(billType);
                IAccessableBusiVO[] ctlVOs = voCreater.createControlVO((DataRuleVO)delRuleVO[0], obj);
                if (type == CheckUpdateType.checkAndUpdate) {
                    ctlInfo = BudgetControlUtil.getIBudgetControl().getControlInfo(ctlVOs);
                } else if (type == CheckUpdateType.check) {
                    ctlInfo = BudgetControlUtil.getIBudgetControl().getCheckInfo(ctlVOs);
                } else if (type == CheckUpdateType.update) {
                    BudgetControlUtil.getIBudgetControl().noCheckUpdateExe(ctlVOs);
                }
                primaryKeys = BudgetControlUtil.getPrimaryKeyLock(ctlVOs);
            }
        }
        catch (BusinessException e) {
            Logger.debug((Object)("\u5f53\u524d\u5f02\u5e38\u7c7b\u578b\u4e3a\uff1aBusinessException\uff0c\u5f02\u5e38\u4fe1\u606f:" + e.getMessage()));
            throw e;
        }
        finally {
            if (primaryKeys != null) {
                PKLock.getInstance().releaseDynamicLock(primaryKeys);
            }
        }
        return ctlInfo;
    }

    private static String[] getPrimaryKeyLock(IAccessableBusiVO[] busivo) throws BusinessException {
        ArrayList<String> list = new ArrayList<String>();
        UFndCtrlContext context = new UFndCtrlContext();
        Map hashEffect = BudgetControlCTLForShare.getMatchingCtrlScheme((IAccessableBusiVO[])busivo, (UFndBdContext)context);
        if (hashEffect.size() == 0) {
            return null;
        }
        for (IdCtrlschemeVO vo : hashEffect.keySet()) {
            list.add(vo.getPrimaryKey());
        }
        return list.toArray(new String[0]);
    }

    public static String getTrueFielName(String billType, String ctl_project) {
        if (billType.equals("H1")) {
            if (ctl_project.equals(BudgetControlConst.CTL_NUM)) {
                return "card_num";
            }
            if (ctl_project.equals(BudgetControlConst.CTL_VALUE)) {
                return "localoriginvalue";
            }
        } else {
            if (ctl_project.equals(BudgetControlConst.CTL_NUM)) {
                return "card_num";
            }
            if (ctl_project.equals(BudgetControlConst.CTL_VALUE)) {
                return "sum_money";
            }
        }
        return null;
    }

    public static IBudgetControl getIBudgetControl() {
        IBudgetControl budgetControl = (IBudgetControl)AMProxy.lookup((String)IBudgetControl.class.getName());
        return budgetControl;
    }

    public static DataRuleVO[] queryControlRule(String billtype, String actionCode) throws BusinessException {
        DataRuleVO[] ruleVOs = BudgetControlUtil.getIBudgetControl().queryControlTactics(billtype, actionCode, true);
        return ruleVOs;
    }

    public static AssetVO[] splitAssetUsedept(AssetVO vo, DeptScaleVO[] deptVos) {
        String[] needSplitFields = new String[]{"localoriginvalue", "card_num"};
        if (null != deptVos) {
            UFDouble total = UFDouble.ZERO_DBL;
            for (DeptScaleVO deptVO : deptVos) {
                UFDouble tUserscale = deptVO.getUsescale();
                if (null == tUserscale) {
                    tUserscale = UFDouble.ZERO_DBL;
                }
                total = total.add(tUserscale);
            }
            VOManager.setAttributeValue((SuperVO[])deptVos, (String)"totalscale", (Object)total);
        }
        AssetVO[] vos = (AssetVO[])UseDeptScaleUtils.splitDataByMutilDept((SuperVO)vo, (String)"pk_usedept", (String[])needSplitFields, (DeptScaleVO[])deptVos);
        return vos;
    }

    public static NewAssetBodyVO[] splitAppUsedept(NewAssetBodyVO vo, DeptScaleVO[] deptVos) {
        String[] needSplitFields = new String[]{"sum_money", "card_num"};
        NewAssetBodyVO[] vos = (NewAssetBodyVO[])UseDeptScaleUtils.splitdataForBudget((String)"pk_usedept", (String[])needSplitFields, (SuperVO)vo, (DeptScaleVO[])deptVos);
        return vos;
    }

    public static NewAssetBodyVO[] splitAppUsedeptnew(NewAssetBodyVO vo, DeptScaleVO[] deptVos, Set<String> pk_accbook) {
        String[] needSplitFields = new String[]{"sum_money", "card_num"};
        NewAssetBodyVO[] vos = (NewAssetBodyVO[])UseDeptScaleUtils.splitdataForBudget((String)"pk_usedept", (String[])needSplitFields, (SuperVO)vo, (DeptScaleVO[])deptVos, pk_accbook);
        return vos;
    }

    public static void disposeNtbCtlInfo(NtbCtlInfoVO info, String billType) throws BusinessException {
        boolean isControl = false;
        if (info != null) {
            if (info.isControl() || info.isAlarm()) {
                isControl = true;
            }
            if (info.isMayBeControl() && billType.equals("HN")) {
                isControl = true;
            }
        }
        if (isControl) {
            Logger.warn((Object)"\u9884\u7b97\u8d85\u51fa\u989d\u5ea6");
            throw new BudgetControlException(info, billType);
        }
    }
}

