/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.tbb.ctl.next;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.itf.fa.service.IAssetService;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.pub.fa.tbb.ctl.next.ICreateNextCtl;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.tb.control.DataRuleVO;

public class AssetUpdateNextCtl
implements ICreateNextCtl {
    @Override
    public Object createNextCtlVO(DataRuleVO thisRuleVO, DataRuleVO nextRule, Object thisObj) throws BusinessException {
        String[] pk_cards = this.getCardKeys(thisObj);
        AggCardVO[] oldCardVOs = this.getOldCardMainBookVO(pk_cards);
        return oldCardVOs;
    }

    private AggCardVO[] getOldCardMainBookVO(String[] pk_cards) throws BusinessException {
        Object[] aVOs;
        AggCardVO[] aggVOs = null;
        if (ArrayUtils.isNotEmpty((Object[])pk_cards) && ArrayUtils.isNotEmpty((Object[])(aVOs = ((IAssetService)AMProxy.lookup(IAssetService.class)).queryMainAssetVOByPks(null, pk_cards)))) {
            aggVOs = CardVOUtils.toAggCards((AssetVO[])aVOs);
            Map<String, List<DeptScaleVO>> multiDeptVOs = ((IAssetService)AMProxy.lookup(IAssetService.class)).queryUseDeptBatch(pk_cards);
            for (int i = 0; i < aggVOs.length; ++i) {
                String pk_card = aggVOs[i].getPrimaryKey();
                List<DeptScaleVO> deptVOs = multiDeptVOs.get(pk_card);
                if (deptVOs == null || deptVOs.size() <= 0) continue;
                aggVOs[i].setTableVO(CardTabConst.useDept, (CircularlyAccessibleValueObject[])CollectionUtils.toArray(deptVOs));
            }
        }
        return aggVOs;
    }

    private String[] getCardKeys(Object thisObj) {
        Object[] objs;
        HashSet<String> bodyKeys = new HashSet<String>();
        if (thisObj instanceof AggCardVO) {
            CardVO cvo = ((AggCardVO)((Object)thisObj)).getParentVO();
            String billSource = cvo.getBill_source();
            if (StringUtils.isNotEmpty((String)billSource) && billSource.equals("HN")) {
                bodyKeys.add(cvo.getPk_card());
            }
        } else if (thisObj.getClass().isArray() && (objs = (Object[])thisObj)[0] instanceof AggCardVO) {
            AggCardVO[] aggVOs;
            for (AggCardVO aggVO : aggVOs = (AggCardVO[])ArrayUtils.convertArrayType((Object[])objs, AggCardVO.class)) {
                CardVO cvo = aggVO.getParentVO();
                String billSource = cvo.getBill_source();
                if (!StringUtils.isNotEmpty((String)billSource) || !billSource.equals("HN")) continue;
                bodyKeys.add(cvo.getPk_card());
            }
        }
        return (String[])CollectionUtils.toArray(bodyKeys);
    }
}

