/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.tbb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.impl.am.common.InSqlManager;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.tb.obj.NtbParamVO;

public class NtbParamTool {
    private NtbParamVO param = null;
    Map<String, List<String>> attrdata = new HashMap<String, List<String>>();

    public NtbParamTool(Object param) {
        NtbParamVO p;
        this.param = param instanceof NtbParamVO ? (p = (NtbParamVO)param) : new NtbParamVO();
        this.initData();
    }

    public static boolean isNtbParamVO(Object obj) {
        return null != obj && obj instanceof NtbParamVO;
    }

    private void initData() {
        String[] busiAttrs = this.getParam().getBusiAttrs();
        boolean[] includelowers = this.getParam().getIncludelower();
        String[] pkdims = this.getParam().getPkDim();
        for (int i = 0; i < busiAttrs.length; ++i) {
            String attr = busiAttrs[i];
            String pkdim = pkdims[i];
            if (this.attrdata.containsKey(attr)) {
                this.attrdata.get(attr).add(pkdim);
            } else {
                ArrayList<String> pkvalue = new ArrayList<String>();
                pkvalue.add(pkdim);
                this.attrdata.put(attr, pkvalue);
            }
            if (!includelowers[i] || this.getParam().getLowerArrays() == null) continue;
            Object[] keys = (String[])this.getParam().getLowerArrays().get(attr);
            if (this.attrdata.get(attr) != null && this.attrdata.get(attr).size() > 0 && ArrayUtils.isNotEmpty((Object[])keys)) {
                this.attrdata.get(attr).addAll(Arrays.asList(keys));
                continue;
            }
            if (!ArrayUtils.isNotEmpty((Object[])keys)) continue;
            this.attrdata.put(attr, Arrays.asList(keys));
        }
    }

    public String getPk_org() {
        return this.getParam().getPk_Org();
    }

    public String getBeginDate() {
        return this.getParam().getBegDate();
    }

    public String getEndDate() {
        return this.getParam().getEndDate();
    }

    public String[] getControlAttrs() {
        return this.attrdata.keySet().toArray(new String[0]);
    }

    public String[] getAttrValueKeys(String attr) {
        return this.attrdata.get(attr).toArray(new String[0]);
    }

    public boolean hasControlAttr(String attr) {
        return this.attrdata.containsKey(attr);
    }

    public String getQueryWhereSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("business_date >= '" + this.getBeginDate() + "'");
        sql.append(" and business_date <= '" + this.getEndDate() + "'");
        for (String attr : this.attrdata.keySet()) {
            List<String> pks = this.attrdata.get(attr);
            sql.append(" and " + attr + "in" + InSqlManager.getInSQLValue(pks));
        }
        return sql.toString();
    }

    public String getQueryWhereSql(Map<String, String> fileColumnName) {
        StringBuffer sql = new StringBuffer();
        for (int i = 1; i < 80; ++i) {
            fileColumnName.put("def" + i, "fa_newasset_b.def" + i);
        }
        for (String field : fileColumnName.keySet()) {
            String column = fileColumnName.get(field);
            if (field.equals("business_date")) {
                sql.append(" and " + column + " >= '" + this.getBeginDate() + "'");
                sql.append(" and " + column + " <= '" + this.getEndDate() + "'");
                continue;
            }
            if (field.equals("pk_org")) {
                sql.append(" and " + column + " = '" + this.getPk_org() + "'");
                continue;
            }
            List<String> pks = this.attrdata.get(field);
            if (pks == null || pks.size() <= 0) continue;
            sql.append(" and " + column + " in " + InSqlManager.getInSQLValue(pks));
        }
        sql.delete(0, 4);
        return sql.toString();
    }

    public String getQueryWhereSqlBatch(Map<String, String> fileColumnName, String groupDocType) {
        StringBuffer sql = new StringBuffer();
        for (int i = 1; i < 80; ++i) {
            fileColumnName.put("def" + i, "fa_newasset_b.def" + i);
        }
        for (String field : fileColumnName.keySet()) {
            List<String> pks;
            String column = fileColumnName.get(field);
            if (field.equals("business_date")) {
                sql.append(" and " + column + " >= '" + this.getBeginDate() + "'");
                sql.append(" and " + column + " <= '" + this.getEndDate() + "'");
                continue;
            }
            if (field.equals("pk_org")) {
                sql.append(" and " + column + " = '" + this.getPk_org() + "'");
                continue;
            }
            if (field.equals(groupDocType.toString()) || (pks = this.attrdata.get(field)) == null || pks.size() <= 0) continue;
            sql.append(" and " + column + " in " + InSqlManager.getInSQLValue(pks));
        }
        sql.delete(0, 4);
        return sql.toString();
    }

    public String getCardQueryWhereSql(Map<String, String> fileColumnName) {
        StringBuffer sql = new StringBuffer();
        for (int i = 1; i < 80; ++i) {
            fileColumnName.put("def" + i, "fa_cardsub.def" + i);
        }
        for (String field : fileColumnName.keySet()) {
            String column = fileColumnName.get(field);
            if (field.equals("business_date")) {
                sql.append(" and " + column + " >= '" + this.getBeginDate() + "'");
                sql.append(" and " + column + " <= '" + this.getEndDate() + "'");
                continue;
            }
            if (field.equals("pk_org")) {
                sql.append(" and " + column + " = '" + this.getPk_org() + "'");
                continue;
            }
            List<String> pks = this.attrdata.get(field);
            if (pks == null || pks.size() <= 0) continue;
            sql.append(" and " + column + " in " + InSqlManager.getInSQLValue(pks));
        }
        sql.delete(0, 4);
        return sql.toString();
    }

    public String getCardQueryWhereSqlBatch(Map<String, String> fileColumnName, String groupDocType) {
        StringBuffer sql = new StringBuffer();
        for (int i = 1; i < 80; ++i) {
            fileColumnName.put("def" + i, "fa_cardsub.def" + i);
        }
        for (String field : fileColumnName.keySet()) {
            List<String> pks;
            String column = fileColumnName.get(field);
            if (field.equals("business_date")) {
                sql.append(" and " + column + " >= '" + this.getBeginDate() + "'");
                sql.append(" and " + column + " <= '" + this.getEndDate() + "'");
                continue;
            }
            if (field.equals("pk_org")) {
                sql.append(" and " + column + " = '" + this.getPk_org() + "'");
                continue;
            }
            if (field.equals(groupDocType.toString()) || (pks = this.attrdata.get(field)) == null || pks.size() <= 0) continue;
            sql.append(" and " + column + " in " + InSqlManager.getInSQLValue(pks));
        }
        sql.delete(0, 4);
        return sql.toString();
    }

    public NtbParamVO getParam() {
        return this.param;
    }

    public void setParam(NtbParamVO param) {
        this.param = param;
    }
}

