/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.msg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import nc.impl.am.common.PfUtilToolsAM;
import nc.itf.fa.service.IAssetService;
import nc.itf.fa.service.IReduceService;
import nc.pub.fa.common.util.StringUtils;
import nc.pub.fa.msg.MsgVO;
import nc.ui.pub.msg.PfLinkData;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;

public class MsgManager {
    public static final String WORKORDER = "4B36";
    public static final String JOBMNGFIL_PRODUCTION = "4D30";
    public static final String PAM = "4A";

    public static <T extends AggregatedValueObject> T assemblyAlterVO(AggregatedValueObject srcVO, MsgVO msgVO) throws BusinessException {
        Object[] srcBodyVOs = (SuperVO[])srcVO.getChildrenVO();
        ArrayList<String> pk_equipList = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])srcBodyVOs)) {
            for (Object srcBody : srcBodyVOs) {
                pk_equipList.add((String)srcBody.getAttributeValue("pk_equip"));
            }
        }
        Object[] retVOs = PfUtilToolsAM.runChangeDataAryWithItfDef((String)msgVO.getDest_bill_type(), (AggregatedValueObject[])new AggregatedValueObject[]{srcVO});
        AggregatedValueObject billVO = (AggregatedValueObject)ArrayUtils.getFirstElem((Object[])retVOs);
        SuperVO[] bodyVOs = (SuperVO[])billVO.getChildrenVO();
        ArrayList<String> pk_cardList = new ArrayList<String>();
        for (SuperVO bodyVO : bodyVOs) {
            String pk_card = (String)bodyVO.getAttributeValue("pk_card");
            if (!StringUtils.isNotBlank((String)pk_card)) continue;
            pk_cardList.add(pk_card);
        }
        if (pk_cardList.size() == 0) {
            String strByID = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0489");
            throw ExceptionUtils.businessException((String)strByID);
        }
        HashSet pk_cardSet = new HashSet();
        String[] filterCardIds = ((IAssetService)AMProxy.lookup(IAssetService.class)).filterOrgCards(msgVO.getPk_org(), (String[])CollectionUtils.toArray(pk_cardList));
        Collections.addAll(pk_cardSet, filterCardIds);
        Map cardMap = ((IReduceService)AMProxy.lookup(IReduceService.class)).isCardReduced((String[])CollectionUtils.toArray(pk_cardList));
        ArrayList<SuperVO> newBodyList = new ArrayList<SuperVO>();
        for (SuperVO bvo : bodyVOs) {
            String pk_card = (String)bvo.getAttributeValue("pk_card");
            if (StringUtils.isEmpty((String)pk_card) || "~".equals(pk_card)) continue;
            boolean isReduced = (Boolean)cardMap.get(pk_card);
            if (!pk_cardSet.contains(pk_card) || isReduced) continue;
            newBodyList.add(bvo);
        }
        billVO.setChildrenVO((CircularlyAccessibleValueObject[])CollectionUtils.toArray(newBodyList));
        return (T)billVO;
    }

    public static MsgVO convertToMsg(PfLinkData linkData) {
        MsgVO msgVO = new MsgVO();
        msgVO.setSrc_billid(linkData.getBillID());
        msgVO.setDest_transi_type(linkData.getBillType());
        msgVO.setDest_bill_type(linkData.getBillType());
        msgVO.setPk_org(linkData.getPkOrg());
        Object userObject = linkData.getUserObject();
        if (userObject == null) {
            return msgVO;
        }
        String strUserObject = (String)userObject;
        if (strUserObject.contains(";")) {
            String[] temp = strUserObject.split(";");
            msgVO.setSrc_module(temp[0]);
            msgVO.setSrc_transi_type(temp[1]);
            int index = temp[1].indexOf("-");
            if (index != -1) {
                msgVO.setSrc_bill_type(temp[1].substring(0, index));
            } else {
                msgVO.setSrc_bill_type(temp[1]);
            }
            msgVO.setService_class_name(temp[2]);
            msgVO.setMethod_name(temp[3]);
        }
        return msgVO;
    }
}

