/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.fulltextretrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nc.bs.logging.Logger;
import nc.itf.fa.prv.IAsset;
import nc.pub.fa.common.util.InSqlManager_FA;
import nc.search.gsc.vo.AppPageInfo;
import nc.search.gsc.vo.PageInfo;
import nc.search.gsc.vo.RowInfo;
import nc.search.gsc.vo.SearchResultVO;
import nc.search.sdk.security.IFullResultFilterProcessor;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;

public class FacardFilterProcessor
implements IFullResultFilterProcessor {
    private static final String[] ASSET_QUERY_FIELDS = new String[]{"pk_card", "newasset_flag", "transi_type"};

    public SearchResultVO processFullResult(SearchResultVO searchResultVO) {
        if (searchResultVO == null || CollectionUtils.isEmpty((Collection)searchResultVO.getRows())) {
            return searchResultVO;
        }
        String[] pk_cards = (String[])searchResultVO.getRows().stream().map(RowInfo::getId).toArray(String[]::new);
        Set<Object> pkCardSet = null;
        Object[] assetVos = null;
        try {
            assetVos = ((IAsset)AMProxy.lookup(IAsset.class)).queryAssetVOWithPermission(pk_cards, ASSET_QUERY_FIELDS);
            if (ArrayUtils.isNotEmpty((Object[])assetVos)) {
                pkCardSet = Arrays.stream(assetVos).map(AssetVO::getPk_card).collect(Collectors.toSet());
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u6743\u9650\u8fc7\u6ee4\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        HashSet newPkCards = pkCardSet == null ? new HashSet() : pkCardSet;
        List newRowInfoList = searchResultVO.getRows().stream().filter(rowInfo -> newPkCards.contains(rowInfo.getId())).collect(Collectors.toList());
        PageInfo pageInfo = searchResultVO.getPageInfo();
        pageInfo.setTotal(newRowInfoList.size());
        pageInfo.setAllpks(newPkCards.toArray(new String[0]));
        if (newRowInfoList.size() % pageInfo.getPageSize() == 0) {
            pageInfo.setTotalPage(newRowInfoList.size() / pageInfo.getPageSize());
        } else {
            pageInfo.setTotalPage(newRowInfoList.size() / pageInfo.getPageSize() + 1);
        }
        searchResultVO.setPageInfo(pageInfo);
        if (newRowInfoList.size() <= pageInfo.getPageSize()) {
            searchResultVO.setRows(newRowInfoList);
        } else {
            searchResultVO.setRows(new ArrayList(newRowInfoList.subList(0, pageInfo.getPageSize())));
        }
        this.dealWithAppPageInfos(searchResultVO, (AssetVO[])assetVos);
        return searchResultVO;
    }

    public SearchResultVO getDataByPage(SearchResultVO pageData) {
        Set<String> pkCardSet = pageData.getRows().stream().map(RowInfo::getId).collect(Collectors.toSet());
        String whereSql = InSqlManager_FA.getInSql((String)"fa_card.pk_card", (String[])pkCardSet.toArray(new String[0]), (UFBoolean)UFBoolean.TRUE);
        AssetVO[] assetVos = null;
        try {
            assetVos = ((IAsset)AMProxy.lookup(IAsset.class)).queryAssetVOBySQL(whereSql, ASSET_QUERY_FIELDS);
        }
        catch (BusinessException e) {
            Logger.error((Object)("\u67e5\u8be2\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
        }
        this.dealWithAppPageInfos(pageData, assetVos);
        return pageData;
    }

    public void dealWithAppPageInfos(SearchResultVO fullResult, AssetVO[] assetVos) {
        if (ArrayUtils.isEmpty((Object[])assetVos)) {
            fullResult.setRows(new ArrayList());
            return;
        }
        Map<String, AssetVO> pkNewAssetFlagMap = Arrays.stream(assetVos).collect(Collectors.toMap(AssetVO::getPk_card, vo -> vo));
        for (int i = 0; i < fullResult.getRows().size(); ++i) {
            RowInfo row = (RowInfo)fullResult.getRows().get(i);
            String pk_card = row.getId();
            AppPageInfo appPage = new AppPageInfo();
            Integer newAssetFlag = pkNewAssetFlagMap.get(pk_card).getNewasset_flag();
            if (newAssetFlag == null) continue;
            if (newAssetFlag % 10 == 0) {
                appPage.setAppcode("201201508A");
                appPage.setPagecode("201201508A_card");
                appPage.setDisplayName(NCLangRes4VoTransl.getNCLangRes().getStrByID("appmenucode", "APP20121508"));
            } else {
                appPage.setAppcode("201201504A");
                appPage.setPagecode("201201504A_card");
                appPage.setDisplayName(NCLangRes4VoTransl.getNCLangRes().getStrByID("appmenucode", "APP20121504"));
            }
            HashMap<String, String> extendValues = new HashMap<String, String>();
            extendValues.put("transiType", pkNewAssetFlagMap.get(pk_card).getTransi_type());
            extendValues.put("linksce", "linksce");
            appPage.setExtendValues(extendValues);
            row.setAppPageInfos(new AppPageInfo[]{appPage});
        }
    }
}

