/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import nc.bs.logging.Logger;
import nc.itf.fa.service.ICategoryService;
import nc.itf.fa.service.ISimulateDepProcess;
import nc.itf.fa.service.IUsingstatusService;
import nc.pub.fa.card.AssetDateCalUtils;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.DeprateUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.dailydep.DailyDepCardVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;

public class Operater9
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private OptionVO optionVO = null;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO method, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.optionVO = optionVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    private void procDep() {
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        boolean depAll_flag = this.optionVO.getDepall_flag().booleanValue();
        boolean isDepAll = false;
        UFDate dep_end_date = endHistoryVO.getDep_end_date();
        String accyear = beginHistoryVo.getAccyear();
        String period = beginHistoryVo.getPeriod();
        String pk_accbook = beginHistoryVo.getPk_accbook();
        String[] periodArea = null;
        try {
            if (StringUtils.isNotEmpty((String)accyear) && StringUtils.isNotEmpty((String)period) && dep_end_date.compareTo(UFDate.getDate((String)(periodArea = PeriodManager.getInstance().queryPerriodDate(pk_accbook, accyear, period))[1])) <= 0) {
                isDepAll = true;
            }
        }
        catch (BusinessException e) {
            Logger.debug((Object)("\u65e5\u6298\u65e7\u5361\u7247\u5224\u65ad\u662f\u5426\u63d0\u8db3\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        boolean depAttr = true;
        try {
            String pk_category_old = beginHistoryVo.getPk_category();
            String pk_usingstatus_old = beginHistoryVo.getPk_usingstatus();
            int depattr = this.queryCategoryAttrMap().get(pk_category_old);
            int dep_flag = this.queryUsingstatusAttrMap().get(pk_usingstatus_old);
            if (depattr == 2 || dep_flag == 0 && depattr != 0) {
                depAttr = false;
            }
        }
        catch (BusinessException e) {
            Logger.error((Object)("\u6a21\u62df\u6298\u65e7\u65f6\uff0c\u67e5\u8be2\u8d44\u4ea7\u7c7b\u522b\u3001\u4f7f\u7528\u72b6\u51b5\u6298\u65e7\u5c5e\u6027\u9519\u8bef\u3002" + e.getMessage()));
        }
        if (isDepAll && depAll_flag && depAttr) {
            this.allDep();
        } else {
            this.normalDep();
        }
    }

    private void heritDep() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (!beginHistoryVo.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.001) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVo.getDepamount();
            this.depRate = beginHistoryVo.getDeprate().toBigDecimal();
        }
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        if (this.depRate.doubleValue() < 0.0) {
            this.depRate = BigDecimal.ZERO;
        }
        this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
    }

    private void allDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = UFDoubleUtils.sub((UFDouble)endHistoryVO.getAccudep(), (UFDouble)endHistoryVO.getDepamount());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage);
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = DeprateUtils.getDivBigDecimal(this.depAmount, localoriginvalue.sub(predevaluate), this.param.getDigitOfDepRate());
            this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
        }
    }

    private void normalDep() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVo = this.depCardVO.getEndCardhistoryVO();
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        if (!beginHistoryVo.getAccudep().equals((Object)accudep) && endHistoryVo.getAccudep().equals((Object)accudep)) {
            accudep = accudep.sub(endHistoryVo.getDepamount());
        }
        UFBoolean isCardSim = this.depCardVO.getIsCardSim();
        UFDate depStartDate = (UFDate)this.getHistoryAttributeValue("dep_start_date");
        UFDate depEndDate = (UFDate)this.getHistoryAttributeValue("dep_end_date");
        UFDate businessdate = this.depCardVO.getReduce_date();
        UFDate currentStartDate = null;
        UFDate currentEndDate = null;
        AccperiodVO periodVO = null;
        String pk_accbook = (String)this.getHistoryAttributeValue("pk_accbook");
        try {
            PeriodManager periodManager = PeriodManager.getInstance();
            periodVO = periodManager.queryPerriodMonth(pk_accbook, businessdate);
            currentStartDate = periodVO.getStartdate();
            currentEndDate = periodVO.getEnddate();
        }
        catch (BusinessException e) {
            try {
                periodVO = AssetDateCalUtils.getTempPeriod(pk_accbook, businessdate);
            }
            catch (BusinessException e2) {
                Logger.error((Object)e2.getMessage());
            }
            currentStartDate = periodVO.getStartdate();
            currentEndDate = periodVO.getEnddate();
        }
        UFDate calStartDate = null;
        UFDate calEndDate = null;
        calStartDate = depStartDate.asBegin().after(currentStartDate.asBegin()) ? depStartDate : currentStartDate;
        calEndDate = depEndDate.asBegin().after(currentEndDate.asBegin()) ? currentEndDate : businessdate;
        if (!isCardSim.booleanValue()) {
            if (businessdate.asBegin().compareTo(calEndDate.asBegin()) > 0 || businessdate.asBegin().compareTo(calStartDate.asBegin()) < 0) {
                this.depAmount = UFDouble.ZERO_DBL;
                this.depRate = BigDecimal.ZERO;
                return;
            }
            calEndDate = businessdate;
            if (depStartDate.asBegin().compareTo(businessdate.asBegin()) == 0) {
                this.depAmount = UFDouble.ZERO_DBL;
                this.depRate = BigDecimal.ZERO;
                return;
            }
        } else {
            calEndDate = currentEndDate;
        }
        beginHistoryVo.setDep_start_date(calStartDate);
        beginHistoryVo.setDep_end_date(calEndDate);
        try {
            Map depMap = ((ISimulateDepProcess)AMProxy.lookup(ISimulateDepProcess.class)).simulateDep(this.depCardVO);
            if (null != depMap && !depMap.isEmpty()) {
                String pk_card = beginHistoryVo.getPk_card();
                DailyDepCardVO dailyDepCardVO = (DailyDepCardVO)depMap.get(pk_card);
                if (null != dailyDepCardVO) {
                    this.depAmount = dailyDepCardVO.getDepamount_cal();
                    if (null == this.depAmount || this.depAmount.doubleValue() < 0.0) {
                        this.depAmount = UFDouble.ZERO_DBL;
                        this.depRate = new BigDecimal(0.0);
                    } else {
                        this.depRate = DeprateUtils.getDivBigDecimal(this.depAmount, this.depCardVO.getEndCardhistoryVO().getLocaloriginvalue(), this.param.getDigitOfDepRate());
                        this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
                    }
                }
            } else {
                this.depAmount = UFDouble.ZERO_DBL;
                this.depRate = new BigDecimal(0.0);
            }
        }
        catch (BusinessException e) {
            Logger.debug((Object)("\u65e5\u6298\u65e7\u5361\u7247\u6a21\u62df\u6298\u65e7\u9519\u8bef\uff01" + e.getMessage()));
        }
    }

    protected Map<String, Integer> queryCategoryAttrMap() throws BusinessException {
        return ((ICategoryService)AMProxy.lookup(ICategoryService.class)).queryCategoryDepattrMap(this.depCardVO.getCardVO().getPk_group());
    }

    protected Map<String, Integer> queryUsingstatusAttrMap() throws BusinessException {
        return ((IUsingstatusService)AMProxy.lookup(IUsingstatusService.class)).queryAllDep_flag(this.depCardVO.getCardVO().getPk_group());
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

