/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater8
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        boolean bFirstMonth = false;
        if (beginHistoryVO.getNewasset_flag() < 2) {
            bFirstMonth = true;
        }
        if (beginHistoryVO.getUsedmonth() == 0) {
            bFirstMonth = true;
        }
        if (this.param.isSimulateDep() || this.isReduced(endHistoryVO.getAsset_state())) {
            bFirstMonth = false;
        }
        if (bFirstMonth) {
            try {
                this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)new UFDouble(localoriginvalue.doubleValue() / 2.0), (String)endHistoryVO.getPk_accbook());
            }
            catch (NumberFormatException e) {
                this.depAmount = new UFDouble(localoriginvalue.doubleValue() / 2.0).setScale(this.param.getDigitOfLocalOriginValue(), 4);
            }
            catch (BusinessException e) {
                this.depAmount = new UFDouble(localoriginvalue.doubleValue() / 2.0).setScale(this.param.getDigitOfLocalOriginValue(), 4);
            }
            this.depRate = new BigDecimal(0.5).setScale(this.param.getDigitOfDepRate(), 4);
            return;
        }
        this.notFirstDep();
    }

    private void notFirstDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble endDepamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        accudep = accudep.sub(endDepamount);
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble localoriginvalue = endHistoryVO.getLocaloriginvalue();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage);
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = new BigDecimal(0.5).setScale(this.param.getDigitOfDepRate(), 4);
        }
    }

    private boolean checkNeedtoDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        accudep = accudep.sub(depamount);
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        if (localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).doubleValue() < 1.0E-4) {
            return false;
        }
        if (endHistoryVO.getUsedmonth() == 0) {
            return true;
        }
        if (this.isReduced(endHistoryVO.getAsset_state())) {
            return true;
        }
        return this.param.isSimulateDep();
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
    }

    private boolean isReduced(String asset_state) {
        HashSet reduceStateSet = new HashSet();
        CollectionUtils.addAll(reduceStateSet, (Object[])new String[]{"redeploy_out", "redeploy_way", "reduce"});
        return reduceStateSet.contains(asset_state);
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

