/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.DeprateUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater7
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.param = param;
        this.depAmount = UFDouble.ZERO_DBL;
        this.depRate = BigDecimal.ZERO;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "accudep"));
        if (!beginHistoryVo.getAccudep().equals((Object)accudep) && endHistoryVO.getAccudep().equals((Object)accudep)) {
            accudep = accudep.sub(endHistoryVO.getDepamount());
        }
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "predevaluate"));
        UFDouble udNewCardSalvate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "salvage"));
        this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(udNewCardSalvate);
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = DeprateUtils.getDivBigDecimal(this.depAmount, localoriginvalue.sub(predevaluate), this.param.getDigitOfDepRate());
        }
        endHistoryVO.setDepunit(new UFDouble(0.0, -1 * this.param.getDigitOfDepRate()));
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private boolean checkNeedtoDep() {
        int isDep = this.depCardVO.getEndCardhistoryVO().getUsedmonth() - this.depCardVO.getBeginCardhistoryVO().getUsedmonth();
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "salvage"));
        if (localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).doubleValue() < 1.0E-4) {
            return isDep > 0;
        }
        return true;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue"));
        UFDouble accudep = UFDoubleUtils.sub((UFDouble)endHistoryVO.getAccudep(), (UFDouble)endHistoryVO.getDepamount());
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "salvage"));
        if (localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private <T> T getHistoryAttributeValue(DepCardVO depCardVO, String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(depCardVO, attributeName);
        return value;
    }
}

