/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.common.util.StringUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Operater3;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater6
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private OptionVO optionVO = null;
    private DepmethodVO depmethodVO = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private UFDouble beforeyeardep = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private DepValueGetterUtils valueGetterUtils;
    private Set<String> traceCards;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.depmethodVO = depmethodVO;
        this.optionVO = optionVO;
        this.param = param;
        this.traceCards = traceCards;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int usedmonth = NumberUtils.getInteger(this.getHistoryAttributeValue("usedmonth"));
        boolean depAll_flag = this.optionVO.getDepall_flag().booleanValue();
        if (usedmonth > servicemonth - 1 && depAll_flag) {
            usedmonth = servicemonth - 1;
        }
        if (usedmonth == servicemonth - 1 && depAll_flag) {
            this.allDep();
        } else if (endHistoryVO.getHerit_flag().booleanValue()) {
            this.heritDep();
        } else {
            this.normalDep();
        }
        beginHistoryVO.setDepunit(new UFDouble(0.0, -1 * this.param.getDigitOfDepRate()));
    }

    private void normalDep() {
        int usedmonth;
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        String traceflag = this.depCardVO.getCardVO().getDef1();
        boolean isTrace = null != traceflag && StringUtils.isNotEmpty((String)traceflag.toString()) && "trace".equals(traceflag);
        String traceBeforeAccudepObj = this.depCardVO.getCardVO().getDef2();
        UFDouble traceBeforeAccudep = null != traceBeforeAccudepObj && StringUtils.isNotEmpty((String)traceBeforeAccudepObj.toString()) ? new UFDouble(traceBeforeAccudepObj.toString()) : UFDouble.ZERO_DBL;
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        if (servicemonth - (usedmonth = NumberUtils.getInteger((Object)beginHistoryVO.getUsedmonth()).intValue()) <= 2 * this.param.getCountOfperiods()) {
            Operater3 operater3 = new Operater3();
            operater3.procDep(this.depCardVO, this.depmethodVO, this.optionVO, this.param, this.traceCards);
            this.depAmount = operater3.getAmount();
            this.depRate = operater3.getRate();
        } else {
            Map<String, Object> valueMap = this.valueGetterUtils.getRecalAttribuateValueMap(this.depCardVO);
            servicemonth = (Integer)valueMap.get("servicemonth_cal");
            usedmonth = (Integer)valueMap.get("usedmonth_cal");
            UFDouble cal_localoriginvalue = (UFDouble)valueMap.get("originvalue_cal");
            UFDouble predevaluate = NumberUtils.getUFDouble((Object)valueMap.get("predevaluate"));
            int iPeriods = this.param.getCountOfperiods();
            this.depRate = UFDoubleUtils.div((UFDouble)new UFDouble(2), (UFDouble)new UFDouble(servicemonth), (int)this.param.getDigitOfDepRate()).toBigDecimal();
            double dYeardep = 0.0;
            for (int i = 0; i < usedmonth / iPeriods; ++i) {
                try {
                    dYeardep += new UFDouble(FAScaleUtils.setScaleByAccbook((UFDouble)new UFDouble((cal_localoriginvalue.doubleValue() - dYeardep - predevaluate.doubleValue()) * this.depRate.doubleValue()), (String)beginHistoryVO.getPk_accbook())).doubleValue() * (double)iPeriods;
                    continue;
                }
                catch (NumberFormatException e) {
                    dYeardep += new UFDouble((cal_localoriginvalue.doubleValue() - dYeardep - predevaluate.doubleValue()) * this.depRate.doubleValue()).setScale(this.param.getDigitOfLocalOriginValue(), 4).doubleValue() * (double)iPeriods;
                    continue;
                }
                catch (BusinessException e) {
                    dYeardep += new UFDouble((cal_localoriginvalue.doubleValue() - dYeardep - predevaluate.doubleValue()) * this.depRate.doubleValue()).setScale(this.param.getDigitOfLocalOriginValue(), 4).doubleValue() * (double)iPeriods;
                }
            }
            if (isTrace) {
                if (usedmonth < iPeriods) {
                    this.beforeyeardep = traceBeforeAccudep;
                    dYeardep = this.beforeyeardep.doubleValue();
                } else if (usedmonth % iPeriods == 0) {
                    dYeardep = this.beforeyeardep.add(this.depAmount.doubleValue() * (double)iPeriods).doubleValue();
                    this.beforeyeardep = new UFDouble(dYeardep);
                } else {
                    dYeardep = this.beforeyeardep.doubleValue();
                }
            }
            this.depAmount = cal_localoriginvalue.sub(new UFDouble(dYeardep)).sub(predevaluate).multiply(this.depRate.doubleValue());
        }
    }

    private void heritDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (!beginHistoryVO.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.001) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVO.getDepamount();
            this.depRate = beginHistoryVO.getDeprate().toBigDecimal();
        }
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private boolean checkNeedtoDep() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble cal_accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        return !(cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage).doubleValue() < 0.0);
    }

    private void processDepEnd() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        UFDouble depamount = NumberUtils.getUFDouble(this.getHistoryAttributeValue("depamount"));
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)((String)this.getHistoryAttributeValue("pk_accbook")));
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private void allDep() {
        ICardhistoryVO endHistory = this.depCardVO.getEndCardhistoryVO();
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble((Object)endHistory.getOriginvalue_cal());
        UFDouble cal_accudep = NumberUtils.getUFDouble((Object)endHistory.getAccudep_cal());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistory.getPredevaluate());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistory.getSalvage());
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage), (String)endHistory.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage).setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = new BigDecimal(0.0);
        } else {
            this.depRate = UFDoubleUtils.div((UFDouble)this.depAmount, (UFDouble)cal_localoriginvalue.sub(salvage).sub(predevaluate), (int)this.param.getDigitOfDepRate()).toBigDecimal();
        }
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

