/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater5
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private OptionVO optionVO = null;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.optionVO = optionVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private boolean checkNeedtoDep() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble cal_accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep_cal"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        return !(cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage).doubleValue() < 0.0);
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        int cal_servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int cal_usedmonth = NumberUtils.getInteger((Object)beginHistoryVO.getUsedmonth_cal());
        boolean depall_flag = this.optionVO.getDepall_flag().booleanValue();
        if (cal_usedmonth > cal_servicemonth - 1 && depall_flag) {
            cal_usedmonth = cal_servicemonth - 1;
        }
        if (cal_usedmonth == cal_servicemonth - 1 && depall_flag) {
            this.allDep();
        } else {
            if (endHistoryVO.getHerit_flag() != null && endHistoryVO.getHerit_flag().booleanValue()) {
                this.heritDep();
            } else {
                this.normalDep();
            }
            endHistoryVO.setDepunit(new UFDouble(0.0, -1 * this.param.getDigitOfDepRate()));
        }
    }

    private void heritDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (!beginHistoryVO.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.0) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVO.getDepamount();
            this.depRate = beginHistoryVO.getDeprate().toBigDecimal();
        }
    }

    private void normalDep() {
        int serviceYears;
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        Map<String, Object> valueMap = this.valueGetterUtils.getRecalAttribuateValueMap(this.depCardVO);
        int cal_servicemonth = (Integer)valueMap.get("servicemonth_cal");
        int cal_usedmonth = (Integer)valueMap.get("usedmonth_cal");
        UFDouble cal_localoriginvalue = (UFDouble)valueMap.get("originvalue_cal");
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)valueMap.get("predevaluate"));
        int periods = this.param.getCountOfperiods();
        int usedYears = cal_usedmonth / periods + 1;
        if (usedYears <= (serviceYears = cal_servicemonth / periods)) {
            this.depRate = UFDoubleUtils.div((UFDouble)new UFDouble(serviceYears - usedYears + 1), (UFDouble)new UFDouble((double)(serviceYears * (serviceYears + 1) * periods) / 2.0 + (double)(cal_servicemonth % periods)), (int)this.param.getDigitOfDepRate()).toBigDecimal();
            this.depAmount = cal_localoriginvalue.sub(salvage).sub(predevaluate).multiply(this.depRate.doubleValue());
        } else {
            this.depRate = UFDoubleUtils.div((UFDouble)UFDouble.ONE_DBL, (UFDouble)new UFDouble((double)(serviceYears * (serviceYears + 1) * periods) / 2.0 + (double)(cal_servicemonth % periods), this.param.getDigitOfDepRate())).toBigDecimal();
            this.depAmount = cal_localoriginvalue.sub(salvage).sub(predevaluate).multiply(this.depRate.doubleValue());
        }
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        if (this.depRate.doubleValue() < 0.0) {
            this.depRate = BigDecimal.ZERO;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private void allDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble cal_accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep_cal());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        this.depAmount = cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage);
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = UFDoubleUtils.div((UFDouble)this.depAmount, (UFDouble)cal_localoriginvalue.sub(salvage).sub(predevaluate), (int)this.param.getDigitOfDepRate()).toBigDecimal();
        }
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

