/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.manager.CurrencyManager;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater4
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private UFDouble depunit;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        if (!beginHistoryVO.getAccudep().equals((Object)accudep) && endHistoryVO.getAccudep().equals((Object)accudep)) {
            accudep = accudep.sub(endHistoryVO.getDepamount());
        }
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble allworkloan = NumberUtils.getUFDouble(this.getHistoryAttributeValue("allworkloan"));
        UFDouble accuworkloan = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accuworkloan"));
        if (allworkloan.doubleValue() > accuworkloan.doubleValue()) {
            UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
            this.depunit = new UFDouble(BigDecimal.valueOf(localoriginvalue.sub(salvage).sub(accudep).sub(predevaluate).doubleValue() / allworkloan.sub(accuworkloan).doubleValue()));
        } else {
            this.depunit = UFDouble.ZERO_DBL;
        }
        try {
            this.depunit = FAScaleUtils.setScaleByCurrTypeAndParam((UFDouble)this.depunit, (String)CurrencyManager.getCurrencyPKByAccbook((String)endHistoryVO.getPk_accbook()), (int)this.param.getDigitOfDepRate());
        }
        catch (Exception e) {
            this.depunit = this.depunit.setScale(this.param.getDigitOfDepRate(), 4);
        }
        this.depAmount = NumberUtils.getUFDouble((Object)this.depCardVO.getEndCardhistoryVO().getAttributeValue("monthworkloan")).multiply(this.depunit.doubleValue());
        beginHistoryVO.setDepunit(this.depunit);
        beginHistoryVO.setDeprate(this.depunit);
        this.depRate = new BigDecimal(0.0);
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private boolean checkNeedtoDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        if (localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).doubleValue() < 0.0) {
            return false;
        }
        double allworkloan = NumberUtils.getInteger((Object)beginHistoryVO.getAllworkloan()).doubleValue();
        return !(allworkloan - NumberUtils.getInteger((Object)beginHistoryVO.getAccuworkloan()).doubleValue() < 0.0);
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

