/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.DeprateUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater3
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private OptionVO optionVO = null;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO method, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.optionVO = optionVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int usedMonth = NumberUtils.getInteger((Object)beginHistoryVo.getUsedmonth());
        boolean depAll_flag = this.optionVO.getDepall_flag().booleanValue();
        if (usedMonth > servicemonth - 1 && depAll_flag) {
            usedMonth = servicemonth - 1;
        }
        if (usedMonth == servicemonth - 1 && depAll_flag) {
            this.allDep();
        } else if (endHistoryVO.getHerit_flag().booleanValue()) {
            this.heritDep();
        } else {
            this.normalDep();
        }
    }

    private void heritDep() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (!beginHistoryVo.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.001) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVo.getDepamount();
            this.depRate = beginHistoryVo.getDeprate().toBigDecimal();
        }
    }

    private boolean checkNeedtoDep() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        double differ = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).doubleValue();
        return !(differ < 0.0);
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamount = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        if (this.depRate.doubleValue() < 0.0) {
            this.depRate = BigDecimal.ZERO;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private void allDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble accudep = UFDoubleUtils.sub((UFDouble)endHistoryVO.getAccudep(), (UFDouble)endHistoryVO.getDepamount());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage);
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = DeprateUtils.getDivBigDecimal(this.depAmount, localoriginvalue.sub(predevaluate), this.param.getDigitOfDepRate());
            this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
        }
    }

    private void normalDep() {
        ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVo = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        if (!beginHistoryVo.getAccudep().equals((Object)accudep) && endHistoryVo.getAccudep().equals((Object)accudep)) {
            accudep = accudep.sub(endHistoryVo.getDepamount());
        }
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int usedMonth = NumberUtils.getInteger((Object)beginHistoryVo.getUsedmonth());
        this.depAmount = new UFDouble(localoriginvalue.sub(salvage).sub(accudep).sub(predevaluate).doubleValue() / (double)(servicemonth - usedMonth));
        UFDouble depAmount_ratedigit = this.depAmount.setScale(this.param.getDigitOfDepRate(), 4);
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVo.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = new BigDecimal(0.0);
        } else {
            this.depRate = DeprateUtils.getDivBigDecimal(depAmount_ratedigit, localoriginvalue.sub(predevaluate), this.param.getDigitOfDepRate());
            this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
        }
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

