/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Set;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.DeprateUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDouble;

public class Operater2
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private OptionVO optionVO = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.optionVO = optionVO;
        this.param = param;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue(this.depCardVO, "servicemonth"));
        int usedMonth = NumberUtils.getInteger((Object)beginHistoryVO.getUsedmonth());
        boolean depAll_flag = this.optionVO.getDepall_flag().booleanValue();
        if (usedMonth > servicemonth - 1 && depAll_flag) {
            usedMonth = servicemonth - 1;
        }
        if (usedMonth == servicemonth - 1 && depAll_flag) {
            this.allDep();
        } else if (endHistoryVO.getHerit_flag() != null && endHistoryVO.getHerit_flag().booleanValue()) {
            this.heritDep(beginHistoryVO, endHistoryVO);
        } else {
            this.normalDep();
        }
        endHistoryVO.setDepunit(new UFDouble(0, -1 * this.param.getDigitOfDepRate()));
    }

    private void heritDep(ICardhistoryVO beginHistoryVO, ICardhistoryVO endHistoryVO) {
        if (!beginHistoryVO.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && (endHistoryVO.getDepamount().doubleValue() > 0.0 || endHistoryVO.getDeprate().doubleValue() > 0.0)) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVO.getDepamount();
            this.depRate = beginHistoryVO.getDeprate().toBigDecimal();
        }
    }

    private boolean checkNeedtoDep() {
        UFDouble predevaluate = UFDouble.ZERO_DBL;
        UFDouble localoriginvalue = UFDouble.ZERO_DBL;
        UFDouble accudep = UFDouble.ZERO_DBL;
        UFDouble salvage = UFDouble.ZERO_DBL;
        predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "predevaluate"));
        localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue"));
        accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "accudep"));
        salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "salvage"));
        double differ = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).doubleValue();
        return !(Math.abs(differ) < 0.0);
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistory = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = UFDouble.ZERO_DBL;
        UFDouble localoriginvalue = UFDouble.ZERO_DBL;
        UFDouble accudep = UFDouble.ZERO_DBL;
        UFDouble salvage = UFDouble.ZERO_DBL;
        UFDouble depamount = UFDouble.ZERO_DBL;
        predevaluate = NumberUtils.getUFDouble((Object)endHistory.getPredevaluate());
        localoriginvalue = NumberUtils.getUFDouble((Object)endHistory.getLocaloriginvalue());
        accudep = NumberUtils.getUFDouble((Object)endHistory.getAccudep());
        salvage = NumberUtils.getUFDouble((Object)endHistory.getSalvage());
        depamount = NumberUtils.getUFDouble((Object)endHistory.getDepamount());
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        if (this.depRate.doubleValue() < 0.0) {
            this.depRate = BigDecimal.ZERO;
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistory.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
    }

    private void allDep() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble localoriginvalue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble accudep = UFDoubleUtils.sub((UFDouble)endHistoryVO.getAccudep(), (UFDouble)endHistoryVO.getDepamount());
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage), (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = localoriginvalue.sub(accudep).sub(predevaluate).sub(salvage).setScale(this.param.getDigitOfLocalOriginValue(), 4);
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = BigDecimal.ZERO;
        } else {
            this.depRate = DeprateUtils.getDivBigDecimal(this.depAmount, localoriginvalue.sub(predevaluate), this.param.getDigitOfDepRate());
            this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
        }
    }

    private void normalDep() {
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue"));
        UFDouble salvageRate = NumberUtils.getUFDouble((Object)(((UFDouble)this.getHistoryAttributeValue(this.depCardVO, "salvagerate")).doubleValue() / 100.0));
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue(this.depCardVO, "servicemonth"));
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue(this.depCardVO, "predevaluate"));
        this.depRate = DeprateUtils.getDivBigDecimal(UFDouble.ONE_DBL.sub(salvageRate), new UFDouble(servicemonth), this.param.getDigitOfDepRate());
        this.depRate = this.depRate.setScale(this.param.getDigitOfDepRate(), 4);
        BigDecimal BDDepAmount = localoriginvalue.toBigDecimal().subtract(predevaluate.toBigDecimal()).multiply(this.depRate);
        this.depAmount = new UFDouble(BDDepAmount);
    }

    private <T> T getHistoryAttributeValue(DepCardVO depCardVO, String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(depCardVO, attributeName);
        return value;
    }
}

