/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Set;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Operater3;
import nc.pub.fa.dep.Param;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccbookManager;
import nc.vo.am.scale.query.IDigitQueryVar;
import nc.vo.am.scale.query.ScaleObjFactory;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.lang.UFDouble;

public class Operater10
implements IDepOperater {
    private DepCardVO depCardVO = null;
    private Param param = null;
    private OptionVO optionVO = null;
    private DepmethodVO depmethodVO = null;
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private DepValueGetterUtils valueGetterUtils;
    private Set<String> traceCards;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.depmethodVO = depmethodVO;
        this.optionVO = optionVO;
        this.param = param;
        this.traceCards = traceCards;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
        this.procDep();
    }

    private void procDep() {
        if (!this.checkNeedtoDep()) {
            return;
        }
        this.calculate();
        this.processDepEnd();
    }

    private void calculate() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int usedmonth = NumberUtils.getInteger(this.getHistoryAttributeValue("usedmonth"));
        boolean depAll_flag = this.optionVO.getDepall_flag().booleanValue();
        if (usedmonth > servicemonth - 1 && depAll_flag) {
            usedmonth = servicemonth - 1;
        }
        if (usedmonth == servicemonth - 1 && depAll_flag) {
            this.allDep();
        } else if (endHistoryVO.getHerit_flag().booleanValue()) {
            this.heritDep();
        } else {
            this.normalDep();
        }
        beginHistoryVO.setDepunit(new UFDouble(0.0, -1 * this.param.getDigitOfDepRate()));
    }

    private void normalDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth"));
        int servicemonth_cal = NumberUtils.getInteger(this.getHistoryAttributeValue("servicemonth_cal"));
        int usedmonth = NumberUtils.getInteger((Object)beginHistoryVO.getUsedmonth());
        if (servicemonth - usedmonth <= 2 * this.param.getCountOfperiods()) {
            Operater3 operater3 = new Operater3();
            operater3.procDep(this.depCardVO, this.depmethodVO, this.optionVO, this.param, this.traceCards);
            this.depAmount = operater3.getAmount();
            this.depRate = operater3.getRate();
        } else {
            UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
            UFDouble cal_localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
            UFDouble cal_accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
            if (!this.depCardVO.getBeginCardhistoryVO().getAccudep().equals((Object)cal_accudep) && this.depCardVO.getEndCardhistoryVO().getAccudep().equals((Object)cal_accudep)) {
                cal_accudep = cal_accudep.sub(this.depCardVO.getEndCardhistoryVO().getDepamount());
            }
            Integer month = 0;
            month = servicemonth_cal == servicemonth ? Integer.valueOf(servicemonth) : Integer.valueOf(servicemonth_cal);
            this.depRate = UFDoubleUtils.div((UFDouble)new UFDouble(2), (UFDouble)new UFDouble(month.intValue()), (int)this.param.getDigitOfDepRate()).toBigDecimal();
            this.depAmount = cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).multiply(this.depRate.doubleValue());
        }
    }

    private void heritDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (!beginHistoryVO.getHerit_flag().booleanValue()) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.001) {
            this.depAmount = endHistoryVO.getDepamount();
            this.depRate = endHistoryVO.getDeprate().toBigDecimal();
        } else {
            this.depAmount = beginHistoryVO.getDepamount();
            this.depRate = beginHistoryVO.getDeprate().toBigDecimal();
        }
    }

    @Override
    public UFDouble getAmount() {
        return this.depAmount;
    }

    @Override
    public BigDecimal getRate() {
        return this.depRate;
    }

    private boolean checkNeedtoDep() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble cal_accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        return !(cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage).doubleValue() < 0.0);
    }

    private void processDepEnd() {
        UFDouble predevaluate = NumberUtils.getUFDouble(this.getHistoryAttributeValue("predevaluate"));
        UFDouble localoriginvalue = NumberUtils.getUFDouble(this.getHistoryAttributeValue("localoriginvalue"));
        UFDouble accudep = NumberUtils.getUFDouble(this.getHistoryAttributeValue("accudep"));
        UFDouble salvage = NumberUtils.getUFDouble(this.getHistoryAttributeValue("salvage"));
        UFDouble depamount = NumberUtils.getUFDouble(this.getHistoryAttributeValue("depamount"));
        if (localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage).sub(this.depAmount).doubleValue() < 1.0E-4) {
            this.depAmount = localoriginvalue.sub(accudep.sub(depamount)).sub(predevaluate).sub(salvage);
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = UFDouble.ZERO_DBL;
            }
        }
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
        }
        String pk_accbook = this.depCardVO.getEndCardhistoryVO().getPk_accbook();
        String pk_currtype = null;
        pk_currtype = AccbookManager.queryCurrTypeByAccbook((String)pk_accbook);
        IDigitQueryVar digitQuery = new ScaleObjFactory().getCurrTypeScaleObj();
        int roundingMode = digitQuery.getRoundingMode((Object)pk_currtype, false);
        if (roundingMode == 4) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 4);
        } else if (roundingMode == 1) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 1);
        } else if (roundingMode == 0) {
            this.depAmount = this.depAmount.setScale(this.param.getDigitOfLocalOriginValue(), 0);
        }
    }

    private void allDep() {
        ICardhistoryVO endHistory = this.depCardVO.getEndCardhistoryVO();
        UFDouble originvalue_cal = null == endHistory.getOriginvalue_cal() ? endHistory.getOriginvalue() : endHistory.getOriginvalue_cal();
        UFDouble cal_localoriginvalue = NumberUtils.getUFDouble((Object)originvalue_cal);
        UFDouble cal_accudep = UFDoubleUtils.sub((UFDouble)endHistory.getAccudep(), (UFDouble)endHistory.getDepamount());
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistory.getPredevaluate());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistory.getSalvage());
        this.depAmount = cal_localoriginvalue.sub(cal_accudep).sub(predevaluate).sub(salvage).setScale(this.param.getDigitOfLocalOriginValue(), 4);
        if (this.depAmount.doubleValue() < 0.0) {
            this.depAmount = UFDouble.ZERO_DBL;
            this.depRate = new BigDecimal(0.0);
        } else {
            this.depRate = UFDoubleUtils.div((UFDouble)this.depAmount, (UFDouble)cal_localoriginvalue.sub(salvage).sub(predevaluate), (int)this.param.getDigitOfDepRate()).toBigDecimal();
        }
    }

    private <T> T getHistoryAttributeValue(String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(this.depCardVO, attributeName);
        return value;
    }
}

