/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.pub.fa.common.consts.DepattributeConst;
import nc.pub.fa.dep.DepCardVO;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.lang.UFDouble;

public class DepValueGetterUtils {
    private OptionVO optionVO;
    private Map<String, Integer> accbookDepMap4Asset;
    private Map<String, Integer> accbookDepMap4Used;
    private Set<String> traceCards;
    private Set<String> depAttrFieldSet = new HashSet<String>();

    public DepValueGetterUtils(OptionVO optionVO, Map<String, Integer> accbookDepMap4Asset, Map<String, Integer> accbookDepMap4Used, Set<String> traceCards) {
        CollectionUtils.addAll(this.depAttrFieldSet, (Object[])new String[]{"localoriginvalue", "accudep", "salvage", "salvagerate", "predevaluate", "originvalue_cal", "accudep_cal"});
        this.optionVO = optionVO;
        this.accbookDepMap4Asset = accbookDepMap4Asset;
        this.accbookDepMap4Used = accbookDepMap4Used;
        this.traceCards = traceCards;
    }

    public <T> T getHistoryAttributeValue(DepCardVO depCardVO, String attributeName) {
        if (this.isCurrentMonthAffect(depCardVO, attributeName)) {
            return (T)depCardVO.getEndCardhistoryVO().getAttributeValue(attributeName);
        }
        return (T)depCardVO.getBeginCardhistoryVO().getAttributeValue(attributeName);
    }

    protected boolean isCurrentMonthAffect(DepCardVO depCardVO, String attributeName) {
        if (this.traceCards != null && this.traceCards.contains(depCardVO.getCardVO().getPk_card())) {
            return true;
        }
        if (attributeName.equals("servicemonth") || attributeName.equals("servicemonth_cal")) {
            return this.optionVO.getServicemonth_flag().booleanValue();
        }
        if (attributeName.equals("pk_depmethod")) {
            return this.optionVO.getDepmethod_flag().booleanValue();
        }
        if (attributeName.equals("allworkloan")) {
            return this.optionVO.getWorkloan_flag().booleanValue();
        }
        if (attributeName.equals("pk_usingstatus")) {
            return this.optionVO.getNewusingstatus().booleanValue();
        }
        if (attributeName.equals("naturemonth")) {
            return this.optionVO.getServicemonth_flag().booleanValue();
        }
        if (this.depAttrFieldSet.contains(attributeName)) {
            Integer depAttr;
            String pk_category = (String)depCardVO.getEndCardhistoryVO().getAttributeValue("pk_category");
            if (this.optionVO.getNewcate_flag() == 0) {
                pk_category = (String)depCardVO.getBeginCardhistoryVO().getAttributeValue("pk_category");
            }
            Integer n = depAttr = depCardVO.getCardVO().getUsufructasset_flag().booleanValue() ? this.accbookDepMap4Used.get(pk_category) : this.accbookDepMap4Asset.get(pk_category);
            if (depAttr != DepattributeConst.ACCBOOK_REDUCE_DEP) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getRecalAttribuateValueMap(DepCardVO depCardVO) {
        UFDouble cal_localoriginvalue = UFDouble.ZERO_DBL;
        Integer cal_servicemonth = 0;
        Integer cal_usedmonth = 0;
        UFDouble cal_predevaluate = UFDouble.ZERO_DBL;
        boolean isValueCurrentAffect = this.isCurrentMonthAffect(depCardVO, "originvalue_cal");
        boolean isServiceMonthCurrentAffect = this.isCurrentMonthAffect(depCardVO, "servicemonth_cal");
        boolean isValueAlter = this.isValueAlter(depCardVO);
        boolean isServiceMonthAlter = this.isServiceMonthAlter(depCardVO);
        UFDouble localoriginvalue_ac = UFDouble.ZERO_DBL;
        UFDouble accudep_ac = UFDouble.ZERO_DBL;
        Integer servicemonth_ac = 0;
        Integer usedmonth_ac = 0;
        String pk_card = depCardVO.getCardVO().getPk_card();
        if (this.traceCards != null && this.traceCards.contains(pk_card) || isValueCurrentAffect) {
            localoriginvalue_ac = depCardVO.getEndCardhistoryVO().getLocaloriginvalue();
            accudep_ac = depCardVO.getEndCardhistoryVO().getAccudep().sub(depCardVO.getEndCardhistoryVO().getDepamount());
            cal_predevaluate = depCardVO.getEndCardhistoryVO().getPredevaluate();
        } else {
            localoriginvalue_ac = depCardVO.getBeginCardhistoryVO().getLocaloriginvalue();
            accudep_ac = depCardVO.getBeginCardhistoryVO().getAccudep();
            cal_predevaluate = depCardVO.getBeginCardhistoryVO().getPredevaluate();
        }
        servicemonth_ac = this.traceCards != null && this.traceCards.contains(pk_card) || isServiceMonthCurrentAffect ? depCardVO.getEndCardhistoryVO().getServicemonth() : depCardVO.getBeginCardhistoryVO().getServicemonth();
        usedmonth_ac = depCardVO.getBeginCardhistoryVO().getUsedmonth();
        if (this.traceCards != null && this.traceCards.contains(pk_card) || isValueCurrentAffect && isValueAlter || isServiceMonthCurrentAffect && isServiceMonthAlter) {
            cal_localoriginvalue = localoriginvalue_ac.sub(accudep_ac);
            cal_servicemonth = servicemonth_ac - usedmonth_ac;
            cal_usedmonth = 0;
            cal_predevaluate = UFDouble.ZERO_DBL;
        } else {
            cal_localoriginvalue = depCardVO.getBeginCardhistoryVO().getOriginvalue_cal();
            cal_localoriginvalue = depCardVO.getBeginCardhistoryVO().getLocaloriginvalue();
            cal_servicemonth = depCardVO.getBeginCardhistoryVO().getServicemonth_cal();
            cal_usedmonth = depCardVO.getBeginCardhistoryVO().getUsedmonth_cal();
            if (depCardVO.getBeginCardhistoryVO().getLocaloriginvalue() != null && depCardVO.getBeginCardhistoryVO().getOriginvalue_cal() != null && depCardVO.getBeginCardhistoryVO().getLocaloriginvalue().compareTo((Object)depCardVO.getBeginCardhistoryVO().getOriginvalue_cal()) != 0) {
                cal_predevaluate = UFDouble.ZERO_DBL;
            }
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("originvalue_cal", cal_localoriginvalue);
        valueMap.put("servicemonth_cal", cal_servicemonth);
        valueMap.put("usedmonth_cal", cal_usedmonth);
        valueMap.put("predevaluate", cal_predevaluate);
        return valueMap;
    }

    protected boolean isValueAlter(DepCardVO depCardVO) {
        List<String> fields = Arrays.asList("localoriginvalue", "salvage", "salvagerate", "accudep", "predevaluate");
        boolean isEquals = true;
        for (String field : fields) {
            UFDouble oldValue = (UFDouble)depCardVO.getBeginCardhistoryVO().getAttributeValue(field);
            UFDouble newValue = (UFDouble)depCardVO.getEndCardhistoryVO().getAttributeValue(field);
            if (field.equals("accudep")) {
                UFDouble depamout = (UFDouble)depCardVO.getEndCardhistoryVO().getAttributeValue("depamount");
                newValue = UFDoubleUtils.sub((UFDouble)newValue, (UFDouble)depamout);
            }
            isEquals = isEquals && UFDoubleUtils.isEqual((UFDouble)oldValue, (UFDouble)newValue);
        }
        return !isEquals;
    }

    private boolean isServiceMonthAlter(DepCardVO depCardVO) {
        Integer oldServiceMonth = depCardVO.getBeginCardhistoryVO().getServicemonth();
        Integer newServiceMonth = depCardVO.getEndCardhistoryVO().getServicemonth();
        return oldServiceMonth.intValue() != newServiceMonth.intValue();
    }

    public Map<String, Integer> getAccbookDepMap4Asset() {
        return this.accbookDepMap4Asset;
    }

    public void setAccbookDepMap4Asset(Map<String, Integer> accbookDepMap4Asset) {
        this.accbookDepMap4Asset = accbookDepMap4Asset;
    }

    public Map<String, Integer> getAccbookDepMap4Used() {
        return this.accbookDepMap4Used;
    }

    public void setAccbookDepMap4Used(Map<String, Integer> accbookDepMap4Used) {
        this.accbookDepMap4Used = accbookDepMap4Used;
    }
}

