/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import nc.pub.fa.common.util.StringUtils;
import nc.pub.fa.dep.DefOperater;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Operater1;
import nc.pub.fa.dep.Operater10;
import nc.pub.fa.dep.Operater2;
import nc.pub.fa.dep.Operater3;
import nc.pub.fa.dep.Operater4;
import nc.pub.fa.dep.Operater5;
import nc.pub.fa.dep.Operater6;
import nc.pub.fa.dep.Operater7;
import nc.pub.fa.dep.Operater8;
import nc.pub.fa.dep.Operater9;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.fa.depmethod.DepmethodVO;

public class DepOperaterFactory {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static Map<String, IDepOperater> operaterMap = new HashMap<String, IDepOperater>();
    private static IDepOperater defDepOperater = new DefOperater();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDepOperater getDepOperater(DepmethodVO depmethodVO) {
        IDepOperater operater = operaterMap.get(depmethodVO.getDepmethod_code());
        if (operater != null) return operater;
        if (!StringUtils.isNotBlank((String)depmethodVO.getDepclass())) return defDepOperater;
        LOCK.lock();
        try {
            if (operaterMap.containsKey(depmethodVO.getDepmethod_code())) return operater;
            operater = (IDepOperater)Class.forName(depmethodVO.getDepclass()).newInstance();
            operaterMap.put(depmethodVO.getDepmethod_code(), operater);
            return operater;
        }
        catch (Exception e) {
            throw ExceptionUtils.businessRuntimeException((Throwable)e);
        }
        finally {
            LOCK.unlock();
        }
    }

    static {
        operaterMap.put("01", new Operater1());
        operaterMap.put("02", new Operater2());
        operaterMap.put("03", new Operater3());
        operaterMap.put("04", new Operater4());
        operaterMap.put("05", new Operater5());
        operaterMap.put("06", new Operater6());
        operaterMap.put("99", new Operater7());
        operaterMap.put("55", new Operater8());
        operaterMap.put("07", new Operater9());
        operaterMap.put("08", new Operater10());
    }
}

