/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.dep;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Set;
import nc.bs.pub.formulaparse.FormulaParse;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.common.util.NumberUtils;
import nc.pub.fa.dep.DepCardVO;
import nc.pub.fa.dep.DepValueGetterUtils;
import nc.pub.fa.dep.IDepOperater;
import nc.pub.fa.dep.Param;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.depmethod.DepmethodVO;
import nc.vo.fa.option.OptionVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.formulaset.VarryVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDouble;

public class DefOperater
implements IDepOperater {
    private UFDouble depAmount = UFDouble.ZERO_DBL;
    private BigDecimal depRate = BigDecimal.ZERO;
    private static final String keyOfDepRate = "deprate";
    private static final String keyOfDepAmount = "depamount";
    private DepmethodVO depMethodVO = null;
    private Param param = null;
    private DepCardVO depCardVO = null;
    private OptionVO optionVO = null;
    private DepValueGetterUtils valueGetterUtils;

    @Override
    public void procDep(DepCardVO depCardVO, DepmethodVO depmethodVO, OptionVO optionVO, Param param, Set<String> traceCards) {
        this.depCardVO = depCardVO;
        this.depMethodVO = depmethodVO;
        this.param = param;
        this.depAmount = null;
        this.depRate = null;
        this.optionVO = optionVO;
        this.valueGetterUtils = new DepValueGetterUtils(optionVO, param.getAccbookDepMap4Asset(), param.getAccbookDepMap4Used(), traceCards);
    }

    @Override
    public UFDouble getAmount() {
        if (this.depAmount != null) {
            return this.depAmount;
        }
        if (!this.checkNeedtoDep()) {
            return UFDouble.ZERO_DBL;
        }
        if (this.doLastMonth()) {
            this.processDepEnd();
            return this.depAmount;
        }
        DepmethodVO depmethodVO = this.getDepmethodVO();
        String amountExpression = depmethodVO.getAmountexpression();
        FormulaParse formulaParse = new FormulaParse();
        formulaParse.setExpress(amountExpression);
        VarryVO varry = formulaParse.getVarry();
        if (amountExpression.length() > 0 && varry.getVarry() == null) {
            this.depAmount = new UFDouble(amountExpression);
            this.processDepEnd();
            return this.depAmount;
        }
        if (varry != null) {
            for (int i = 0; i < varry.getVarry().length; ++i) {
                String key = varry.getVarry()[i];
                Object obj = null;
                obj = key.equals(keyOfDepRate) ? this.getRate() : this.getAttrValue(key);
                String value = null;
                if (obj == null) continue;
                if (obj instanceof Integer) {
                    formulaParse.addVariable(key, (Object)((Integer)obj));
                    continue;
                }
                if (obj instanceof UFBoolean) {
                    formulaParse.addVariable(key, (Object)((UFBoolean)obj).booleanValue());
                    continue;
                }
                value = new UFDouble(obj.toString()).setScale(8, 4).toString();
                formulaParse.addVariable(key, (Object)new UFDouble(value));
            }
        }
        String depAmountValue = formulaParse.getValue();
        this.depAmount = new UFDouble(depAmountValue);
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        if (endHistoryVO.getHerit_flag().booleanValue()) {
            if (!beginHistoryVO.getHerit_flag().booleanValue()) {
                this.depAmount = endHistoryVO.getDepamount();
                this.depRate = endHistoryVO.getDeprate().toBigDecimal();
            } else if (endHistoryVO.getDepamount() != null && endHistoryVO.getDepamount().doubleValue() > 0.0) {
                this.depAmount = endHistoryVO.getDepamount();
                this.depRate = endHistoryVO.getDeprate().toBigDecimal();
            } else {
                this.depAmount = beginHistoryVO.getDepamount();
                this.depRate = beginHistoryVO.getDeprate().toBigDecimal();
            }
        }
        this.processDepEnd();
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.getParam().getDigitOfLocalOriginValue(), 4);
        }
        return this.depAmount;
    }

    private void processDepEnd() {
        ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
        UFDouble calOriginValue = NumberUtils.getUFDouble((Object)endHistoryVO.getLocaloriginvalue());
        UFDouble calAccuDep = NumberUtils.getUFDouble((Object)endHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
        UFDouble depamountOfMonthBegin = NumberUtils.getUFDouble((Object)endHistoryVO.getDepamount());
        UFDouble differ = calOriginValue.sub(calAccuDep.sub(depamountOfMonthBegin)).sub(predevaluate).sub(salvage);
        if (differ.sub(this.depAmount).doubleValue() < 0.0) {
            this.depAmount = differ;
            if (this.depAmount.doubleValue() < 0.0) {
                this.depAmount = new UFDouble(0);
            }
        }
        try {
            this.depAmount = FAScaleUtils.setScaleByAccbook((UFDouble)this.depAmount, (String)endHistoryVO.getPk_accbook());
        }
        catch (BusinessException e) {
            this.depAmount = this.depAmount.setScale(this.getParam().getDigitOfLocalOriginValue(), 4);
        }
        this.depCardVO.getBeginCardhistoryVO().setDepamount(this.depAmount);
    }

    @Override
    public BigDecimal getRate() {
        String rst;
        if (this.depRate != null) {
            return this.depRate;
        }
        DepmethodVO depmethodVO = this.getDepmethodVO();
        String formula = depmethodVO.getRateexpression();
        FormulaParse f = new FormulaParse();
        f.setExpress(formula);
        VarryVO varry = f.getVarry();
        if (formula.length() > 0 && varry.getVarry() == null) {
            return new BigDecimal(formula);
        }
        if (varry != null) {
            Hashtable<String, String> varryData = new Hashtable<String, String>();
            for (int i = 0; i < varry.getVarry().length; ++i) {
                String key = varry.getVarry()[i];
                Object obj = null;
                obj = key.equals(keyOfDepAmount) ? this.getAmount() : this.getAttrValue(key);
                String value = null;
                if (obj == null) continue;
                value = obj.toString().trim();
                value = new UFDouble(value).setScale(8, 4).toString();
                varryData.put(key, value);
            }
            f.setData(varryData);
        }
        if ((rst = f.getValue()) != null) {
            this.depRate = new BigDecimal(rst).setScale(this.getParam().getDigitOfDepRate(), 4);
        }
        this.depRate = this.depRate.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : this.depRate;
        return this.depRate;
    }

    private boolean checkNeedtoDep() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        UFDouble predevaluate = NumberUtils.getUFDouble((Object)beginHistoryVO.getPredevaluate());
        UFDouble calOriginValue = NumberUtils.getUFDouble((Object)beginHistoryVO.getLocaloriginvalue());
        UFDouble calAccudep = NumberUtils.getUFDouble((Object)beginHistoryVO.getAccudep());
        UFDouble salvage = NumberUtils.getUFDouble((Object)beginHistoryVO.getSalvage());
        return !(calOriginValue.sub(calAccudep).sub(predevaluate).sub(salvage).doubleValue() < 0.0);
    }

    public boolean doLastMonth() {
        ICardhistoryVO beginHistoryVO = this.depCardVO.getBeginCardhistoryVO();
        int servicemonth = NumberUtils.getInteger(this.getHistoryAttributeValue(this.depCardVO, "servicemonth"));
        int usedMonth = NumberUtils.getInteger((Object)beginHistoryVO.getUsedmonth());
        if (usedMonth != servicemonth - 1) {
            return false;
        }
        boolean isDepCompleted = false;
        if (this.optionVO.getDepall_flag() == null || this.optionVO.getDepall_flag().booleanValue()) {
            isDepCompleted = true;
        }
        if (usedMonth > servicemonth - 1 && isDepCompleted) {
            return true;
        }
        if (usedMonth == servicemonth - 1) {
            if (isDepCompleted) {
                ICardhistoryVO endHistoryVO = this.depCardVO.getEndCardhistoryVO();
                UFDouble calOriginvalue = endHistoryVO.getLocaloriginvalue();
                UFDouble calAccudep = endHistoryVO.getAccudep();
                UFDouble depamount = endHistoryVO.getDepamount();
                calAccudep = calAccudep.sub(depamount);
                UFDouble predevaluate = NumberUtils.getUFDouble((Object)endHistoryVO.getPredevaluate());
                UFDouble salvage = NumberUtils.getUFDouble((Object)endHistoryVO.getSalvage());
                this.depAmount = calOriginvalue.sub(calAccudep).sub(predevaluate).sub(salvage);
            } else {
                return false;
            }
        }
        return true;
    }

    private Object getAttrValue(String key) {
        Object value = this.depCardVO.getCardVO().getAttributeValue(key);
        if (value == null) {
            Object laccudepObj;
            Object localOriginObj;
            value = this.getHistoryAttributeValue(this.depCardVO, key);
            if (key.equals("salvagerate")) {
                value = new UFDouble(value.toString()).div(new UFDouble(100));
            }
            if (key.equals("accudep")) {
                ICardhistoryVO beginHistoryVo = this.depCardVO.getBeginCardhistoryVO();
                ICardhistoryVO endHistoryVo = this.depCardVO.getEndCardhistoryVO();
                if (!beginHistoryVo.getAccudep().equals(value) && endHistoryVo.getAccudep().equals(value)) {
                    value = new UFDouble(value.toString()).sub(endHistoryVo.getDepamount());
                }
            }
            if ("netvalue".equals(key)) {
                localOriginObj = this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue");
                laccudepObj = this.getHistoryAttributeValue(this.depCardVO, "accudep");
                value = new UFDouble(localOriginObj.toString()).sub(new UFDouble(laccudepObj.toString()));
            }
            if ("netrating".equals(key)) {
                localOriginObj = this.getHistoryAttributeValue(this.depCardVO, "localoriginvalue");
                laccudepObj = this.getHistoryAttributeValue(this.depCardVO, "accudep");
                Object prevalueObj = this.getHistoryAttributeValue(this.depCardVO, "predevaluate");
                value = new UFDouble(localOriginObj.toString()).sub(new UFDouble(laccudepObj.toString())).sub(new UFDouble(prevalueObj.toString()));
            }
        }
        if ("monthworkloan".equals(key)) {
            value = this.depCardVO.getEndCardhistoryVO().getAttributeValue(key);
        }
        if (value == null) {
            value = this.depCardVO.getEndCardhistoryVO().getAttributeValue(key);
        }
        if (value == null) {
            return "0.00";
        }
        return value;
    }

    private DepmethodVO getDepmethodVO() {
        return this.depMethodVO;
    }

    private Param getParam() {
        return this.param;
    }

    private <T> T getHistoryAttributeValue(DepCardVO depCardVO, String attributeName) {
        Object value = this.valueGetterUtils.getHistoryAttributeValue(depCardVO, attributeName);
        return value;
    }
}

