/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.bs.dao.BaseDAO;
import nc.bs.framework.common.NCLocator;
import nc.bs.logging.Logger;
import nc.impl.am.common.InSqlManager;
import nc.impl.am.db.DBAccessUtil;
import nc.impl.am.db.VOPersistUtil;
import nc.impl.am.db.processor.AMBeanListProcessor;
import nc.impl.am.db.processor.ListMapProcessor;
import nc.itf.fa.prv.IAsset;
import nc.jdbc.framework.SQLParameter;
import nc.jdbc.framework.generator.IdGenerator;
import nc.jdbc.framework.processor.ResultSetProcessor;
import nc.jdbc.framework.type.SQLTypeFactory;
import nc.pub.fa.asset.scale.AssetScaleProcessUtil;
import nc.pub.fa.card.AssetFieldConst;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.pub.fa.card.NoMetaSuperVO;
import nc.pub.fa.card.NumberDataUtils;
import nc.pub.fa.card.UFBooleanDataUtils;
import nc.pub.fa.card.UsufructCardBackupVersionEnum;
import nc.pub.fa.common.util.StringUtils;
import nc.vo.am.common.AMSuperVO;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.DepAccrualBackupVO;
import nc.vo.fa.assetcard.DepAccrualVO;
import nc.vo.fa.assetcard.RentPaymentPlanBackupVO;
import nc.vo.fa.assetcard.RentPaymentPlanVO;
import nc.vo.fa.assetcard.StepRentStandardBackupVO;
import nc.vo.fa.assetcard.StepRentStandardVO;
import nc.vo.fa.assetcard.UsufructAssetBackupVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BeanHelper;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.ISuperVO;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFDateTime;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class UsufructCardBackup {
    private IAsset iAsset = (IAsset)AMProxy.lookup(IAsset.class);
    private DBAccessUtil dbUtil = new DBAccessUtil();

    public boolean existsVersion(String pk_bill_src, String transi_type_src) throws BusinessException {
        String sql_h = " select count(1) from fa_usufructasset_backup where pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'";
        return this.dbUtil.queryAggregationFunctionCount(sql_h) > 0;
    }

    public UsufructCardBackupVersionEnum alwaysSameVersion(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        String sql_backup = "select pk_card, change_version from fa_usufructasset_backup where pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'";
        Map map_change_version_backup = (Map)this.dbUtil.executeQuery(sql_backup, (ResultSetProcessor)new ListMapProcessor());
        if (map_change_version_backup.isEmpty()) {
            return UsufructCardBackupVersionEnum.BACKUP_VERSION_NOT_EXIST;
        }
        String sql_card = "select pk_card, isnull(change_version, 0) from fa_usufructasset where dr = 0 and pk_card in " + InSqlManager.getInSQLValue((String[])pk_cards);
        Map map_change_version_card = (Map)this.dbUtil.executeQuery(sql_card, (ResultSetProcessor)new ListMapProcessor());
        Iterator iterator = map_change_version_card.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String pk_card = (String)entry.getKey();
            List change_version_card = (List)entry.getValue();
            List change_version_backup = (List)map_change_version_backup.get(pk_card);
            if (((Integer)change_version_backup.get(0)).intValue() == ((Integer)change_version_card.get(0)).intValue()) {
                return UsufructCardBackupVersionEnum.VERSION_SAME;
            }
            if ((Integer)change_version_backup.get(0) > (Integer)change_version_card.get(0)) {
                return UsufructCardBackupVersionEnum.BACKUP_VERSION_BIGGER;
            }
            String asset_code_sql = "select asset_code from fa_card where dr = 0 and pk_card = " + StringUtils.addQuoMarks((String)pk_card);
            List asset_codes = this.dbUtil.querySingleColumn(asset_code_sql);
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0855", null, new String[]{String.join((CharSequence)",", asset_codes)}));
        }
        String asset_code_sql = "select asset_code from fa_card where dr = 0 and pk_card in " + InSqlManager.getInSQLValue((String[])pk_cards);
        List asset_codes = this.dbUtil.querySingleColumn(asset_code_sql);
        throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0855", null, new String[]{String.join((CharSequence)",", asset_codes)}));
    }

    public void checkSupport0(String ... pk_cards) throws BusinessException {
        int n = 0;
        String[] stringArray = pk_cards;
        int n2 = stringArray.length;
        if (n < n2) {
            String pk_card = stringArray[n];
            if (this.existsBackup(pk_card)) {
                return;
            }
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0807"));
        }
    }

    public Map<String, AggCardVO> queryCurrentVersionAggCardOnApprove(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        for (String pk_card : pk_cards) {
            boolean existsBackupFromBillSrc = this.existsBackupFromBillSrc(pk_card, pk_bill_src, transi_type_src);
            if (existsBackupFromBillSrc) continue;
            throw ExceptionUtils.businessRuntimeException((String)("fa_usufructasset_backup version does not exist from pk_card = '" + pk_card + "' and pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'"));
        }
        return this.queryVersionAggCardVO(pk_bill_src, transi_type_src, pk_cards, false);
    }

    public Map<String, AggCardVO> queryPreviousVersionAggCardOnUnApprove(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        pk_cards = ArrayUtils.distinct((String[])pk_cards);
        this.checkSupport0(pk_cards);
        return this.queryVersionAggCardVO(pk_bill_src, transi_type_src, pk_cards, true);
    }

    public Map<String, AggCardVO> queryPreviousVersionAggCardFromBillSrc(String pk_bill_src, String transi_type_src, String pk_card) throws BusinessException {
        return this.queryVersionAggCardVO(pk_bill_src, transi_type_src, new String[]{pk_card}, true);
    }

    private Map<String, AggCardVO> queryVersionAggCardVO(String pk_bill_src, String transi_type_src, String[] pk_cards, boolean inverse) throws BusinessException {
        pk_cards = ArrayUtils.distinct((String[])pk_cards);
        HashMap<String, AggCardVO> aggCardVOs = new HashMap<String, AggCardVO>();
        for (String pk_card : pk_cards) {
            AggCardVO oldCardVO = this.iAsset.getAggCardVOWhenLast(pk_card);
            aggCardVOs.put(pk_card, oldCardVO);
        }
        HashMap<String, Object> selectWheres = new HashMap<String, Object>();
        for (String pk_card : pk_cards) {
            selectWheres.clear();
            AggCardVO aggCardVO = (AggCardVO)((Object)aggCardVOs.get(pk_card));
            Integer change_version = this.queryBackupVersion(pk_card, pk_bill_src, transi_type_src);
            if (inverse) {
                Integer n = change_version;
                change_version = change_version - 1;
            }
            selectWheres.put("pk_card", pk_card);
            selectWheres.put("change_version", change_version);
            String whereSql = this.extractWhereSql(selectWheres);
            List addUsufructAssetBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new UsufructAssetBackupVO(), whereSql).toString(), (ResultSetProcessor)new UsufructAssetBackupVOAMBeanListProcessor());
            List rentPaymentPlanBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new RentPaymentPlanBackupVO(), whereSql).toString(), (ResultSetProcessor)new RentPaymentPlanBackupVOAMBeanListProcessor());
            List depAccrualBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new DepAccrualBackupVO(), whereSql).toString(), (ResultSetProcessor)new DepAccrualBackupVOAMBeanListProcessor());
            UsufructAssetVO[] addUsufructAssetVOs = (UsufructAssetVO[])this.copyNoMetaSuperVOToAMSuperVO(addUsufructAssetBackupVOs.toArray(new UsufructAssetBackupVO[0]), UsufructAssetVO.class);
            RentPaymentPlanVO[] rentPaymentPlanVOs = (RentPaymentPlanVO[])this.copyNoMetaSuperVOToAMSuperVO(rentPaymentPlanBackupVOs.toArray(new RentPaymentPlanBackupVO[0]), RentPaymentPlanVO.class);
            Arrays.sort((Object[])rentPaymentPlanVOs);
            DepAccrualVO[] depAccrualVOs = (DepAccrualVO[])this.copyNoMetaSuperVOToAMSuperVO(depAccrualBackupVOs.toArray(new DepAccrualBackupVO[0]), DepAccrualVO.class);
            aggCardVO.setTableVO(CardTabConst.usufructasset_tab, (CircularlyAccessibleValueObject[])addUsufructAssetVOs);
            aggCardVO.setTableVO(CardTabConst.rentpayplan_tab, (CircularlyAccessibleValueObject[])rentPaymentPlanVOs);
            aggCardVO.setTableVO(CardTabConst.depaccrual_tab, (CircularlyAccessibleValueObject[])depAccrualVOs);
            if (!((UsufructAssetBackupVO)addUsufructAssetBackupVOs.get(0)).getStep_rent().booleanValue()) continue;
            List stepRentStandardBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new StepRentStandardBackupVO(), whereSql).toString(), (ResultSetProcessor)new StepRentStandardBackupVOAMBeanListProcessor());
            StepRentStandardVO[] stepRentStandardVOs = (StepRentStandardVO[])this.copyNoMetaSuperVOToAMSuperVO(stepRentStandardBackupVOs.toArray(new StepRentStandardBackupVO[0]), StepRentStandardVO.class);
            aggCardVO.setTableVO(CardTabConst.steprentstandard_tab, (CircularlyAccessibleValueObject[])stepRentStandardVOs);
        }
        return aggCardVOs;
    }

    public void addBackup(AssetEntiretyVO oldAssetEntiretyVO, AssetEntiretyVO addAssetEntiretyVO, String pk_bill_src, String transi_type_src) throws BusinessException {
        AggCardVO oldAggCardVO = CardVOUtils.toAggCard(oldAssetEntiretyVO);
        AggCardVO addAggCardVO = CardVOUtils.toAggCard(addAssetEntiretyVO);
        this.addBackup(oldAggCardVO, addAggCardVO, pk_bill_src, transi_type_src);
    }

    private void addBackup(AggCardVO oldAggCardVO, AggCardVO addAggCardVO, String pk_bill_src, String transi_type_src) throws BusinessException {
        RentPaymentPlanVO[] oldRentPaymentPlanVO;
        CardVO cardVO;
        String pk_card;
        boolean existsBackupFromBillSrc;
        AssetScaleProcessUtil.scaleProcess((AggregatedValueObject[])new AggCardVO[]{addAggCardVO});
        UsufructAssetVO oldUsufructVO = oldAggCardVO.getUsufructAssetVO();
        UsufructAssetVO addUsufructVO = addAggCardVO.getUsufructAssetVO();
        UFBooleanDataUtils.changeNullData((AMSuperVO[])new UsufructAssetVO[]{addUsufructVO});
        NumberDataUtils.changeNullData((AMSuperVO[])new UsufructAssetVO[]{addUsufructVO});
        Object change_version = oldUsufructVO.getChange_version();
        if (change_version == null) {
            change_version = 0;
        }
        if (existsBackupFromBillSrc = this.existsBackupFromBillSrc(pk_card = (cardVO = (CardVO)oldAggCardVO.getParent()).getPk_card(), pk_bill_src, transi_type_src)) {
            throw ExceptionUtils.businessRuntimeException((String)("fa_usufructasset_backup always exist version from pk_card = '" + pk_card + "' and pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'"));
        }
        if (!this.existsBackup(pk_card)) {
            oldRentPaymentPlanVO = (RentPaymentPlanVO[])oldAggCardVO.body(CardTabConst.rentpayplan_tab);
            DepAccrualVO[] oldDepAccrualVO = (DepAccrualVO[])oldAggCardVO.body(CardTabConst.depaccrual_tab);
            UsufructAssetBackupVO usufructAssetBackupVO = this.copy(oldUsufructVO, UsufructAssetBackupVO.class);
            NoMetaSuperVO[] rentPaymentPlanBackupVOs = (RentPaymentPlanBackupVO[])this.copyAMSuperVOToNoMetaSuperVO((AMSuperVO[])oldRentPaymentPlanVO, RentPaymentPlanBackupVO.class);
            NoMetaSuperVO[] depAccrualBackupVOs = (DepAccrualBackupVO[])this.copyAMSuperVOToNoMetaSuperVO((AMSuperVO[])oldDepAccrualVO, DepAccrualBackupVO.class);
            this.updateChangeVersion((Integer)change_version, new UsufructAssetBackupVO[]{usufructAssetBackupVO});
            this.updateChangeVersion((Integer)change_version, rentPaymentPlanBackupVOs);
            this.updateChangeVersion((Integer)change_version, depAccrualBackupVOs);
            ImmutablePair usufructAssetBackupVOSql = this.extractBatchInsertSql(new UsufructAssetBackupVO[]{usufructAssetBackupVO});
            ImmutablePair rentPaymentPlanBackupVOSql = this.extractBatchInsertSql(rentPaymentPlanBackupVOs);
            ImmutablePair depAccrualBackupVOSql = this.extractBatchInsertSql(depAccrualBackupVOs);
            this.dbUtil.executeBatchUpdate((String)usufructAssetBackupVOSql.getLeft(), (SQLParameter[])usufructAssetBackupVOSql.getRight(), false);
            this.dbUtil.executeBatchUpdate((String)rentPaymentPlanBackupVOSql.getLeft(), (SQLParameter[])rentPaymentPlanBackupVOSql.getRight(), false);
            this.dbUtil.executeBatchUpdate((String)depAccrualBackupVOSql.getLeft(), (SQLParameter[])depAccrualBackupVOSql.getRight(), false);
            if (oldUsufructVO.getStep_rent().booleanValue()) {
                AMSuperVO[] stepRentStandardVO = (StepRentStandardVO[])oldAggCardVO.body(CardTabConst.steprentstandard_tab);
                NoMetaSuperVO[] stepRentStandardBackupVOs = (StepRentStandardBackupVO[])this.copyAMSuperVOToNoMetaSuperVO(stepRentStandardVO, StepRentStandardBackupVO.class);
                this.updateChangeVersion((Integer)change_version, stepRentStandardBackupVOs);
                ImmutablePair stepRentStandardBackupVOSql = this.extractBatchInsertSql(stepRentStandardBackupVOs);
                this.dbUtil.executeBatchUpdate((String)stepRentStandardBackupVOSql.getLeft(), (SQLParameter[])stepRentStandardBackupVOSql.getRight(), false);
            }
            oldUsufructVO.setChange_version((Integer)change_version);
            VOPersistUtil.update((String[])new String[]{"change_version"}, (ISuperVO[])new UsufructAssetVO[]{oldUsufructVO});
        }
        oldRentPaymentPlanVO = change_version;
        change_version = change_version.intValue() + 1;
        boolean existsBackupVersion = this.existsBackupVersion(pk_card, (Integer)change_version);
        if (existsBackupVersion) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0855", null, new String[]{addAggCardVO.getCardVO().getAsset_code()}));
        }
        RentPaymentPlanVO[] rentPaymentPlanVO = (RentPaymentPlanVO[])addAggCardVO.body(CardTabConst.rentpayplan_tab);
        DepAccrualVO[] depAccrualVO = (DepAccrualVO[])addAggCardVO.body(CardTabConst.depaccrual_tab);
        UsufructAssetBackupVO usufructAssetBackupVO = this.copy(addUsufructVO, UsufructAssetBackupVO.class);
        NoMetaSuperVO[] rentPaymentPlanBackupVOs = (RentPaymentPlanBackupVO[])this.copyAMSuperVOToNoMetaSuperVO((AMSuperVO[])rentPaymentPlanVO, RentPaymentPlanBackupVO.class);
        NoMetaSuperVO[] depAccrualBackupVOs = (DepAccrualBackupVO[])this.copyAMSuperVOToNoMetaSuperVO((AMSuperVO[])depAccrualVO, DepAccrualBackupVO.class);
        usufructAssetBackupVO.setPk_bill_src(pk_bill_src);
        usufructAssetBackupVO.setTransi_type_src(transi_type_src);
        this.updateChangeVersion((Integer)change_version, new UsufructAssetBackupVO[]{usufructAssetBackupVO});
        this.updateChangeVersion((Integer)change_version, rentPaymentPlanBackupVOs);
        this.updateChangeVersion((Integer)change_version, depAccrualBackupVOs);
        this.updatePK(pk_card, new UsufructAssetBackupVO[]{usufructAssetBackupVO});
        this.updatePK(pk_card, rentPaymentPlanBackupVOs);
        this.updatePK(pk_card, depAccrualBackupVOs);
        ImmutablePair usufructAssetBackupVOSql = this.extractBatchInsertSql(new UsufructAssetBackupVO[]{usufructAssetBackupVO});
        ImmutablePair rentPaymentPlanBackupVOSql = this.extractBatchInsertSql(rentPaymentPlanBackupVOs);
        ImmutablePair depAccrualBackupVOSql = this.extractBatchInsertSql(depAccrualBackupVOs);
        this.dbUtil.executeBatchUpdate((String)usufructAssetBackupVOSql.getLeft(), (SQLParameter[])usufructAssetBackupVOSql.getRight(), false);
        this.dbUtil.executeBatchUpdate((String)rentPaymentPlanBackupVOSql.getLeft(), (SQLParameter[])rentPaymentPlanBackupVOSql.getRight(), false);
        this.dbUtil.executeBatchUpdate((String)depAccrualBackupVOSql.getLeft(), (SQLParameter[])depAccrualBackupVOSql.getRight(), false);
        if (addUsufructVO.getStep_rent().booleanValue()) {
            AMSuperVO[] stepRentStandardVO = (StepRentStandardVO[])addAggCardVO.body(CardTabConst.steprentstandard_tab);
            NoMetaSuperVO[] stepRentStandardBackupVOs = (StepRentStandardBackupVO[])this.copyAMSuperVOToNoMetaSuperVO(stepRentStandardVO, StepRentStandardBackupVO.class);
            this.updateChangeVersion((Integer)change_version, stepRentStandardBackupVOs);
            this.updatePK(pk_card, stepRentStandardBackupVOs);
            ImmutablePair stepRentStandardBackupVOSql = this.extractBatchInsertSql(stepRentStandardBackupVOs);
            this.dbUtil.executeBatchUpdate((String)stepRentStandardBackupVOSql.getLeft(), (SQLParameter[])stepRentStandardBackupVOSql.getRight(), false);
        }
    }

    public void addWriteBackBackupApprove(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        pk_cards = ArrayUtils.distinct((String[])pk_cards);
        this.addWriteBackBackup0(pk_bill_src, transi_type_src, pk_cards, false);
        DBAccessUtil.updateMainTableTs((String)"H0", (String[])pk_cards);
    }

    public void addWriteBackBackupUnApprove(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        pk_cards = ArrayUtils.distinct((String[])pk_cards);
        this.checkSupport0(pk_cards);
        this.addWriteBackBackup0(pk_bill_src, transi_type_src, pk_cards, true);
        DBAccessUtil.updateMainTableTs((String)"H0", (String[])pk_cards);
    }

    private void addWriteBackBackup0(String pk_bill_src, String transi_type_src, String[] pk_cards, boolean inverse) throws BusinessException {
        BaseDAO baseDao = new BaseDAO();
        UsufructAssetVO[] oldUsufructAssetVOs = this.iAsset.batchQueryUsufructVO(Lists.newArrayList((Object[])pk_cards));
        HashMap<String, UsufructAssetVO> map = new HashMap<String, UsufructAssetVO>();
        for (UsufructAssetVO vo : oldUsufructAssetVOs) {
            map.put(vo.getPk_card(), vo);
        }
        HashMap<String, Object> selectWheres = new HashMap<String, Object>();
        ArrayList deleteSQLs = Lists.newArrayList();
        ArrayList insertUsufructAssetVOs = Lists.newArrayList();
        ArrayList insertDepAccrualVOs = Lists.newArrayList();
        ArrayList insertRentPaymentPlanVOs = Lists.newArrayList();
        ArrayList insertStepRentStandardVOs = Lists.newArrayList();
        for (String pk_card : pk_cards) {
            selectWheres.clear();
            UsufructAssetVO oldUsufructAssetVO = (UsufructAssetVO)((Object)map.get(pk_card));
            int change_version_card = oldUsufructAssetVO.getChange_version();
            int change_version_backup = this.queryBackupVersion(pk_card, pk_bill_src, transi_type_src);
            if (inverse) {
                if (change_version_card != change_version_backup) {
                    throw ExceptionUtils.businessRuntimeException((String)"card version and current backup version must be the same");
                }
            } else if (change_version_card + 1 != change_version_backup) {
                throw ExceptionUtils.businessRuntimeException((String)"card version + 1 and current backup version must be the same");
            }
            change_version_card = inverse ? --change_version_card : ++change_version_card;
            selectWheres.put("pk_card", pk_card);
            selectWheres.put("change_version", change_version_card);
            String selectWhereSql = this.extractWhereSql(selectWheres);
            List usufructAssetBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new UsufructAssetBackupVO(), selectWhereSql).toString(), (ResultSetProcessor)new UsufructAssetBackupVOAMBeanListProcessor());
            if (usufructAssetBackupVOs.size() > 1) {
                throw ExceptionUtils.businessRuntimeException((String)("\u5b58\u5728\u591a\u6761\u4f7f\u7528\u6743\u9875\u7b7e\u6570\u636e\uff1a" + selectWhereSql));
            }
            List rentPaymentPlanBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new RentPaymentPlanBackupVO(), selectWhereSql).toString(), (ResultSetProcessor)new RentPaymentPlanBackupVOAMBeanListProcessor());
            List depAccrualBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new DepAccrualBackupVO(), selectWhereSql).toString(), (ResultSetProcessor)new DepAccrualBackupVOAMBeanListProcessor());
            UsufructAssetVO[] addUsufructAssetVOs = (UsufructAssetVO[])this.copyNoMetaSuperVOToAMSuperVO(usufructAssetBackupVOs.toArray(new UsufructAssetBackupVO[0]), UsufructAssetVO.class);
            DepAccrualVO[] depAccrualVOs = (DepAccrualVO[])this.copyNoMetaSuperVOToAMSuperVO(depAccrualBackupVOs.toArray(new DepAccrualBackupVO[0]), DepAccrualVO.class);
            RentPaymentPlanVO[] rentPaymentPlanVOs = (RentPaymentPlanVO[])this.copyNoMetaSuperVOToAMSuperVO(rentPaymentPlanBackupVOs.toArray(new RentPaymentPlanBackupVO[0]), RentPaymentPlanVO.class);
            HashMap<String, Object> deleteWheres = new HashMap<String, Object>();
            deleteWheres.put("pk_card", pk_card);
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new UsufructAssetVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new DepAccrualVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new RentPaymentPlanVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new StepRentStandardVO()));
            this.updateUsufructRevised(oldUsufructAssetVO, addUsufructAssetVOs[0]);
            this.collect(insertUsufructAssetVOs, (SuperVO[])addUsufructAssetVOs);
            this.collect(insertDepAccrualVOs, (SuperVO[])depAccrualVOs);
            this.collect(insertRentPaymentPlanVOs, (SuperVO[])rentPaymentPlanVOs);
            if (!((UsufructAssetBackupVO)usufructAssetBackupVOs.get(0)).getStep_rent().booleanValue()) continue;
            List stepRentStandardBackupVOs = (List)this.dbUtil.executeQuery(this.extractSelectSql(new StepRentStandardBackupVO(), selectWhereSql).toString(), (ResultSetProcessor)new StepRentStandardBackupVOAMBeanListProcessor());
            StepRentStandardVO[] stepRentStandardVOs = (StepRentStandardVO[])this.copyNoMetaSuperVOToAMSuperVO(stepRentStandardBackupVOs.toArray(new StepRentStandardBackupVO[0]), StepRentStandardVO.class);
            this.collect(insertStepRentStandardVOs, (SuperVO[])stepRentStandardVOs);
        }
        this.dbUtil.batchUpdate(deleteSQLs.toArray(new String[0]));
        baseDao.insertVOArray(insertUsufructAssetVOs.toArray(new SuperVO[0]));
        baseDao.insertVOArray(insertDepAccrualVOs.toArray(new SuperVO[0]));
        baseDao.insertVOArray(insertRentPaymentPlanVOs.toArray(new SuperVO[0]));
        baseDao.insertVOArray(insertStepRentStandardVOs.toArray(new SuperVO[0]));
    }

    public void deleteBackup(String pk_bill_src, String transi_type_src, String ... pk_cards) throws BusinessException {
        for (String pk_card : pk_cards) {
            boolean existsBackupFromBillSrc = this.existsBackupFromBillSrc(pk_card, pk_bill_src, transi_type_src);
            if (existsBackupFromBillSrc) continue;
            throw ExceptionUtils.businessRuntimeException((String)("fa_usufructasset_backup version does not exist from pk_card = '" + pk_card + "' and pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'"));
        }
        UsufructAssetVO[] usufructAssetVOs = this.iAsset.batchQueryUsufructVO(Lists.newArrayList((Object[])pk_cards));
        ArrayList deleteSQLs = Lists.newArrayList();
        for (UsufructAssetVO usufructAssetVO : usufructAssetVOs) {
            String pk_card = usufructAssetVO.getPk_card();
            int change_version = usufructAssetVO.getChange_version();
            HashMap<String, Object> deleteWheres = new HashMap<String, Object>();
            deleteWheres.put("pk_card", pk_card);
            deleteWheres.put("change_version", ++change_version);
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new UsufructAssetBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new RentPaymentPlanBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new DepAccrualBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new StepRentStandardBackupVO()));
            if (change_version != 1) continue;
            deleteWheres.put("change_version", 0);
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new UsufructAssetBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new RentPaymentPlanBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new DepAccrualBackupVO()));
            deleteSQLs.add(this.extractDeleteSql(deleteWheres, new StepRentStandardBackupVO()));
        }
        this.dbUtil.batchUpdate(deleteSQLs.toArray(new String[0]));
    }

    private <T extends NoMetaSuperVO> void updatePK(String pk_card, T ... beans) {
        String[] pks = ((IdGenerator)NCLocator.getInstance().lookup(IdGenerator.class)).generate(beans.length);
        for (int i = 0; i < pks.length; ++i) {
            T bean = beans[i];
            if (bean == null) continue;
            BeanHelper.setProperty(bean, (String)((NoMetaSuperVO)bean).getPKFieldName(), (Object)pks[i]);
            BeanHelper.setProperty(bean, (String)"pk_card", (Object)pk_card);
        }
    }

    private <T extends NoMetaSuperVO> void updateChangeVersion(Integer change_version, T ... beans) {
        for (T bean : beans) {
            if (bean == null) continue;
            BeanHelper.setProperty(bean, (String)"change_version", (Object)change_version);
            BeanHelper.setProperty(bean, (String)"ts", (Object)new UFDateTime());
        }
    }

    private void updateUsufructRevised(UsufructAssetVO s, UsufructAssetVO t) {
        String[] attributeNames = s.getAttributeNames();
        ArrayList revises = Lists.newArrayList((Object[])AssetFieldConst.REVISE_FIELDS);
        List collect = Stream.of(attributeNames).filter(name -> "udef".startsWith((String)name) || revises.contains(name)).collect(Collectors.toList());
        for (String name2 : collect) {
            Object val = s.getAttributeValue(name2);
            if (val == null) continue;
            t.setAttributeValue(name2, val);
        }
    }

    private boolean existsBackup(String pk_card) throws BusinessException {
        return this.dbUtil.queryHasResult("select 1 from fa_usufructasset_backup where dr = 0 and pk_card = " + String.format("'%s'", pk_card));
    }

    private boolean existsBackupFromBillSrc(String pk_card, String pk_bill_src, String transi_type_src) throws BusinessException {
        return this.dbUtil.queryHasResult("select 1 from fa_usufructasset_backup where dr = 0 and pk_card = '" + pk_card + "' and pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'");
    }

    private boolean existsBackupVersion(String pk_card, Integer change_version) throws BusinessException {
        return this.dbUtil.queryHasResult("select 1 from fa_usufructasset_backup where dr = 0 and pk_card = '" + pk_card + "' and change_version = '" + change_version + "'");
    }

    private Integer queryBackupVersion(String pk_card, String pk_bill_src, String transi_type_src) throws BusinessException {
        String queryVersionSql = "select change_version from fa_usufructasset_backup where dr = 0 and pk_card = '" + pk_card + "' and pk_bill_src = '" + pk_bill_src + "' and transi_type_src = '" + transi_type_src + "'";
        List versions = this.dbUtil.querySingleColumn(queryVersionSql);
        return (Integer)versions.get(0);
    }

    private void collect(List<SuperVO> collector, SuperVO ... vos) {
        for (SuperVO sv : vos) {
            collector.add(sv);
        }
    }

    private String extractWhereSql(Map<String, Object> updates) {
        List updateVals = updates.entrySet().stream().map(e -> {
            Object value = e.getValue();
            String key = (String)e.getKey();
            return key + (value == null ? " is null " : String.format(" = '%s'", value.toString()));
        }).collect(Collectors.toList());
        return String.join((CharSequence)" and ", updateVals);
    }

    private <T extends NoMetaSuperVO> String extractDeleteSql(Map<String, Object> deletes, T bean) {
        StringBuilder deleteSql = new StringBuilder(" delete from ");
        deleteSql.append(bean.getTableName());
        deleteSql.append(" where ");
        deleteSql.append(this.extractWhereSql(deletes));
        return deleteSql.toString();
    }

    private <T extends AMSuperVO> String extractDeleteSql(Map<String, Object> deletes, T bean) {
        StringBuilder deleteSql = new StringBuilder(" delete from ");
        deleteSql.append(bean.getTableName());
        deleteSql.append(" where ");
        deleteSql.append(this.extractWhereSql(deletes));
        return deleteSql.toString();
    }

    private <T extends NoMetaSuperVO> StringBuilder extractUpdateSql(String tableName, T bean) throws BusinessException {
        Field[] childFields = bean.getClass().getDeclaredFields();
        ArrayList updateVals = Lists.newArrayList();
        ArrayList whereVals = Lists.newArrayList();
        String primaryKey = bean.getPKFieldName();
        try {
            for (Field field : childFields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                String name = field.getName();
                Object value = BeanHelper.getProperty(bean, (String)name);
                if (name.equals(primaryKey)) {
                    whereVals.add(name + " = " + String.format("'%s'", value.toString()));
                    continue;
                }
                if (name.equals("dr")) {
                    whereVals.add(name + " = 0 ");
                    continue;
                }
                updateVals.add(name + " = " + (value == null ? null : String.format("'%s'", value.toString())));
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.businessException((Throwable)e);
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ");
        updateSql.append(tableName);
        updateSql.append(" ");
        updateSql.append("set ");
        updateSql.append(String.join((CharSequence)", ", updateVals));
        updateSql.append(" ");
        updateSql.append("where ");
        updateSql.append(String.join((CharSequence)" and ", whereVals));
        return updateSql;
    }

    private <T extends NoMetaSuperVO> List<String> extractBatchUpdateSql(T ... beans) throws BusinessException {
        ArrayList updateSqlList = Lists.newArrayList();
        if (beans == null) {
            return updateSqlList;
        }
        for (T bean : beans) {
            updateSqlList.add(this.extractUpdateSql(((NoMetaSuperVO)bean).getTableName(), bean).toString());
        }
        return updateSqlList;
    }

    private <T extends NoMetaSuperVO> List<String> extractBatchUpdateSql(String sets, String where, T ... beans) throws BusinessException {
        ArrayList updateSqlList = Lists.newArrayList();
        if (beans == null) {
            return updateSqlList;
        }
        for (T bean : beans) {
            StringBuilder updateSql = new StringBuilder(" update ");
            updateSql.append(((NoMetaSuperVO)bean).getTableName());
            updateSql.append(" set ");
            updateSql.append(sets);
            updateSql.append(" where ");
            updateSql.append(where);
            updateSqlList.add(updateSql.toString());
        }
        return updateSqlList;
    }

    private <T extends NoMetaSuperVO> StringBuilder extractSelectSql(T bean, String whereSql) {
        Field[] childFields = bean.getClass().getDeclaredFields();
        ArrayList columns = Lists.newArrayList();
        for (Field field : childFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            columns.add(field.getName());
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ");
        selectSql.append(String.join((CharSequence)", ", columns));
        selectSql.append(" ");
        selectSql.append("from ");
        selectSql.append(bean.getTableName());
        selectSql.append(" where ");
        selectSql.append(whereSql);
        return selectSql;
    }

    private <T extends NoMetaSuperVO> ImmutablePair<String, SQLParameter> extractInsertSql(T bean) throws BusinessException {
        Field[] childFields = bean.getClass().getDeclaredFields();
        ArrayList columns = Lists.newArrayList();
        ArrayList values = Lists.newArrayList();
        ArrayList placeholders = Lists.newArrayList();
        try {
            for (Field field : childFields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                String name = field.getName();
                columns.add(name);
                Object value = BeanHelper.getProperty(bean, (String)name);
                values.add(value == null ? SQLTypeFactory.getNullType((int)12) : value);
                placeholders.add("?");
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.businessException((Throwable)e);
        }
        SQLParameter para = new SQLParameter();
        values.forEach(v -> para.addParam(v));
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ");
        insertSql.append(bean.getTableName());
        insertSql.append(" (");
        insertSql.append(String.join((CharSequence)", ", columns));
        insertSql.append(") ");
        insertSql.append("values (");
        insertSql.append(String.join((CharSequence)", ", placeholders));
        insertSql.append(") ");
        ImmutablePair pair = ImmutablePair.of((Object)insertSql.toString(), (Object)para);
        return pair;
    }

    private <T extends NoMetaSuperVO> ImmutablePair<String, SQLParameter[]> extractBatchInsertSql(T ... beans) throws BusinessException {
        ArrayList insertParas = Lists.newArrayList();
        String sql = null;
        for (T bean : beans) {
            if (bean == null) continue;
            ImmutablePair<String, SQLParameter> extractInsertSql = this.extractInsertSql(bean);
            sql = (String)extractInsertSql.getLeft();
            insertParas.add((SQLParameter)extractInsertSql.getRight());
        }
        return ImmutablePair.of(sql, (Object)insertParas.toArray(new SQLParameter[0]));
    }

    private <S extends NoMetaSuperVO, T extends AMSuperVO> T copy(S source, Class<T> target) {
        Gson gson = new Gson();
        String json = gson.toJson(source);
        AMSuperVO bean = (AMSuperVO)gson.fromJson(json, target);
        return (T)bean;
    }

    private <S extends NoMetaSuperVO, T extends AMSuperVO> T[] copyNoMetaSuperVOToAMSuperVO(S[] orginVOs, Class<T> distClass) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])orginVOs)) {
            return null;
        }
        try {
            AMSuperVO[] targVOs = (AMSuperVO[])Array.newInstance(distClass, orginVOs.length);
            for (int i = 0; i < targVOs.length; ++i) {
                targVOs[i] = this.copy(orginVOs[i], distClass);
            }
            return targVOs;
        }
        catch (NegativeArraySizeException e) {
            Logger.error((Object)e.getMessage());
            throw ExceptionUtils.businessException((Throwable)e);
        }
    }

    private <S extends AMSuperVO, T extends NoMetaSuperVO> T copy(S source, Class<T> target) {
        Gson gson = new Gson();
        String json = gson.toJson(source);
        NoMetaSuperVO bean = (NoMetaSuperVO)gson.fromJson(json, target);
        return (T)bean;
    }

    private <S extends AMSuperVO, T extends NoMetaSuperVO> T[] copyAMSuperVOToNoMetaSuperVO(S[] orginVOs, Class<T> distClass) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])orginVOs)) {
            return null;
        }
        ArrayList<S> adds = new ArrayList<S>();
        HashSet<String> uniques = new HashSet<String>();
        for (S s : orginVOs) {
            if (s.getStatus() == 0) {
                String pk = (String)BeanHelper.getProperty(s, (String)s.getPKFieldName());
                if (!StringUtils.isBlank((String)pk) && !uniques.add(pk)) continue;
                adds.add(s);
                continue;
            }
            if (s.getStatus() == 3) continue;
            adds.add(s);
        }
        try {
            NoMetaSuperVO[] targVOs = (NoMetaSuperVO[])Array.newInstance(distClass, adds.size());
            int len = adds.size();
            for (int i = 0; i < len; ++i) {
                targVOs[i] = this.copy((AMSuperVO)adds.get(i), distClass);
            }
            return targVOs;
        }
        catch (NegativeArraySizeException e) {
            Logger.error((Object)e.getMessage());
            throw ExceptionUtils.businessException((Throwable)e);
        }
    }

    public static <T extends NoMetaSuperVO> List<String> names(T bean) {
        Field[] childFields = bean.getClass().getDeclaredFields();
        ArrayList columns = Lists.newArrayList();
        for (Field field : childFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            columns.add(field.getName());
        }
        return columns;
    }

    public class UsufructAssetBackupVOAMBeanListProcessor
    extends AMBeanListProcessor<UsufructAssetBackupVO> {
    }

    public class RentPaymentPlanBackupVOAMBeanListProcessor
    extends AMBeanListProcessor<RentPaymentPlanBackupVO> {
    }

    public class DepAccrualBackupVOAMBeanListProcessor
    extends AMBeanListProcessor<DepAccrualBackupVO> {
    }

    public class StepRentStandardBackupVOAMBeanListProcessor
    extends AMBeanListProcessor<StepRentStandardBackupVO> {
    }
}

