/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.bs.logging.Logger;
import nc.impl.am.common.InSqlManager;
import nc.itf.am.pub.IAddReduceStyleService;
import nc.itf.fa.service.ICategoryService;
import nc.itf.fa.service.IUseDeptScaleService;
import nc.itf.fa.service.IUsingstatusService;
import nc.itf.org.IDeptQryService;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.ParameterManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.DeptVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nccloud.pub.fa.fapub.utils.MutliDeptProcessUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReferLeafCheckUtils {
    public static Set<String> UsingStatusLeafCheck(StringBuilder errorMsg, String ... pks) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pks)) {
            return null;
        }
        HashSet<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        Map<String, List<String>> allChildIdBypk = ((IUsingstatusService)AMProxy.lookup(IUsingstatusService.class)).getAllChildIdByParentId(true, pks);
        for (String pk : pks) {
            if (!CollectionUtils.isNotEmpty((Collection)allChildIdBypk.get(pk))) continue;
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0568");
            isNotLeafData.add(pk);
        }
        errorMsg.append(msg);
        return isNotLeafData;
    }

    public static Set<String> AddreduceStyleLeafCheck(StringBuilder errorMsg, String ... pks) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pks)) {
            return null;
        }
        HashSet<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        Map allChildIdBypk = ((IAddReduceStyleService)AMProxy.lookup(IAddReduceStyleService.class)).queryAllChildPkByParentId(true, pks);
        for (String pk : pks) {
            if (!CollectionUtils.isNotEmpty((Collection)((Collection)allChildIdBypk.get(pk)))) continue;
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0540");
            isNotLeafData.add(pk);
        }
        if (!isNotLeafData.isEmpty()) {
            errorMsg.append(msg + "\n");
        }
        return isNotLeafData;
    }

    public static Set<String> MandeptLeafCheck(StringBuilder errorMsg, String ... pks) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pks)) {
            return null;
        }
        Set<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        String whereSql = " dr = 0 and enablestate = 2 and pk_fatherorg in " + InSqlManager.getInSQLValue((String[])pks);
        Object[] allChildDeptVOs = ((IDeptQryService)AMProxy.lookup(IDeptQryService.class)).queryDeptVOSByGroupIDAndClause(pk_group, whereSql);
        if (ArrayUtils.isNotEmpty((Object[])allChildDeptVOs)) {
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0387");
            isNotLeafData = Arrays.stream(allChildDeptVOs).map(vo -> vo.getPk_fatherorg()).distinct().collect(Collectors.toSet());
        }
        errorMsg.append(msg);
        return isNotLeafData;
    }

    public static Set<String> UsedeptLeafCheck(StringBuilder errorMsg, String ... link_keys) throws BusinessException {
        if (ArrayUtils.isBlank((Object[])link_keys) || link_keys[0].contains("&")) {
            return Sets.newHashSet();
        }
        Set<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        DeptScaleVO[] allDeptScaleVOs = ((IUseDeptScaleService)AMProxy.lookup(IUseDeptScaleService.class)).queryUseDeptByLink(link_keys);
        String[] pk_depts = (String[])Arrays.stream(allDeptScaleVOs).map(DeptScaleVO::getPk_dept).distinct().toArray(String[]::new);
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        String whereSql = " dr = 0 and enablestate = 2 and pk_fatherorg in " + InSqlManager.getInSQLValue((String[])pk_depts);
        Object[] allChildDeptVOs = ((IDeptQryService)AMProxy.lookup(IDeptQryService.class)).queryDeptVOSByGroupIDAndClause(pk_group, whereSql);
        if (ArrayUtils.isNotEmpty((Object[])allChildDeptVOs)) {
            isNotLeafData = Arrays.stream(allChildDeptVOs).map(vo -> vo.getPk_dept()).distinct().collect(Collectors.toSet());
            Set pK_depts = Arrays.stream(allChildDeptVOs).map(DeptVO::getPk_fatherorg).collect(Collectors.toSet());
            for (DeptScaleVO scaleVO : allDeptScaleVOs) {
                String pk_dept = scaleVO.getPk_dept();
                if (!pK_depts.contains(pk_dept)) continue;
                isNotLeafData.add(scaleVO.getLink_key());
            }
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0388");
        }
        errorMsg.append(msg);
        return isNotLeafData;
    }

    public static Set<String> CategoryLeafCheck(StringBuilder errorMsg, String pk_org, String[] pks) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pks)) {
            return null;
        }
        HashSet<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        Map<String, List<String>> querySubCategory = ((ICategoryService)AMProxy.lookup(ICategoryService.class)).queryVisibleAllChildPkByParentId(pk_org, true, pks);
        for (String pk : pks) {
            if (!CollectionUtils.isNotEmpty((Collection)querySubCategory.get(pk))) continue;
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0358");
            isNotLeafData.add(pk);
        }
        errorMsg.append(msg);
        return isNotLeafData;
    }

    public static Set<String> UsedeptScaleLeafCheck(StringBuilder errorMsg, String ... mutiStr) throws BusinessException {
        if (ArrayUtils.isBlank((Object[])mutiStr) || !mutiStr[0].contains("&")) {
            return Sets.newHashSet();
        }
        MutliDeptProcessUtils mutilDeptProcessUtils = new MutliDeptProcessUtils();
        Set<String> isNotLeafData = new HashSet<String>();
        String msg = "";
        ArrayList<String> dept_list = new ArrayList<String>();
        for (String str : mutiStr) {
            DeptScaleVO[] deptScaleVOs;
            for (DeptScaleVO deptScaleVO : deptScaleVOs = mutilDeptProcessUtils.dealMultiDeptWeb2NC(str)) {
                dept_list.add(deptScaleVO.getPk_dept());
            }
        }
        String[] pk_depts = (String[])dept_list.stream().distinct().toArray(String[]::new);
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        String whereSql = " dr = 0 and enablestate = 2 and pk_fatherorg in " + InSqlManager.getInSQLValue((String[])pk_depts);
        Object[] allChildDeptVOs = ((IDeptQryService)AMProxy.lookup(IDeptQryService.class)).queryDeptVOSByGroupIDAndClause(pk_group, whereSql);
        if (ArrayUtils.isNotEmpty((Object[])allChildDeptVOs)) {
            msg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0388");
            isNotLeafData = Arrays.stream(allChildDeptVOs).map(vo -> vo.getPk_fatherorg()).distinct().collect(Collectors.toSet());
        }
        errorMsg.append(msg);
        return isNotLeafData;
    }

    public static UFBoolean IsAllowDepMidlev(String pk_org) {
        UFBoolean deptSysPara = null;
        try {
            deptSysPara = ParameterManager.getParaBoolean((String)pk_org, (String)"FA74");
        }
        catch (BusinessException e1) {
            String errMsg = NCLangRes4VoTransl.getNCLangRes().getStrByID("fapub_0", "02012000-0140");
            Logger.error((Object)errMsg);
        }
        return deptSysPara;
    }

    public static void UsingstatusCheck(List<String> pk_usingstatus, StringBuilder errorMsg, Map<Integer, String> pk_usingstatus_index) throws BusinessException {
        StringBuilder builder = new StringBuilder();
        Set<String> usingStatusLeafCheck = ReferLeafCheckUtils.UsingStatusLeafCheck(builder, (String[])pk_usingstatus.stream().distinct().toArray(String[]::new));
        if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
            for (int index : pk_usingstatus_index.keySet()) {
                if (!usingStatusLeafCheck.contains(pk_usingstatus_index.get(index))) continue;
                errorMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0892", null, new String[]{"" + index}));
                errorMsg.append("\n");
            }
        }
    }

    public static void AddreduceStyleCheck(List<String> pk_addreducestyle, StringBuilder errorMsg, Map<Integer, String> pk_addreducestyle_index) throws BusinessException {
        StringBuilder builder = new StringBuilder();
        Set<String> addreduceStyleLeafCheck = ReferLeafCheckUtils.AddreduceStyleLeafCheck(builder, (String[])pk_addreducestyle.stream().distinct().toArray(String[]::new));
        if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
            for (int index : pk_addreducestyle_index.keySet()) {
                if (!addreduceStyleLeafCheck.contains(pk_addreducestyle_index.get(index))) continue;
                errorMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0893", null, new String[]{"" + index}));
                errorMsg.append("\n");
            }
        }
    }

    public static void MandeptCheck(List<String> pk_mandepts, StringBuilder errorMsg, Map<Integer, String> pk_mandepts_index) throws BusinessException {
        StringBuilder builder = new StringBuilder();
        Set<String> mandeptLeafCheck = ReferLeafCheckUtils.MandeptLeafCheck(builder, (String[])pk_mandepts.stream().distinct().toArray(String[]::new));
        if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
            for (int index : pk_mandepts_index.keySet()) {
                if (!mandeptLeafCheck.contains(pk_mandepts_index.get(index))) continue;
                errorMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0890", null, new String[]{"" + index}));
                errorMsg.append("\n");
            }
        }
    }

    public static void UsedeptCheck(List<String> usedepts, StringBuilder errorMsg, Map<Integer, String> usedepts_index) throws BusinessException {
        StringBuilder builder = new StringBuilder();
        Set<String> usedeptLeafCheck = ReferLeafCheckUtils.UsedeptLeafCheck(builder, (String[])usedepts.stream().distinct().toArray(String[]::new));
        Set<String> usedeptLeafCheck2 = ReferLeafCheckUtils.UsedeptScaleLeafCheck(builder, (String[])usedepts.stream().distinct().toArray(String[]::new));
        MutliDeptProcessUtils mutilDeptProcessUtils = new MutliDeptProcessUtils();
        if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
            block0: for (int index : usedepts_index.keySet()) {
                DeptScaleVO[] deptScaleVOs;
                String usedept_sacle;
                if (usedeptLeafCheck.contains(usedepts_index.get(index))) {
                    errorMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0889", null, new String[]{"" + index}));
                    errorMsg.append("\n");
                }
                if (!(usedept_sacle = usedepts_index.get(index)).contains("&")) continue;
                for (DeptScaleVO deptScaleVO : deptScaleVOs = mutilDeptProcessUtils.dealMultiDeptWeb2NC(usedept_sacle)) {
                    if (!usedeptLeafCheck2.contains(deptScaleVO.getPk_dept())) continue;
                    errorMsg.append(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0889", null, new String[]{"" + index}));
                    errorMsg.append("\n");
                    continue block0;
                }
            }
        }
    }
}

