/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nc.bs.pub.formulaparse.FormulaParse;
import nc.itf.fa.service.IAccbookInfoService;
import nc.md.model.IAttribute;
import nc.pub.fa.asset.relative.handler.BaseRelateHandler;
import nc.pub.fa.card.AssetBeanUtils;
import nc.pub.fa.card.AssetFieldConst;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.CurrencyManager;
import nc.vo.am.manager.CurrencyRateManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.logging.Debug;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.commons.collections.MapUtils;

public class LocaloriginvalueFormulaCalculator {
    private final Map<String, String> formulaVariables = new ConcurrentHashMap<String, String>();
    private final BaseRelateHandler handler;
    private final String pk_org;
    private final String pk_category;
    private final UFBoolean usufructasset_flag;

    public LocaloriginvalueFormulaCalculator(BaseRelateHandler handler) {
        this.handler = handler;
        this.pk_org = handler.getPk_org();
        this.pk_category = (String)handler.getValue("pk_category", null);
        this.usufructasset_flag = (UFBoolean)handler.getValue("usufructasset_flag", null);
    }

    public String getFormulaVariable(String pk_accbook) throws BusinessException {
        if (this.formulaVariables.containsKey(pk_accbook)) {
            return this.formulaVariables.get(pk_accbook);
        }
        Map<String, String> mapFormula = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryFormula(this.pk_org, new String[]{this.pk_category}, pk_accbook, this.usufructasset_flag);
        if (MapUtils.isNotEmpty(mapFormula)) {
            String formulaString = mapFormula.get(this.pk_category);
            this.formulaVariables.put(pk_accbook, formulaString);
            return formulaString;
        }
        throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0799"));
    }

    public UFDouble calc(String pk_accbook) throws BusinessException {
        FormulaParse parse = new FormulaParse();
        String formulaVariables = this.getFormulaVariable(pk_accbook);
        String[] formulaVariable = parse.getVarry(formulaVariables).getVarry();
        UFDate date = this.handler.getCurrencyRateDate();
        for (String variable : formulaVariable) {
            UFDouble data = UFDouble.ZERO_DBL;
            IAttribute attribute = AssetBeanUtils.getAssetAttribut(variable);
            if (attribute != null) {
                Object value = this.handler.getValue(variable, pk_accbook);
                if (value != null) {
                    UFDouble u;
                    data = value instanceof UFDouble ? (u = (UFDouble)value) : new UFDouble(value.toString());
                }
            } else {
                data = new UFDouble(variable);
            }
            if (ArrayUtils.changeToList((Object[])AssetFieldConst.ORGMONEY_FIELD).contains(variable) || attribute.getDataType().getTypeType() == 56) {
                String pk_currency_org = CurrencyManager.getLocalCurrencyPK((String)this.pk_org);
                try {
                    data = CurrencyRateManager.getAccbookAmount((String)pk_accbook, (String)pk_currency_org, (UFDouble)data, (UFDate)date);
                }
                catch (BusinessException e) {
                    Debug.error((Object)e.getMessage());
                }
            } else if (ArrayUtils.changeToList((Object[])AssetFieldConst.ORIGINMONEY_FIELD).contains(variable)) {
                String pk_accbook_selected = this.handler.getSelectedAccbook();
                UFDouble ratevalue = UFDouble.ZERO_DBL;
                String pk_ratetype = null;
                if (pk_accbook.equals(pk_accbook_selected)) {
                    ratevalue = (UFDouble)this.handler.getValue("localcurr_rate", pk_accbook);
                    pk_ratetype = (String)this.handler.getValue("pk_ratetype", pk_accbook);
                } else {
                    ratevalue = this.handler.getCardhistoryVO(pk_accbook).getLocalcurr_rate();
                    pk_ratetype = this.handler.getCardhistoryVO(pk_accbook).getPk_ratetype();
                }
                UFDouble rate = ratevalue == null ? UFDouble.ZERO_DBL : ratevalue;
                String pk_currency = (String)this.handler.getValue("pk_currency", pk_accbook);
                try {
                    if (StringUtils.isNotEmpty((String)pk_currency)) {
                        data = CurrencyRateManager.getAccbookAmountByOpp((String)pk_accbook, (String)pk_currency, (UFDouble)data, (UFDouble)rate, (UFDate)date, (String)pk_ratetype);
                    }
                }
                catch (BusinessException e) {
                    Debug.error((Object)e.getMessage());
                }
            }
            parse.addVariable(variable, (Object)data);
        }
        String value = parse.getValue();
        return new UFDouble(value);
    }
}

