/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.service.IAccbookInfoService;
import nc.itf.fa.service.IDepmethodService;
import nc.pub.fa.asset.relative.handler.BaseRelateHandler;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.card.AssetDateCalUtils;
import nc.pub.fa.card.CardVOUtils;
import nc.pub.fa.common.consts.DepattributeConst;
import nc.pub.fa.common.manager.VOManager;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.eampub.util.UFDateTimeUtils;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDateTime;

public class DepStartDateCalculator {
    private final CardVO headVO;
    private final CardhistoryVO[] cardhistoryVOs;
    private final Map<String, CardhistoryVO> mapCardhistoryVOs;
    private final String pk_org;
    private final String pk_category;
    private final boolean usufructasset_flag;
    private final UFDate begin_date;
    private final UFDate business_date;
    private final Map<String, Integer> mapDepAttr;
    private final Map<String, Boolean> mapIsDayDep;
    private UFDate maxBeginDate;

    public DepStartDateCalculator(CardVO headVO, CardhistoryVO ... cardhistoryVOs) throws BusinessException {
        this.headVO = headVO;
        this.cardhistoryVOs = cardhistoryVOs;
        this.mapCardhistoryVOs = Stream.of(cardhistoryVOs).collect(Collectors.toMap(CardhistoryVO::getPk_accbook, o -> o));
        this.pk_org = headVO.getPk_org();
        this.usufructasset_flag = UFBoolean.TRUE.equals((Object)headVO.getUsufructasset_flag());
        this.pk_category = cardhistoryVOs[0].getPk_category();
        this.maxBeginDate = this.begin_date = headVO.getBegin_date();
        this.business_date = headVO.getBusiness_date();
        String[] pk_accbooks = (String[])VOManager.getAttributeValueArray((CircularlyAccessibleValueObject[])cardhistoryVOs, (String)"pk_accbook");
        this.mapDepAttr = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryDepmethodattr(this.pk_org, this.pk_category, pk_accbooks, UFBoolean.valueOf((boolean)this.usufructasset_flag));
        String[] pk_depmethods = (String[])VOManager.getAttributeValueArray((CircularlyAccessibleValueObject[])cardhistoryVOs, (String)"pk_depmethod");
        this.mapIsDayDep = ((IDepmethodService)AMProxy.lookup(IDepmethodService.class)).getIsDayDepMap(pk_depmethods);
        for (CardhistoryVO cardhistoryVO : cardhistoryVOs) {
            UFDate begin_period = cardhistoryVO.getBegin_period();
            UFDate business_period = cardhistoryVO.getBusiness_period();
            if (begin_period == null) {
                DepStartDateCalculator.begin_period(this.begin_date, cardhistoryVO);
            }
            if (business_period != null) continue;
            DepStartDateCalculator.business_period(this.business_date, cardhistoryVO);
        }
    }

    public DepStartDateCalculator(CardVO headVO, UsufructAssetVO usufructVO, CardhistoryVO ... cardhistoryVOs) throws BusinessException {
        this(headVO, cardhistoryVOs);
        if (this.usufructasset_flag) {
            this.maxBeginDate = PayScheduleCalculateHelper.getMaxBeginDate(headVO, usufructVO);
        }
    }

    public DepStartDateCalculator(BaseRelateHandler baseRelateHandler) throws BusinessException {
        this(baseRelateHandler.getAggCvo().getCardVO(), baseRelateHandler.getCardhistoryData());
        if (this.usufructasset_flag) {
            this.maxBeginDate = PayScheduleCalculateHelper.getMaxBeginDate(baseRelateHandler);
        }
    }

    public DepStartDateCalculator(AssetVO assetVO) throws BusinessException {
        this(CardVOUtils.toCard(assetVO), CardVOUtils.toCardhistory(assetVO));
    }

    public UFDate calc(String pk_accbook, String pk_depmethod) throws BusinessException {
        if (!this.mapIsDayDep.containsKey(pk_depmethod)) {
            Map<String, Boolean> isDayDepMap = ((IDepmethodService)AMProxy.lookup(IDepmethodService.class)).getIsDayDepMap(new String[]{pk_depmethod});
            this.mapIsDayDep.putAll(isDayDepMap);
        }
        boolean isday = this.mapIsDayDep.get(pk_depmethod);
        UFDate dep_start_date = null;
        boolean depFlag = this.isDepFlag(pk_accbook);
        if (isday) {
            dep_start_date = depFlag ? this.maxBeginDate : this.maxBeginDate.getDateAfter(1);
            return dep_start_date.asBegin();
        }
        if (depFlag) {
            try {
                AccperiodVO tAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, this.maxBeginDate);
                dep_start_date = tAccperiodVO.getStartdate();
            }
            catch (BusinessException e) {
                dep_start_date = AssetDateCalUtils.calTempDepStartDate(pk_accbook, this.maxBeginDate, UFBoolean.FALSE);
            }
        } else {
            try {
                AccperiodVO tAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, this.maxBeginDate);
                AccperiodVO nextAccperiodVO = PeriodManager.getInstance().getNextPeriod(pk_accbook, tAccperiodVO);
                dep_start_date = nextAccperiodVO.getStartdate();
            }
            catch (BusinessException e) {
                dep_start_date = AssetDateCalUtils.calTempDepStartDate(pk_accbook, this.maxBeginDate, UFBoolean.TRUE);
            }
        }
        return dep_start_date.asBegin();
    }

    public int calcUsedmonth(String pk_accbook, UFDate dep_start_date) throws BusinessException {
        CardhistoryVO cardhistoryVO = this.mapCardhistoryVOs.get(pk_accbook);
        int usedMonth = 0;
        if (dep_start_date.afterDate(this.business_date)) {
            usedMonth = 0;
        } else {
            Integer serviceMonth;
            usedMonth = PeriodManager.getInstance().getSubPeriodByDate(pk_accbook, dep_start_date.asLocalEnd(), this.business_date);
            if (usedMonth < 0) {
                usedMonth = 0;
            }
            if ((serviceMonth = cardhistoryVO.getServicemonth()) != null && serviceMonth < usedMonth) {
                usedMonth = serviceMonth;
            }
        }
        return usedMonth;
    }

    public boolean isDepFlag(String pk_accbook) {
        boolean depFlag = false;
        int depattr = this.mapDepAttr.get(pk_accbook);
        if (depattr == DepattributeConst.ACCBOOK_REDUCE_DEP || depattr == DepattributeConst.ACCBOOK_REDUCE_AFTER_DEP) {
            depFlag = false;
        } else if (depattr == DepattributeConst.ACCBOOK_NEW_DEP || depattr == DepattributeConst.ACCBOOK_ALL_DEP) {
            depFlag = true;
        }
        return depFlag;
    }

    public static void begin_period(UFDate begin_date, CardhistoryVO cardhistoryVO) {
        String pk_accbook = cardhistoryVO.getPk_accbook();
        try {
            String periodPK = PeriodManager.getInstance().getPeriodPK(pk_accbook, begin_date);
            AccperiodVO accperiodVO = PeriodManager.queryPeriodByAccperiodMonth((String)periodPK);
            cardhistoryVO.setBegin_period(accperiodVO.getStartdate());
        }
        catch (BusinessException ignore) {
            cardhistoryVO.setBegin_period(new UFDate(UFDateTimeUtils.getCurrMonthFirstDayTime((UFDateTime)new UFDateTime(begin_date.getMillis())).getMillis()));
        }
    }

    public static void business_period(UFDate business_date, CardhistoryVO cardhistoryVO) throws BusinessException {
        if (business_date == null) {
            return;
        }
        String pk_accbook = cardhistoryVO.getPk_accbook();
        String periodPK = PeriodManager.getInstance().getPeriodPK(pk_accbook, business_date);
        AccperiodVO accperiodVO = PeriodManager.queryPeriodByAccperiodMonth((String)periodPK);
        cardhistoryVO.setBusiness_period(accperiodVO.getStartdate());
    }

    public static UFDate getDepStartDate(String pk_accbook, int depattr, boolean isday, UFDate begindate) throws BusinessException {
        UFDate dep_start_date = null;
        if (depattr == DepattributeConst.ACCBOOK_REDUCE_DEP || depattr == DepattributeConst.ACCBOOK_REDUCE_AFTER_DEP) {
            if (isday) {
                dep_start_date = begindate.getDateAfter(1);
            } else {
                try {
                    AccperiodVO tAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, begindate);
                    AccperiodVO nextAccperiodVO = PeriodManager.getInstance().getNextPeriod(pk_accbook, tAccperiodVO);
                    dep_start_date = nextAccperiodVO.getStartdate();
                }
                catch (BusinessException e) {
                    dep_start_date = AssetDateCalUtils.calTempDepStartDate(pk_accbook, begindate, UFBoolean.TRUE);
                }
            }
        } else if (depattr == DepattributeConst.ACCBOOK_NEW_DEP || depattr == DepattributeConst.ACCBOOK_ALL_DEP) {
            if (isday) {
                dep_start_date = begindate;
            } else {
                try {
                    AccperiodVO tAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, begindate);
                    dep_start_date = tAccperiodVO.getStartdate();
                }
                catch (BusinessException e) {
                    dep_start_date = AssetDateCalUtils.calTempDepStartDate(pk_accbook, begindate, UFBoolean.FALSE);
                }
            }
        }
        return dep_start_date.asBegin();
    }
}

