/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nc.pub.fa.card.AssetTabConstManager;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.cache.CardVOAttrNameCaffeine;
import nc.pub.fa.common.util.UseDeptScaleUtils;
import nc.vo.am.common.MappedBaseVO;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.BaseVOUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.fa.asset.AggAssetVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.assetcard.ExpenseVO;
import nc.vo.fa.assetcard.InsuranceVO;
import nc.vo.fa.assetcard.LogalterVO;
import nc.vo.fa.assetcard.LogdevalueVO;
import nc.vo.fa.assetcard.LogevaluateVO;
import nc.vo.fa.assetcard.RentVO;
import nc.vo.fa.assetcard.SubequipVO;
import nc.vo.fa.assetcard.itf.ICardVO;
import nc.vo.fa.assetcard.itf.ICardhistoryVO;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.IAttributeMeta;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDouble;
import nc.vo.trade.pub.IExAggVO;

public class CardVOUtils {
    private static void fillAggAssetVOTabData(AggAssetVO toAggAssetVO, AssetEntiretyVO fromAssetEntiretyVO) {
        if (fromAssetEntiretyVO == null || toAggAssetVO == null) {
            return;
        }
        String[] tableCodes = toAggAssetVO.getTableCodes();
        Object pk_accbook = toAggAssetVO.getParentVO().getAttributeValue("pk_accbook");
        for (int i = 0; i < tableCodes.length; ++i) {
            SuperVO[] vos = null;
            vos = pk_accbook == null ? fromAssetEntiretyVO.getTabVO(tableCodes[i], null) : fromAssetEntiretyVO.getTabVO(tableCodes[i], pk_accbook.toString());
            toAggAssetVO.setTableVO(tableCodes[i], (CircularlyAccessibleValueObject[])vos);
        }
    }

    public static AggAssetVO toAggAsset(AggCardVO fromAggCardVO) {
        AssetEntiretyVO vo = CardVOUtils.toAssetEntirety(fromAggCardVO);
        return CardVOUtils.toAggAsset(vo, null);
    }

    public static AggAssetVO[] getAggAssetVOByAggCardVO_allHistory(AggCardVO fromAggCardVO) {
        AssetEntiretyVO evo = CardVOUtils.toAssetEntirety(fromAggCardVO);
        Object[] bookKeys = evo.getAllBookKeys();
        if (ArrayUtils.isNotEmpty((Object[])bookKeys)) {
            ArrayList<AggAssetVO> aggAvoList = new ArrayList<AggAssetVO>();
            for (Object pk_accbook : bookKeys) {
                AggAssetVO aggAvo = CardVOUtils.toAggAsset(evo, (String)pk_accbook);
                aggAvoList.add(aggAvo);
            }
            return (AggAssetVO[])CollectionUtils.toArray(aggAvoList);
        }
        return null;
    }

    public static AggAssetVO[] toAggAsset(AssetEntiretyVO fromAssetEntiretyVO) {
        Object[] bookKeys = fromAssetEntiretyVO.getAllBookKeys();
        if (ArrayUtils.isNotEmpty((Object[])bookKeys)) {
            boolean isRealBookExist = false;
            for (Object book : bookKeys) {
                if (!StringUtils.isNotEmpty((String)book)) continue;
                isRealBookExist = true;
            }
            ArrayList<AggAssetVO> aggAvoList = new ArrayList<AggAssetVO>();
            if (isRealBookExist) {
                for (Object pk_accbook : bookKeys) {
                    AggAssetVO aggAvo = CardVOUtils.toAggAsset(fromAssetEntiretyVO, (String)pk_accbook);
                    aggAvoList.add(aggAvo);
                }
            } else {
                AggAssetVO aggAvo = CardVOUtils.compagesAggAssetVO(fromAssetEntiretyVO.getCardVO(), fromAssetEntiretyVO.getCardhistoryVOs()[0]);
                CardVOUtils.fillAggAssetVOTabData(aggAvo, fromAssetEntiretyVO);
                aggAvoList.add(aggAvo);
            }
            return (AggAssetVO[])CollectionUtils.toArray(aggAvoList);
        }
        return null;
    }

    public static AssetEntiretyVO toAssetEntirety(AssetVO fromAssetVO) {
        CardVO cardvo = CardVOUtils.toCard(fromAssetVO);
        CardhistoryVO hisVO = CardVOUtils.toCardhistory(fromAssetVO);
        return CardVOUtils.combineEntiretyVO(cardvo, new CardhistoryVO[]{hisVO});
    }

    public static AssetVO[] toAssets(AssetEntiretyVO fromAssetEntiretyVO) {
        CardhistoryVO[] hisVos;
        ArrayList<AssetVO> data = new ArrayList<AssetVO>();
        for (CardhistoryVO hisVo : hisVos = fromAssetEntiretyVO.getCardhistoryVOs()) {
            data.add(CardVOUtils.compagesHeadVO(fromAssetEntiretyVO.getCardVO(), hisVo));
        }
        return data.toArray(new AssetVO[0]);
    }

    public static AssetEntiretyVO[] toAssetEntireties(AssetVO[] fromAssetVOs) {
        AggCardVO[] aggCardVos = CardVOUtils.toAggCards(fromAssetVOs);
        ArrayList<AssetEntiretyVO> data = new ArrayList<AssetEntiretyVO>();
        for (AggCardVO aggCardVo : aggCardVos) {
            data.add(CardVOUtils.toAssetEntirety(aggCardVo));
        }
        return data.toArray(new AssetEntiretyVO[0]);
    }

    public static AssetVO getAssetVOFromAssetEntiretyVOByPkaccbook(AssetEntiretyVO fromAssetEntiretyVO, String pk_accbook) {
        CardhistoryVO hisVo = fromAssetEntiretyVO.getCardhistoryVO(pk_accbook);
        return CardVOUtils.compagesHeadVO(fromAssetEntiretyVO.getCardVO(), hisVo);
    }

    public static AggAssetVO toAggAsset(AssetEntiretyVO fromAssetEntiretyVO, String pk_accbook) {
        AggAssetVO data = null;
        AssetEntiretyVO entiretyVO = fromAssetEntiretyVO;
        if (StringUtils.isEmpty((String)pk_accbook)) {
            pk_accbook = entiretyVO.getMainAccbookKey();
        }
        data = CardVOUtils.compagesAggAssetVO(entiretyVO.getCardVO(), entiretyVO.getCardhistoryVO(pk_accbook));
        CardVOUtils.fillAggAssetVOTabData(data, fromAssetEntiretyVO);
        return data;
    }

    public static CardVO toCard(AssetVO fromAssetVO) {
        CardVO cardVO = new CardVO();
        String[] fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(cardVO);
        for (int i = 0; i < fieldNames.length; ++i) {
            cardVO.setAttributeValue(fieldNames[i], fromAssetVO.getAttributeValue(fieldNames[i]));
        }
        Map valueIndex = fromAssetVO.getValueIndex();
        cardVO.setValueIndex(valueIndex);
        cardVO.setStatus(fromAssetVO.getStatus());
        cardVO.setTs(fromAssetVO.getTs());
        return cardVO;
    }

    public static AssetEntiretyVO getAssetEntiretyVOFromAggVOAndHistoryVOs(AggAssetVO fromAggAssetVO, CardhistoryVO ... fromCardhistoryVOs) {
        AssetEntiretyVO entiretyVO = new AssetEntiretyVO();
        CardVO cardvo = CardVOUtils.toCard(fromAggAssetVO);
        entiretyVO.setCardVO(cardvo);
        entiretyVO.setCardhistoryVOs(fromCardhistoryVOs);
        CardVOUtils.fillAssetEntiretyVOTabData(entiretyVO, fromAggAssetVO);
        return entiretyVO;
    }

    public static AssetEntiretyVO toAssetEntirety(AggAssetVO fromAggAssetVO) {
        AssetEntiretyVO entiretyVO = new AssetEntiretyVO();
        CardVO cardvo = CardVOUtils.toCard(fromAggAssetVO);
        CardhistoryVO hisVO = CardVOUtils.toCardhistory(fromAggAssetVO);
        entiretyVO.setCardVO(cardvo);
        entiretyVO.setCardhistoryVOs(hisVO);
        CardVOUtils.fillAssetEntiretyVOTabData(entiretyVO, fromAggAssetVO);
        return entiretyVO;
    }

    private static void fillAssetEntiretyVOTabData(AssetEntiretyVO toAssetEntiretyVO, AggAssetVO fromAggAssetVO) {
        String[] tabCodes = fromAggAssetVO.getTableCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            SuperVO[] data = fromAggAssetVO.getTableVO(tabCodes[i]);
            toAssetEntiretyVO.setTabVO(tabCodes[i], data);
        }
    }

    public static CardVO toCard(AggAssetVO fromAggAssetVO) {
        CircularlyAccessibleValueObject circularlyAccessibleValueObject = fromAggAssetVO.getParentVO();
        if (circularlyAccessibleValueObject instanceof AssetVO) {
            AssetVO assetVO = (AssetVO)circularlyAccessibleValueObject;
            return CardVOUtils.toCard(assetVO);
        }
        return null;
    }

    public static CardhistoryVO toCardhistory(AssetVO fromAssetVO) {
        CardhistoryVO vo = new CardhistoryVO();
        String[] fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(vo);
        for (int i = 0; i < fieldNames.length; ++i) {
            vo.setAttributeValue(fieldNames[i], fromAssetVO.getAttributeValue(fieldNames[i]));
        }
        vo.setAttributeValue("ts", fromAssetVO.getAttributeValue("ts_history"));
        vo.setStatus(fromAssetVO.getStatus());
        Object pk_card = fromAssetVO.getAttributeValue("pk_card");
        if (pk_card != null) {
            vo.setPk_card(pk_card.toString());
        }
        return vo;
    }

    public static CardhistoryVO toCardhistory(AggAssetVO fromAggAssetVO) {
        CircularlyAccessibleValueObject circularlyAccessibleValueObject = fromAggAssetVO.getParentVO();
        if (circularlyAccessibleValueObject instanceof AssetVO) {
            AssetVO assetVO = (AssetVO)circularlyAccessibleValueObject;
            return CardVOUtils.toCardhistory(assetVO);
        }
        return null;
    }

    public static AggAssetVO compagesAggAssetVO(CardVO fromCardVO, CardhistoryVO formCardhistoryVO) {
        if (fromCardVO == null || formCardhistoryVO == null) {
            return null;
        }
        AggAssetVO aggvo = new AggAssetVO();
        AssetVO vo = CardVOUtils.compagesHeadVO(fromCardVO, formCardhistoryVO);
        aggvo.setParentVO((CircularlyAccessibleValueObject)vo);
        return aggvo;
    }

    public static AssetVO compagesHeadVO(CardVO fromCardVO, CardhistoryVO fromCardhistoryVO) {
        if (fromCardVO == null || fromCardhistoryVO == null) {
            return null;
        }
        AssetVO toAssetVO = new AssetVO();
        String[] fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(fromCardVO);
        for (int i = 0; i < fieldNames.length; ++i) {
            toAssetVO.setAttributeValue(fieldNames[i], fromCardVO.getAttributeValue(fieldNames[i]));
        }
        Map valueIndex = fromCardVO.getValueIndex();
        toAssetVO.setValueIndex(valueIndex);
        fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(fromCardhistoryVO);
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("ts")) {
                toAssetVO.setAttributeValue("ts_history", fromCardhistoryVO.getAttributeValue("ts"));
                continue;
            }
            if (fieldNames[i].equals("pk_org") || fieldNames[i].equals("pk_group")) continue;
            toAssetVO.setAttributeValue(fieldNames[i], fromCardhistoryVO.getAttributeValue(fieldNames[i]));
        }
        CardVOUtils.countFinanceFieldValue((SuperVO)toAssetVO);
        return toAssetVO;
    }

    public static AssetVO compagesHeadVO(ICardVO fromCardVO, ICardhistoryVO fromCardhistoryVO) {
        if (fromCardVO == null || fromCardhistoryVO == null) {
            return null;
        }
        AssetVO toAssetVO = new AssetVO();
        String[] fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(new CardVO());
        for (int i = 0; i < fieldNames.length; ++i) {
            toAssetVO.setAttributeValue(fieldNames[i], fromCardVO.getAttributeValue(fieldNames[i]));
        }
        Map valueIndex = fromCardVO.getValueIndex();
        toAssetVO.setValueIndex(valueIndex);
        fieldNames = CardVOAttrNameCaffeine.getCaffeine().get(new CardhistoryVO());
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("ts")) {
                toAssetVO.setAttributeValue("ts_history", fromCardhistoryVO.getAttributeValue("ts"));
                continue;
            }
            if (fieldNames[i].equals("pk_org") || fieldNames[i].equals("pk_group")) continue;
            toAssetVO.setAttributeValue(fieldNames[i], fromCardhistoryVO.getAttributeValue(fieldNames[i]));
        }
        CardVOUtils.countFinanceFieldValue((SuperVO)toAssetVO);
        return toAssetVO;
    }

    public static void countFinanceFieldValue(SuperVO vo) {
        UFDouble local = (UFDouble)vo.getAttributeValue("localoriginvalue");
        UFDouble local_group = (UFDouble)vo.getAttributeValue("localoriginvalue_group");
        UFDouble local_global = (UFDouble)vo.getAttributeValue("localoriginvalue_global");
        UFDouble accudep = (UFDouble)vo.getAttributeValue("accudep");
        UFDouble accudep_group = (UFDouble)vo.getAttributeValue("accudep_group");
        UFDouble accudep_global = (UFDouble)vo.getAttributeValue("accudep_global");
        UFDouble devaluate = (UFDouble)vo.getAttributeValue("predevaluate");
        UFDouble devaluate_group = (UFDouble)vo.getAttributeValue("predevaluate_group");
        UFDouble devaluate_global = (UFDouble)vo.getAttributeValue("predevaluate_global");
        UFDouble localData = local == null ? UFDouble.ZERO_DBL : local;
        UFDouble local_groupData = local_group == null ? UFDouble.ZERO_DBL : local_group;
        UFDouble local_globalData = local_global == null ? UFDouble.ZERO_DBL : local_global;
        UFDouble accudepData = accudep == null ? UFDouble.ZERO_DBL : accudep;
        UFDouble accudep_groupData = accudep_group == null ? UFDouble.ZERO_DBL : accudep_group;
        UFDouble accudep_globalData = accudep_global == null ? UFDouble.ZERO_DBL : accudep_global;
        UFDouble devaluateData = devaluate == null ? UFDouble.ZERO_DBL : devaluate;
        UFDouble devaluate_groupData = devaluate_group == null ? UFDouble.ZERO_DBL : devaluate_group;
        UFDouble devaluate_globalData = devaluate_global == null ? UFDouble.ZERO_DBL : devaluate_global;
        UFDouble netvalue = UFDoubleUtils.isGreaterThan((UFDouble)localData.sub(accudepData), (UFDouble)UFDouble.ZERO_DBL) ? localData.sub(accudepData) : UFDouble.ZERO_DBL;
        UFDouble netvalue_group = UFDoubleUtils.isGreaterThan((UFDouble)local_groupData.sub(accudep_groupData), (UFDouble)UFDouble.ZERO_DBL) ? local_groupData.sub(accudep_groupData) : UFDouble.ZERO_DBL;
        UFDouble netvalue_global = UFDoubleUtils.isGreaterThan((UFDouble)local_globalData.sub(accudep_globalData), (UFDouble)UFDouble.ZERO_DBL) ? local_globalData.sub(accudep_globalData) : UFDouble.ZERO_DBL;
        vo.setAttributeValue("netvalue", (Object)netvalue);
        vo.setAttributeValue("netvalue_group", (Object)netvalue_group);
        vo.setAttributeValue("netvalue_global", (Object)netvalue_global);
        UFDouble netrating = UFDoubleUtils.isGreaterThan((UFDouble)netvalue.sub(devaluateData), (UFDouble)UFDouble.ZERO_DBL) ? netvalue.sub(devaluateData) : UFDouble.ZERO_DBL;
        UFDouble netrating_group = UFDoubleUtils.isGreaterThan((UFDouble)netvalue_group.sub(devaluate_groupData), (UFDouble)UFDouble.ZERO_DBL) ? netvalue_group.sub(devaluate_groupData) : UFDouble.ZERO_DBL;
        UFDouble netrating_global = UFDoubleUtils.isGreaterThan((UFDouble)netvalue_global.sub(devaluate_globalData), (UFDouble)UFDouble.ZERO_DBL) ? netvalue_global.sub(devaluate_globalData) : UFDouble.ZERO_DBL;
        vo.setAttributeValue("netrating", (Object)netrating);
        vo.setAttributeValue("netrating_group", (Object)netrating_group);
        vo.setAttributeValue("netrating_global", (Object)netrating_global);
    }

    public static AggCardVO toAggCard(AssetEntiretyVO fromAssetEntiretyVO) {
        AggCardVO aggVO = new AggCardVO();
        aggVO.setParentVO((CircularlyAccessibleValueObject)fromAssetEntiretyVO.getCardVO());
        String[] tabCodes = aggVO.getTableCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            if (tabCodes[i].equals(CardTabConst.history)) {
                aggVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])fromAssetEntiretyVO.getCardhistoryVOs());
                continue;
            }
            SuperVO[] old = fromAssetEntiretyVO.getTabVO(tabCodes[i]);
            SuperVO[] newdata = CardVOUtils.toTrueTab(old);
            aggVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])newdata);
        }
        aggVO.setTableVO(CardTabConst.useDept, (CircularlyAccessibleValueObject[])CardVOUtils.toTrueTab(fromAssetEntiretyVO.getTabVO(CardTabConst.useDept)));
        return aggVO;
    }

    public static AggCardVO toAggCard(AggAssetVO fromAggAssetVO) {
        AssetVO assetVO = (AssetVO)fromAggAssetVO.head();
        AggCardVO aggVO = CardVOUtils.toAggCard(assetVO);
        String[] tabCodes = fromAggAssetVO.getTableCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            SuperVO[] old = fromAggAssetVO.getTableVO(tabCodes[i]);
            SuperVO[] newdata = CardVOUtils.toTrueTab(old);
            aggVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])newdata);
        }
        aggVO.setTableVO(CardTabConst.useDept, (CircularlyAccessibleValueObject[])CardVOUtils.toTrueTab(fromAggAssetVO.getTableVO(CardTabConst.useDept)));
        return aggVO;
    }

    public static AggCardVO changeAggCardVOTabDataToTrueType(AggCardVO fromAggCardVO) {
        String[] tabCodes = fromAggCardVO.getTableCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            if (tabCodes[i].equals(CardTabConst.history)) {
                fromAggCardVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])fromAggCardVO.getTableVO(CardTabConst.history));
                continue;
            }
            if (!tabCodes[i].endsWith(CardTabConst.alter) && !tabCodes[i].endsWith(CardTabConst.evaluate) && !tabCodes[i].endsWith(CardTabConst.deploy) && !tabCodes[i].endsWith(CardTabConst.devalue) && !tabCodes[i].endsWith(CardTabConst.reduce)) continue;
            SuperVO[] old = fromAggCardVO.getTableVO(tabCodes[i]);
            SuperVO[] newdata = CardVOUtils.changeViewBillVOToTrueTabVO(old);
            fromAggCardVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])newdata);
        }
        return fromAggCardVO;
    }

    public static SuperVO[] changeViewBillVOToTrueTabVO(SuperVO[] viewVOs) {
        if (ArrayUtils.isEmpty((Object[])viewVOs)) {
            return null;
        }
        String pkfield = "";
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < viewVOs.length; ++i) {
            if (viewVOs[i].getStatus() == 3) {
                data.add(viewVOs[i]);
                continue;
            }
            if (viewVOs[0].getClass().getName().equals(DeptScaleVO.class.getName())) continue;
            if (viewVOs[0].getClass().getName().equals(LogalterVO.class.getName())) {
                pkfield = "pk_logalter";
            } else if (viewVOs[0].getClass().getName().equals(ExpenseVO.class.getName())) {
                pkfield = "pk_expense";
            } else if (viewVOs[0].getClass().getName().equals(InsuranceVO.class.getName())) {
                pkfield = "pk_insurance";
            } else if (viewVOs[0].getClass().getName().equals(LogdevalueVO.class.getName())) {
                pkfield = "pk_devalue";
            } else if (viewVOs[0].getClass().getName().equals(LogevaluateVO.class.getName())) {
                pkfield = "pk_logevaluate";
            } else if (viewVOs[0].getClass().getName().equals(RentVO.class.getName())) {
                pkfield = "pk_rent";
            } else if (viewVOs[0].getClass().getName().equals(SubequipVO.class.getName())) {
                pkfield = "pk_subequip";
            }
            Class viewClass = AssetTabConstManager.getTrueTabVO(viewVOs[0].getClass());
            SuperVO vo = (SuperVO)BaseVOUtils.initClass((Class)viewClass);
            Object[] fields = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            fields = (String[])ArrayUtils.addElement((Object[])fields, (Object[])new String[]{"pk_bill"});
            for (int j = 0; j < fields.length; ++j) {
                vo.setAttributeValue((String)fields[j], viewVOs[i].getAttributeValue((String)fields[j]));
            }
            Object pkValue = viewVOs[i].getAttributeValue(pkfield);
            if (viewVOs[0].getClass().getName().equals(LogalterVO.class.getName())) {
                if (StringUtils.isEmpty((String)(null == pkValue ? null : pkValue.toString()))) {
                    vo.setStatus(2);
                } else if (null != pkValue && pkValue.toString().length() == 20) {
                    vo.setStatus(1);
                } else {
                    vo.setStatus(0);
                }
            } else if (StringUtils.isEmpty((String)(null == pkValue ? null : pkValue.toString()))) {
                vo.setStatus(2);
            } else if (null != pkValue && pkValue.toString().length() == 20) {
                vo.setStatus(1);
            }
            data.add(vo);
        }
        return data.toArray(new SuperVO[0]);
    }

    public static AggCardVO[] toAggCards(AssetEntiretyVO[] fromAssetEntiretyVOs) {
        if (ArrayUtils.isEmpty((Object[])fromAssetEntiretyVOs)) {
            return null;
        }
        ArrayList<AggCardVO> aggVOlist = new ArrayList<AggCardVO>();
        for (AssetEntiretyVO vo : fromAssetEntiretyVOs) {
            aggVOlist.add(CardVOUtils.toAggCard(vo));
        }
        return aggVOlist.toArray(new AggCardVO[0]);
    }

    public static AssetEntiretyVO toAssetEntirety(AggCardVO fromAggCardVO) {
        Object data;
        AssetEntiretyVO entiretyVO = new AssetEntiretyVO();
        String[] tabCodes = entiretyVO.getTabCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            data = fromAggCardVO.getTableVO(tabCodes[i]);
            if (data != null && ((SuperVO[])data).length > 0) {
                SuperVO[] viewVOs = CardVOUtils.changeTrueTabVOToViewTabVO((SuperVO[])data);
                entiretyVO.setTabVO(tabCodes[i], viewVOs);
                continue;
            }
            entiretyVO.setTabVO(tabCodes[i], null);
        }
        entiretyVO.setCardVO(fromAggCardVO.getParentVO());
        SuperVO[] vos = fromAggCardVO.getTableVO(CardTabConst.history);
        data = new ArrayList();
        for (int i = 0; i < vos.length; ++i) {
            data.add((CardhistoryVO)vos[i]);
        }
        entiretyVO.setCardhistoryVOs(data.toArray(new CardhistoryVO[0]));
        return entiretyVO;
    }

    public static AssetEntiretyVO combineEntiretyVO(CardVO fromCardVO, CardhistoryVO[] fromCardhistoryVOs) {
        AssetEntiretyVO entiretyvo = new AssetEntiretyVO();
        entiretyvo.setCardVO(fromCardVO);
        entiretyvo.setCardhistoryVOs(fromCardhistoryVOs);
        return entiretyvo;
    }

    public static AggCardVO[] combineAggCardVO(CardVO[] fromCardVOs, CardhistoryVO[] fromCardhistoryVOs) {
        ArrayList<AggCardVO> aggCvos = new ArrayList<AggCardVO>();
        if (ArrayUtils.isNotEmpty((Object[])fromCardVOs) && ArrayUtils.isNotEmpty((Object[])fromCardhistoryVOs)) {
            for (CardVO cvo : fromCardVOs) {
                String pk_card = cvo.getPk_card();
                ArrayList<CardhistoryVO> hisVOList = new ArrayList<CardhistoryVO>();
                for (CardhistoryVO hisVO : fromCardhistoryVOs) {
                    if (!hisVO.getPk_card().equals(pk_card)) continue;
                    hisVOList.add(hisVO);
                }
                AggCardVO aggCvo = new AggCardVO();
                aggCvo.setParentVO((CircularlyAccessibleValueObject)cvo);
                aggCvo.setTableVO(CardTabConst.history, (CircularlyAccessibleValueObject[])CollectionUtils.toArray(hisVOList));
                aggCvos.add(aggCvo);
            }
        }
        return (AggCardVO[])CollectionUtils.toArray(aggCvos);
    }

    public static <T extends SuperVO> T[] changeTrueTabVOToViewTabVO(SuperVO[] trueVOs) {
        if (ArrayUtils.isEmpty((Object[])trueVOs)) {
            return null;
        }
        Class viewClass = AssetTabConstManager.getViewTabVO(trueVOs[0].getClass());
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < trueVOs.length; ++i) {
            SuperVO vo = (SuperVO)BaseVOUtils.initClass((Class)viewClass);
            String[] fields = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            for (int j = 0; j < fields.length; ++j) {
                vo.setAttributeValue(fields[j], trueVOs[i].getAttributeValue(fields[j]));
            }
            vo.setStatus(trueVOs[i].getStatus());
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.convertToRealTypeArray(data);
    }

    public static <T extends SuperVO, E extends SuperVO> T[] changeTrueTabVOToViewTabVOGeneric(E[] trueVOs) {
        if (ArrayUtils.isEmpty((Object[])trueVOs)) {
            return null;
        }
        Class viewClass = AssetTabConstManager.getViewTabVO(trueVOs[0].getClass());
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < trueVOs.length; ++i) {
            SuperVO vo = (SuperVO)BaseVOUtils.initClass((Class)viewClass);
            String[] fields = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            for (int j = 0; j < fields.length; ++j) {
                vo.setAttributeValue(fields[j], trueVOs[i].getAttributeValue(fields[j]));
            }
            vo.setStatus(trueVOs[i].getStatus());
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.convertToRealTypeArray(data);
    }

    public static <T extends SuperVO, E extends SuperVO> T[] changeViewTabVOToTrueTabVOGeneric(E[] viewVOs) {
        if (ArrayUtils.isEmpty((Object[])viewVOs)) {
            return null;
        }
        Class viewClass = AssetTabConstManager.getTrueTabVO(viewVOs[0].getClass());
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < viewVOs.length; ++i) {
            SuperVO vo = (SuperVO)BaseVOUtils.initClass((Class)viewClass);
            Object[] fields = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            fields = (String[])ArrayUtils.addElement((Object[])fields, (Object[])new String[]{"pk_bill"});
            for (int j = 0; j < fields.length; ++j) {
                vo.setAttributeValue((String)fields[j], viewVOs[i].getAttributeValue((String)fields[j]));
            }
            vo.setStatus(viewVOs[i].getStatus());
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.convertToRealTypeArray(data);
    }

    public static SuperVO[] toTrueTab(SuperVO[] viewVOs) {
        if (ArrayUtils.isEmpty((Object[])viewVOs)) {
            return null;
        }
        Class viewClass = AssetTabConstManager.getTrueTabVO(viewVOs[0].getClass());
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < viewVOs.length; ++i) {
            SuperVO vo = (SuperVO)BaseVOUtils.initClass((Class)viewClass);
            Object[] fields = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            fields = (String[])ArrayUtils.addElement((Object[])fields, (Object[])new String[]{"pk_bill"});
            for (int j = 0; j < fields.length; ++j) {
                vo.setAttributeValue((String)fields[j], viewVOs[i].getAttributeValue((String)fields[j]));
            }
            vo.setStatus(viewVOs[i].getStatus());
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.convertToRealTypeArray(data);
    }

    public static String[] getAllBooksFormAggvo(AggCardVO fromAggCardVO) {
        Object[] history = fromAggCardVO.getTableVO(CardTabConst.history);
        HashSet<String> data = new HashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])history)) {
            for (Object vo : history) {
                String pk_accbook = (String)vo.getAttributeValue("pk_accbook");
                if (!StringUtils.isNotEmpty((String)pk_accbook)) continue;
                data.add(pk_accbook);
            }
        }
        return data.toArray(new String[0]);
    }

    public static AssetVO toAsset(AggCardVO fromAggCardVO) {
        AssetEntiretyVO assetEntiretyVO = CardVOUtils.toAssetEntirety(fromAggCardVO);
        return CardVOUtils.compagesHeadVO(assetEntiretyVO.getCardVO(), assetEntiretyVO.getMainCardhistoryVO());
    }

    public static AggCardVO toAggCard(AssetVO fromAssetVO) {
        CardVO cardvo = CardVOUtils.toCard(fromAssetVO);
        CardhistoryVO hisVO = CardVOUtils.toCardhistory(fromAssetVO);
        AggCardVO aggVO = new AggCardVO();
        aggVO.setParentVO((CircularlyAccessibleValueObject)cardvo);
        aggVO.setTableVO(CardTabConst.history, (CircularlyAccessibleValueObject[])new CardhistoryVO[]{hisVO});
        return aggVO;
    }

    public static AggCardVO[] toAggCards(AggAssetVO[] fromAggAssetVOs) {
        if (ArrayUtils.isEmpty((Object[])fromAggAssetVOs)) {
            return null;
        }
        ArrayList<AggCardVO> aggCardVOs = new ArrayList<AggCardVO>();
        for (int i = 0; i < fromAggAssetVOs.length; ++i) {
            AggCardVO aggCard = CardVOUtils.toAggCard(fromAggAssetVOs[i]);
            aggCardVOs.add(aggCard);
        }
        return aggCardVOs.toArray(new AggCardVO[0]);
    }

    public static AggCardVO[] toAggCards(AssetVO[] fromAssetVOs) {
        if (ArrayUtils.isEmpty((Object[])fromAssetVOs)) {
            return null;
        }
        Arrays.stream(fromAssetVOs).forEach(head -> {
            if (head.getPk_card() == null) {
                head.setPk_card("~");
            }
        });
        Map<String, List<AssetVO>> groupData = Arrays.stream(fromAssetVOs).collect(Collectors.groupingBy(AssetVO::getPk_card));
        ArrayList aggCardVOs = new ArrayList();
        groupData.keySet().stream().map(key -> (List)groupData.get(key)).forEach(assetVOList -> {
            CardhistoryVO[] tableVO = (CardhistoryVO[])assetVOList.stream().map(vo -> {
                if ("~".equals(vo.getPk_card())) {
                    vo.setPk_card(null);
                }
                return CardVOUtils.toCardhistory(vo);
            }).toArray(CardhistoryVO[]::new);
            CardVO cardvo = CardVOUtils.toCard((AssetVO)assetVOList.get(0));
            AggCardVO aggCardvo = new AggCardVO();
            aggCardvo.setParentVO((CircularlyAccessibleValueObject)cardvo);
            aggCardvo.setTableVO(CardTabConst.history, (CircularlyAccessibleValueObject[])tableVO);
            aggCardVOs.add(aggCardvo);
        });
        return aggCardVOs.toArray(new AggCardVO[0]);
    }

    public static String getMainAccbook(AggCardVO fromAggCardVO) {
        AssetVO vo = CardVOUtils.toAsset(fromAggCardVO);
        return null != vo ? vo.getPk_accbook() : "";
    }

    public static <T extends SuperVO> T[] changeCircularlyAccessibleVO(CircularlyAccessibleValueObject[] vos, Class<T> className) {
        if (ArrayUtils.isEmpty((Object[])vos)) {
            return null;
        }
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < vos.length; ++i) {
            String[] fileName;
            SuperVO vo = (SuperVO)BaseVOUtils.initClass(className);
            for (String file : fileName = CardVOAttrNameCaffeine.getCaffeine().get(vo)) {
                vo.setAttributeValue(file, vos[i].getAttributeValue(file));
            }
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.toArray(data);
    }

    public static <T extends SuperVO> T[] changeBaseVO(MappedBaseVO[] vos, Class<T> className) {
        if (ArrayUtils.isEmpty((Object[])vos)) {
            return null;
        }
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < vos.length; ++i) {
            SuperVO vo = (SuperVO)vos[i].convert(className);
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.toArray(data);
    }

    public static <T extends SuperVO> T[] changeBaseVOWithField(MappedBaseVO[] vos, Class<T> className, Map<String, String> fieldMap) {
        if (ArrayUtils.isEmpty((Object[])vos)) {
            return null;
        }
        ArrayList<SuperVO> data = new ArrayList<SuperVO>();
        for (int i = 0; i < vos.length; ++i) {
            SuperVO vo = (SuperVO)BaseVOUtils.initClass(className);
            String[] fileName = CardVOAttrNameCaffeine.getCaffeine().get(vo);
            for (String file : fileName) {
                vo.setAttributeValue(file, vos[i].getAttributeValue(file));
            }
            if (!fieldMap.isEmpty()) {
                for (String field : fieldMap.keySet()) {
                    String mapField = fieldMap.get(field);
                    Object oValue = vo.getAttributeValue(mapField);
                    if (null != oValue) continue;
                    vo.setAttributeValue(mapField, vos[i].getAttributeValue(field));
                }
            }
            data.add(vo);
        }
        return (SuperVO[])CollectionUtils.toArray(data);
    }

    public static void combinMutiUsedept(AggCardVO fromAggCardVO) {
        SuperVO[] hisVOs = BaseVOUtils.getBodyVOs((IExAggVO[])new AggCardVO[]{fromAggCardVO}, (String)CardTabConst.history);
        if (ArrayUtils.getLength((Object)hisVOs) > 1) {
            IAttributeMeta[] attMetas;
            ArrayList<String> splitFields = new ArrayList<String>();
            for (IAttributeMeta att : attMetas = hisVOs[0].getMetaData().getAttributes()) {
                if (att.getModelType() != 52 && !att.getName().equals("card_num")) continue;
                splitFields.add(att.getName());
            }
            SuperVO[] newVOs = UseDeptScaleUtils.combinDataByMutilDept((SuperVO[])hisVOs, (String[])((String[])CollectionUtils.toArray(splitFields)));
            fromAggCardVO.setTableVO(CardTabConst.history, (CircularlyAccessibleValueObject[])newVOs);
        }
    }

    public static String getCardVoucherType(AssetVO assetVO) {
        if (UFBoolean.TRUE.equals((Object)assetVO.getUsufructasset_flag())) {
            return "S0";
        }
        return "H0";
    }

    public static void fillAggCardVOByAssetEntiretyVO(AggCardVO toAggCardVO, AssetEntiretyVO fromAssetEntiretyVO) {
        toAggCardVO.setParentVO((CircularlyAccessibleValueObject)fromAssetEntiretyVO.getCardVO());
        String[] tabCodes = toAggCardVO.getTableCodes();
        for (int i = 0; i < tabCodes.length; ++i) {
            if (tabCodes[i].equals(CardTabConst.history)) {
                toAggCardVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])fromAssetEntiretyVO.getCardhistoryVOs());
                continue;
            }
            SuperVO[] old = fromAssetEntiretyVO.getTabVO(tabCodes[i]);
            SuperVO[] newdata = CardVOUtils.toTrueTab(old);
            toAggCardVO.setTableVO(tabCodes[i], (CircularlyAccessibleValueObject[])newdata);
        }
        toAggCardVO.setTableVO(CardTabConst.useDept, (CircularlyAccessibleValueObject[])CardVOUtils.toTrueTab(fromAssetEntiretyVO.getTabVO(CardTabConst.useDept)));
    }

    public static CardVO getCardVOFromHeadVO(AssetVO allvo) {
        CardVO vo = new CardVO();
        String[] fieldNames = vo.getAttributeNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            vo.setAttributeValue(fieldNames[i], allvo.getAttributeValue(fieldNames[i]));
        }
        vo.setStatus(allvo.getStatus());
        vo.setTs(allvo.getTs());
        return vo;
    }

    public static CardhistoryVO getCardhistoryVOFromHeadVO(AssetVO allvo) {
        CardhistoryVO vo = new CardhistoryVO();
        String[] fieldNames = vo.getAttributeNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("ts")) {
                vo.setAttributeValue("ts", allvo.getAttributeValue("ts_history"));
                continue;
            }
            vo.setAttributeValue(fieldNames[i], allvo.getAttributeValue(fieldNames[i]));
        }
        vo.setStatus(allvo.getStatus());
        Object pk_card = allvo.getAttributeValue("pk_card");
        if (pk_card != null) {
            vo.setPk_card(pk_card.toString());
        }
        return vo;
    }
}

