/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.Map;
import nc.bs.framework.common.RuntimeEnv;
import nc.bs.uif2.BusinessExceptionAdapter;
import nc.md.MDBaseQueryFacade;
import nc.md.data.access.NCObject;
import nc.md.model.IBean;
import nc.md.model.IBusinessEntity;
import nc.md.model.MetaDataException;
import nc.pub.fa.card.AssetClientBDObject;
import nc.vo.bd.meta.AggVOBDObject;
import nc.vo.bd.meta.CAVO2BDObject;
import nc.vo.bd.meta.IBDObject;
import nc.vo.bd.meta.IBDObjectAdapterFactory;
import nc.vo.bd.meta.NCObject2BDObjectAdapter;
import nc.vo.fa.asset.AggAssetVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.AssetVO;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;

public class AssetVOBDObjectFactory
implements IBDObjectAdapterFactory {
    public IBDObject createBDObject(Object obj) {
        IBDObject bdo = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return null;
        }
        if (obj instanceof IBDObject) {
            bdo = (IBDObject)obj;
        } else if (obj instanceof CircularlyAccessibleValueObject) {
            bdo = obj instanceof AssetVO && this.isRunningInClient() ? new AssetClientBDObject(obj) : new CAVO2BDObject((CircularlyAccessibleValueObject)obj);
        } else if (obj instanceof AggregatedValueObject) {
            bdo = obj instanceof AggAssetVO && this.isRunningInClient() ? new AssetClientBDObject(obj) : new AggVOBDObject((AggregatedValueObject)obj);
        } else if (obj instanceof AssetEntiretyVO) {
            bdo = this.isRunningInClient() ? new AssetClientBDObject(obj) : new CAVO2BDObject((CircularlyAccessibleValueObject)((AssetEntiretyVO)obj).getCardVO());
        } else {
            try {
                String className = obj.getClass().getName();
                IBean bean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(className);
                if (bean == null) {
                    return null;
                }
                Map name_path_map = ((IBusinessEntity)bean).getBizInterfaceMapInfo(IBDObject.class.getName());
                bdo = new NCObject2BDObjectAdapter(NCObject.newInstance((Object)obj), name_path_map);
            }
            catch (MetaDataException e) {
                throw new BusinessExceptionAdapter((BusinessException)((Object)e));
            }
        }
        return bdo;
    }

    private boolean isRunningInClient() {
        return RuntimeEnv.getInstance().isRunningInBrowser();
    }
}

