/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import nc.md.MDBaseQueryFacade;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.md.model.impl.BusinessEntity;
import nc.md.model.impl.Component;
import nc.md.model.type.impl.CollectionType;
import nc.pub.fa.card.CardTabConst;
import nc.vo.am.common.util.BaseVOUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.asset.DeptscaleViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;

public class AssetTabConstManager {
    public static String getTabCodeByClassName(String className) throws BusinessException {
        IBean tabBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(className);
        String name = tabBean.getName();
        String tabCode = CardTabConst.getTabCode(name);
        return tabCode;
    }

    private static SuperVO transToSuperVO(String className) {
        SuperVO vo = null;
        try {
            Class<?> classType = Class.forName(className);
            vo = (SuperVO)BaseVOUtils.initClass(classType);
        }
        catch (ClassNotFoundException e) {
            ExceptionUtils.asBusinessExceptionAdpator((Exception)e);
        }
        return vo;
    }

    public static SuperVO getPreTabViewClass(String tabCode) {
        SuperVO vo = null;
        try {
            IBean assetBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(AssetVO.class.getName());
            String trueTabCode = CardTabConst.getTabCode(tabCode);
            IAttribute tabArrri = assetBean.getAttributeByName(trueTabCode);
            CollectionType type = (CollectionType)tabArrri.getDataType();
            BusinessEntity be = (BusinessEntity)type.getElementType();
            String className = be.getFullClassName();
            vo = AssetTabConstManager.transToSuperVO(className);
        }
        catch (BusinessException e) {
            ExceptionUtils.asBusinessExceptionAdpator((Exception)((Object)e));
        }
        return vo;
    }

    public static SuperVO getAfterTabTrueClass(String tabCode) {
        SuperVO vo = null;
        try {
            IBean cardBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(CardVO.class.getName());
            String trueTabCode = CardTabConst.getTabCode(tabCode);
            IAttribute tabArrri = cardBean.getAttributeByName(trueTabCode);
            if (tabArrri != null) {
                CollectionType type = (CollectionType)tabArrri.getDataType();
                BusinessEntity be = (BusinessEntity)type.getElementType();
                String className = be.getFullClassName();
                vo = AssetTabConstManager.transToSuperVO(className);
            }
        }
        catch (BusinessException e) {
            ExceptionUtils.asBusinessExceptionAdpator((Exception)((Object)e));
        }
        return vo;
    }

    public static Class getViewTabVO(Class trueClass) {
        Class<?> type = null;
        try {
            String tabCode = null;
            if (trueClass.getName().equals(DeptScaleVO.class.getName())) {
                tabCode = CardTabConst.useDept;
            } else {
                if (AssetTabConstManager.isViewTabVO(trueClass)) {
                    return trueClass;
                }
                IBean tabBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(trueClass.getName());
                String servieceTabCode = tabBean.getName();
                tabCode = CardTabConst.getTabCode(servieceTabCode);
            }
            SuperVO vo = AssetTabConstManager.getPreTabViewClass(tabCode);
            type = vo.getClass();
        }
        catch (BusinessException e) {
            ExceptionUtils.asBusinessExceptionAdpator((Exception)((Object)e));
        }
        return type;
    }

    public static Class getTrueTabVO(Class viewClass) {
        Class<?> type = null;
        try {
            String tabCode = null;
            if (viewClass.getName().equals(DeptscaleViewVO.class.getName())) {
                return DeptScaleVO.class;
            }
            if (AssetTabConstManager.isTrueTabVO(viewClass)) {
                return viewClass;
            }
            IBean tabBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(viewClass.getName());
            String viewTabCode = tabBean.getName();
            tabCode = CardTabConst.getTabCode(viewTabCode);
            SuperVO vo = AssetTabConstManager.getAfterTabTrueClass(tabCode);
            type = vo.getClass();
        }
        catch (BusinessException e) {
            ExceptionUtils.asBusinessExceptionAdpator((Exception)((Object)e));
        }
        return type;
    }

    public static boolean isTrueTabVO(Class trueClass) throws BusinessException {
        BusinessEntity tabBean = (BusinessEntity)MDBaseQueryFacade.getInstance().getBeanByFullClassName(trueClass.getName());
        Component com = (Component)tabBean.getContainer();
        String mainClassName = com.getPrimaryBusinessEntity().getFullClassName();
        return mainClassName.endsWith(CardVO.class.getName());
    }

    public static boolean isViewTabVO(Class viewClass) throws BusinessException {
        IBean tabBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(viewClass.getName());
        String mainClassName = tabBean.getOwnerComponent().getPrimaryBusinessEntity().getFullClassName();
        return mainClassName.endsWith(AssetVO.class.getName());
    }
}

