/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.Map;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.pub.fa.deploy.DeployValueParamConst;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccbookManager;
import nc.vo.fa.asset.AssetVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;

public class AssetSourceBillUtil {
    public static AssetVO procDeployInVOByDeployParameter(AssetVO inAssetVO, AssetVO outAssetVO, Map<String, Map<String, String>> reduceAssetDataMap, Integer deployValueSelect) throws BusinessException {
        if (null == outAssetVO) {
            return inAssetVO;
        }
        inAssetVO = DeployValueParamConst.ORIGIN_VALUE.intValue() == deployValueSelect.intValue() ? AssetSourceBillUtil.procDeployInBodyByOrigValue(inAssetVO, outAssetVO, reduceAssetDataMap) : (DeployValueParamConst.NETVALUE.intValue() == deployValueSelect.intValue() ? AssetSourceBillUtil.procDeployInBodyByNetvalue(inAssetVO, outAssetVO, reduceAssetDataMap) : (DeployValueParamConst.NETRATING.intValue() == deployValueSelect.intValue() ? AssetSourceBillUtil.procDeployInBodyByNetrating(inAssetVO, outAssetVO, reduceAssetDataMap) : AssetSourceBillUtil.procDeployInBodyByHandin(inAssetVO, outAssetVO, reduceAssetDataMap)));
        AssetSourceBillUtil.resetAccountField(inAssetVO, outAssetVO);
        return inAssetVO;
    }

    private static AssetVO procDeployInBodyByOrigValue(AssetVO inAssetVO, AssetVO outAssetVO, Map<String, Map<String, String>> reduceAssetDataMap) {
        inAssetVO.setOriginvalue(outAssetVO.getLocaloriginvalue());
        inAssetVO.setLocaloriginvalue(inAssetVO.getOriginvalue());
        String pk_currency_accbook = AccbookManager.queryCurrTypeByAccbook((String)outAssetVO.getPk_accbook());
        inAssetVO.setPk_currency(pk_currency_accbook);
        inAssetVO.setAccudep(outAssetVO.getAccudep());
        inAssetVO.setPredevaluate(outAssetVO.getPredevaluate());
        inAssetVO.setNetvalue(UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()));
        inAssetVO.setNetrating(UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()), (UFDouble)outAssetVO.getPredevaluate()));
        inAssetVO.setSalvage(outAssetVO.getSalvage());
        inAssetVO.setBegin_date(outAssetVO.getBegin_date());
        inAssetVO.setDep_start_date(outAssetVO.getDep_start_date());
        inAssetVO.setDep_end_date(outAssetVO.getDep_end_date());
        inAssetVO.setNaturemonth(outAssetVO.getNaturemonth());
        inAssetVO.setServicemonth(outAssetVO.getServicemonth());
        inAssetVO.setUsedmonth(outAssetVO.getUsedmonth());
        Map<String, String> fieldMap = reduceAssetDataMap.get(outAssetVO.getPk_card());
        if (null != fieldMap && !fieldMap.isEmpty()) {
            String accudepObj;
            String usedmonth = fieldMap.get("usedmonth");
            if (null != usedmonth) {
                inAssetVO.setAttributeValue("usedmonth", usedmonth);
            }
            if (null != (accudepObj = fieldMap.get("accudep"))) {
                inAssetVO.setAttributeValue("accudep", accudepObj);
            }
        }
        return inAssetVO;
    }

    private static AssetVO procDeployInBodyByNetvalue(AssetVO inAssetVO, AssetVO outAssetVO, Map<String, Map<String, String>> reduceAssetDataMap) {
        String business_date_reduceObj;
        inAssetVO.setOriginvalue(outAssetVO.getLocaloriginvalue().sub(outAssetVO.getAccudep()));
        inAssetVO.setLocaloriginvalue(inAssetVO.getOriginvalue());
        String pk_currency_accbook = AccbookManager.queryCurrTypeByAccbook((String)outAssetVO.getPk_accbook());
        inAssetVO.setPk_currency(pk_currency_accbook);
        inAssetVO.setNetvalue(UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()));
        inAssetVO.setNetrating(UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()), (UFDouble)outAssetVO.getPredevaluate()));
        inAssetVO.setBegin_date(outAssetVO.getBegin_date().getDateAfter(1));
        Map<String, String> reduceMap = reduceAssetDataMap.get(outAssetVO.getPk_card());
        if (null != reduceMap && !reduceMap.isEmpty() && null != (business_date_reduceObj = reduceMap.get("business_date"))) {
            UFDate newBeginDate = UFDate.getDate((String)business_date_reduceObj);
            inAssetVO.setBegin_date(newBeginDate.getDateAfter(1));
        }
        inAssetVO.setDep_end_date(outAssetVO.getDep_end_date());
        inAssetVO.setNaturemonth(outAssetVO.getNaturemonth() - outAssetVO.getUsedmonth());
        inAssetVO.setUsedmonth(0);
        inAssetVO.setAccudep(UFDouble.ZERO_DBL);
        inAssetVO.setPredevaluate(outAssetVO.getPredevaluate());
        inAssetVO.setRevalued_amount(UFDouble.ZERO_DBL);
        inAssetVO.setTax_cost(UFDouble.ZERO_DBL);
        inAssetVO.setOther_cost(UFDouble.ZERO_DBL);
        inAssetVO.setDismant_cost(UFDouble.ZERO_DBL);
        inAssetVO.setInstall_fee(UFDouble.ZERO_DBL);
        return inAssetVO;
    }

    private static AssetVO procDeployInBodyByNetrating(AssetVO inAssetVO, AssetVO outAssetVO, Map<String, Map<String, String>> reduceAssetDataMap) {
        String business_date_reduceObj;
        inAssetVO.setOriginvalue(outAssetVO.getLocaloriginvalue().sub(outAssetVO.getAccudep()).sub(outAssetVO.getPredevaluate()));
        inAssetVO.setLocaloriginvalue(inAssetVO.getOriginvalue());
        String pk_currency_accbook = AccbookManager.queryCurrTypeByAccbook((String)outAssetVO.getPk_accbook());
        inAssetVO.setPk_currency(pk_currency_accbook);
        inAssetVO.setNetvalue(UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()));
        inAssetVO.setNetrating(UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()), (UFDouble)outAssetVO.getPredevaluate()));
        inAssetVO.setBegin_date(outAssetVO.getBegin_date().getDateAfter(1));
        Map<String, String> reduceMap = reduceAssetDataMap.get(outAssetVO.getPk_card());
        if (null != reduceMap && !reduceMap.isEmpty() && null != (business_date_reduceObj = reduceMap.get("business_date"))) {
            UFDate newBeginDate = UFDate.getDate((String)business_date_reduceObj);
            inAssetVO.setBegin_date(newBeginDate.getDateAfter(1));
        }
        inAssetVO.setDep_end_date(outAssetVO.getDep_end_date());
        inAssetVO.setNaturemonth(outAssetVO.getNaturemonth() - outAssetVO.getUsedmonth());
        inAssetVO.setUsedmonth(0);
        inAssetVO.setAccudep(UFDouble.ZERO_DBL);
        inAssetVO.setPredevaluate(UFDouble.ZERO_DBL);
        inAssetVO.setRevalued_amount(UFDouble.ZERO_DBL);
        inAssetVO.setTax_cost(UFDouble.ZERO_DBL);
        inAssetVO.setOther_cost(UFDouble.ZERO_DBL);
        inAssetVO.setDismant_cost(UFDouble.ZERO_DBL);
        inAssetVO.setInstall_fee(UFDouble.ZERO_DBL);
        return inAssetVO;
    }

    private static AssetVO procDeployInBodyByHandin(AssetVO inAssetVO, AssetVO outAssetVO, Map<String, Map<String, String>> reduceAssetDataMap) {
        String business_date_reduceObj;
        inAssetVO.setOriginvalue(null);
        inAssetVO.setLocaloriginvalue(null);
        String pk_currency_accbook = AccbookManager.queryCurrTypeByAccbook((String)outAssetVO.getPk_accbook());
        inAssetVO.setPk_currency(pk_currency_accbook);
        inAssetVO.setBegin_date(outAssetVO.getBegin_date().getDateAfter(1));
        Map<String, String> reduceMap = reduceAssetDataMap.get(outAssetVO.getPk_card());
        if (null != reduceMap && !reduceMap.isEmpty() && null != (business_date_reduceObj = reduceMap.get("business_date"))) {
            UFDate newBeginDate = UFDate.getDate((String)business_date_reduceObj);
            inAssetVO.setBegin_date(newBeginDate.getDateAfter(1));
        }
        inAssetVO.setNetrating(UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)outAssetVO.getLocaloriginvalue(), (UFDouble)outAssetVO.getAccudep()), (UFDouble)outAssetVO.getPredevaluate()));
        inAssetVO.setDep_end_date(outAssetVO.getDep_end_date());
        inAssetVO.setNaturemonth(outAssetVO.getNaturemonth() - outAssetVO.getUsedmonth());
        inAssetVO.setUsedmonth(0);
        inAssetVO.setAccudep(UFDouble.ZERO_DBL);
        inAssetVO.setPredevaluate(UFDouble.ZERO_DBL);
        inAssetVO.setRevalued_amount(UFDouble.ZERO_DBL);
        inAssetVO.setTax_cost(UFDouble.ZERO_DBL);
        inAssetVO.setOther_cost(UFDouble.ZERO_DBL);
        inAssetVO.setDismant_cost(UFDouble.ZERO_DBL);
        inAssetVO.setInstall_fee(UFDouble.ZERO_DBL);
        return inAssetVO;
    }

    private static void resetAccountField(AssetVO inAssetVO, AssetVO outAssetVO) throws BusinessException {
        inAssetVO.setDeprate(UFDouble.ZERO_DBL);
        inAssetVO.setDepamount(UFDouble.ZERO_DBL);
        inAssetVO.setDepamount_global(UFDouble.ZERO_DBL);
        inAssetVO.setDepamount_group(UFDouble.ZERO_DBL);
        inAssetVO.setDepunit(UFDouble.ZERO_DBL);
        inAssetVO.setDepunit_global(UFDouble.ZERO_DBL);
        inAssetVO.setDepunit_group(UFDouble.ZERO_DBL);
        inAssetVO.setCurryeardep(UFDouble.ZERO_DBL);
        inAssetVO.setCurryeardep_global(UFDouble.ZERO_DBL);
        inAssetVO.setCurryeardep_group(UFDouble.ZERO_DBL);
        if (null != inAssetVO.getLocaloriginvalue() && null != inAssetVO.getSalvagerate()) {
            UFDouble newSalvage = FAScaleUtils.setScaleByAccbook((UFDouble)inAssetVO.getLocaloriginvalue().multiply(inAssetVO.getSalvagerate()).div(100.0), (String)outAssetVO.getPk_accbook());
            inAssetVO.setSalvage(newSalvage);
        }
    }
}

