/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nc.bs.logging.Logger;
import nc.md.IMDQueryFacade;
import nc.md.MDBaseQueryFacade;
import nc.md.common.AssociationKind;
import nc.md.model.IAssociation;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.md.model.IColumn;
import nc.mddb.model.impl.MultiColumn;
import nc.pub.fa.common.util.MDUtils;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;

public class AssetQuerySqlTool {
    public static boolean isAssociateCardhistory(String whereSql) throws BusinessException {
        IMDQueryFacade mdQueryFacade = MDBaseQueryFacade.getInstance();
        IBean cardHistBean = mdQueryFacade.getBeanByFullClassName(CardhistoryVO.class.getName());
        Set cardHistBeanAttrNames = MDUtils.getAttributeNames((IBean)cardHistBean);
        boolean needCardhistory = false;
        for (String name : cardHistBeanAttrNames) {
            if (name.equals("pk_org") || name.equals("pk_group") || !whereSql.contains(name)) continue;
            needCardhistory = true;
            break;
        }
        return needCardhistory;
    }

    public static boolean isAssociateCardsub(String whereSql) throws BusinessException {
        return StringUtils.isNotEmpty((String)whereSql) && whereSql.contains("def");
    }

    public static boolean haveAccbookCondition(String whereSql) throws BusinessException {
        IMDQueryFacade mdQueryFacade = MDBaseQueryFacade.getInstance();
        IBean cardHistBean = mdQueryFacade.getBeanByFullClassName(CardhistoryVO.class.getName());
        Set cardHistBeanAttrNames = MDUtils.getAttributeNames((IBean)cardHistBean);
        boolean accbookCondition = false;
        for (String name : cardHistBeanAttrNames) {
            if (!whereSql.contains(name) || !name.equals("pk_accbook")) continue;
            accbookCondition = true;
            break;
        }
        return accbookCondition;
    }

    private static boolean hasSmallString(String[] sameNames, String s) {
        if (ArrayUtils.isNotEmpty((Object[])sameNames)) {
            for (int i = 0; i < sameNames.length; ++i) {
                if (sameNames[i] == null || sameNames[i].indexOf(s) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String adjustWhereSQL(String whereSql) throws BusinessException {
        if (StringUtils.isNotEmpty((String)whereSql)) {
            Set cardColumn = Arrays.stream(MDUtils.getColumns(CardVO.class)).collect(Collectors.toSet());
            Set cardHisColumn = Arrays.stream(MDUtils.getColumns(CardhistoryVO.class)).collect(Collectors.toSet());
            String[] splitResult = StringUtils.split((String)whereSql, (String[])new String[]{",", " ", "(", ")"});
            ArrayList<String> hasReplaced = new ArrayList<String>();
            hasReplaced.add("pk_group");
            hasReplaced.add("pk_category");
            for (String s : splitResult) {
                if (hasReplaced.contains(s)) continue;
                if (cardHisColumn.contains(s)) {
                    whereSql = whereSql.replace(s, "fa_cardhistory." + s);
                } else if (cardColumn.contains(s)) {
                    whereSql = whereSql.replace(s, "fa_card." + s);
                }
                hasReplaced.add(s);
            }
            whereSql = whereSql.replace(".fa_cardhistory.", ".");
            IBean cardBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(CardVO.class.getName());
            List cardAttris = cardBean.getAttributes();
            for (IAttribute attr : cardAttris) {
                if (attr.getDataType().getTypeType() != 203) continue;
                String name = attr.getColumn().getName();
                whereSql = whereSql.replaceAll("(?<=[^\\.])" + name, "fa_card." + name);
                whereSql = whereSql.replace("fa_card.fa_card." + name, "fa_card." + name);
            }
            IBean cardHisBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(CardhistoryVO.class.getName());
            List cardHisAttris = cardHisBean.getAttributes();
            for (IAttribute attr : cardHisAttris) {
                if (attr.getDataType().getTypeType() != 203) continue;
                String name = attr.getColumn().getName();
                whereSql = whereSql.replaceAll("(?<=[^\\.])" + name, "fa_cardhistory." + name);
                whereSql = whereSql.replace("fa_cardhistory.fa_cardhistory." + name, "fa_cardhistory." + name);
            }
        }
        return whereSql;
    }

    public static String adjustSelectFiled(String ... fields) throws BusinessException {
        int lenth;
        if (fields == null || fields.length == 0) {
            return null;
        }
        IMDQueryFacade mdQueryFacade = MDBaseQueryFacade.getInstance();
        IBean cardBean = mdQueryFacade.getBeanByFullClassName(CardVO.class.getName());
        IBean cardHistBean = mdQueryFacade.getBeanByFullClassName(CardhistoryVO.class.getName());
        Set cardBeanAttrNames = MDUtils.getAttributeNames((IBean)cardBean);
        Set cardHistBeanAttrNames = MDUtils.getAttributeNames((IBean)cardHistBean);
        StringBuffer fileSql = new StringBuffer();
        int tag = lenth = fields.length;
        for (String f : fields) {
            if (tag != lenth--) {
                fileSql.append(",");
            }
            if (cardBeanAttrNames.contains(f)) {
                fileSql.append(" fa_card." + f);
                continue;
            }
            if (!cardHistBeanAttrNames.contains(f) || f.equals("pk_org") || f.equals("pk_group") || f.equals("pk_card")) continue;
            fileSql.append(" fa_cardhistory." + f);
        }
        return fileSql.toString();
    }

    public static String buildQuerySql(String whereSql, String[] fields, String[] orderByFields) throws BusinessException {
        IBean cardBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(CardVO.class.getName());
        IBean hisBean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(CardhistoryVO.class.getName());
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (ArrayUtils.isEmpty((Object[])fields)) {
            IAssociation value;
            int i;
            List cardAttri = cardBean.getAttributesOfModel();
            String[] cardhistoryAttri = hisBean.getAttributesOfModel();
            for (i = 0; i < cardAttri.size(); ++i) {
                value = ((IAttribute)cardAttri.get(i)).getAssociation();
                if (value != null && value.getType() == AssociationKind.Composite || null == cardAttri.get(i) || null == ((IAttribute)cardAttri.get(i)).getColumn()) continue;
                IColumn colBase = ((IAttribute)cardAttri.get(i)).getColumn();
                if (colBase instanceof MultiColumn) {
                    MultiColumn mc = (MultiColumn)colBase;
                    List cols = mc.getColumns();
                    for (IColumn col : cols) {
                        String name = col.getName();
                        if (name.equals("pk_org") || name.equals("pk_group") || name.equals("pk_card") || name.equals("pk_org_v")) {
                            sql.append("fa_card." + name + ",");
                            continue;
                        }
                        sql.append(name + ",");
                    }
                    continue;
                }
                String name = colBase.getName();
                if (name.equals("pk_org") || name.equals("pk_group") || name.equals("pk_card") || name.equals("pk_org_v")) {
                    sql.append("fa_card." + name + ",");
                    continue;
                }
                sql.append(name + ",");
            }
            for (i = 0; i < cardhistoryAttri.size(); ++i) {
                String name;
                value = ((IAttribute)cardhistoryAttri.get(i)).getAssociation();
                if (value != null && value.getType() == AssociationKind.Composite || (name = ((IAttribute)cardhistoryAttri.get(i)).getColumn().getName()).equals("pk_group") || name.equals("pk_card") || name.equals("pk_org") || name.equals("pk_org_v")) continue;
                sql.append(name + ",");
            }
            sql.append("fa_card.ts as ts,");
            sql.append("fa_cardhistory.ts as ts_history");
        } else {
            for (String field : fields) {
                if (field.equals("pk_org") || field.equals("pk_group") || field.equals("pk_card") || field.equals("pk_org_v")) {
                    sql.append("fa_card." + (String)field + ",");
                    continue;
                }
                IAttribute cattr = cardBean.getAttributeByName(field);
                IAttribute hisattr = hisBean.getAttributeByName(field);
                if (cattr == null && hisattr == null) {
                    String errorMsg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0485", null, new String[]{field});
                    Logger.error((Object)errorMsg);
                    ExceptionUtils.asBusinessRuntimeException((String)errorMsg);
                }
                sql.append((String)field + ",");
            }
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(" from fa_card inner join fa_cardhistory on fa_card.pk_card = fa_cardhistory.pk_card inner join fa_cardsub on fa_card.pk_card = fa_cardsub.pk_card");
        sql.append(" where ");
        if (whereSql != null) {
            sql.append(whereSql);
            sql.append(" and fa_card.dr = 0");
            sql.append(" and fa_cardhistory.dr = 0");
            sql.append(" and fa_cardsub.dr = 0");
        } else {
            sql.append(" fa_card.dr = 0");
            sql.append(" and fa_cardhistory.dr = 0");
            sql.append(" and fa_cardsub.dr = 0");
        }
        if (null != orderByFields && orderByFields.length > 0) {
            StringBuffer orderBySql = new StringBuffer();
            for (String orderByField : orderByFields) {
                if (null == orderByField || "".equals(orderByField) || "".equals(orderByField.trim())) continue;
                orderBySql.append(orderByField).append(", ");
            }
            if (orderBySql.length() > 0) {
                int lastIndex = orderBySql.lastIndexOf(", ");
                if (lastIndex > -1) {
                    String subString = orderBySql.substring(0, lastIndex);
                    if (null != subString && !"".equals(subString) && !"".equals(subString.trim())) {
                        sql.append(" order by ");
                        sql.append(subString);
                    }
                } else {
                    sql.append(" order by ");
                    sql.append(orderBySql);
                }
            }
        }
        return sql.toString();
    }
}

