/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nc.bs.logging.Logger;
import nc.jdbc.framework.mapping.IMappingMeta;
import nc.jdbc.framework.mapping.MappingMeta;
import nc.jdbc.framework.processor.BaseProcessor;
import nc.jdbc.framework.processor.ProcessorUtils;
import nc.md.MDBaseQueryFacade;
import nc.md.model.IAttribute;
import nc.md.model.IBean;
import nc.pub.fa.card.MDPersistUtil;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.fa.asset.AssetVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;

public class AssetProcessor
extends BaseProcessor {
    protected IBean bean = null;
    protected String[] columns = null;

    public AssetProcessor() {
        this.init();
    }

    public AssetProcessor(String[] columns) {
        this.columns = columns;
        this.init();
    }

    private void init() {
        try {
            this.bean = MDBaseQueryFacade.getInstance().getBeanByFullClassName(AssetVO.class.getName());
            this.checkColums();
        }
        catch (BusinessException e) {
            Logger.error((Object)((Object)e));
            ExceptionUtils.asBusinessRuntimeException((Throwable)e);
        }
    }

    public Object processResultSet(ResultSet rs) throws SQLException {
        MappingMeta meta = MDPersistUtil.getMappingDataOfBean(this.bean, null);
        List assetVOs = ProcessorUtils.toBeanList((ResultSet)rs, AssetVO.class, (IMappingMeta)meta, (String[])this.columns);
        if (assetVOs != null && assetVOs.size() > 0) {
            return assetVOs.toArray(new AssetVO[0]);
        }
        return null;
    }

    protected void checkColums() throws BusinessException {
        if (this.columns != null && this.columns.length > 0) {
            for (int i = 0; i < this.columns.length; ++i) {
                IAttribute attr = this.bean.getAttributeByName(this.columns[i]);
                if (attr != null) continue;
                ExceptionUtils.asBusinessException((String)(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0484") + this.columns[i]));
            }
        }
    }
}

