/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.BaseVOUtils;
import nc.vo.am.excel.VODataItem;
import nc.vo.am.transform.TransferTempVO;
import nc.vo.am.transform.message.IMessageCollector;
import nc.vo.fa.asset.AggAssetVO;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.uif2.LoginContext;

public class AssetExcelImportContext {
    private String pk_org;
    private String pk_accbook_selected;
    private String pk_main_accboook;
    private LoginContext loginContext;
    private List<ExcelSheetData> importDatas;
    private AggAssetVO[] aggAssetVOs;
    private List<IMessageCollector> gatherMsgCollectors;
    private Map<String, Integer> subGroupFlag2PseudoColumn = new HashMap<String, Integer>();
    private Map<String, Object> extraParamMap;
    private UFBoolean isUsufructAsset;

    public String getPk_org() {
        return this.pk_org;
    }

    public void setPk_org(String pk_org) {
        this.pk_org = pk_org;
    }

    public String getPk_accbook_selected() {
        return this.pk_accbook_selected;
    }

    public void setPk_accbook_selected(String pk_accbook_selected) {
        this.pk_accbook_selected = pk_accbook_selected;
    }

    public String getPk_main_accboook() {
        return this.pk_main_accboook;
    }

    public void setPk_main_accboook(String pk_main_accboook) {
        this.pk_main_accboook = pk_main_accboook;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Map<String, Object> getExtraParamMap() {
        return this.extraParamMap;
    }

    public void setExtraParamMap(Map<String, Object> extraParamMap) {
        this.extraParamMap = extraParamMap;
    }

    public UFBoolean getIsUsufructAsset() {
        return this.isUsufructAsset;
    }

    public void setIsUsufructAsset(UFBoolean isUsufructAsset) {
        this.isUsufructAsset = isUsufructAsset;
    }

    public void addImportData(ExcelSheetData sheetData) {
        if (this.importDatas == null) {
            this.importDatas = new ArrayList<ExcelSheetData>();
        }
        this.importDatas.add(sheetData);
    }

    public List<ExcelSheetData> getImportDatas() {
        return this.importDatas;
    }

    public void setImportDatas(List<ExcelSheetData> importDatas) {
        this.importDatas = importDatas;
    }

    public List<IMessageCollector> getGatherMsgCollectors() {
        return this.gatherMsgCollectors;
    }

    public void addMsgCollector(IMessageCollector msgCollector) {
        if (this.gatherMsgCollectors == null) {
            this.gatherMsgCollectors = new ArrayList<IMessageCollector>();
        }
        this.gatherMsgCollectors.add(msgCollector);
    }

    public Map<Integer, String> getRowErrorMap() {
        if (this.gatherMsgCollectors == null || this.gatherMsgCollectors.size() == 0) {
            return new HashMap<Integer, String>();
        }
        HashMap<Integer, String> rowErrorMap = new HashMap<Integer, String>();
        for (IMessageCollector collector : this.gatherMsgCollectors) {
            Map msgMap = collector.constructRowMessage();
            if (msgMap == null) continue;
            for (Map.Entry entry : msgMap.entrySet()) {
                String error = (String)rowErrorMap.get(entry.getKey());
                if (error != null) {
                    rowErrorMap.put((Integer)entry.getKey(), error + ";\n" + (String)entry.getValue());
                    continue;
                }
                rowErrorMap.put((Integer)entry.getKey(), (String)entry.getValue());
            }
        }
        return rowErrorMap;
    }

    public AggAssetVO[] getAggAssetVOs() {
        return this.aggAssetVOs;
    }

    public void setAggAssetVOs(AggAssetVO[] aggAssetVOs) {
        this.aggAssetVOs = aggAssetVOs;
    }

    public Map<String, Integer> getSubGroupFlag2PseudoColumn() {
        return this.subGroupFlag2PseudoColumn;
    }

    public void setSubGroupFlag2PseudoColumn(Map<String, Integer> subGroupFlag2PseudoColumn) {
        this.subGroupFlag2PseudoColumn = subGroupFlag2PseudoColumn;
    }

    public TransferTempVO[] filterExcelVOs(ExcelSheetData excelSheet) {
        if (this.gatherMsgCollectors == null || this.gatherMsgCollectors.size() == 0 || ArrayUtils.isEmpty((Object[])excelSheet.getExcelVOs())) {
            return excelSheet.getExcelVOs();
        }
        HashSet<Integer> errorSet = new HashSet<Integer>();
        for (IMessageCollector collector : this.gatherMsgCollectors) {
            Map msgMap = collector.constructRowMessage();
            if (msgMap == null) continue;
            for (Map.Entry entry : msgMap.entrySet()) {
                errorSet.add((Integer)entry.getKey());
            }
        }
        ArrayList<TransferTempVO> voFiltered = new ArrayList<TransferTempVO>();
        if (excelSheet.isHead()) {
            for (TransferTempVO excel : excelSheet.getExcelVOs()) {
                if (errorSet.contains(BaseVOUtils.getPseudoColumnValue((CircularlyAccessibleValueObject)excel))) continue;
                voFiltered.add(excel);
            }
        } else {
            for (TransferTempVO excel : excelSheet.getExcelVOs()) {
                String subgroupFlag = (String)excel.getAttributeValue("IMPORT_SUBGROUP_FLAG");
                if (errorSet.contains(this.subGroupFlag2PseudoColumn.get(subgroupFlag))) continue;
                voFiltered.add(excel);
            }
        }
        return voFiltered.toArray(new TransferTempVO[0]);
    }

    public class ExcelSheetData {
        private String areaCode;
        private String areaName;
        private String metaId;
        private String voClass;
        private TransferTempVO[] excelVOs;
        private VODataItem[] excelColItems;
        private String[] importKeys;
        private String[] importNames;
        private SuperVO[] metaVOs;
        private IMessageCollector subMsgCollector;

        public TransferTempVO[] getExcelVOs() {
            return this.excelVOs;
        }

        public void setExcelVOs(TransferTempVO[] excelVOs) {
            this.excelVOs = excelVOs;
        }

        public VODataItem[] getExcelColItems() {
            return this.excelColItems;
        }

        public void setExcelColItems(VODataItem[] excelColItems) {
            this.excelColItems = excelColItems;
            ArrayList<String> keyList = new ArrayList<String>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (VODataItem dataItem : excelColItems) {
                keyList.add(dataItem.getCode());
                nameList.add(dataItem.getName());
            }
            this.importKeys = keyList.toArray(new String[0]);
            this.importNames = nameList.toArray(new String[0]);
        }

        public String[] getImportKeys() {
            return this.importKeys;
        }

        public void setImportKeys(String[] importKeys) {
            this.importKeys = importKeys;
        }

        public String[] getImportNames() {
            return this.importNames;
        }

        public void setImportNames(String[] importNames) {
            this.importNames = importNames;
        }

        public String getMetaId() {
            return this.metaId;
        }

        public void setMetaId(String metaId) {
            this.metaId = metaId;
        }

        public String getVoClass() {
            return this.voClass;
        }

        public void setVoClass(String voClass) {
            this.voClass = voClass;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getAreaName() {
            return this.areaName;
        }

        public void setAreaName(String areaName) {
            this.areaName = areaName;
        }

        public SuperVO[] getMetaVOs() {
            return this.metaVOs;
        }

        public void setMetaVOs(SuperVO[] metaVOs) {
            this.metaVOs = metaVOs;
        }

        public IMessageCollector getSubMsgCollector() {
            return this.subMsgCollector;
        }

        public void setSubMsgCollector(IMessageCollector subMsgCollector) {
            this.subMsgCollector = subMsgCollector;
        }

        public boolean isHead() {
            return this.voClass != null && this.voClass.equals("nc.vo.fa.asset.AssetVO");
        }
    }
}

