/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.Calendar;
import java.util.Date;
import nc.bd.accperiod.AccperiodmonthAccessor;
import nc.bs.logging.Logger;
import nc.pubitf.accperiod.AccountCalendar;
import nc.pubitf.uapbd.CurrencyRateUtilHelper;
import nc.vo.am.common.BizContext;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.rent.UFDateUtils;
import nc.vo.bd.period2.AccperiodmonthVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;

public class AssetDateCalUtils {
    private static AssetDateCalUtils instance = new AssetDateCalUtils();
    public static final int DAY = 2;
    public static final int MONTH = 1;
    public static final int YEAR = 0;

    public static AssetDateCalUtils getInstance() {
        return instance;
    }

    public static UFDate calDvalidate(UFDate vdate, Integer qualitydaynum, Integer qualityunit) {
        try {
            if (vdate == null || qualitydaynum == null || qualityunit == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(vdate.toDate());
            if (2 == qualityunit) {
                cal.add(5, qualitydaynum);
            } else if (1 == qualityunit) {
                cal.add(2, qualitydaynum);
            } else if (0 == qualityunit) {
                cal.add(1, qualitydaynum);
            }
            return UFDate.getDate((Date)cal.getTime());
        }
        catch (Exception ex) {
            Logger.error((Object)("\u65e5\u671f\u8ba1\u7b97\u9519\u8bef\uff1a" + ex.getMessage()));
            return vdate;
        }
    }

    public static UFDate getDepEndDate(UFDate depStartDate, int naturemonth) {
        Object newDepEndDate = "";
        int startYear = depStartDate.getYear();
        int startMonth = depStartDate.getMonth();
        int startDay = depStartDate.getDay();
        int serviceZ = naturemonth / 12;
        int serviceY = naturemonth % 12;
        int year_other = 0;
        int month_other = 0;
        int totalMonth = startMonth + serviceY;
        if (totalMonth > 12) {
            year_other = totalMonth / 12;
            month_other = totalMonth % 12;
        } else {
            month_other = totalMonth;
        }
        if (depStartDate.asLocalBegin().toString().endsWith("-01 00:00:00")) {
            if (--month_other == 0) {
                --year_other;
                month_other = 12;
            }
            int retYear = startYear + serviceZ + year_other;
            Calendar c = Calendar.getInstance();
            c.set(retYear, month_other - 1, 1);
            int monthEndDay = c.getActualMaximum(5);
            newDepEndDate = retYear + "-" + month_other + "-" + monthEndDay;
        } else {
            int retYear = startYear + serviceZ + year_other;
            Calendar c = Calendar.getInstance();
            c.set(retYear, month_other - 1, 1);
            int monthEndDay = c.getActualMaximum(5);
            startDay = startDay > monthEndDay ? monthEndDay : --startDay;
            newDepEndDate = retYear + "-" + month_other + "-" + startDay;
        }
        return UFDate.getDate((String)newDepEndDate).asEnd();
    }

    public static String getServiceMonth(String pk_accbook, Integer natureMonth, UFDate businessDate) throws BusinessException {
        PeriodManager periodManager = PeriodManager.getInstance();
        int allPeriod = periodManager.queryPeriodNum(pk_accbook, String.valueOf(businessDate.getYear()));
        double calServiceMonth = Math.ceil((double)(natureMonth / 12 * allPeriod) + (double)(natureMonth % 12 * allPeriod) / 12.0);
        int calServiceMonthInt = (int)calServiceMonth;
        String serviceMonth = String.valueOf(calServiceMonthInt);
        return serviceMonth;
    }

    public static UFDate calTempDepStartDate(String pk_accbook, UFDate begindate, UFBoolean nextPeriod) throws BusinessException {
        UFDate dep_start_date = null;
        UFDate busiDate = BizContext.getInstance().getBizDate();
        int firstPeriodYear = busiDate.getYear();
        AccperiodVO tempAccperiodVO = null;
        UFDate newTemDate = null;
        try {
            AccperiodVO firstPeriod = PeriodManager.getInstance().getFirstPeriod(pk_accbook);
            firstPeriodYear = firstPeriod.getStartdate().getYear();
            newTemDate = (begindate.getMonth() + "-" + begindate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)firstPeriodYear) ? UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay())) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-28"))) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay()));
            tempAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, newTemDate);
            if (nextPeriod.booleanValue()) {
                tempAccperiodVO = PeriodManager.getInstance().getNextPeriod(pk_accbook, tempAccperiodVO);
            }
        }
        catch (BusinessException e) {
            newTemDate = begindate;
            int time = 0;
            int startYear = begindate.getYear();
            while (true) {
                if (time > 100) {
                    String error = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0648", null, new String[]{"" + (firstPeriodYear + 1)});
                    throw new BusinessException(error);
                }
                UFDate criTemDate = !UFDate.isLeapYear((int)startYear) && (begindate.getMonth() + "-" + begindate.getDay()).equals("2-29") ? UFDate.getDate((String)(startYear + "-" + begindate.getMonth() + "-" + (begindate.getDay() - 1))) : UFDate.getDate((String)(startYear + "-" + begindate.getMonth() + "-" + begindate.getDay()));
                try {
                    AccperiodVO critempAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, criTemDate);
                    if (nextPeriod.booleanValue()) {
                        try {
                            critempAccperiodVO = PeriodManager.getInstance().getNextPeriod(pk_accbook, critempAccperiodVO);
                        }
                        catch (BusinessException e3) {
                            critempAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, criTemDate);
                            UFDate criDepStartDate = critempAccperiodVO.getEnddate();
                            AccperiodVO lastPeriod = PeriodManager.getInstance().getLastPeriod(pk_accbook, critempAccperiodVO.getAccyear());
                            UFDate calSDate = UFDate.getDate((String)(critempAccperiodVO.getAccyear() + "-" + begindate.getMonth() + "-" + begindate.getDay()));
                            boolean nextYear = !(!calSDate.afterDate(lastPeriod.getStartdate()) && !calSDate.isSameDate(lastPeriod.getStartdate()) || !calSDate.beforeDate(lastPeriod.getEnddate()) && !calSDate.isSameDate(lastPeriod.getEnddate()));
                            criDepStartDate = UFDateUtils.getAfterDayBeginDate((UFDate)criDepStartDate);
                            UFDate newTempDepStartDate = null;
                            newTempDepStartDate = nextYear ? ((criDepStartDate.getMonth() + "-" + criDepStartDate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)(begindate.getYear() + 1)) ? UFDate.getDate((String)(begindate.getYear() + 1 + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay())) : UFDate.getDate((String)(begindate.getYear() + 1 + "-" + criDepStartDate.getMonth() + "-28"))) : UFDate.getDate((String)(begindate.getYear() + 1 + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay()))) : ((criDepStartDate.getMonth() + "-" + criDepStartDate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)begindate.getYear()) ? UFDate.getDate((String)(begindate.getYear() + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay())) : UFDate.getDate((String)(begindate.getYear() + "-" + criDepStartDate.getMonth() + "-28"))) : UFDate.getDate((String)(begindate.getYear() + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay())));
                            return newTempDepStartDate;
                        }
                    }
                    UFDate criDepStartDate = critempAccperiodVO.getStartdate();
                    UFDate newTempDepStartDate = null;
                    newTempDepStartDate = (criDepStartDate.getMonth() + "-" + criDepStartDate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)(criDepStartDate.getYear() - time)) ? UFDate.getDate((String)(criDepStartDate.getYear() - time + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay())) : UFDate.getDate((String)(criDepStartDate.getYear() - time + "-" + criDepStartDate.getMonth() + "-28"))) : UFDate.getDate((String)(criDepStartDate.getYear() - time + "-" + criDepStartDate.getMonth() + "-" + criDepStartDate.getDay()));
                    ++time;
                    return newTempDepStartDate;
                }
                catch (BusinessException e1) {
                    ++time;
                    ++startYear;
                    continue;
                }
                break;
            }
        }
        if (null == tempAccperiodVO) {
            String error = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0639", null, new String[]{newTemDate == null ? "" : newTemDate.toStdString()});
            throw new BusinessException(error);
        }
        dep_start_date = tempAccperiodVO.getStartdate();
        int cutYear = dep_start_date.getYear() - firstPeriodYear;
        dep_start_date = UFDate.getDate((String)(begindate.getYear() + cutYear + "-" + dep_start_date.getMonth() + "-" + dep_start_date.getDay()));
        return dep_start_date;
    }

    public static AccperiodVO getTempPeriod(String pk_accbook, UFDate begindate) throws BusinessException {
        UFDate busiDate = BizContext.getInstance().getBizDate();
        int firstPeriodYear = busiDate.getYear();
        AccperiodVO tempAccperiodVO = null;
        try {
            AccperiodVO firstPeriod = PeriodManager.getInstance().getFirstPeriod(pk_accbook);
            firstPeriodYear = firstPeriod.getStartdate().getYear();
            UFDate newTemDate = null;
            newTemDate = (begindate.getMonth() + "-" + begindate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)firstPeriodYear) ? UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay())) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-28"))) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay()));
            tempAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, newTemDate);
        }
        catch (BusinessException e) {
            tempAccperiodVO = AssetDateCalUtils.getNextBusiYearTempPeriod(pk_accbook, begindate);
            return tempAccperiodVO;
        }
        UFDate newStartDate = tempAccperiodVO.getStartdate();
        UFDate newEndDate = tempAccperiodVO.getEnddate();
        int cutYear = newStartDate.getYear() - firstPeriodYear;
        newStartDate = UFDate.getDate((String)(begindate.getYear() + cutYear + "-" + newStartDate.getMonth() + "-" + newStartDate.getDay()));
        int endDateDay = newEndDate.getDay();
        if (29 == endDateDay && !UFDate.isLeapYear((int)begindate.getYear())) {
            --endDateDay;
        }
        newEndDate = UFDate.getDate((String)(begindate.getYear() + cutYear + "-" + newEndDate.getMonth() + "-" + endDateDay));
        tempAccperiodVO.setAccyear(String.valueOf(begindate.getYear() + cutYear));
        tempAccperiodVO.setStartdate(newStartDate);
        tempAccperiodVO.setEnddate(newEndDate);
        return tempAccperiodVO;
    }

    public static AccperiodVO getNextBusiYearTempPeriod(String pk_accbook, UFDate begindate) throws BusinessException {
        UFDate busiDate = BizContext.getInstance().getBizDate();
        int firstPeriodYear = busiDate.getYear() + 1;
        AccperiodVO tempAccperiodVO = null;
        UFDate newTemDate = null;
        try {
            newTemDate = (begindate.getMonth() + "-" + begindate.getDay()).equals("2-29") ? (UFDate.isLeapYear((int)firstPeriodYear) ? UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay())) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-28"))) : UFDate.getDate((String)(firstPeriodYear + "-" + begindate.getMonth() + "-" + begindate.getDay()));
            tempAccperiodVO = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, newTemDate);
        }
        catch (BusinessException e) {
            Logger.error((Object)("\u67e5\u8be2\u4f1a\u8ba1\u671f\u95f4\u9519\u8bef" + newTemDate), (Throwable)e);
            String error = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0639", null, new String[]{newTemDate == null ? "" : newTemDate.toStdString()});
            throw new BusinessException(error);
        }
        UFDate newStartDate = tempAccperiodVO.getStartdate();
        UFDate newEndDate = tempAccperiodVO.getEnddate();
        newStartDate = UFDate.getDate((String)(begindate.getYear() + "-" + newStartDate.getMonth() + "-" + newStartDate.getDay()));
        int endDateDay = newEndDate.getDay();
        if (29 == endDateDay && !UFDate.isLeapYear((int)begindate.getYear())) {
            --endDateDay;
        }
        newEndDate = UFDate.getDate((String)(begindate.getYear() + "-" + newEndDate.getMonth() + "-" + endDateDay));
        if (Integer.parseInt(tempAccperiodVO.getAccyear()) > tempAccperiodVO.getStartdate().getYear()) {
            tempAccperiodVO.setAccyear(String.valueOf(begindate.getYear() + 1));
        } else {
            tempAccperiodVO.setAccyear(String.valueOf(begindate.getYear() - 1));
        }
        tempAccperiodVO.setStartdate(newStartDate);
        tempAccperiodVO.setEnddate(newEndDate);
        return tempAccperiodVO;
    }

    public Integer getSubPeriodByDate(String pk_accbook, UFDate begindate, UFDate enddate) throws BusinessException {
        String pk_periodscheme = CurrencyRateUtilHelper.getInstance().getAccperiodschemeByAccountingbookID(pk_accbook);
        int monthLenth = 0;
        AccperiodVO beginPeriodVO = null;
        try {
            beginPeriodVO = this.queryPerriodMonth(pk_accbook, begindate);
        }
        catch (BusinessException e) {
            beginPeriodVO = AssetDateCalUtils.getTempPeriod(pk_accbook, begindate);
        }
        if (beginPeriodVO == null) {
            AccperiodmonthVO periodVO = AccperiodmonthAccessor.getInstance().queryMinAccperiodmonth(pk_periodscheme);
            UFDate period_begin_date = periodVO.getBegindate();
            int allPeriodNum = this.queryPeriodNum(pk_accbook, String.valueOf(period_begin_date.getYear()));
            Integer hadPeriodNum = this.getSubPeriodByDate(pk_accbook, period_begin_date, enddate);
            if (hadPeriodNum == -1) {
                hadPeriodNum = 0;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(period_begin_date.toDate());
            cal.add(5, -1);
            UFDate newCalEndDate = UFDate.getDate((Date)cal.getTime()).asEnd();
            for (int tyear = begindate.getYear(); tyear <= newCalEndDate.getYear(); ++tyear) {
                UFDate tStartDate = UFDate.getDate((String)(tyear + "-01-01"));
                tStartDate = tyear == begindate.getYear() ? begindate : UFDate.getDate((String)(tyear + "-01-01"));
                UFDate tEndDate = UFDate.getDate((String)(tyear + "-12-31"));
                if (tEndDate.compareTo(newCalEndDate) > 0) {
                    tEndDate = newCalEndDate;
                }
                UFDate calSDate = UFDate.getDate((String)(enddate.getYear() + "-" + tStartDate.getMonth() + "-" + tStartDate.getDay()));
                UFDate calEDate = UFDate.getDate((String)(enddate.getYear() + "-" + tEndDate.getMonth() + "-" + tEndDate.getDay()));
                Integer tPeriodNum = 0;
                AccperiodmonthVO tempbeginMonth = AccperiodmonthAccessor.getInstance().queryAccperiodmonthVOByDate(pk_periodscheme, calSDate);
                AccperiodmonthVO tempendMonth = AccperiodmonthAccessor.getInstance().queryAccperiodmonthVOByDate(pk_periodscheme, calEDate);
                if (null == tempbeginMonth || null == tempendMonth) {
                    return monthLenth;
                }
                tPeriodNum = tempbeginMonth.getYearmth().equals(tempendMonth.getYearmth()) && tempbeginMonth.getAccperiodmth().equals(tempendMonth.getAccperiodmth()) ? Integer.valueOf(1) : this.getSubPeriodByDate(pk_accbook, calSDate.asBegin(), calEDate.asEnd());
                if (tPeriodNum > allPeriodNum) {
                    tPeriodNum = allPeriodNum;
                }
                hadPeriodNum = hadPeriodNum + tPeriodNum;
            }
            monthLenth = hadPeriodNum;
        } else {
            AccperiodmonthVO beginMonth = null;
            AccperiodmonthVO endMonth = null;
            beginMonth = AccperiodmonthAccessor.getInstance().queryAccperiodmonthVOByDate(pk_periodscheme, begindate);
            endMonth = AccperiodmonthAccessor.getInstance().queryAccperiodmonthVOByDate(pk_periodscheme, enddate);
            if (endMonth == null) {
                endMonth = new AccperiodmonthVO();
                endMonth.setYearmth(String.valueOf(enddate.getYear()) + "-" + enddate.getMonth());
                endMonth.setAccperiodmth(String.valueOf(enddate.getMonth()));
            }
            if (beginMonth == null) {
                beginMonth = new AccperiodmonthVO();
                beginMonth.setYearmth(beginPeriodVO.getAccyear() + "-" + beginPeriodVO.getPeriod());
                beginMonth.setAccperiodmth(beginPeriodVO.getPeriod());
                int num = this.queryPeriodNum(pk_accbook, String.valueOf(enddate.getYear()));
                if (num < 12) {
                    try {
                        int nextnum = this.queryPeriodNum(pk_accbook, String.valueOf(enddate.getYear() + 1));
                        if (num != nextnum) {
                            num = nextnum;
                        }
                    }
                    catch (BusinessException ein) {
                        Logger.info((Object)ein.getMessage());
                    }
                }
                String startYear = beginPeriodVO.getAccyear();
                String endYear = endMonth.getYearmth().indexOf("-") > -1 ? endMonth.getYearmth().substring(0, endMonth.getYearmth().lastIndexOf("-")) : endMonth.getYearmth();
                int numW = num - Integer.parseInt(beginPeriodVO.getPeriod()) + Integer.parseInt(endMonth.getYearmth().substring(endMonth.getYearmth().indexOf("-") + 1, endMonth.getYearmth().length()));
                int inNum = (Integer.parseInt(endYear) - Integer.parseInt(startYear) - 1) * num + numW;
                return inNum;
            }
            if (beginMonth.getYearmth().equals(endMonth.getYearmth()) && beginMonth.getAccperiodmth().equals(endMonth.getAccperiodmth())) {
                return -1;
            }
            if (beginMonth.getYearmth().compareTo(endMonth.getYearmth()) > 0 && beginMonth.getAccperiodmth().compareTo(endMonth.getAccperiodmth()) > 0) {
                return -1;
            }
            AccountCalendar accountCalendar = this.getAccountCalendar(pk_accbook);
            AccperiodmonthVO[] monthVos = accountCalendar.getMonthVOsByDates(begindate.asBegin(), enddate);
            if (monthVos == null || monthVos.length == 0) {
                return 0;
            }
            monthLenth = monthVos.length;
            if (monthVos.length > 0) {
                AccperiodmonthVO firstMonthVO = monthVos[0];
                if (begindate.asBegin().compareTo(firstMonthVO.getBegindate().asBegin()) < 0) {
                    ++monthLenth;
                }
            } else {
                AccperiodmonthVO periodVO = AccperiodmonthAccessor.getInstance().queryMinAccperiodmonth(pk_periodscheme);
                if (begindate.getDay() >= periodVO.getBegindate().getDay() && begindate.getDay() <= periodVO.getEnddate().getDay()) {
                    ++monthLenth;
                }
            }
        }
        return monthLenth;
    }

    public AccperiodVO queryPerriodMonth(String pk_accbook, UFDate date) throws BusinessException {
        return this.queryPerriodMonth(pk_accbook, date.toString());
    }

    public AccperiodVO queryPerriodMonth(String pk_accbook, String date) throws BusinessException {
        AccountCalendar accountCalendar = this.getAccountCalendar(pk_accbook);
        accountCalendar.setDate(UFDate.fromPersisted((String)date));
        AccperiodVO vo = new AccperiodVO();
        vo.setAccyear(accountCalendar.getYearVO().getPeriodyear());
        vo.setPeriod(accountCalendar.getMonthVO().getAccperiodmth());
        vo.setStartdate(accountCalendar.getMonthVO().getBegindate());
        vo.setEnddate(accountCalendar.getMonthVO().getEnddate());
        return vo;
    }

    public AccperiodVO queryPerriodMonth(String pk_accbook, UFDate date, Boolean deduce) throws BusinessException {
        AccperiodVO accperiodVO;
        block2: {
            accperiodVO = null;
            try {
                accperiodVO = this.queryPerriodMonth(pk_accbook, date.toString());
            }
            catch (BusinessException e) {
                if (!deduce.booleanValue()) break block2;
                accperiodVO = AssetDateCalUtils.getTempPeriod(pk_accbook, date);
            }
        }
        return accperiodVO;
    }

    public AccountCalendar getAccountCalendar(String pk_accbook) throws BusinessException {
        String pk_periodscheme = CurrencyRateUtilHelper.getInstance().getAccperiodschemeByAccountingbookID(pk_accbook);
        AccountCalendar accountCalendar = AccountCalendar.getInstanceByPeriodScheme((String)pk_periodscheme);
        return accountCalendar;
    }

    public int queryPeriodNum(String pk_accbook, String year) throws BusinessException {
        AccountCalendar accountCalendar = this.getAccountCalendar(pk_accbook);
        accountCalendar.set(year);
        AccperiodmonthVO[] monthVos = accountCalendar.getMonthVOsOfCurrentYear();
        if (monthVos != null) {
            return monthVos.length;
        }
        return 0;
    }

    public static int getDaysOfCurrentYear(Integer accyear) {
        int[] days = new int[]{365, 366};
        if (UFDate.isLeapYear((int)accyear)) {
            return days[1];
        }
        return days[0];
    }

    public AccperiodVO getNextPeriod(String pk_accbook, String accyear, String period) throws BusinessException {
        AccperiodVO currentPeriod = new AccperiodVO(accyear, period);
        return this.getNextPeriod(pk_accbook, currentPeriod);
    }

    public AccperiodVO getNextPeriod(String pk_accbook, AccperiodVO currentPeriod) throws BusinessException {
        AccperiodVO nextPeriod = null;
        try {
            nextPeriod = PeriodManager.getInstance().getNextPeriod(pk_accbook, currentPeriod);
        }
        catch (BusinessException e) {
            UFDate busiDate = BizContext.getInstance().getBizDate();
            try {
                AccperiodVO bizDatePeriod = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, busiDate);
                AccperiodVO[] periodsOfYear = PeriodManager.getInstance().queryPeriodsByYear(pk_accbook, bizDatePeriod.getAccyear(), true);
                int periodInt = Integer.valueOf(currentPeriod.getPeriod());
                AccperiodVO referNextPeriod = null;
                Object nextAccyear = null;
                if (periodInt + 1 <= periodsOfYear.length) {
                    referNextPeriod = periodsOfYear[periodInt + 1 - 1];
                    nextAccyear = currentPeriod.getAccyear();
                } else {
                    referNextPeriod = periodsOfYear[0];
                    nextAccyear = "" + (Integer.valueOf(currentPeriod.getAccyear()) + 1);
                }
                nextPeriod = new AccperiodVO();
                nextPeriod.setAccyear((String)nextAccyear);
                nextPeriod.setPeriod(referNextPeriod.getPeriod());
                int cutYear = Integer.valueOf(referNextPeriod.getAccyear()) - Integer.valueOf((String)nextAccyear);
                UFDate newStartDate = referNextPeriod.getStartdate();
                UFDate newEndDate = referNextPeriod.getEnddate();
                int currentPeriodYear = newStartDate.getYear() - cutYear;
                int day = newStartDate.getDay();
                if (29 == day && !UFDate.isLeapYear((int)currentPeriodYear)) {
                    --day;
                }
                newStartDate = UFDate.getDate((String)(currentPeriodYear + "-" + newStartDate.getMonth() + "-" + day));
                day = newEndDate.getDay();
                if (29 == day && !UFDate.isLeapYear((int)currentPeriodYear)) {
                    --day;
                }
                newEndDate = UFDate.getDate((String)(currentPeriodYear + "-" + newEndDate.getMonth() + "-" + day));
                nextPeriod.setStartdate(newStartDate);
                nextPeriod.setEnddate(newEndDate);
            }
            catch (BusinessException e2) {
                throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0757"));
            }
        }
        return nextPeriod;
    }
}

