/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.card;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nc.impl.am.common.InSqlManager;
import nc.pub.fa.asset.relative.handler.BaseRelateHandler;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.pub.fa.card.LocaloriginvalueFormulaCalculator;
import nc.pub.fa.common.util.UseDeptScaleUtils;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.fa.asset.AssetCopyDataVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.fa.deptscale.DeptScaleVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDouble;
import nccloud.impl.platform.common.util.QueryUtil;

public class AssetCopyDataUtil {
    public static void setCopyDataToVo(AssetEntiretyVO vo, AssetCopyDataVO copydata) {
        vo.getCardVO().setPk_card(copydata.getPk_card());
        vo.getCardVO().setCard_code(copydata.getCard_code());
        vo.getCardVO().setAsset_code(copydata.getAsset_code());
        vo.getCardVO().setBill_source("handin");
        vo.getCardVO().setTs(copydata.getTs());
        AssetCopyDataUtil.clearCopyCardVO(vo.getCardVO());
        List<SuperVO> copyHisVOs = copydata.getHisVos();
        CardhistoryVO[] historyvo = vo.getCardhistoryVOs();
        if (null != copyHisVOs && null != historyvo && historyvo.length != copyHisVOs.size()) {
            historyvo = copyHisVOs.toArray(new CardhistoryVO[0]);
            vo.setCardhistoryVOs(copyHisVOs.toArray(new CardhistoryVO[0]));
        }
        for (int i = 0; i < historyvo.length; ++i) {
            historyvo[i].setPk_card(copydata.getPk_card());
            String pk_accbook = historyvo[i].getPk_accbook();
            historyvo[i].setPk_cardhistory(copydata.getHistorykey().get(pk_accbook));
            historyvo[i].setPk_usedept(copydata.getLink_key());
            historyvo[i].setTs(copydata.getTs_history());
            historyvo[i].setHerit_flag(UFBoolean.FALSE);
            AssetCopyDataUtil.clearCopyCardhistoryVO(historyvo[i]);
        }
        vo.clearTabDatas();
    }

    public static void clearCopyCardVO(CardVO cvo) {
        cvo.setBill_source("handin");
        cvo.setPk_bill_src(null);
        cvo.setPk_bill_b_src(null);
        cvo.setPk_equip(null);
        cvo.setPk_equip_usedept(null);
        cvo.setPk_equip_usedept_v(null);
        cvo.setBill_code_src(null);
        cvo.setStatus(2);
        cvo.setSaga_btxid(null);
        cvo.setSaga_frozen(null);
        cvo.setSaga_gtxid(null);
        cvo.setSaga_status(null);
    }

    public static void clearCopyCardhistoryVO(CardhistoryVO hisVO) {
        hisVO.setDeprate(UFDouble.ZERO_DBL);
        hisVO.setDepamount(UFDouble.ZERO_DBL);
        hisVO.setDepunit(UFDouble.ZERO_DBL);
        hisVO.setLocal_interest(UFDouble.ZERO_DBL);
        hisVO.setNewasset_flag(hisVO.getNewasset_flag() % 10);
        hisVO.setAsset_state("exist");
    }

    public static AssetCopyDataVO[] disposeReturnCopyData(AggCardVO[] newAggvo) throws BusinessException {
        Map mutilDepts;
        ArrayList<AssetCopyDataVO> returndata = new ArrayList<AssetCopyDataVO>();
        HashMap<String, String> card_links = new HashMap<String, String>();
        List pkCards = Arrays.stream(newAggvo).filter(k -> k.getParentVO() != null).map(k -> k.getParentVO().getPk_card()).collect(Collectors.toList());
        UsufructAssetVO[] vos = null;
        Map<String, List<UsufructAssetVO>> usufructPkCard = null;
        if (CollectionUtils.isNotEmpty(pkCards)) {
            String conditionSQL = " dr = 0 and pk_card in " + InSqlManager.getInSQLValue(pkCards);
            vos = (UsufructAssetVO[])QueryUtil.queryVOByCond(UsufructAssetVO.class, (String)conditionSQL, null);
            usufructPkCard = Arrays.stream(vos).collect(Collectors.groupingBy(UsufructAssetVO::getPk_card));
        }
        for (int i = 0; i < newAggvo.length; ++i) {
            List<UsufructAssetVO> result;
            AssetCopyDataVO copydata = new AssetCopyDataVO();
            CardVO copyCardvo = newAggvo[i].getParentVO();
            copydata.setPk_card(copyCardvo.getPk_card());
            copydata.setCard_code(copyCardvo.getCard_code());
            copydata.setAsset_code(copyCardvo.getAsset_code());
            copydata.setTs(copyCardvo.getTs());
            SuperVO[] copyhistoryvo = newAggvo[i].getTableVO(CardTabConst.history);
            for (int t = 0; t < copyhistoryvo.length; ++t) {
                CardhistoryVO history = (CardhistoryVO)copyhistoryvo[t];
                String accbookKey = history.getPk_accbook();
                String key = history.getPk_cardhistory();
                copydata.getHistorykey().put(accbookKey, key);
            }
            UFBoolean usedept_flag = ((CardhistoryVO)copyhistoryvo[0]).getUsedep_flag();
            if (UFBoolean.TRUE.equals((Object)usedept_flag)) {
                copydata.setDeptscale_flag(true);
                copydata.setLink_key(((CardhistoryVO)copyhistoryvo[0]).getPk_usedept());
            } else {
                copydata.setDeptscale_flag(false);
                String link_key = ((CardhistoryVO)copyhistoryvo[0]).getPk_usedept();
                if (StringUtils.isNotEmpty((String)link_key)) {
                    card_links.put(copyCardvo.getPk_card(), link_key);
                }
            }
            copydata.setTs_history(((CardhistoryVO)copyhistoryvo[0]).getTs());
            copydata.setHisVos(Arrays.asList(copyhistoryvo));
            if (usufructPkCard != null && CollectionUtils.isNotEmpty(result = usufructPkCard.get(copydata.getPk_card()))) {
                UsufructAssetVO[] copy = result.toArray(new UsufructAssetVO[0]);
                copydata.setUsufurctVos(CardVOUtils.changeTrueTabVOToViewTabVO((SuperVO[])copy));
            }
            returndata.add(copydata);
        }
        if (card_links.size() > 0 && (mutilDepts = UseDeptScaleUtils.queryDeptScaleBatch((String[])((String[])CollectionUtils.toArray(card_links.values())))) != null && mutilDepts.size() > 0) {
            for (AssetCopyDataVO copyData : returndata) {
                List mutildept;
                String pk_card = copyData.getPk_card();
                String link_key = (String)card_links.get(pk_card);
                if (!StringUtils.isNotEmpty((String)link_key) || (mutildept = (List)mutilDepts.get(link_key)) == null || mutildept.size() != 1) continue;
                copyData.setLink_key(((DeptScaleVO)mutildept.get(0)).getPk_dept());
            }
        }
        return returndata.toArray(new AssetCopyDataVO[0]);
    }

    private static Object getValue(String fieldName, AggCardVO aggVO, CardhistoryVO newCardhistoryVO) {
        String[] hisAttrNames = newCardhistoryVO.getAttributeNames();
        List<String> hisNamesList = Arrays.asList(hisAttrNames);
        if (hisNamesList.contains(fieldName)) {
            return newCardhistoryVO.getAttributeValue(fieldName);
        }
        return aggVO.getParent().getAttributeValue(fieldName);
    }

    public static UFDouble getLocaloriginValue(AggCardVO fromAggCardVO, CardhistoryVO newCardhistoryVO) throws BusinessException {
        String pk_accbook = newCardhistoryVO.getPk_accbook();
        Object[] allCardhistoryVOs = fromAggCardVO.getAllCardhistoryVOs();
        CardhistoryVO[] newCardhistoryVOs = (CardhistoryVO[])ArrayUtils.addElement((Object[])allCardhistoryVOs, (Object[])new CardhistoryVO[]{newCardhistoryVO});
        fromAggCardVO.setAllCardhistoryVOs(newCardhistoryVOs);
        LocaloriginValueRelateHandler localoriginValueRelateHandler = new LocaloriginValueRelateHandler(fromAggCardVO, pk_accbook);
        LocaloriginvalueFormulaCalculator localoriginvalueFormulaCalculator = new LocaloriginvalueFormulaCalculator(localoriginValueRelateHandler);
        UFDouble localoriginvalue = localoriginvalueFormulaCalculator.calc(pk_accbook);
        fromAggCardVO.setAllCardhistoryVOs((CardhistoryVO[])allCardhistoryVOs);
        return localoriginvalue;
    }

    private static class LocaloriginValueRelateHandler
    extends BaseRelateHandler {
        public LocaloriginValueRelateHandler(AggCardVO fromAggCardVO, String selectedAccbook) {
            this.setRelateVO(fromAggCardVO);
            this.setSelectedAccbook(selectedAccbook);
        }

        @Override
        public boolean isEditAble(String pk_accbook) {
            return false;
        }

        @Override
        public Object getOriginValue(String fieldName) {
            return null;
        }
    }
}

