/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.prv.IAsset;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.asset.manager.UsufructAssetCheckStatusEnum;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesCore;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculatorCheck;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculatorParams;
import nc.pub.fa.asset.util.usufruct.UsufructAssetImportSence;
import nc.pub.fa.card.AssetTooltips;
import nc.pub.fa.card.CardTabConst;
import nc.vo.am.common.newlease.LiabilityCalcParams;
import nc.vo.am.common.newlease.LiabilityPubVO;
import nc.vo.am.common.newlease.PaySchedulePubVO;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.CurrencyRateManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.RentTypeEnum;
import nc.vo.fa.asset.StepRentStandardViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UsufructAssetImportCheck {
    private final AssetEntiretyVO assetEntiretyVO;
    private final String prefixLine;

    public UsufructAssetImportCheck(AssetEntiretyVO assetEntiretyVO) {
        this.assetEntiretyVO = assetEntiretyVO;
        this.prefixLine = AssetTooltips.getRowIndexMultiLang((SuperVO)assetEntiretyVO.getCardVO());
    }

    public void calc() throws BusinessException {
        boolean isReportHistory;
        UsufructAssetViewVO usufructVO = this.assetEntiretyVO.getUsufructAssetViewVO();
        if (UFBoolean.TRUE.equals((Object)usufructVO.getStep_lease_flag())) {
            usufructVO.setFullcyclebegindate(null);
        }
        if (UFBoolean.TRUE.equals((Object)usufructVO.getStep_rent())) {
            usufructVO.setRent_standard(null);
        }
        boolean bl = isReportHistory = usufructVO.getPk_card() != null;
        if (isReportHistory) {
            this.calcHistoryLocalValue(usufructVO);
        } else if (UsufructAssetImportSence.isAutoCalc(this.assetEntiretyVO.getCardVO())) {
            ((IAsset)AMProxy.lookup(IAsset.class)).leaseLiabilities(null, this.assetEntiretyVO, UsufructAssetCheckStatusEnum.LEASE_ADD_IMPORT_1);
        } else {
            this.calcImport2();
        }
    }

    private void calcImport2() throws BusinessException {
        UsufructAssetViewVO usufructVO = this.assetEntiretyVO.getUsufructAssetViewVO();
        RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs = (RentPaymentPlanViewVO[])this.assetEntiretyVO.getTableVO(CardTabConst.rentpayplan_tab);
        DepAccrualViewVO[] importDepAccrualViewVOs = (DepAccrualViewVO[])this.assetEntiretyVO.getTableVO(CardTabConst.depaccrual_tab);
        DepAccrualViewVO[] mergeDepAccrualViewVOs = UsufructAssetCalculator.handleDepAccrualStatus(usufructVO, this.assetEntiretyVO, importDepAccrualViewVOs);
        this.assetEntiretyVO.setTabVO(CardTabConst.depaccrual_tab, (SuperVO[])mergeDepAccrualViewVOs);
        UFDouble totalrent_origina = UFDouble.ZERO_DBL;
        UFDouble total_tax = UFDouble.ZERO_DBL;
        for (RentPaymentPlanViewVO pay : importRentPaymentPlanViewVOs) {
            totalrent_origina = UFDoubleUtils.add((UFDouble)totalrent_origina, (UFDouble)pay.getCalculate_renttax());
            total_tax = UFDoubleUtils.add((UFDouble)total_tax, (UFDouble)pay.getCalculate_tax());
            pay.setStatus(2);
            if (pay.getAmount_type() != null) continue;
            pay.setAmount_type(RentTypeEnum.rent_default.toIntValue());
        }
        usufructVO.setTotalrent_origina(totalrent_origina);
        usufructVO.setTotal_tax(total_tax);
        UFDouble total_interest = UFDouble.ZERO_DBL;
        for (DepAccrualViewVO viewVO : importDepAccrualViewVOs) {
            if (3 == viewVO.getStatus() || !viewVO.getIsaccruedbymonth().booleanValue()) continue;
            total_interest = UFDoubleUtils.add((UFDouble)total_interest, (UFDouble)viewVO.getInterest());
        }
        usufructVO.setTotal_interest(total_interest);
        this.calcHistoryLocalValue(usufructVO);
    }

    private void calcHistoryLocalValue(UsufructAssetViewVO usufructVO) throws BusinessException {
        CardhistoryVO[] cardhistoryVOs = this.assetEntiretyVO.getCardhistoryVOs();
        String pk_currency = this.assetEntiretyVO.getCardVO().getPk_currency();
        UFDate business_date = this.assetEntiretyVO.getCardVO().getBusiness_date();
        for (CardhistoryVO history : cardhistoryVOs) {
            String pk_accbook = history.getPk_accbook();
            UFDouble localcurr_rate = history.getLocalcurr_rate();
            String pk_ratetype = history.getPk_ratetype();
            UFDate convertDate = business_date;
            localcurr_rate = history.getLocalcurr_rate();
            UFDouble local_total_interest = CurrencyRateManager.getAccbookAmountByOpp((String)pk_accbook, (String)pk_currency, (UFDouble)usufructVO.getTotal_interest(), (UFDouble)localcurr_rate, (UFDate)convertDate, (String)pk_ratetype);
            UFDouble totalrent_localorigina = CurrencyRateManager.getAccbookAmountByOpp((String)pk_accbook, (String)pk_currency, (UFDouble)usufructVO.getTotalrent_origina(), (UFDouble)localcurr_rate, (UFDate)convertDate, (String)pk_ratetype);
            UFDouble total_localtax = CurrencyRateManager.getAccbookAmountByOpp((String)pk_accbook, (String)pk_currency, (UFDouble)usufructVO.getTotal_tax(), (UFDouble)localcurr_rate, (UFDate)convertDate, (String)pk_ratetype);
            history.setLocal_total_interest(local_total_interest);
            history.setSurplus_interest(local_total_interest);
            history.setTotalrent_localorigina(totalrent_localorigina);
            history.setTotal_localtax(total_localtax);
        }
    }

    public StringBuilder checkPaymentPlanAndDepAccrual() {
        StringBuilder errors = new StringBuilder();
        try {
            UsufructAssetCalculatorCheck.checkUsufructAssetBeforeCalculator(this.assetEntiretyVO, UsufructAssetCheckStatusEnum.LEASE_ADD, null);
        }
        catch (BusinessException e) {
            throw ExceptionUtils.businessRuntimeException((Throwable)e);
        }
        if (UsufructAssetImportSence.isAutoCalc(this.assetEntiretyVO.getCardVO())) {
            return errors;
        }
        try {
            UsufructAssetViewVO addUsufructVO = this.assetEntiretyVO.getUsufructAssetViewVO();
            UsufructAssetCalculator.fixupCohesionProcess(addUsufructVO);
            ArrayList dates = Lists.newArrayList((Object[])new UFDate[]{addUsufructVO.getRentstart_date(), PayScheduleCalculateHelper.getMaxEndDate(addUsufructVO), addUsufructVO.getStarting_date()});
            PayScheduleCalculator payScheduleCalculator = new PayScheduleCalculator(null, this.assetEntiretyVO, dates, UsufructAssetCheckStatusEnum.LEASE_ADD);
            PaySchedulePubVO[] calcPaymentPlanViewVOs = payScheduleCalculator.calc();
            LiabilityCalcParams liabilityCalcParams = UsufructAssetCalculatorParams.getCalcParams(this.assetEntiretyVO);
            LeaseLiabilitiesCore leaseLiabilitiesCalculator = new LeaseLiabilitiesCore(liabilityCalcParams, addUsufructVO, calcPaymentPlanViewVOs);
            List<LiabilityPubVO> calcLiabilityPubVOs = leaseLiabilitiesCalculator.calc();
            CardVO cardVO = this.assetEntiretyVO.getCardVO();
            String pk_org = cardVO.getPk_org();
            CardhistoryVO[] cardhistoryVOs = this.assetEntiretyVO.getCardhistoryVOs();
            AccperiodVO minUnClosebookPeriod = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).queryMinUnClosebookPeriod(pk_org, cardhistoryVOs[0].getPk_accbook());
            UFDate startdate = minUnClosebookPeriod.getStartdate();
            RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs = (RentPaymentPlanViewVO[])this.assetEntiretyVO.getTableVO(CardTabConst.rentpayplan_tab);
            DiffRentPaymentPlan diffRentPaymentPlan = new DiffRentPaymentPlan((RentPaymentPlanViewVO[])calcPaymentPlanViewVOs, importRentPaymentPlanViewVOs, startdate, this.prefixLine);
            errors.append(diffRentPaymentPlan.check());
            StepRentStandardViewVO[] importStepRentStandardViewVOs = (StepRentStandardViewVO[])this.assetEntiretyVO.getTableVO(CardTabConst.steprentstandard_tab);
            DiffStepRentStandard diffStepRentStandard = new DiffStepRentStandard(importStepRentStandardViewVOs, importRentPaymentPlanViewVOs, addUsufructVO, this.prefixLine);
            errors.append(diffStepRentStandard.check());
            DepAccrualViewVO[] importDepAccrualViewVOs = (DepAccrualViewVO[])this.assetEntiretyVO.getTableVO(CardTabConst.depaccrual_tab);
            DiffDepAccrual diffDepAccrual = new DiffDepAccrual(calcLiabilityPubVOs, importDepAccrualViewVOs, startdate, this.prefixLine);
            errors.append(diffDepAccrual.check());
        }
        catch (BusinessException e) {
            throw ExceptionUtils.businessRuntimeException((Throwable)e);
        }
        return errors;
    }

    private static <T extends UFDate> Pair<List<String>, List<String>> diffList(List<T> left, List<T> right) {
        if (ListUtils.isEqualList(left, right)) {
            return null;
        }
        List intersection = ListUtils.intersection(left, right);
        left.removeAll(intersection);
        right.removeAll(intersection);
        List<Object> leftStr = Lists.newArrayList();
        if (!left.isEmpty()) {
            leftStr = left.stream().map(o -> o.toStdString()).collect(Collectors.toList());
        }
        List<Object> rightStr = Lists.newArrayList();
        if (!right.isEmpty()) {
            rightStr = right.stream().map(o -> o.toStdString()).collect(Collectors.toList());
        }
        return Pair.of((Object)leftStr, (Object)rightStr);
    }

    private static class DiffRentPaymentPlan {
        private final RentPaymentPlanViewVO[] calcPaymentPlanViewVOs;
        private final RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs;
        private final UFDate diffDate;
        private final String prefixLine;

        public DiffRentPaymentPlan(RentPaymentPlanViewVO[] calcPaymentPlanViewVOs, RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs, UFDate startdate, String prefixLine) {
            this.calcPaymentPlanViewVOs = calcPaymentPlanViewVOs;
            this.importRentPaymentPlanViewVOs = importRentPaymentPlanViewVOs;
            this.diffDate = startdate;
            this.prefixLine = prefixLine;
        }

        public String check() {
            List calcDates = Stream.of(this.calcPaymentPlanViewVOs).filter(o -> {
                UFDate end_date = o.getEnd_date();
                return this.diffDate.isSameDate(end_date) || this.diffDate.beforeDate(end_date);
            }).map(o -> o.getStart_date()).collect(Collectors.toList());
            List importDates = Stream.of(this.importRentPaymentPlanViewVOs).filter(o -> {
                UFDate end_date = o.getEnd_date();
                return this.diffDate.isSameDate(end_date) || this.diffDate.beforeDate(end_date);
            }).map(o -> o.getStart_date()).collect(Collectors.toList());
            Pair<List<String>, List<String>> containingDates = UsufructAssetImportCheck.diffList(importDates, calcDates);
            if (containingDates != null) {
                return this.prefixLine + NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0825", null, new String[]{String.join((CharSequence)",", (Iterable)containingDates.getLeft()), String.join((CharSequence)",", (Iterable)containingDates.getRight())});
            }
            return "";
        }
    }

    private static class DiffStepRentStandard {
        private StepRentStandardViewVO[] importStepRentStandardViewVOs;
        private RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs;
        private UsufructAssetViewVO addUsufructVO;
        private final String prefixLine;

        public DiffStepRentStandard(StepRentStandardViewVO[] importStepRentStandardViewVOs, RentPaymentPlanViewVO[] importRentPaymentPlanViewVOs, UsufructAssetViewVO addUsufructVO, String prefixLine) {
            this.importStepRentStandardViewVOs = importStepRentStandardViewVOs;
            this.importRentPaymentPlanViewVOs = importRentPaymentPlanViewVOs;
            this.addUsufructVO = addUsufructVO;
            this.prefixLine = prefixLine;
        }

        public String check() {
            if (UFBoolean.TRUE.equals((Object)this.addUsufructVO.getStep_lease_flag())) {
                List importRents;
                List importRentStartDates;
                List importStepStartDates = Stream.of(this.importStepRentStandardViewVOs).map(o -> o.getStart_date()).collect(Collectors.toList());
                boolean equalStartDates = ListUtils.isEqualList(importStepStartDates, importRentStartDates = Stream.of(this.importRentPaymentPlanViewVOs).map(o -> o.getStart_date()).collect(Collectors.toList()));
                if (!equalStartDates) {
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0827");
                }
                List importStepRents = Stream.of(this.importStepRentStandardViewVOs).map(o -> o.getRent()).collect(Collectors.toList());
                boolean equalRents = ListUtils.isEqualList(importStepRents, importRents = Stream.of(this.importRentPaymentPlanViewVOs).map(o -> o.getCalculate_renttax()).collect(Collectors.toList()));
                if (!equalRents) {
                    return this.prefixLine + NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0827");
                }
            }
            return "";
        }
    }

    private static class DiffDepAccrual {
        private final List<LiabilityPubVO> calcLiabilityPubVOs;
        private final DepAccrualViewVO[] importDepAccrualViewVOs;
        private final UFDate diffDate;
        private final String prefixLine;

        public DiffDepAccrual(List<LiabilityPubVO> clacLiabilityPubVOs, DepAccrualViewVO[] importDepAccrualViewVOs, UFDate startdate, String prefixLine) {
            this.calcLiabilityPubVOs = clacLiabilityPubVOs;
            this.importDepAccrualViewVOs = importDepAccrualViewVOs;
            this.diffDate = startdate;
            this.prefixLine = prefixLine;
        }

        public String check() {
            List calcDates = this.calcLiabilityPubVOs.stream().filter(o -> {
                UFDate end_date = o.getEnd_date();
                return this.diffDate.isSameDate(end_date) || this.diffDate.beforeDate(end_date);
            }).map(o -> o.getBegin_date()).collect(Collectors.toList());
            List importDates = Stream.of(this.importDepAccrualViewVOs).filter(o -> {
                UFDate start_date = o.getEnd_date();
                return this.diffDate.isSameDate(start_date) || this.diffDate.beforeDate(start_date);
            }).map(o -> o.getBegin_date()).collect(Collectors.toList());
            Pair<List<String>, List<String>> containingDates = UsufructAssetImportCheck.diffList(importDates, calcDates);
            if (containingDates != null) {
                return this.prefixLine + NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0826", null, new String[]{String.join((CharSequence)",", (Iterable)containingDates.getLeft()), String.join((CharSequence)",", (Iterable)containingDates.getRight())});
            }
            return "";
        }
    }
}

