/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.prv.IAccrual;
import nc.itf.fa.service.IAccrualliaService;
import nc.itf.fa.service.IAssetService;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.asset.manager.UsufructAssetCheckStatusEnum;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVOManager;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.common.manager.FipManager;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.MultiLanguageUtil;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.am.rent.UFDateUtils;
import nc.vo.am.timerule.LeaseRentTimeRuleCalculator;
import nc.vo.am.timerule.LeaseTimeRuleVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.StepRentStandardViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.dto.pub.leasepub.DatePair;

public class UsufructAssetCalculatorCheck {
    public static void checkCancalLeaseChange(UFDate effective_period, String pk_group, String pk_org, CardhistoryVO[] cardhistoryVOs) throws BusinessException {
        boolean reducedState = true;
        for (CardhistoryVO cardhistoryVO : cardhistoryVOs) {
            String asset_state = cardhistoryVO.getAsset_state();
            if (!"exist".equals(asset_state)) continue;
            reducedState = false;
            break;
        }
        if (reducedState) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("fanccloud_0", "02012100-0080"));
        }
        List<String> pk_accbooks = Stream.of(cardhistoryVOs).map(CardhistoryVO::getPk_accbook).collect(Collectors.toList());
        Map mapAccbookName = MultiLanguageUtil.getMultiLangByClassId((String[])pk_accbooks.toArray(new String[0]), (String)"fb4da7d4-77b0-4cb8-81c3-db65e32d63af");
        Map minUnCloseBookPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks.toArray(new String[0]));
        for (String pk_accbook : pk_accbooks) {
            AccperiodVO accperiodVO = (AccperiodVO)minUnCloseBookPeriods.get(pk_accbook);
            UFDate startdate = accperiodVO.getStartdate();
            UFDate enddate = accperiodVO.getEnddate();
            if (effective_period.beforeDate(startdate) || effective_period.afterDate(enddate)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0775", null, new String[]{(String)mapAccbookName.get(pk_accbook), accperiodVO.getAccyear(), accperiodVO.getPeriod(), startdate.toLocalString(), enddate.toLocalString()}));
            }
            if (effective_period.getYear() != startdate.getYear() || effective_period.getMonth() <= startdate.getMonth()) continue;
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0741"));
        }
        Set minUnCloseBookPeriodsEntrySet = minUnCloseBookPeriods.entrySet();
        for (Map.Entry entry : minUnCloseBookPeriodsEntrySet) {
            String pk_accbook = (String)entry.getKey();
            AccperiodVO minUnClosebookPeriod = (AccperiodVO)entry.getValue();
            String accbookName = (String)mapAccbookName.get(pk_accbook);
            UsufructAssetCalculatorCheck.checkFipMakeVoucher(pk_group, pk_org, pk_accbook, minUnClosebookPeriod, accbookName);
        }
    }

    public static void checkUsufructAssetBeforeCalculator(AssetEntiretyVO assetEntiretyVO, UsufructAssetCheckStatusEnum ucs, Map<String, Object> userjson) throws BusinessException {
        Integer prerule;
        StepRentStandardViewVO[] stepRentStandardViewVOs;
        Map map;
        String newValue;
        CardVO cardVO = assetEntiretyVO.getCardVO();
        String prefixLine = "";
        UsufructAssetViewVO usufructVO = assetEntiretyVO.getUsufructAssetViewVO();
        UFDate begin_date = cardVO.getBegin_date();
        if (usufructVO.getStep_lease_flag() == null) {
            usufructVO.setStep_lease_flag(UFBoolean.FALSE);
        }
        UFBoolean step_lease_flag = usufructVO.getStep_lease_flag();
        String rent_way = usufructVO.getRent_way();
        UFDate rentstart_date = usufructVO.getRentstart_date();
        UFDate starting_date = usufructVO.getStarting_date();
        UFDate ending_date = usufructVO.getEnding_date();
        UFDate relet_ending_date = usufructVO.getRelet_ending_date();
        UFDate fullcyclebegindate = usufructVO.getFullcyclebegindate();
        boolean isStepLeaseFlag = true;
        if (userjson != null && userjson.keySet().contains("step_lease_flag")) {
            isStepLeaseFlag = false;
        }
        if (!step_lease_flag.booleanValue() && rent_way == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0884"));
        }
        String bill_source = cardVO.getBill_source();
        if (!"4A3A".equals(bill_source) && rent_way != null && Integer.parseInt(rent_way) < 1) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0909"));
        }
        if (rentstart_date.afterDate(starting_date)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0739"));
        }
        if (ending_date == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0908"));
        }
        if (starting_date.afterDate(ending_date)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0738"));
        }
        UFBoolean renewal_flag = usufructVO.getRenewal_flag();
        if (UFBoolean.TRUE.equals((Object)renewal_flag) && relet_ending_date == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0779"));
        }
        if (UFBoolean.TRUE.equals((Object)usufructVO.getPurchase_choice()) && usufructVO.getPurchase_price() == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0780"));
        }
        if (UFBoolean.TRUE.equals((Object)renewal_flag) && ending_date.getDateAfter(1).afterDate(relet_ending_date)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0736"));
        }
        if (userjson != null && userjson.get("change_start_date") != null && StringUtils.isNotBlank((CharSequence)(newValue = (String)(map = (Map)userjson.get("change_start_date")).get("newValue")))) {
            UFDate change_start_date = new UFDate((String)map.get("newValue"), true);
            UFDate fullcyclebegindate2 = fullcyclebegindate;
            if (fullcyclebegindate2 == null) {
                fullcyclebegindate2 = usufructVO.getStarting_date();
            }
            if (change_start_date.beforeDate(fullcyclebegindate2)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0886"));
            }
        }
        if (userjson != null && userjson.get("rent_way") != null && StringUtils.isBlank((CharSequence)(newValue = (String)(map = (Map)userjson.get("change_start_date")).get("newValue")))) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0888"));
        }
        UFDate lastEndDate = PayScheduleCalculateHelper.getMaxEndDate(usufructVO);
        if (fullcyclebegindate != null && (fullcyclebegindate.beforeDate(starting_date) || fullcyclebegindate.afterDate(lastEndDate) || fullcyclebegindate.isSameDate(lastEndDate))) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0820"));
        }
        if (lastEndDate.before(begin_date)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0835"));
        }
        if (UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(usufructVO) && usufructVO.getPrerule() == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0823"));
        }
        if (UFBoolean.TRUE.equals((Object)usufructVO.getStep_rent()) && ArrayUtils.isEmpty((Object[])(stepRentStandardViewVOs = (StepRentStandardViewVO[])assetEntiretyVO.getTabVO("steprentstandard_tab")))) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0762"));
        }
        if (UFBoolean.TRUE.equals((Object)step_lease_flag)) {
            boolean fullXNaturalMonths;
            if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0821"));
            }
            if (UsufructAssetEnumJudge.isDiscountModeMonth(usufructVO) && !(fullXNaturalMonths = UsufructAssetCalculatorCheck.isFullXNaturalMonths(stepRentStandardViewVOs = (StepRentStandardViewVO[])assetEntiretyVO.getTabVO("steprentstandard_tab")))) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0800"));
            }
        } else {
            if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO) && !rentstart_date.isSameDate(starting_date) && fullcyclebegindate != null && !fullcyclebegindate.isSameDate(starting_date)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0821"));
            }
            if (UsufructAssetEnumJudge.isDiscountModeMonth(usufructVO) && !UsufructAssetCalculatorCheck.isFullXNaturalMonthsForUsufructBeginDate(usufructVO)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0822"));
            }
        }
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(usufructVO)) {
            UFDate retrospective_date = usufructVO.getRetrospective_date();
            if (retrospective_date == null) {
                retrospective_date = new UFDate("2021-01-01 00:00:00");
                usufructVO.setRetrospective_date(retrospective_date);
            }
            if (lastEndDate.beforeDate(retrospective_date)) {
                if (UsufructAssetCheckStatusEnum.LEASE_ADD == ucs || UsufructAssetCheckStatusEnum.LEASE_ADD_IMPORT_1 == ucs || UsufructAssetCheckStatusEnum.LEASE_ADD_IMPORT_2 == ucs) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0809"));
                }
                if (UsufructAssetCheckStatusEnum.LEASE_CHANGE == ucs) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0808"));
                }
            }
        }
        if (UFBoolean.TRUE.equals((Object)usufructVO.getStep_rent()) && !"4A3A".equals(bill_source)) {
            UFDate first_start_date;
            StepRentStandardViewVO[] steprentstandard_tab = (StepRentStandardViewVO[])assetEntiretyVO.getTabVO("steprentstandard_tab");
            List<StepRentStandardViewVO> collect = Stream.of(steprentstandard_tab).filter(vo -> vo.getStatus() != 3).collect(Collectors.toList());
            int count = (steprentstandard_tab = collect.toArray(new StepRentStandardViewVO[0])).length;
            if (count == 0) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0762"));
            }
            if (UFBoolean.TRUE.equals((Object)usufructVO.getStep_lease_flag()) && isStepLeaseFlag && !(first_start_date = steprentstandard_tab[0].getStart_date()).isSameDate(starting_date)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0798"));
            }
            UFDate lastEnd_date = starting_date;
            UFDate last_one_end_date = lastEndDate;
            steprentstandard_tab[count - 1].setEnd_date(last_one_end_date);
            for (StepRentStandardViewVO vo2 : steprentstandard_tab) {
                if (vo2.getStart_date() != null && vo2.getEnd_date() != null) continue;
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0901"));
            }
            Stream.of(steprentstandard_tab).forEach(vo -> {
                vo.setStart_date(vo.getStart_date().asLocalBegin());
                vo.setEnd_date(vo.getEnd_date().asLocalEnd());
            });
            for (int i = 0; i < count; ++i) {
                StepRentStandardViewVO stepRentStandardViewVO = steprentstandard_tab[i];
                UFDate start_date = stepRentStandardViewVO.getStart_date();
                UFDate end_date = stepRentStandardViewVO.getEnd_date();
                UFDouble rent = stepRentStandardViewVO.getRent();
                String lineNo = "" + (i + 1);
                if (Objects.isNull(rent)) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0910", null, new String[]{lineNo}));
                }
                if (rent.compareTo((Object)UFDouble.ZERO_DBL) < 0) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0763", null, new String[]{lineNo, Objects.isNull(rent) ? "" : rent.toString()}));
                }
                if (!start_date.before(last_one_end_date)) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0764", null, new String[]{lineNo, start_date.toLocalString(), last_one_end_date.toLocalString()}));
                }
                if (i == 0) {
                    if (starting_date.beforeDate(start_date) && isStepLeaseFlag) {
                        throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0765", null, new String[]{lineNo, start_date.toLocalString(), starting_date.toLocalString()}));
                    }
                } else {
                    UFDate dateAfterOne = lastEnd_date.getDateAfter(1);
                    if (!start_date.isSameDate(dateAfterOne)) {
                        throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0766", null, new String[]{lineNo, start_date.toLocalString(), dateAfterOne.toLocalString()}));
                    }
                }
                if (Objects.isNull(end_date) || start_date.afterDate(end_date)) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0767", null, new String[]{lineNo, Objects.isNull(end_date) ? "" : end_date.toLocalString(), start_date.toLocalString()}));
                }
                lastEnd_date = stepRentStandardViewVO.getEnd_date();
            }
        }
        if (UsufructAssetEnumJudge.isDiscountModeMonth(usufructVO) || UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
            String pk_org = assetEntiretyVO.getCardVO().getPk_org();
            List<String> pk_accbooks = Stream.of(assetEntiretyVO.getCardhistoryVOs()).map(CardhistoryVO::getPk_accbook).collect(Collectors.toList());
            Map minPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks.toArray(new String[0]));
            for (String pk_accbook : pk_accbooks) {
                AccperiodVO accperiodVO;
                if (UsufructAssetCalculatorCheck.isNormalPeriod(pk_org, pk_accbook, (accperiodVO = (AccperiodVO)minPeriods.get(pk_accbook)).getAccyear())) continue;
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0784"));
            }
        }
        if (UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(usufructVO) && (prerule = usufructVO.getPrerule()) == null) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0818"));
        }
    }

    public static void checkEndDateForLeaseChange(AssetEntiretyVO oldAssetEntiretyVO, AssetEntiretyVO assetEntiretyVO, Map<String, Object> userjson, String currentBillCode) throws BusinessException {
        CardVO cardVO = assetEntiretyVO.getCardVO();
        String pk_group = cardVO.getPk_group();
        String pk_card = cardVO.getPk_card();
        String pk_org = cardVO.getPk_org();
        UsufructAssetCalculator.filterHistroy(oldAssetEntiretyVO);
        UsufructAssetCalculator.filterHistroy(assetEntiretyVO);
        CardhistoryVO[] currCardhistoryVOs = assetEntiretyVO.getCardhistoryVOs();
        CardhistoryVO[] oldCardhistoryVOs = oldAssetEntiretyVO.getCardhistoryVOs();
        if (currCardhistoryVOs.length != oldCardhistoryVOs.length) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0778"));
        }
        boolean reducedState = true;
        for (CardhistoryVO oldCardhistoryVO : oldCardhistoryVOs) {
            String asset_state = oldCardhistoryVO.getAsset_state();
            if (!"exist".equals(asset_state)) continue;
            reducedState = false;
            break;
        }
        if (reducedState) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("fanccloud_0", "02012100-0080"));
        }
        if (userjson.get("needValidateBill") == null) {
            for (CardhistoryVO history : currCardhistoryVOs) {
                String pk_accbook = history.getPk_accbook();
                Map<String, String> checkCardFitForBill = ((IAssetService)AMProxy.lookup(IAssetService.class)).checkCardFitForBill(pk_accbook, currentBillCode, false, null, pk_card);
                String string = checkCardFitForBill.get(pk_card);
                if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                throw ExceptionUtils.businessException((String)string);
            }
        }
        UsufructAssetViewVO usufruct = assetEntiretyVO.getUsufructAssetViewVO();
        UFDate change_date = usufruct.getChange_date();
        List<String> pk_accbooks = Stream.of(assetEntiretyVO.getCardhistoryVOs()).map(CardhistoryVO::getPk_accbook).collect(Collectors.toList());
        Map mapAccbookName = MultiLanguageUtil.getMultiLangByClassId((String[])pk_accbooks.toArray(new String[0]), (String)"fb4da7d4-77b0-4cb8-81c3-db65e32d63af");
        Map minUnCloseBookPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks.toArray(new String[0]));
        for (String string : pk_accbooks) {
            AccperiodVO accperiodVO = (AccperiodVO)minUnCloseBookPeriods.get(string);
            UFDate startdate = accperiodVO.getStartdate();
            UFDate enddate = accperiodVO.getEnddate();
            if (change_date.beforeDate(startdate) || change_date.afterDate(enddate)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0775", null, new String[]{(String)mapAccbookName.get(string), accperiodVO.getAccyear(), accperiodVO.getPeriod(), startdate.toLocalString(), enddate.toLocalString()}));
            }
            if (change_date.getYear() != startdate.getYear() || change_date.getMonth() <= startdate.getMonth()) continue;
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0741"));
        }
        Set minUnCloseBookPeriodsEntrySet = minUnCloseBookPeriods.entrySet();
        for (Map.Entry entry : minUnCloseBookPeriodsEntrySet) {
            String pk_accbook = (String)entry.getKey();
            AccperiodVO minUnClosebookPeriod = (AccperiodVO)entry.getValue();
            String accbookName = (String)mapAccbookName.get(pk_accbook);
            UsufructAssetCalculatorCheck.checkFipMakeVoucher(pk_group, pk_org, pk_accbook, minUnClosebookPeriod, accbookName);
        }
        if (UFBoolean.TRUE.equals((Object)usufruct.getRenewal_flag()) && userjson.containsKey("ending_date")) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0790"));
        }
        UFDate uFDate = PayScheduleCalculateHelper.getMaxEndDate(usufruct);
        UsufructAssetViewVO usufructAssetViewVO = oldAssetEntiretyVO.getUsufructAssetViewVO();
        UFDate oldEndingDate = PayScheduleCalculateHelper.getMaxEndDate(usufructAssetViewVO);
        if (uFDate.beforeDate(change_date)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0771"));
        }
        if (change_date.getYear() == oldEndingDate.getYear() && change_date.getMonth() == oldEndingDate.getMonth() && change_date.getDay() > oldEndingDate.getDay()) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0788", null, new String[]{change_date.toLocalString(), oldEndingDate.toLocalString()}));
        }
        for (Map.Entry periods : minUnCloseBookPeriodsEntrySet) {
            UFDate nextEndingDate;
            boolean isFipMakeAndMinUnClosebookPeriod;
            String pk_accbook = (String)periods.getKey();
            AccperiodVO minUnClosebookPeriod = (AccperiodVO)periods.getValue();
            if (uFDate.beforeDate(oldEndingDate) && (oldEndingDate.beforeDate(minUnClosebookPeriod.getStartdate()) || uFDate.beforeDate(minUnClosebookPeriod.getStartdate()))) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0773"));
            }
            if (!oldEndingDate.beforeDate(uFDate) || !(isFipMakeAndMinUnClosebookPeriod = UsufructAssetCalculatorCheck.isFipMakeAndMinUnClosebookPeriod(pk_group, pk_org, pk_accbook, nextEndingDate = oldEndingDate.getDateAfter(1)))) continue;
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0776", null, new String[]{nextEndingDate.toLocalString()}));
        }
        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(pk_card).setChangeDate(change_date);
    }

    static boolean isFipMakeAndMinUnClosebookPeriod(String pk_group, String pk_org, String pk_accbook, UFDate endDate) throws BusinessException {
        String periodPK;
        try {
            periodPK = PeriodManager.getInstance().getPeriodPK(pk_accbook, endDate);
        }
        catch (BusinessException ignore) {
            return false;
        }
        AccperiodVO accperiodVO = PeriodManager.queryPeriodByAccperiodMonth((String)periodPK);
        AccperiodVO minUnClosebookPeriod = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).queryMinUnClosebookPeriod(pk_org, pk_accbook);
        UFBoolean isFipMakeVoucher = FipManager.isFipMakeVoucher((String)pk_org, (String)accperiodVO.getAccyear(), (String)accperiodVO.getPeriod(), (String)pk_accbook);
        boolean isMakeVoucher = ((IAccrual)AMProxy.lookup(IAccrual.class)).isMakeVoucher(pk_org, pk_accbook, accperiodVO.getAccyear(), accperiodVO.getPeriod());
        boolean isMakeVoucher2 = ((IAccrualliaService)AMProxy.lookup(IAccrualliaService.class)).isFipMakeVoucher(pk_group, pk_org, pk_accbook, accperiodVO.getAccyear(), accperiodVO.getPeriod());
        return isMakeVoucher2 || isMakeVoucher || isFipMakeVoucher.booleanValue() || accperiodVO.before(minUnClosebookPeriod);
    }

    static void checkFipMakeVoucher(String pk_group, String pk_org, String pk_accbook, AccperiodVO accperiodVO, String accbookName) throws BusinessException {
        UFBoolean isMakeVoucherDep = FipManager.isFipMakeVoucher((String)pk_org, (String)accperiodVO.getAccyear(), (String)accperiodVO.getPeriod(), (String)pk_accbook);
        boolean isMakeVoucherAccrual = ((IAccrual)AMProxy.lookup(IAccrual.class)).isMakeVoucher(pk_org, pk_accbook, accperiodVO.getAccyear(), accperiodVO.getPeriod());
        boolean isMakeVoucherAccruallia = ((IAccrualliaService)AMProxy.lookup(IAccrualliaService.class)).isFipMakeVoucher(pk_group, pk_org, pk_accbook, accperiodVO.getAccyear(), accperiodVO.getPeriod());
        if (isMakeVoucherDep.booleanValue()) {
            String strByID = NCLangRes4VoTransl.getNCLangRes().getStrByID("fapub_0", "02012000-0180", null, new String[]{accbookName});
            throw ExceptionUtils.businessException((String)strByID);
        }
        if (isMakeVoucherAccruallia || isMakeVoucherAccrual) {
            String strByID2 = NCLangRes4VoTransl.getNCLangRes().getStrByID("fapub_0", "02012000-0181", null, new String[]{accbookName});
            throw ExceptionUtils.businessException((String)strByID2);
        }
    }

    public static boolean isFullXNaturalMonths(StepRentStandardViewVO[] stepRentStandardViewVOs) {
        ArrayList collect = Lists.newArrayList();
        for (StepRentStandardViewVO vo : stepRentStandardViewVOs) {
            if (vo.getStatus() == 3) continue;
            collect.add(vo);
        }
        if (collect.size() == 1) {
            return true;
        }
        ArrayList<DatePair> datePairs = new ArrayList<DatePair>();
        for (StepRentStandardViewVO step : collect) {
            DatePair datePair = new DatePair();
            datePair.setStart(step.getStart_date());
            datePair.setEnd(step.getEnd_date());
            datePairs.add(datePair);
        }
        datePairs.remove(datePairs.size() - 1);
        LeaseRentTimeRuleCalculator timeRuleCalculator = new LeaseRentTimeRuleCalculator();
        for (DatePair pair : datePairs) {
            int fullMonth = PayScheduleCalculateHelper.fullMonth(pair, timeRuleCalculator);
            if (fullMonth != -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isFullXNaturalMonthsForUsufructBeginDate(UsufructAssetViewVO usufructVO) {
        DatePair datePair;
        UFDate rentstart_date = usufructVO.getRentstart_date();
        UFDate starting_date = usufructVO.getStarting_date();
        UFDate fullcyclebegindate = usufructVO.getFullcyclebegindate();
        if (fullcyclebegindate == null) {
            fullcyclebegindate = starting_date;
        }
        if (rentstart_date.isSameDate(starting_date) && starting_date.isSameDate(fullcyclebegindate)) {
            return true;
        }
        ArrayList<DatePair> datePairs = new ArrayList<DatePair>();
        if (!rentstart_date.isSameDate(starting_date)) {
            datePair = new DatePair();
            datePair.setStart(rentstart_date);
            datePair.setEnd(UFDateUtils.getBeforeDayEndDate((UFDate)starting_date));
            datePairs.add(datePair);
        }
        if (!starting_date.isSameDate(fullcyclebegindate)) {
            datePair = new DatePair();
            datePair.setStart(starting_date);
            datePair.setEnd(UFDateUtils.getBeforeDayEndDate((UFDate)fullcyclebegindate));
            datePairs.add(datePair);
        }
        LeaseRentTimeRuleCalculator timeRuleCalculator = new LeaseRentTimeRuleCalculator();
        for (DatePair pair : datePairs) {
            int fullMonth = PayScheduleCalculateHelper.fullMonth(pair, timeRuleCalculator);
            if (fullMonth != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isNormalPeriod(String pk_org, String pk_accbook, String accyear) throws BusinessException {
        return true;
    }

    public static boolean isNormalPeriod2(String pk_org, String pk_accbook, String accyear) throws BusinessException {
        PeriodManager periodManager = PeriodManager.getInstance();
        AccperiodVO[] periodVO = periodManager.queryPeriodsByYear(pk_accbook, accyear, true);
        if (periodVO.length == 12) {
            for (AccperiodVO accVO : periodVO) {
                String beginDate = accVO.getStartdate().toString();
                String endDate = accVO.getEnddate().toString();
                int monthCon = periodManager.getMonCountBetween(beginDate.substring(0, 10), endDate.substring(0, 10));
                if (monthCon == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean isFullPeriod(UFDate start_date, UFDate end_date, UsufructAssetViewVO usufruct) {
        UFBoolean step_lease_flag = usufruct.getStep_lease_flag();
        if (UFBoolean.TRUE.equals((Object)step_lease_flag)) {
            return true;
        }
        Integer rent_way = Integer.valueOf(usufruct.getRent_way()) - 1;
        if (rent_way == 0) {
            return true;
        }
        LeaseTimeRuleVO ruleVO = PayScheduleCalculateHelper.leaseTimeRuleVO(rent_way, usufruct.getStarting_date().getDay());
        UFDate nextDate = ruleVO.nextDate(start_date);
        return nextDate.before(end_date);
    }
}

