/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.impl.am.db.DBAccessUtil;
import nc.itf.ali.contract.pub.IContractInService;
import nc.itf.bd.taxcode.ITaxcodeQueryService;
import nc.itf.fa.prv.IAsset;
import nc.pub.fa.asset.relation.BeginLiabilityEnum;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVO;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVOManager;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.card.AssetFieldConst;
import nc.vo.am.common.newlease.utils.MathUtils;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.MultiLanguageUtil;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.discountmethodsetting.MonthDayCalMode;
import nc.vo.am.proxy.AMProxy;
import nc.vo.am.rent.UFDateUtils;
import nc.vo.am.scale.query.ScaleUtils;
import nc.vo.am.timerule.LeaseRentTimeRuleCalculator;
import nc.vo.am.timerule.LeaseTimeRuleVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.asset.CohesionProcessEnum;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.assetcard.LogChangeRecordVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;

public class UsufructAssetCalculator {
    private static final LeaseRentTimeRuleCalculator timeRuleCalculator = new LeaseRentTimeRuleCalculator();

    public static DepAccrualViewVO[] handleDepAccrualStatus(UsufructAssetViewVO usufructVO, AssetEntiretyVO assetEntiretyVO, DepAccrualViewVO ... viewvos) {
        if (UsufructAssetEnumJudge.isDiscountModeMonth(usufructVO)) {
            Stream.of(viewvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.TRUE);
                viewvo.setStatus(2);
            });
        } else if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
            Stream.of(viewvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.TRUE);
                viewvo.setStatus(2);
            });
        } else {
            Stream.of(viewvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.FALSE);
                viewvo.setStatus(2);
                viewvo.setDay_date(viewvo.getBegin_date());
            });
            DepAccrualViewVO[] monthViewVos = UsufructAssetCalculator.collectDayDataToMonth(viewvos, PayScheduleCalculateHelper.completeDates(usufructVO), usufructVO);
            viewvos = (DepAccrualViewVO[])ArrayUtils.mergeArrays((Object[])viewvos, (Object[])monthViewVos);
        }
        return UsufructAssetCalculator.fillEffInterestRate(usufructVO, assetEntiretyVO, viewvos);
    }

    public static DepAccrualViewVO[] fillEffInterestRate(UsufructAssetViewVO usufructVO, AssetEntiretyVO assetEntiretyVO, DepAccrualViewVO ... viewvos) {
        String pk_card = usufructVO.getPk_card();
        if (pk_card != null) {
            try {
                Object[] assetVOs = ((IAsset)AMProxy.lookup(IAsset.class)).queryAssetVOBySQL(" pk_card = '" + pk_card + "'", new String[]{"bill_source"});
                if (ArrayUtils.isBlank((Object[])assetVOs)) {
                    return viewvos;
                }
                if (ArrayUtils.isNotBlank((Object[])assetVOs) && ("4A3A".equals(((AssetVO)assetVOs[0]).getBill_source()) || "36R2".equals(((AssetVO)assetVOs[0]).getBill_source()))) {
                    return viewvos;
                }
                Stream.of(viewvos).forEach(viewvo -> {
                    if (StringUtils.isBlank((CharSequence)viewvo.getEffective_interest_rate())) {
                        if (UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(usufructVO) && viewvo.getIsaccruedbymonth().booleanValue()) {
                            viewvo.setEffective_interest_rate(UsufructAssetCalculator.getEffectiveInterestRateStr(viewvo, usufructVO, true));
                        } else {
                            viewvo.setEffective_interest_rate(UsufructAssetCalculator.getEffectiveInterestRateStr(viewvo, usufructVO, false));
                        }
                    }
                });
                if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
                    UsufructAssetCalculator.handleUnFullEffectiveStr(usufructVO, viewvos);
                }
                return viewvos;
            }
            catch (BusinessException e) {
                ExceptionUtils.asBusinessRuntimeException((Throwable)e);
            }
        }
        Stream.of(viewvos).forEach(viewvo -> {
            if (StringUtils.isBlank((CharSequence)viewvo.getEffective_interest_rate()) && assetEntiretyVO != null) {
                if (UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(usufructVO) && viewvo.getIsaccruedbymonth().booleanValue()) {
                    viewvo.setEffective_interest_rate(UsufructAssetCalculator.getEffectiveInterestRateStr(viewvo, usufructVO, true));
                } else {
                    viewvo.setEffective_interest_rate(UsufructAssetCalculator.getEffectiveInterestRateStr(viewvo, usufructVO, false));
                }
            }
        });
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO) && assetEntiretyVO != null) {
            UsufructAssetCalculator.handleUnFullEffectiveStr(usufructVO, viewvos);
        }
        return viewvos;
    }

    public static void handleUnFullEffectiveStr(UsufructAssetViewVO usufructVO, DepAccrualViewVO ... viewvos) {
        UFDate fullcyclebegindate = usufructVO.getFullcyclebegindate();
        if (fullcyclebegindate == null) {
            fullcyclebegindate = usufructVO.getStarting_date();
        }
        UFDate fullcyclebegindate2 = fullcyclebegindate;
        Stream.of(viewvos).forEach(vo -> {
            if (vo.getBegin_date().beforeDate(fullcyclebegindate2)) {
                int day = UFDate.getDaysBetween((UFDate)vo.getBegin_date(), (UFDate)vo.getEnd_date()) + 1;
                BigDecimal realInterest = UsufructAssetCalculator.getRealInterestRate(vo, usufructVO, UFBoolean.FALSE);
                String str = day + NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0882");
                vo.setEffective_interest_rate(str + ":" + realInterest.setScale(8, 4));
            }
        });
    }

    public static DepAccrualViewVO[] collectDayDataToMonth(DepAccrualViewVO[] viewvos, List<UFDate> dates, UsufructAssetViewVO usufruct) {
        if (UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(usufruct)) {
            boolean tax_deductible = UFBoolean.TRUE.equals((Object)usufruct.getTax_deductible());
            ArrayList deps = Lists.newArrayList();
            UFDate curr_rentstart_date = dates.get(0);
            UFDate curr_ending_date = dates.get(1);
            UFDate curr_starting_month = curr_rentstart_date.getDateBefore(curr_rentstart_date.getDay() - 1);
            UFDate curr_ending_month = curr_ending_date.getDateAfter(UFDate.getDaysMonth((int)curr_ending_date.getYear(), (int)curr_ending_date.getMonth()) - curr_ending_date.getDay());
            LeaseTimeRuleVO leaseTimeRuleVO = new LeaseTimeRuleVO();
            leaseTimeRuleVO.setLeaseType(4);
            leaseTimeRuleVO.setType(9);
            leaseTimeRuleVO.setMonth(1);
            leaseTimeRuleVO.setDay(curr_starting_month.getDay());
            List subBeginDates = timeRuleCalculator.getDateRegions(curr_starting_month, curr_ending_month, leaseTimeRuleVO);
            int length = subBeginDates.size();
            for (int i = 0; i < length; ++i) {
                DepAccrualViewVO newViewVO = new DepAccrualViewVO();
                newViewVO.setBegin_date((UFDate)subBeginDates.get(i));
                if (i == 0) {
                    newViewVO.setBegin_date(curr_rentstart_date);
                }
                if (i == length - 1) {
                    newViewVO.setEnd_date(curr_ending_date);
                } else {
                    newViewVO.setEnd_date(UFDateUtils.getLastDayEndDate((UFDate)((UFDate)subBeginDates.get(i + 1))));
                }
                List tempDeps = Stream.of(viewvos).filter(o -> {
                    UFDate day_date = o.getDay_date();
                    UFDate lastDayFromBeginDate = UFDateUtils.getLastDayEndDate((UFDate)newViewVO.getBegin_date());
                    UFDate afterDayFromEndDate = UFDateUtils.getAfterDayBeginDate((UFDate)newViewVO.getEnd_date());
                    return day_date.afterDate(lastDayFromBeginDate) && day_date.beforeDate(afterDayFromEndDate);
                }).collect(Collectors.toList());
                BigDecimal monthRate = BigDecimal.ZERO;
                for (DepAccrualViewVO tempDep : tempDeps) {
                    String str1;
                    String str;
                    String str2;
                    if (tempDep.getRate() != null) {
                        monthRate = tempDep.getRate();
                        continue;
                    }
                    if (tempDep.getEffective_interest_rate() == null || !StringUtils.isNotBlank((CharSequence)(str2 = (str = tempDep.getEffective_interest_rate()).substring((str1 = str.substring(0, str.indexOf(":"))).length() + 1, str.length())))) continue;
                    monthRate = new BigDecimal(str2).divide(new BigDecimal(100));
                }
                if (tempDeps.size() <= 0) continue;
                newViewVO.setRate(monthRate);
                newViewVO.setBegin_liability(((DepAccrualViewVO)((Object)tempDeps.get(0))).getBegin_liability());
                newViewVO.setEnd_liability(((DepAccrualViewVO)((Object)tempDeps.get(tempDeps.size() - 1))).getEnd_liability());
                double sum = tempDeps.stream().mapToDouble(vo -> vo.getInterest().doubleValue()).sum();
                newViewVO.setInterest(new UFDouble(sum));
                newViewVO.setIsaccruedbymonth(UFBoolean.TRUE);
                newViewVO.setStatus(2);
                double calculate_renttax = tempDeps.stream().mapToDouble(vo -> vo.getCalculate_renttax().doubleValue()).sum();
                newViewVO.setCalculate_renttax(new UFDouble(calculate_renttax));
                double calculate_rentnotax = tempDeps.stream().mapToDouble(vo -> vo.getCalculate_rentnotax().doubleValue()).sum();
                newViewVO.setCalculate_rentnotax(new UFDouble(calculate_rentnotax));
                newViewVO.setCalculate_rentnotax(new UFDouble(calculate_rentnotax));
                double calc_cash = tax_deductible ? calculate_rentnotax : calculate_renttax;
                newViewVO.setCalc_cash(new UFDouble(calc_cash));
                deps.add(newViewVO);
            }
            return deps.toArray(new DepAccrualViewVO[0]);
        }
        return null;
    }

    public static String getEffectiveInterestRateStr(DepAccrualViewVO viewvo, UsufructAssetViewVO usufructVO, boolean isDayToMonth) {
        Object resultStr = "";
        BigDecimal interestRate = BigDecimal.ZERO;
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
            String month = usufructVO.getRent_way();
            interestRate = UsufructAssetCalculator.getRealInterestRate(viewvo, usufructVO, UFBoolean.TRUE);
            resultStr = (String)resultStr + ("1".equals(month) ? "" : month) + "02012005-0883";
        } else {
            interestRate = UsufructAssetCalculator.getRealInterestRate(viewvo, usufructVO, null);
            if (UsufructAssetEnumJudge.isDiscountModeMonth(usufructVO)) {
                resultStr = (String)resultStr + "02012005-0883";
            } else if (UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(usufructVO)) {
                resultStr = (String)resultStr + "02012005-0882";
            }
            if (isDayToMonth) {
                resultStr = "02012005-0882";
                if (viewvo.getRate() != null) {
                    interestRate = viewvo.getRate().multiply(new BigDecimal(100));
                }
            }
        }
        return (String)resultStr + ":" + interestRate.setScale(8, 4);
    }

    private static BigDecimal getRealInterestRate(DepAccrualViewVO viewvo, UsufructAssetViewVO usufructVO, UFBoolean isFullcycle) {
        BigDecimal effectiveInterestRate = BigDecimal.ZERO;
        int day = UFDate.getDaysBetween((UFDate)viewvo.getBegin_date(), (UFDate)viewvo.getEnd_date()) + 1;
        int month = UFDateUtils.countMonth((UFDate)viewvo.getBegin_date(), (UFDate)viewvo.getEnd_date());
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(usufructVO)) {
            month = Integer.valueOf(usufructVO.getRent_way());
        }
        if (isFullcycle != null && isFullcycle.booleanValue()) {
            effectiveInterestRate = usufructVO.getMonthdaycalmode().intValue() == MonthDayCalMode.averageinterest.toIntValue() ? MathUtils.div((BigDecimal)MathUtils.multiply((UFDouble)usufructVO.getInterest_rate(), (BigDecimal)BigDecimal.valueOf(month)), (BigDecimal)BigDecimal.valueOf(12L)) : MathUtils.sub((double)Math.pow(MathUtils.add((BigDecimal)BigDecimal.ONE, (UFDouble)usufructVO.getInterest_rate()).doubleValue(), MathUtils.div((BigDecimal)BigDecimal.valueOf(month), (BigDecimal)new BigDecimal(12)).doubleValue()), (double)1.0);
            return effectiveInterestRate;
        }
        if (usufructVO.getMonthdaycalmode().intValue() == MonthDayCalMode.averageinterest.toIntValue()) {
            if (usufructVO.getInterest_base() == 5 || usufructVO.getInterest_base() == 3) {
                effectiveInterestRate = MathUtils.div((BigDecimal)MathUtils.multiply((UFDouble)usufructVO.getInterest_rate(), (BigDecimal)BigDecimal.valueOf(day)), (BigDecimal)BigDecimal.valueOf(360L));
            } else if (usufructVO.getInterest_base() == 4 || usufructVO.getInterest_base() == 2) {
                effectiveInterestRate = MathUtils.div((BigDecimal)MathUtils.multiply((UFDouble)usufructVO.getInterest_rate(), (BigDecimal)BigDecimal.valueOf(day)), (BigDecimal)BigDecimal.valueOf(365L));
            } else if (usufructVO.getInterest_base() == 1) {
                effectiveInterestRate = MathUtils.div((BigDecimal)MathUtils.multiply((UFDouble)usufructVO.getInterest_rate(), (BigDecimal)BigDecimal.valueOf(month)), (BigDecimal)BigDecimal.valueOf(12L));
            }
        } else if (usufructVO.getInterest_base() == 5 || usufructVO.getInterest_base() == 3) {
            effectiveInterestRate = MathUtils.sub((double)Math.pow(MathUtils.add((BigDecimal)BigDecimal.ONE, (UFDouble)usufructVO.getInterest_rate()).doubleValue(), MathUtils.div((BigDecimal)BigDecimal.valueOf(day), (BigDecimal)new BigDecimal(360)).doubleValue()), (double)1.0);
        } else if (usufructVO.getInterest_base() == 4 || usufructVO.getInterest_base() == 2) {
            effectiveInterestRate = MathUtils.sub((double)Math.pow(MathUtils.add((BigDecimal)BigDecimal.ONE, (UFDouble)usufructVO.getInterest_rate()).doubleValue(), MathUtils.div((BigDecimal)BigDecimal.valueOf(day), (BigDecimal)new BigDecimal(365)).doubleValue()), (double)1.0);
        } else if (usufructVO.getInterest_base() == 1) {
            effectiveInterestRate = MathUtils.sub((double)Math.pow(MathUtils.add((BigDecimal)BigDecimal.ONE, (UFDouble)usufructVO.getInterest_rate()).doubleValue(), MathUtils.div((BigDecimal)BigDecimal.valueOf(month), (BigDecimal)new BigDecimal(12)).doubleValue()), (double)1.0);
        }
        return effectiveInterestRate;
    }

    public static void fixupCohesionProcess(UsufructAssetViewVO usufruct) {
        UFDate retrospective_date = usufruct.getRetrospective_date();
        if (retrospective_date == null) {
            retrospective_date = new UFDate("2021-01-01 00:00:00");
            usufruct.setRetrospective_date(retrospective_date);
        }
        retrospective_date = retrospective_date.asEnd();
        UFDate ending_date = PayScheduleCalculateHelper.getMaxEndDate(usufruct);
        if (ending_date.beforeDate(retrospective_date)) {
            usufruct.setCohesion_process(CohesionProcessEnum.RETROSPECTIVE_ADJUSTMENT.toIntValue());
        }
    }

    public static LogChangeRecordVO insertLogChangeRecordVO(AssetEntiretyVO assetEntiretyVO, Map<String, Object> userjson) throws BusinessException {
        UsufructAssetViewVO usufruct = assetEntiretyVO.getUsufructAssetViewVO();
        Map map = AssetFieldConst.LOGCHANGECONTENT;
        StringBuilder changeContent = new StringBuilder();
        String result = null;
        CardVO cardVO = assetEntiretyVO.getCardVO();
        String pk_currency = cardVO.getPk_currency();
        for (Map.Entry<String, Object> entry : userjson.entrySet()) {
            String key = entry.getKey();
            if ("steprentStandardData".equals(key)) {
                changeContent.append((String)map.get(key) + ";");
                continue;
            }
            Map value = (Map)entry.getValue();
            Object newValue = value.get("newValue");
            Object oldValue = value.get("oldValue");
            if ("rent_standard".equals(key) || "purchase_price".equals(key)) {
                if (newValue instanceof String) {
                    String s = (String)newValue;
                    newValue = ScaleUtils.setScaleByCurrType((UFDouble)new UFDouble(s), (String)pk_currency, (boolean)false);
                } else if (newValue instanceof Double) {
                    Double d = (Double)newValue;
                    newValue = ScaleUtils.setScaleByCurrType((UFDouble)new UFDouble(d), (String)pk_currency, (boolean)false);
                }
            }
            if ("ending_date".equals(key) || "relet_ending_date".equals(key)) {
                newValue = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)newValue}) ? UFDate.getDate((String)((String)newValue)).toLocalString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
                oldValue = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)oldValue}) ? UFDate.getDate((String)((String)oldValue)).toLocalString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if ("change_start_date".equals(key)) {
                newValue = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)newValue}) ? UFDate.getDate((String)((String)newValue)).toLocalString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
                oldValue = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if ("interest_rate".equals(key) || "tax_rate".equals(key)) {
                oldValue = ScaleUtils.setScale((UFDouble)new UFDouble((String)oldValue), (int)2, (int)4);
                newValue = ScaleUtils.setScale((UFDouble)new UFDouble((String)newValue), (int)2, (int)4);
            }
            if ("tax_code".equals(key)) {
                oldValue = UsufructAssetCalculator.taxCode((String)oldValue);
                newValue = UsufructAssetCalculator.taxCode((String)newValue);
            }
            if (oldValue == null) {
                oldValue = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if (newValue == null) {
                newValue = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if ("change_start_date".equals(key)) {
                changeContent.append((String)map.get(key) + ":").append(newValue).append(";");
                continue;
            }
            changeContent.append((String)map.get(key) + ",").append("02012005-0731:").append(oldValue).append(",").append("02012005-0732:").append(newValue).append(";");
        }
        if (changeContent.length() > 0) {
            result = changeContent.substring(0, changeContent.length() - 1);
            result = result.replace("true", "Y").replace("false", "N");
        }
        LogChangeRecordVO vo = new LogChangeRecordVO();
        vo.setPk_card(usufruct.getPk_card());
        vo.setEffective_period(usufruct.getChange_date());
        vo.setChange_period(UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(usufruct.getPk_card()).getChangeDate());
        vo.setChange_content(result);
        DBAccessUtil dbUtil = new DBAccessUtil();
        dbUtil.getBaseDAO().insertVO((SuperVO)vo);
        vo.setPk_bill_src(vo.getPk_logchangerecord());
        dbUtil.getBaseDAO().updateVO((SuperVO)vo);
        return vo;
    }

    public static LogChangeRecordVO getLogChangeRecordVOForAlter(AssetEntiretyVO assetEntiretyVO, Map<String, Object> userjson) throws BusinessException {
        UsufructAssetViewVO usufruct = assetEntiretyVO.getUsufructAssetViewVO();
        Map map = AssetFieldConst.LOGCHANGECONTENT;
        StringBuilder changeContent = new StringBuilder();
        String result = null;
        CardVO cardVO = assetEntiretyVO.getCardVO();
        String pk_currency = cardVO.getPk_currency();
        for (Map.Entry<String, Object> entry : userjson.entrySet()) {
            String key = entry.getKey();
            if ("needValidateBill".equals(key) || "pk_bill_src".equals(key) || "transi_type".equals(key)) continue;
            if ("steprentStandardData".equals(key)) {
                changeContent.append((String)map.get(key) + ";");
                continue;
            }
            Map value = (Map)entry.getValue();
            Object newValue = value.get("newValue");
            Object oldValue = value.get("oldValue");
            if ("rent_standard".equals(key) || "purchase_price".equals(key)) {
                if (newValue instanceof String) {
                    String s = (String)newValue;
                    newValue = ScaleUtils.setScaleByCurrType((UFDouble)new UFDouble(s), (String)pk_currency, (boolean)false);
                } else if (newValue instanceof Double) {
                    Double d = (Double)newValue;
                    newValue = ScaleUtils.setScaleByCurrType((UFDouble)new UFDouble(d), (String)pk_currency, (boolean)false);
                }
            }
            if ("ending_date".equals(key) || "relet_ending_date".equals(key)) {
                newValue = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)newValue}) ? UFDate.getDate((String)((String)newValue)).toLocalString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
                oldValue = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)oldValue}) ? UFDate.getDate((String)((String)oldValue)).toLocalString() : NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if ("interest_rate".equals(key) || "tax_rate".equals(key)) {
                oldValue = ScaleUtils.setScale((UFDouble)new UFDouble((String)oldValue), (int)2, (int)4);
                newValue = ScaleUtils.setScale((UFDouble)new UFDouble((String)newValue), (int)2, (int)4);
            }
            if ("tax_code".equals(key)) {
                oldValue = UsufructAssetCalculator.taxCode((String)oldValue);
                newValue = UsufructAssetCalculator.taxCode((String)newValue);
            }
            if (oldValue == null) {
                oldValue = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            if (newValue == null) {
                newValue = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0781");
            }
            changeContent.append((String)map.get(key) + ",").append("02012005-0731:").append(oldValue).append(",").append("02012005-0732:").append(newValue).append(";");
        }
        if (changeContent.length() > 0) {
            result = changeContent.substring(0, changeContent.length() - 1);
            result = result.replace("true", "Y").replace("false", "N");
        }
        LogChangeRecordVO vo = new LogChangeRecordVO();
        vo.setPk_card(usufruct.getPk_card());
        vo.setEffective_period(usufruct.getChange_date());
        vo.setChange_period(UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(usufruct.getPk_card()).getChangeDate());
        vo.setChange_content(result);
        return vo;
    }

    private static String taxCode(String pk_taxcode) throws BusinessException {
        if (pk_taxcode == null) {
            return null;
        }
        Object[] taxcodes = ((ITaxcodeQueryService)AMProxy.lookup(ITaxcodeQueryService.class)).getTaxcodeVOsByCond(" isnull(dr,0) = 0 and pk_taxcode='" + pk_taxcode + "'");
        if (ArrayUtils.isEmpty((Object[])taxcodes)) {
            return null;
        }
        String description = MultiLanguageUtil.getMultiLanguageValue((SuperVO)taxcodes[0], (String)"description");
        return description;
    }

    static LeaseTimeRuleVO getLeaseTimeRuleVO(UsufructAssetViewVO usufructVO, CardVO cardVO) {
        if ("4A3A".equals(cardVO.getBill_source())) {
            try {
                return ((IContractInService)AMProxy.lookup(IContractInService.class)).queryContractInRentTypeByPk(new String[]{cardVO.getPk_bill_b_src()});
            }
            catch (BusinessException e) {
                throw ExceptionUtils.businessRuntimeException((Throwable)e);
            }
        }
        UFBoolean step_lease_flag = usufructVO.getStep_lease_flag();
        if (UFBoolean.TRUE.equals((Object)step_lease_flag)) {
            LeaseTimeRuleVO ruleVO = new LeaseTimeRuleVO();
            ruleVO.setType(10);
            ruleVO.setLeaseType(5);
            return ruleVO;
        }
        String rent_way_month = usufructVO.getRent_way();
        LeaseTimeRuleVO ruleVO = new LeaseTimeRuleVO();
        UFDate fullcyclebegindate = PayScheduleCalculateHelper.getFullcyclebegindate(usufructVO);
        try {
            ruleVO.setType(9);
            ruleVO.setLeaseType(4);
            ruleVO.setMonth(Integer.valueOf(rent_way_month).intValue());
            ruleVO.setDay(fullcyclebegindate.getDay());
            return ruleVO;
        }
        catch (NumberFormatException nfe) {
            throw ExceptionUtils.businessRuntimeException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0796", null, new String[]{rent_way_month}));
        }
    }

    public static void setBeginLiability(UFDouble begin_liability, BeginLiabilityEnum beginLiabilityEnum, UsufructAssetViewVO usufruct) {
        UsufructAssetCalculatorVO usufructAssetCalculatorVO = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(usufruct.getPk_card());
        if (beginLiabilityEnum.isOld()) {
            usufructAssetCalculatorVO.setOldBeginLiability(begin_liability);
        } else {
            usufructAssetCalculatorVO.setNewBeginLiability(begin_liability);
        }
    }

    public static UFDouble getBeginLiability(BeginLiabilityEnum beginLiabilityEnum, String pk_card) {
        UsufructAssetCalculatorVO usufructAssetCalculatorVO = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(pk_card);
        return beginLiabilityEnum.isOld() ? usufructAssetCalculatorVO.getOldBeginLiability() : usufructAssetCalculatorVO.getNewBeginLiability();
    }

    public static void filterHistroy(AssetEntiretyVO assetEntiretyVO) {
        CardhistoryVO[] currHistories = assetEntiretyVO.getCardhistoryVOs();
        ArrayList usingCardhistories = Lists.newArrayList();
        for (CardhistoryVO vo : currHistories) {
            String asset_state = vo.getAsset_state();
            if (!"exist".equals(asset_state)) continue;
            usingCardhistories.add(vo);
        }
        assetEntiretyVO.setCardhistoryVOs(usingCardhistories.toArray(new CardhistoryVO[0]));
    }
}

