/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.bs.logging.Logger;
import nc.pub.fa.asset.manager.UsufructAssetCheckStatusEnum;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.card.CardTabConst;
import nc.vo.ali.newlease.constant.CalKeysConst;
import nc.vo.am.common.newlease.ContractRentPubVO;
import nc.vo.am.common.newlease.NewLeaseCalculateVO;
import nc.vo.am.common.newlease.PaySchedulePubVO;
import nc.vo.am.common.newlease.RentSubsectionVO;
import nc.vo.am.common.newlease.utils.CalculateRentUtils;
import nc.vo.am.common.util.CloneUtil;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.scale.query.ScaleUtils;
import nc.vo.am.timerule.LeaseTimeRuleVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.RentTypeEnum;
import nc.vo.fa.asset.StepRentStandardViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;

public class PayScheduleCalculator {
    private final RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs;
    private final UsufructAssetCheckStatusEnum usufructAssetCheckStatusEnum;
    private final AssetEntiretyVO addAssetEntiretyVO;
    private final UsufructAssetViewVO addUsufructVO;
    private final String pk_card;
    private final CardVO addCardVO;
    private final String pk_currency;
    private final boolean bill_source_from_ali;
    private final List<UFDate> dates;
    private final boolean step_lease_flag;
    private final boolean rent_split_flag;
    private boolean calc_pay_advance_flag;
    private UFDate retrospective_date;
    private boolean change_to_step_lease_flag;
    private UFDate change_start_date;

    public PayScheduleCalculator(RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs, AssetEntiretyVO addAssetEntiretyVO, List<UFDate> dates, UsufructAssetCheckStatusEnum usufructAssetCheckStatusEnum) {
        this.tempOldRentPaymentPlanVOs = tempOldRentPaymentPlanVOs;
        this.usufructAssetCheckStatusEnum = usufructAssetCheckStatusEnum;
        this.addAssetEntiretyVO = addAssetEntiretyVO;
        this.addUsufructVO = addAssetEntiretyVO.getUsufructAssetViewVO();
        this.pk_card = this.addUsufructVO.getPk_card();
        this.addCardVO = addAssetEntiretyVO.getCardVO();
        this.pk_currency = this.addCardVO.getPk_currency();
        this.bill_source_from_ali = "4A3A".equals(this.addCardVO.getBill_source());
        this.dates = dates;
        this.step_lease_flag = UFBoolean.TRUE.equals((Object)this.addUsufructVO.getStep_lease_flag());
        this.rent_split_flag = UFBoolean.TRUE.equals((Object)this.addUsufructVO.getRent_split_flag());
        this.calc_pay_advance_flag = UFBoolean.TRUE.equals((Object)this.addUsufructVO.getPay_advance_flag());
        this.retrospective_date = this.addUsufructVO.getRetrospective_date();
        if (this.retrospective_date == null) {
            this.retrospective_date = new UFDate("2021-01-01 00:00:00");
        }
        this.change_to_step_lease_flag = false;
    }

    public RentPaymentPlanViewVO[] calc() throws BusinessException {
        this.configure();
        LinkedList<PaySchedulePubVO> payvos = this.calcPaymentPlan();
        this.deleteInvalidPay(payvos);
        this.calculateRentAdvanceFlag4simpleRetrospectiveAdjustment(payvos);
        payvos.stream().filter(payvo -> UFDoubleUtils.isNullOrZero((UFDouble)payvo.getTax_rate())).forEach(payvo -> payvo.setTax_rate(this.addUsufructVO.getTax_rate()));
        this.appendRentAdvance(payvos);
        this.appendPurchaseChoice(payvos);
        return payvos.toArray(new RentPaymentPlanViewVO[0]);
    }

    private void deleteInvalidPay(LinkedList<PaySchedulePubVO> payvos) {
        if (!UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO)) {
            return;
        }
        Iterator it = payvos.iterator();
        while (it.hasNext()) {
            PaySchedulePubVO pay = (PaySchedulePubVO)it.next();
            UFDate end_date = pay.getEnd_date();
            if (end_date.beforeDate(this.retrospective_date)) {
                it.remove();
                continue;
            }
            UFDate start_date = pay.getStart_date();
            if (!start_date.beforeDate(this.retrospective_date) && !start_date.isSameDate(this.retrospective_date) || !end_date.afterDate(this.retrospective_date) && !end_date.isSameDate(this.retrospective_date)) continue;
            pay.setStart_date(this.retrospective_date.asBegin());
            if (!this.rent_split_flag) continue;
            UFDouble splitRenttax = this.addUsufructVO.getSplit_renttax();
            pay.setCalculate_renttax(splitRenttax);
            CalculateRentUtils.calcTax((PaySchedulePubVO)pay, (UFDouble)splitRenttax);
        }
    }

    private LinkedList<PaySchedulePubVO> calcPaymentPlan() throws BusinessException {
        NewLeaseCalculateVO leaseCalculateVO = new NewLeaseCalculateVOBuilder(this.addAssetEntiretyVO, this.dates).build();
        List<PaySchedulePubVO> paySchedulePubVOs = null;
        paySchedulePubVOs = this.step_lease_flag ? this.calcRentPaymentPlanForStepLease(leaseCalculateVO) : this.calcRentPaymentPlan(leaseCalculateVO);
        Collections.sort(paySchedulePubVOs);
        return Lists.newLinkedList(paySchedulePubVOs);
    }

    private void configure() {
        PayScheduleCalculator.calcSplitRentNotax(this.addUsufructVO);
    }

    public static void calcSplitRentNotax(UsufructAssetViewVO usufructVO) {
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(usufructVO) && UFBoolean.TRUE.equals((Object)usufructVO.getRent_split_flag())) {
            UFDouble tax_rate = usufructVO.getTax_rate();
            UFDouble split_renttax = usufructVO.getSplit_renttax();
            UFDouble tax = CalculateRentUtils.getTax((UFDouble)tax_rate, (UFDouble)split_renttax);
            usufructVO.setSplit_tax(tax);
            usufructVO.setSplit_rentnotax(UFDoubleUtils.sub((UFDouble)split_renttax, (UFDouble)tax));
        } else {
            usufructVO.setSplit_renttax(null);
        }
    }

    private void calculateRentAdvanceFlag4simpleRetrospectiveAdjustment(LinkedList<PaySchedulePubVO> payvos) {
        if (UsufructAssetCheckStatusEnum.LEASE_CHANGE == this.usufructAssetCheckStatusEnum) {
            return;
        }
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO)) {
            UFDate end_date;
            UFDate rentstart_date = this.addUsufructVO.getRentstart_date();
            UFDate starting_date = this.addUsufructVO.getStarting_date();
            Optional<Object> findFirst = Optional.empty();
            if (rentstart_date.isSameDate(starting_date)) {
                findFirst = Optional.of(payvos.get(0));
            } else if (payvos.size() > 1) {
                findFirst = Optional.of(payvos.get(1));
            }
            if (findFirst.isPresent() && (end_date = ((PaySchedulePubVO)findFirst.get()).getEnd_date()).beforeDate(this.retrospective_date)) {
                this.calc_pay_advance_flag = false;
            }
        }
    }

    private void appendRentAdvance(LinkedList<PaySchedulePubVO> payvos) {
        if (this.calc_pay_advance_flag) {
            if (UsufructAssetCheckStatusEnum.LEASE_CHANGE == this.usufructAssetCheckStatusEnum) {
                if (this.tempOldRentPaymentPlanVOs[0].getStatus() == 3 || this.tempOldRentPaymentPlanVOs[1].getStatus() == 3) {
                    this.tempOldRentPaymentPlanVOs[0].setStatus(3);
                    this.addRentAdvance(payvos);
                }
            } else {
                this.addRentAdvance(payvos);
            }
        }
    }

    private void appendPurchaseChoice(List<? super PaySchedulePubVO> payvos) {
        CardVO cardVO = this.addAssetEntiretyVO.getCardVO();
        if (!UFBoolean.TRUE.equals((Object)this.addUsufructVO.getPurchase_choice())) {
            return;
        }
        RentPaymentPlanViewVO payvo = new RentPaymentPlanViewVO();
        UFDate end_date = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
        payvo.setStart_date(end_date.asLocalBegin());
        payvo.setEnd_date(end_date);
        payvo.setTax_rate(this.addUsufructVO.getTax_rate());
        payvo.setCalculate_renttax(PayScheduleCalculateHelper.getPurchasePrice(this.addUsufructVO));
        payvo.setAdjustment_renttax(PayScheduleCalculateHelper.getPurchasePrice(this.addUsufructVO));
        if (this.bill_source_from_ali) {
            payvo.setAdjustment_renttax(UFDouble.ZERO_DBL);
            payvo.setAdjustment_tax(UFDouble.ZERO_DBL);
            payvo.setAdjustment_rentnotax(UFDouble.ZERO_DBL);
        }
        payvo.setCalculate_tax(CalculateRentUtils.getTax((UFDouble)payvo.getTax_rate(), (UFDouble)payvo.getCalculate_renttax()));
        this.recalculateScaleForRent(cardVO.getPk_currency(), payvo);
        payvo.setAmount_type(RentTypeEnum.rent_buy.toIntValue());
        payvo.setNoCalculate(UFBoolean.FALSE);
        payvo.setStatus(2);
        payvo.setTax_deductible(this.addUsufructVO.getTax_deductible());
        payvos.add(payvo);
    }

    private void addRentAdvance(LinkedList<PaySchedulePubVO> paymentPlans) {
        int i;
        UFDate rentstart_date = this.addUsufructVO.getRentstart_date();
        UFDate starting_date = this.addUsufructVO.getStarting_date();
        Optional<Object> findFirst = Optional.empty();
        if (rentstart_date.isSameDate(starting_date)) {
            findFirst = Optional.of(paymentPlans.get(0));
        } else if (paymentPlans.size() > 1) {
            findFirst = Optional.of(paymentPlans.get(1));
        }
        if (!findFirst.isPresent()) {
            return;
        }
        PaySchedulePubVO pay = (PaySchedulePubVO)findFirst.get();
        PaySchedulePubVO newPaln = (PaySchedulePubVO)CloneUtil.clone((Object)pay);
        newPaln.setAmount_type(Integer.valueOf(RentTypeEnum.rent_advance.toIntValue()));
        newPaln.setStart_date(paymentPlans.get(0).getStart_date());
        newPaln.setEnd_date(paymentPlans.get(0).getStart_date().asLocalEnd());
        newPaln.setStatus(2);
        for (i = 0; i < CalKeysConst.CALCCALKEYS.length; ++i) {
            pay.setAttributeValue(CalKeysConst.CALCCALKEYS[i], (Object)UFDouble.ZERO_DBL);
        }
        for (i = 0; i < CalKeysConst.CALCADJUSTKEYS.length; ++i) {
            pay.setAttributeValue(CalKeysConst.CALCADJUSTKEYS[i], (Object)UFDouble.ZERO_DBL);
        }
        pay.setTax_deductible(this.addUsufructVO.getTax_deductible());
        paymentPlans.addFirst(newPaln);
    }

    private List<PaySchedulePubVO> calcRentPaymentPlanForStepLease(NewLeaseCalculateVO leaseCalcVO) {
        if (this.change_to_step_lease_flag) {
            CalculateRentUtils.splitSubVOForStepLease2((NewLeaseCalculateVO)leaseCalcVO);
        } else {
            CalculateRentUtils.splitSubVOForStepLease((NewLeaseCalculateVO)leaseCalcVO);
        }
        if (this.change_to_step_lease_flag) {
            this.handleStepLease(leaseCalcVO);
            this.fillStepLease(leaseCalcVO);
        }
        CalculateRentUtils.calculateForStepLease((NewLeaseCalculateVO)leaseCalcVO);
        PaySchedulePubVO paySchedulePubVO = null;
        if (leaseCalcVO.getPayType() != null) {
            try {
                paySchedulePubVO = (PaySchedulePubVO)leaseCalcVO.getPayType().newInstance();
            }
            catch (Exception e) {
                paySchedulePubVO = new PaySchedulePubVO();
                Logger.info((Object)e.getMessage());
            }
        } else {
            paySchedulePubVO = new PaySchedulePubVO();
        }
        List rentSubVOs = leaseCalcVO.getRentSubVOs();
        ArrayList list = Lists.newArrayList();
        for (RentSubsectionVO rentSubVO : rentSubVOs) {
            PaySchedulePubVO vo = (PaySchedulePubVO)CloneUtil.clone((Object)paySchedulePubVO);
            CalculateRentUtils.runChangeSubVO2DetailVO((RentSubsectionVO)rentSubVO, (PaySchedulePubVO)vo);
            list.add(vo);
        }
        String pk_currency_origin = leaseCalcVO.getPk_currency_origin();
        for (PaySchedulePubVO payvo : list) {
            this.recalculateScaleForRent(pk_currency_origin, payvo);
        }
        return list;
    }

    private void fillStepLease(NewLeaseCalculateVO leaseCalcVO) {
        List rentSubVOs = leaseCalcVO.getRentSubVOs();
        Object firstVO = rentSubVOs.get(0);
        if (firstVO instanceof RentSubsectionVO) {
            RentSubsectionVO renSubvo = (RentSubsectionVO)firstVO;
            UFDate sub_begin_date = renSubvo.getSub_begin_date();
            List list = Stream.of(this.tempOldRentPaymentPlanVOs).filter(vo -> vo.getStart_date().beforeDate(sub_begin_date)).filter(vo -> vo.getEnd_date().afterDate(sub_begin_date)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                RentSubsectionVO rentVO = leaseCalcVO.getRentSubVO();
                rentVO.setAmount_type(Integer.valueOf(1));
                RentSubsectionVO newSubVO = (RentSubsectionVO)CloneUtil.clone((Object)rentVO);
                newSubVO.setSubsection_type("full_period");
                newSubVO.setPeriod_num(Integer.valueOf(0));
                newSubVO.setNoCalculate(UFBoolean.FALSE);
                newSubVO.setSub_begin_date(((RentPaymentPlanViewVO)((Object)list.get(0))).getStart_date());
                newSubVO.setSub_end_date(sub_begin_date.getDateBefore(1));
                newSubVO.setPre_rent(((RentPaymentPlanViewVO)((Object)list.get(0))).getAdjustment_renttax());
                newSubVO.setPlan_pay_date(renSubvo.getPlan_pay_date());
                for (Object rentSubVO : rentSubVOs) {
                    RentSubsectionVO rentSubVo = (RentSubsectionVO)rentSubVO;
                    rentSubVo.setPeriod_num(Integer.valueOf(rentSubVo.getPeriod_num() + 1));
                }
                rentSubVOs.add(0, newSubVO);
            }
        }
    }

    private void handleStepLease(NewLeaseCalculateVO leaseCalcVO) {
        List rentSubVOs = leaseCalcVO.getRentSubVOs();
        Object firstVO = rentSubVOs.get(0);
        if (firstVO instanceof RentSubsectionVO) {
            for (Object rentSubVO : rentSubVOs) {
                RentSubsectionVO rentVO = (RentSubsectionVO)rentSubVO;
                if (this.change_start_date == null || !rentVO.getSub_end_date().beforeDate(this.change_start_date)) continue;
                List list = Stream.of(this.tempOldRentPaymentPlanVOs).filter(vo -> !(!vo.getStart_date().beforeDate(rentVO.getSub_begin_date()) && !vo.getStart_date().isSameDate(rentVO.getSub_begin_date()) || !vo.getEnd_date().afterDate(rentVO.getSub_begin_date()) && !vo.getEnd_date().isSameDate(rentVO.getSub_begin_date()))).collect(Collectors.toList());
                rentVO.setPre_rent(((RentPaymentPlanViewVO)((Object)list.get(0))).getAdjustment_renttax());
            }
        }
    }

    private List<PaySchedulePubVO> calcRentPaymentPlan(NewLeaseCalculateVO leaseCalcVO) {
        if (this.change_to_step_lease_flag) {
            this.handleRentSubVO(leaseCalcVO.getRentSubVO());
        }
        List rentSubVOs = CalculateRentUtils.splitSubVOForRentTypeEnum((RentSubsectionVO)leaseCalcVO.getRentSubVO());
        leaseCalcVO.setRentSubVOs(rentSubVOs);
        CalculateRentUtils.calculate((NewLeaseCalculateVO)leaseCalcVO);
        PaySchedulePubVO paySchedulePubVO = null;
        if (leaseCalcVO.getPayType() != null) {
            try {
                paySchedulePubVO = (PaySchedulePubVO)leaseCalcVO.getPayType().newInstance();
            }
            catch (Exception e) {
                paySchedulePubVO = new PaySchedulePubVO();
                Logger.info((Object)e.getMessage());
            }
        } else {
            paySchedulePubVO = new PaySchedulePubVO();
        }
        ArrayList list = Lists.newArrayList();
        for (Object rentSubVO : rentSubVOs) {
            PaySchedulePubVO vo = (PaySchedulePubVO)CloneUtil.clone((Object)paySchedulePubVO);
            CalculateRentUtils.runChangeSubVO2DetailVO((RentSubsectionVO)rentSubVO, (PaySchedulePubVO)vo);
            list.add(vo);
        }
        String pk_currency_origin = leaseCalcVO.getPk_currency_origin();
        for (PaySchedulePubVO payvo : list) {
            this.recalculateScaleForRent(pk_currency_origin, payvo);
        }
        RentSubsectionVO leaseTimeVO = leaseCalcVO.getRentSubVO();
        UFDate full_start_date = leaseTimeVO.getFull_start_date();
        UFDate start_pay_date = leaseTimeVO.getStart_pay_date();
        if (start_pay_date.beforeDate(full_start_date)) {
            for (PaySchedulePubVO sub : list) {
                UFDate start_date = sub.getStart_date();
                if (!start_date.isSameDate(start_pay_date)) continue;
                sub.setSubsection_type("not_full_period");
                break;
            }
        }
        return list;
    }

    private void handleRentSubVO(RentSubsectionVO rentVO) {
        LeaseTimeRuleVO ruleVO = rentVO.getRuleVO();
        UFDate beginDate = rentVO.getSub_begin_date().asBegin();
        ruleVO.setDay(beginDate.getDay());
    }

    private void recalculateScaleForRent(String pk_currency_origin, PaySchedulePubVO payvo) {
        UFDouble calculate_renttax = payvo.getCalculate_renttax();
        UFDouble calculate_tax = payvo.getCalculate_tax();
        calculate_renttax = ScaleUtils.setScaleByCurrType((UFDouble)calculate_renttax, (String)pk_currency_origin, (boolean)false);
        calculate_tax = ScaleUtils.setScaleByCurrType((UFDouble)calculate_tax, (String)pk_currency_origin, (boolean)false);
        payvo.setCalculate_renttax(calculate_renttax);
        payvo.setCalculate_tax(calculate_tax);
        payvo.setCalculate_rentnotax(UFDoubleUtils.sub((UFDouble)calculate_renttax, (UFDouble)calculate_tax));
        payvo.setAdjustment_renttax(calculate_renttax);
        payvo.setAdjustment_tax(calculate_tax);
        payvo.setAdjustment_rentnotax(UFDoubleUtils.sub((UFDouble)calculate_renttax, (UFDouble)calculate_tax));
        if (this.bill_source_from_ali) {
            payvo.setAdjustment_renttax(UFDouble.ZERO_DBL);
            payvo.setAdjustment_tax(UFDouble.ZERO_DBL);
            payvo.setAdjustment_rentnotax(UFDouble.ZERO_DBL);
        }
    }

    public boolean isChange_to_step_lease_flag() {
        return this.change_to_step_lease_flag;
    }

    public void setChange_to_step_lease_flag(boolean change_to_step_lease_flag) {
        this.change_to_step_lease_flag = change_to_step_lease_flag;
    }

    public UFDate getChange_start_date() {
        return this.change_start_date;
    }

    public void setChange_start_date(UFDate change_start_date) {
        this.change_start_date = change_start_date;
    }

    private static class NewLeaseCalculateVOBuilder {
        private AssetEntiretyVO addAssetEntiretyVO;
        private UsufructAssetViewVO addUsufructVO;
        private CardVO addCardVO;
        private String pk_currency;
        private List<UFDate> dates;

        public NewLeaseCalculateVOBuilder(AssetEntiretyVO addAssetEntiretyVO, List<UFDate> dates) {
            this.addAssetEntiretyVO = addAssetEntiretyVO;
            this.addUsufructVO = addAssetEntiretyVO.getUsufructAssetViewVO();
            this.addCardVO = addAssetEntiretyVO.getCardVO();
            this.pk_currency = this.addCardVO.getPk_currency();
            this.dates = dates;
        }

        public NewLeaseCalculateVO build() throws BusinessException {
            NewLeaseCalculateVO leaseCalcVO = new NewLeaseCalculateVO();
            RentSubsectionVO leaseTimeVO = this.buildRentSubsectionVO(this.dates.get(0), this.dates.get(1), this.dates.get(2));
            Map<String, List<ContractRentPubVO>> rentVOMap = this.buildContractRentPubVOMap();
            if (!UFBoolean.TRUE.equals((Object)this.addUsufructVO.getStep_lease_flag())) {
                UFDate full_start_date = leaseTimeVO.getFull_start_date();
                UFDate start_pay_date = leaseTimeVO.getStart_pay_date();
                if (start_pay_date.beforeDate(full_start_date)) {
                    List<ContractRentPubVO> list = rentVOMap.get("FA_16newLease");
                    for (ContractRentPubVO rent : list) {
                        UFDate start_date = rent.getStart_date();
                        UFDate end_date = rent.getEnd_date();
                        if (!start_date.isSameDate(start_pay_date) && !start_date.beforeDate(start_pay_date) || !start_pay_date.isSameDate(end_date) && !start_pay_date.beforeDate(end_date)) continue;
                        leaseTimeVO.setRent_day(rent.getPre_rent_tax());
                        break;
                    }
                }
            }
            leaseCalcVO.setRentSubVO(leaseTimeVO);
            leaseCalcVO.setPk_currency_origin(this.pk_currency);
            leaseCalcVO.setRentMap(rentVOMap);
            leaseCalcVO.setSceneConst(Integer.valueOf(5));
            leaseCalcVO.setPayType(RentPaymentPlanViewVO.class);
            leaseCalcVO.setPre_rent_type(Integer.valueOf(1));
            return leaseCalcVO;
        }

        private RentSubsectionVO buildRentSubsectionVO(UFDate begin_date, UFDate end_date, UFDate pay_date) throws BusinessException {
            RentSubsectionVO rentVO = new RentSubsectionVO();
            rentVO.setPk_contract_eq("FA_16newLease");
            rentVO.setSub_begin_date(begin_date);
            rentVO.setSub_end_date(end_date);
            rentVO.setStart_pay_date(pay_date);
            rentVO.setRent_type(String.valueOf(4));
            rentVO.setTax_rate(this.addUsufructVO.getTax_rate());
            rentVO.setTax_deductible(this.addUsufructVO.getTax_deductible());
            rentVO.setPaydate_type(this.addUsufructVO.getPayment_type());
            LeaseTimeRuleVO ruleVO = UsufructAssetCalculator.getLeaseTimeRuleVO(this.addUsufructVO, this.addCardVO);
            rentVO.setRuleVO(ruleVO);
            UFDate fullcyclebegindate = PayScheduleCalculateHelper.getFullcyclebegindate(this.addUsufructVO);
            if (fullcyclebegindate.beforeDate(pay_date)) {
                rentVO.setFull_start_date(pay_date);
            } else {
                rentVO.setFull_start_date(fullcyclebegindate);
            }
            rentVO.setRent_day(UFDouble.ZERO_DBL);
            return rentVO;
        }

        private Map<String, List<ContractRentPubVO>> buildContractRentPubVOMap() {
            HashMap map = Maps.newHashMap();
            ArrayList list = Lists.newArrayList();
            ContractRentPubVO rentVO = null;
            if (UFBoolean.TRUE.equals((Object)this.addUsufructVO.getStep_rent())) {
                StepRentStandardViewVO[] steprentstandard_tab = (StepRentStandardViewVO[])this.addAssetEntiretyVO.getTabVO(CardTabConst.steprentstandard_tab);
                List<StepRentStandardViewVO> collect = Stream.of(steprentstandard_tab).filter(vo -> vo.getStatus() != 3).collect(Collectors.toList());
                steprentstandard_tab = collect.toArray(new StepRentStandardViewVO[0]);
                UFDate retrospective_date = this.addUsufructVO.getRetrospective_date();
                boolean simple_retrospective_adjustment = false;
                if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO)) {
                    simple_retrospective_adjustment = true;
                }
                for (StepRentStandardViewVO viewVO : steprentstandard_tab) {
                    UFDate start_date = viewVO.getStart_date();
                    UFDate end_date = viewVO.getEnd_date();
                    if (retrospective_date != null && simple_retrospective_adjustment && retrospective_date.afterDate(start_date) && (retrospective_date.beforeDate(end_date) || retrospective_date.isSameDate(end_date))) {
                        rentVO = new ContractRentPubVO();
                        rentVO.setStart_date(start_date);
                        rentVO.setEnd_date(retrospective_date.getDateBefore(1).asEnd());
                        rentVO.setPre_rent_tax(viewVO.getRent());
                        rentVO.setPre_rent_type(Integer.valueOf(1));
                        list.add(rentVO);
                        rentVO = new ContractRentPubVO();
                        rentVO.setStart_date(retrospective_date);
                        rentVO.setEnd_date(end_date);
                        rentVO.setPre_rent_tax(viewVO.getRent());
                        rentVO.setPre_rent_type(Integer.valueOf(1));
                        list.add(rentVO);
                        continue;
                    }
                    rentVO = new ContractRentPubVO();
                    rentVO.setStart_date(start_date);
                    rentVO.setEnd_date(end_date);
                    rentVO.setPre_rent_tax(viewVO.getRent());
                    rentVO.setPre_rent_type(Integer.valueOf(1));
                    list.add(rentVO);
                }
            } else {
                rentVO = new ContractRentPubVO();
                rentVO.setStart_date(this.addUsufructVO.getRentstart_date());
                UFDate finalEnding_date = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
                rentVO.setEnd_date(finalEnding_date);
                rentVO.setPre_rent_tax(this.addUsufructVO.getRent_standard());
                rentVO.setPre_rent_type(Integer.valueOf(1));
                list.add(rentVO);
            }
            map.put("FA_16newLease", list);
            return map;
        }
    }
}

