/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nc.pub.fa.asset.relative.handler.BaseRelateHandler;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.rent.UFDateUtils;
import nc.vo.am.timerule.LeaseRentTimeRuleCalculator;
import nc.vo.am.timerule.LeaseTimeRuleVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.dto.pub.leasepub.DatePair;

public class PayScheduleCalculateHelper {
    static LeaseTimeRuleVO leaseTimeRuleVO(Integer month, int day) {
        LeaseTimeRuleVO ruleVO = new LeaseTimeRuleVO();
        ruleVO.setLeaseType(4);
        ruleVO.setType(9);
        ruleVO.setMonth(month.intValue());
        ruleVO.setDay(day);
        return ruleVO;
    }

    public static boolean inPayperiod(UFDate changeDate, RentPaymentPlanViewVO pay) {
        UFDate start_date = pay.getStart_date();
        UFDate end_date = pay.getEnd_date();
        return !(!start_date.beforeDate(changeDate) && !start_date.isSameDate(changeDate) || !changeDate.beforeDate(end_date) && !changeDate.isSameDate(end_date));
    }

    public static boolean inChangePayperiod(UFDate change_date, RentPaymentPlanViewVO pay, AccperiodVO minAccperiod, UsufructAssetViewVO addUsufructVO) {
        UFDate start_date = pay.getStart_date();
        UFDate min_end_date = minAccperiod.getEnddate();
        UFDate min_begin_date = minAccperiod.getStartdate();
        if (min_end_date.beforeDate(change_date)) {
            return PayScheduleCalculateHelper.inPayperiod(change_date, pay) && (start_date.beforeDate(min_end_date) && start_date.afterDate(min_begin_date) || start_date.afterDate(min_end_date)) || start_date.afterDate(change_date);
        }
        if (UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(addUsufructVO)) {
            if (PayScheduleCalculateHelper.inPayperiod(change_date, pay) && start_date.isSameDate(change_date)) {
                return true;
            }
            return start_date.afterDate(change_date);
        }
        if (PayScheduleCalculateHelper.inPayperiod(change_date, pay)) {
            return start_date.afterDate(min_begin_date) || start_date.isSameDate(min_begin_date);
        }
        return start_date.afterDate(change_date);
    }

    static List<UFDate> completeDates(UsufructAssetViewVO usufruct) {
        ArrayList dates = Lists.newArrayList();
        dates.add(usufruct.getRentstart_date());
        dates.add(PayScheduleCalculateHelper.getMaxEndDate(usufruct));
        dates.add(usufruct.getStarting_date());
        return dates;
    }

    public static int fullMonth(DatePair pair, LeaseRentTimeRuleCalculator timeRuleCalculator) {
        UFDate start = pair.getStart().asBegin();
        UFDate end = pair.getEnd().asEnd();
        int countMonth = UFDateUtils.countMonth((UFDate)start, (UFDate)end);
        LeaseTimeRuleVO timeRule = PayScheduleCalculateHelper.leaseTimeRuleVO(countMonth, start.getDay());
        int day = timeRule.getDay();
        int startDay = start.getDay();
        List beginDates = timeRuleCalculator.getDateRegions(start, end.getDateAfter(1).asBegin(), timeRule);
        if (CollectionUtils.isEmpty((Collection)beginDates)) {
            return -1;
        }
        UFDate firstDate = (UFDate)beginDates.get(0);
        UFDate lastDate = ((UFDate)beginDates.get(beginDates.size() - 1)).getDateBefore(1).asEnd();
        if ((firstDate.isSameDate(start) || day == startDay) && lastDate.isSameDate(end) && beginDates.size() == 2) {
            return countMonth;
        }
        return -1;
    }

    public static UFDate getMaxBeginDate(CardVO cardVO, UsufructAssetViewVO usufructVO) {
        UFDate begin_date = cardVO.getBegin_date();
        UFDate rentstart_date = usufructVO.getRentstart_date();
        UFDate maxDate = UFDateUtils.maxDate((UFDate)begin_date, (UFDate)rentstart_date);
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(usufructVO)) {
            UFDate retrospective_date = usufructVO.getRetrospective_date();
            maxDate = UFDateUtils.maxDate((UFDate)retrospective_date, (UFDate)maxDate);
        }
        return maxDate;
    }

    public static UFDate getMaxBeginDate(CardVO cardVO, UsufructAssetVO usufructVO) {
        UFDate begin_date = cardVO.getBegin_date();
        UFDate rentstart_date = usufructVO.getRentstart_date();
        UFDate maxDate = UFDateUtils.maxDate((UFDate)begin_date, (UFDate)rentstart_date);
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(usufructVO)) {
            UFDate retrospective_date = usufructVO.getRetrospective_date();
            maxDate = UFDateUtils.maxDate((UFDate)retrospective_date, (UFDate)maxDate);
        }
        return maxDate;
    }

    public static UFDate getMaxBeginDate(AssetEntiretyVO assetEntiretyVO) {
        return PayScheduleCalculateHelper.getMaxBeginDate(assetEntiretyVO.getCardVO(), assetEntiretyVO.getUsufructAssetViewVO());
    }

    public static UFDate getMaxBeginDate(BaseRelateHandler baseRelateHandler) {
        AggCardVO aggCvo = baseRelateHandler.getAggCvo();
        CardVO cardVO = (CardVO)aggCvo.head();
        UsufructAssetVO usufructAssetVO = aggCvo.getUsufructAssetVO();
        return PayScheduleCalculateHelper.getMaxBeginDate(cardVO, usufructAssetVO);
    }

    public static UFDate getMaxEndDate(UsufructAssetViewVO usufructVO) {
        return UFBoolean.TRUE.equals((Object)usufructVO.getRenewal_flag()) ? usufructVO.getRelet_ending_date() : usufructVO.getEnding_date();
    }

    public static UFDouble getPurchasePrice(UsufructAssetViewVO usufructVO) {
        return UFBoolean.TRUE.equals((Object)usufructVO.getPurchase_choice()) ? usufructVO.getPurchase_price() : UFDouble.ZERO_DBL;
    }

    public static UFDate getMaxEndDate(UsufructAssetVO usufructVO) {
        return UFBoolean.TRUE.equals((Object)usufructVO.getRenewal_flag()) ? usufructVO.getRelet_ending_date() : usufructVO.getEnding_date();
    }

    public static UFDate getFullcyclebegindate(UsufructAssetViewVO usufructVO) {
        UFDate fullcyclebegindate = usufructVO.getFullcyclebegindate();
        UFDate starting_date = usufructVO.getStarting_date();
        if (fullcyclebegindate == null) {
            return starting_date;
        }
        return fullcyclebegindate;
    }

    public static UFDate getMaxBeginDateForNature(CardVO cardVO, UsufructAssetVO usufructVO) {
        UFDate begin_date = cardVO.getBegin_date();
        UFDate rentstart_date = usufructVO.getRentstart_date();
        UFDate maxDate = UFDateUtils.maxDate((UFDate)begin_date, (UFDate)rentstart_date);
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(usufructVO)) {
            UFDate retrospective_date = usufructVO.getRetrospective_date();
            maxDate = UFDateUtils.maxDate((UFDate)retrospective_date, (UFDate)maxDate);
        } else {
            maxDate = rentstart_date;
        }
        return maxDate;
    }
}

