/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.pub.lang.UFDate;

public class LeaseLiabilitiesMiddleChangeRecordByMonth {
    private final UsufructAssetViewVO addUsufructVO;
    private final RentPaymentPlanViewVO selectedChangePlan;
    private final DepAccrualViewVO[] oldDepAccuralVOs;
    private final UFDate discountingBeginDate;
    private boolean isMiddleChange = false;
    private boolean isCalcDepAccruaInNext = false;
    private final boolean isDiscountModeMonth365OrMonth360;
    private final boolean isDiscountModeDay365OrDay360;
    private final boolean isPaymentTypeEnumPayment_before;

    public LeaseLiabilitiesMiddleChangeRecordByMonth(UsufructAssetViewVO addUsufructVO, RentPaymentPlanViewVO selectedChangePlan, DepAccrualViewVO[] oldDepAccuralVOs, UFDate discountingBeginDate) {
        this.addUsufructVO = addUsufructVO;
        this.selectedChangePlan = selectedChangePlan;
        this.oldDepAccuralVOs = oldDepAccuralVOs;
        this.discountingBeginDate = discountingBeginDate;
        this.initMiddleChangeFlag();
        this.isDiscountModeMonth365OrMonth360 = UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(addUsufructVO);
        this.isDiscountModeDay365OrDay360 = UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(addUsufructVO);
        this.isPaymentTypeEnumPayment_before = UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(addUsufructVO);
    }

    public void initMiddleChangeFlag() {
        if (this.selectedChangePlan == null) {
            return;
        }
        UFDate start_date = this.selectedChangePlan.getStart_date();
        UFDate end_date = this.selectedChangePlan.getEnd_date();
        List selectedDepBeginDates = Stream.of(this.oldDepAccuralVOs).filter(o -> o.getBegin_date().isSameDate(start_date) || o.getBegin_date().afterDate(start_date)).filter(o -> o.getEnd_date().isSameDate(end_date) || o.getEnd_date().beforeDate(end_date)).map(o -> o.getBegin_date()).collect(Collectors.toList());
        if (selectedDepBeginDates.isEmpty()) {
            throw ExceptionUtils.businessRuntimeException((String)"\u6ca1\u6709\u4e0b\u4e00\u4e2a\u53ef\u53d8\u66f4\u7684\u5468\u671f\uff0c\u4e0d\u53ef\u53d8\u66f4\uff01");
        }
        if (this.discountingBeginDate.beforeDate((UFDate)selectedDepBeginDates.get(0)) || this.discountingBeginDate.afterDate((UFDate)selectedDepBeginDates.get(selectedDepBeginDates.size() - 1))) {
            this.isMiddleChange = true;
            this.isCalcDepAccruaInNext = true;
            return;
        }
        if (!((UFDate)selectedDepBeginDates.get(0)).isSameDate(this.discountingBeginDate)) {
            this.isMiddleChange = true;
            if (((UFDate)selectedDepBeginDates.get(selectedDepBeginDates.size() - 1)).isSameDate(this.discountingBeginDate)) {
                this.isCalcDepAccruaInNext = true;
            }
        }
    }

    public boolean isMiddleChange() {
        return this.isMiddleChange;
    }

    public boolean isCalcDepAccruaInNext() {
        return this.isCalcDepAccruaInNext;
    }

    public boolean isDeleteOldCurrentChangePay() {
        if (!this.isPaymentTypeEnumPayment_before) {
            return true;
        }
        return this.isPaymentTypeEnumPayment_before && !this.isMiddleChange;
    }

    public RentPaymentPlanViewVO[] mergePaymentPlan(RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs, RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs) {
        if (this.isDeleteOldCurrentChangePay()) {
            return (RentPaymentPlanViewVO[])ArrayUtils.mergeArrays((Object[])tempOldRentPaymentPlanVOs, (Object[])addRentPaymentPlanViewVOs);
        }
        RentPaymentPlanViewVO[] remainingRentPaymentPlans = (RentPaymentPlanViewVO[])ArrayUtils.remove((Object[])addRentPaymentPlanViewVOs, (int)0);
        return (RentPaymentPlanViewVO[])ArrayUtils.mergeArrays((Object[])tempOldRentPaymentPlanVOs, (Object[])remainingRentPaymentPlans);
    }
}

