/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.common.manager.VOManager;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.vo.am.common.newlease.LiabilityCalcInfo;
import nc.vo.am.common.newlease.LiabilityCalcParams;
import nc.vo.am.common.newlease.LiabilityPubVO;
import nc.vo.am.common.newlease.PaySchedulePubVO;
import nc.vo.am.common.newlease.utils.MathUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.proxy.AMProxy;
import nc.vo.am.timerule.LeaseTimeRuleVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.pub.ampub.liability.uitl.LiabilityCalculator;
import org.apache.commons.lang3.tuple.Pair;

public class LeaseLiabilitiesCore {
    private final LiabilityCalcParams liabilityCalcParams;
    private final UsufructAssetViewVO addUsufructVO;
    private final PaySchedulePubVO[] paySchedulePubVOs;
    private final boolean periodRulePrefirst;
    private final boolean paymentTypePayment_before;

    public LeaseLiabilitiesCore(LiabilityCalcParams liabilityCalcParams, UsufructAssetViewVO addUsufructVO, PaySchedulePubVO[] paySchedulePubVOs) {
        this.liabilityCalcParams = liabilityCalcParams;
        this.addUsufructVO = addUsufructVO;
        this.paySchedulePubVOs = paySchedulePubVOs;
        this.periodRulePrefirst = UsufructAssetEnumJudge.isPeriodRulePrefirst(addUsufructVO);
        this.paymentTypePayment_before = UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(addUsufructVO);
    }

    public List<LiabilityPubVO> calc() {
        LiabilityCalcInfo liabilityCalcInfo = new LiabilityCalcInfo(this.paySchedulePubVOs, this.liabilityCalcParams);
        Object[] liabilityPubVOs = new LiabilityCalculator().liabilityCalculate(liabilityCalcInfo);
        return liabilityPubVOs != null ? Lists.newArrayList((Object[])liabilityPubVOs) : Lists.newArrayList();
    }

    private void clearInputdate() {
        this.addUsufructVO.setInputdate(null);
        this.addUsufructVO.setInputdatebegin_liability(UFDouble.ZERO_DBL);
    }

    public void recalcInputDate(List<LiabilityPubVO> liabilityPubVOs, AssetEntiretyVO assetEntiretyVO) throws BusinessException {
        UFDate retrospective_date;
        CardhistoryVO[] cardhistoryVOs = assetEntiretyVO.getCardhistoryVOs();
        int newasset_flag = cardhistoryVOs[0].getNewasset_flag();
        if (newasset_flag != 0) {
            this.clearInputdate();
            return;
        }
        if (UFBoolean.TRUE.equals((Object)this.addUsufructVO.getStep_lease_flag())) {
            this.clearInputdate();
            return;
        }
        UFDate inputdate = this.addUsufructVO.getInputdate();
        UFDouble inputdatebegin_liability = this.addUsufructVO.getInputdatebegin_liability();
        if (inputdate == null || UFDoubleUtils.isNullOrZero((UFDouble)inputdatebegin_liability)) {
            this.clearInputdate();
            return;
        }
        UFDate fullcyclebegindate = PayScheduleCalculateHelper.getFullcyclebegindate(this.addUsufructVO);
        if (inputdate.beforeDate(fullcyclebegindate)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0829", null, new String[]{inputdate.toLocalString()}));
        }
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO) && inputdate.beforeDate(retrospective_date = this.addUsufructVO.getRetrospective_date())) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0848", null, new String[]{inputdate.toLocalString(), retrospective_date.toLocalString()}));
        }
        String[] pk_accbooks = (String[])VOManager.getAttributeValueArray((CircularlyAccessibleValueObject[])cardhistoryVOs, (String)"pk_accbook");
        Map minUnCloseBookPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks);
        for (String pk_accbook : pk_accbooks) {
            AccperiodVO accperiodVO = (AccperiodVO)minUnCloseBookPeriods.get(pk_accbook);
            UFDate enddate = accperiodVO.getEnddate();
            if (!inputdate.afterDate(enddate)) continue;
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0849", null, new String[]{inputdate.toLocalString(), accperiodVO.getAccyear(), accperiodVO.getPeriod(), enddate.toLocalString()}));
        }
        PhaseCollection phaseCollection = new PhaseCollection();
        phaseCollection.init(liabilityPubVOs);
        boolean legalInputDate = phaseCollection.isLegalInputDate(inputdate);
        if (!legalInputDate) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0828", null, new String[]{inputdate.toLocalString()}));
        }
        phaseCollection.reCalcFlag(inputdate);
        phaseCollection.calc(inputdatebegin_liability);
    }

    public Pair<List<PaySchedulePubVO>, List<LiabilityPubVO>> intercept(List<LiabilityPubVO> liabilityvos) {
        UFDate inputdate = this.addUsufructVO.getInputdate();
        if (inputdate == null) {
            return Pair.of((Object)Lists.newArrayList((Object[])this.paySchedulePubVOs), liabilityvos);
        }
        List interceptPaySchedulePubVOs = Stream.of(this.paySchedulePubVOs).filter(o -> inputdate.beforeDate(o.getStart_date()) || inputdate.isSameDate(o.getStart_date())).collect(Collectors.toList());
        List interceptLiabilityPubVOs = liabilityvos.stream().filter(o -> inputdate.beforeDate(o.getBegin_date()) || inputdate.isSameDate(o.getBegin_date())).collect(Collectors.toList());
        Pair pair = Pair.of(interceptPaySchedulePubVOs, interceptLiabilityPubVOs);
        return pair;
    }

    public static UFDate discountingBeginDate(UFDate changeDate, DepAccrualViewVO[] deps, UsufructAssetViewVO usufruct) {
        if (UsufructAssetEnumJudge.isDiscountModeMonth(usufruct)) {
            int month = changeDate.getMonth();
            int year = changeDate.getYear();
            for (DepAccrualViewVO dep : deps) {
                UFDate start_date;
                if (dep.getStatus() == 3 || year != (start_date = dep.getBegin_date()).getYear() || month != start_date.getMonth()) continue;
                return start_date;
            }
            UFDate start_date = deps[deps.length - 1].getBegin_date();
            LeaseTimeRuleVO ruleVO = PayScheduleCalculateHelper.leaseTimeRuleVO(1, usufruct.getStarting_date().getDay());
            UFDate nextDate = ruleVO.nextDate(start_date);
            if (year == nextDate.getYear() && month == nextDate.getMonth()) {
                return nextDate;
            }
        }
        return changeDate;
    }

    private class PhaseCollection {
        List<Phase> list = new ArrayList<Phase>();
        List<UFDate> begin_dates = new ArrayList<UFDate>();

        public void addPhase(Phase phase) {
            this.list.add(phase);
            this.begin_dates.add(phase.firstDate);
        }

        public void init(List<LiabilityPubVO> liabilityPubVOs) {
            Phase phase = null;
            for (LiabilityPubVO liabilityPubVO : liabilityPubVOs) {
                BigDecimal rate = liabilityPubVO.getRate();
                if (rate != null) {
                    phase = new Phase(liabilityPubVO);
                    this.addPhase(phase);
                    continue;
                }
                phase.addLiabilityPubVO(liabilityPubVO);
            }
        }

        public boolean isLegalInputDate(UFDate inputdate) {
            for (UFDate begin_date : this.begin_dates) {
                if (!inputdate.isSameDate(begin_date)) continue;
                return true;
            }
            return false;
        }

        public UFDate inCompleteEndDate(LiabilityCalcParams liabilityCalcParams) {
            boolean hadInCompleteVO = liabilityCalcParams.hadInCompleteVO();
            if (hadInCompleteVO) {
                if (this.begin_dates.size() > 1) {
                    return this.begin_dates.get(1).getDateBefore(1);
                }
                return this.list.get(0).lastDate();
            }
            return null;
        }

        public void reCalcFlag(UFDate inputdate) {
            for (Phase phase : this.list) {
                phase.reCalcFlag(inputdate);
            }
        }

        public void calc(UFDouble inputdatebegin_liability) {
            UFDouble end_liability_last = FAScaleUtils.setScaleByCurrType((UFDouble)inputdatebegin_liability, (String)LeaseLiabilitiesCore.this.liabilityCalcParams.getPk_currency_origin(), (boolean)false);
            boolean firstRecalc = true;
            for (Phase phase : this.list) {
                if (!phase.isRecalc) continue;
                end_liability_last = phase.recalc(end_liability_last, firstRecalc);
                firstRecalc = false;
            }
        }
    }

    private class Phase {
        List<LiabilityPubVO> phases = new ArrayList<LiabilityPubVO>();
        BigDecimal realRate;
        UFDate firstDate;
        boolean isRecalc = false;

        public Phase(LiabilityPubVO liabilityPubVO) {
            this.phases.add(liabilityPubVO);
            this.realRate = liabilityPubVO.getRate();
            this.firstDate = liabilityPubVO.getBegin_date();
        }

        public UFDouble getCalc_cash() {
            if (LeaseLiabilitiesCore.this.paymentTypePayment_before) {
                return this.phases.get(0).getCalc_cash();
            }
            return this.phases.get(this.length() - 1).getCalc_cash();
        }

        public void addLiabilityPubVO(LiabilityPubVO liabilityPubVO) {
            this.phases.add(liabilityPubVO);
        }

        public UFDate lastDate() {
            return this.phases.get(this.phases.size() - 1).getEnd_date();
        }

        public int length() {
            return this.phases.size();
        }

        public void reCalcFlag(UFDate inputdate) {
            if (inputdate.isSameDate(this.firstDate) || inputdate.beforeDate(this.firstDate)) {
                this.isRecalc = true;
            }
        }

        public UFDouble recalc(UFDouble inputdatebegin_liability0, boolean firstRecalc) {
            UFDouble begin_liability_calc_cash_interestSum = null;
            begin_liability_calc_cash_interestSum = LeaseLiabilitiesCore.this.paymentTypePayment_before ? (LeaseLiabilitiesCore.this.periodRulePrefirst ? UFDouble.ZERO_DBL : this.getCalc_cash()) : UFDouble.ZERO_DBL;
            UFDouble first_begin_liability_interestSum = UFDoubleUtils.sub((UFDouble)inputdatebegin_liability0, (UFDouble)begin_liability_calc_cash_interestSum);
            if (firstRecalc) {
                first_begin_liability_interestSum = inputdatebegin_liability0;
            }
            BigDecimal interestSum = null;
            if (LeaseLiabilitiesCore.this.paymentTypePayment_before) {
                if (LeaseLiabilitiesCore.this.periodRulePrefirst) {
                    UFDouble calc_cash = this.getCalc_cash();
                    interestSum = MathUtils.multiply((UFDouble)UFDoubleUtils.sub((UFDouble)first_begin_liability_interestSum, (UFDouble)calc_cash), (BigDecimal)this.realRate);
                } else {
                    interestSum = MathUtils.multiply((UFDouble)first_begin_liability_interestSum, (BigDecimal)this.realRate);
                }
            } else {
                interestSum = MathUtils.multiply((UFDouble)first_begin_liability_interestSum, (BigDecimal)this.realRate);
            }
            UFDouble[] divWeight = this.divWeight(interestSum);
            UFDouble end_liability_last = inputdatebegin_liability0;
            for (int i = 0; i < this.phases.size(); ++i) {
                LiabilityPubVO liabilityPubVO = this.phases.get(i);
                UFDouble end_liability_calc_cash = null;
                UFDouble begin_liability_calc_cash = null;
                UFDouble begin_liability = null;
                UFDouble end_liability = null;
                end_liability_calc_cash = LeaseLiabilitiesCore.this.paymentTypePayment_before ? (LeaseLiabilitiesCore.this.periodRulePrefirst ? liabilityPubVO.getCalc_cash() : UFDouble.ZERO_DBL) : liabilityPubVO.getCalc_cash();
                begin_liability_calc_cash = LeaseLiabilitiesCore.this.paymentTypePayment_before ? (LeaseLiabilitiesCore.this.periodRulePrefirst ? UFDouble.ZERO_DBL : liabilityPubVO.getCalc_cash()) : UFDouble.ZERO_DBL;
                begin_liability = UFDoubleUtils.sub((UFDouble)end_liability_last, (UFDouble)begin_liability_calc_cash);
                if (i == 0 && firstRecalc) {
                    begin_liability = inputdatebegin_liability0;
                }
                UFDouble intersetStep = divWeight[i];
                end_liability_last = end_liability = UFDoubleUtils.add((UFDouble)begin_liability, (UFDouble)UFDoubleUtils.sub((UFDouble)intersetStep, (UFDouble)end_liability_calc_cash));
                liabilityPubVO.setBegin_liability(begin_liability);
                liabilityPubVO.setInterest(intersetStep);
                liabilityPubVO.setEnd_liability(end_liability);
            }
            return end_liability_last;
        }

        private UFDouble[] divWeight(BigDecimal interestSum) {
            UFDouble total = MathUtils.toUFDouble((BigDecimal)interestSum);
            int count = this.length();
            BigDecimal countBig = BigDecimal.valueOf(count);
            UFDouble[] interests = new UFDouble[count];
            for (int i = 0; i < count; ++i) {
                if (i == count - 1) {
                    interests[i] = UFDouble.ZERO_DBL;
                    interests[i] = total.sub(UFDoubleUtils.add((UFDouble[])interests), total.getPower());
                } else {
                    interests[i] = MathUtils.toUFDouble((BigDecimal)MathUtils.div((BigDecimal)interestSum, (BigDecimal)countBig));
                }
                interests[i] = FAScaleUtils.setScaleByCurrType((UFDouble)interests[i], (String)LeaseLiabilitiesCore.this.liabilityCalcParams.getPk_currency_origin(), (boolean)false);
            }
            return interests;
        }
    }
}

