/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.pub.fa.asset.relation.BeginLiabilityEnum;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesCore;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.vo.am.common.newlease.LiabilityCalcParams;
import nc.vo.am.common.newlease.LiabilityPubVO;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CloneUtil;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;

public class LeaseLiabilitiesChangeCalculator {
    private final UFDate discountingBeginDate;
    private final UsufructAssetViewVO addUsufructVO;
    private final DepAccrualViewVO[] oldDepAccuralVOs;
    private final Map<String, AccperiodVO> minUnCloseBookPeriods;
    private final LiabilityCalcParams liabilityCalcParams;
    private final boolean interestBaseEnumMonth365OrMonth360;
    private final Optional<DepAccrualViewVO> willChangedDepAccrualViewVO;
    private SplitDateBackup splitDateBackup;

    public LeaseLiabilitiesChangeCalculator(UFDate discountingBeginDate, UsufructAssetViewVO addUsufructVO, DepAccrualViewVO[] oldDepAccuralVOs, Map<String, AccperiodVO> minUnCloseBookPeriods, LiabilityCalcParams liabilityCalcParams) {
        this.discountingBeginDate = discountingBeginDate;
        this.addUsufructVO = addUsufructVO;
        this.oldDepAccuralVOs = oldDepAccuralVOs;
        Arrays.sort((Object[])this.oldDepAccuralVOs);
        this.minUnCloseBookPeriods = minUnCloseBookPeriods;
        this.liabilityCalcParams = liabilityCalcParams;
        this.interestBaseEnumMonth365OrMonth360 = UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(addUsufructVO);
        this.willChangedDepAccrualViewVO = this.getWillChangedDepAccrualViewVO();
    }

    public DepAccrualViewVO[] calc(RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs) throws BusinessException {
        this.handleOldDepAccrualStatus();
        this.backupStartDate(addRentPaymentPlanViewVOs);
        LeaseLiabilitiesCore leaseLiabilitiesCalculator = new LeaseLiabilitiesCore(this.liabilityCalcParams, this.addUsufructVO, addRentPaymentPlanViewVOs);
        List<LiabilityPubVO> liabilityvos = leaseLiabilitiesCalculator.calc();
        this.resumeStartDate(addRentPaymentPlanViewVOs);
        this.reduceLiability(liabilityvos);
        DepAccrualViewVO[] addDepAccrualViewVOs = this.handleAddDepAccrualStatus(liabilityvos);
        DepAccrualViewVO[] mergeDepAccrualViewVOs = (DepAccrualViewVO[])ArrayUtils.mergeArrays((Object[])this.oldDepAccuralVOs, (Object[])addDepAccrualViewVOs);
        this.handleDayDepAccrual(addRentPaymentPlanViewVOs, mergeDepAccrualViewVOs);
        return mergeDepAccrualViewVOs;
    }

    private void handleDayDepAccrual(RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs, DepAccrualViewVO[] mergeDepAccrualViewVOs) {
        if (UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(this.addUsufructVO) && addRentPaymentPlanViewVOs[0].getStart_date().beforeDate(this.discountingBeginDate)) {
            UFDate start_date = addRentPaymentPlanViewVOs[0].getStart_date();
            UFDate end_date = addRentPaymentPlanViewVOs[0].getEnd_date();
            UFDouble calculate_renttax = addRentPaymentPlanViewVOs[0].getCalculate_renttax();
            UFDouble calculate_rentnotax = addRentPaymentPlanViewVOs[0].getCalculate_rentnotax();
            Stream.of(mergeDepAccrualViewVOs).forEach(vo -> {
                if (vo.getStatus() != 3 && !UFDoubleUtils.isEqual((UFDouble)vo.getCalc_cash(), (UFDouble)UFDouble.ZERO_DBL) && (vo.getBegin_date().afterDate(start_date) || vo.getBegin_date().isSameDate(start_date)) && (vo.getEnd_date().beforeDate(end_date) || vo.getEnd_date().isSameDate(end_date))) {
                    vo.setCalculate_renttax(calculate_renttax);
                    vo.setCalculate_rentnotax(calculate_rentnotax);
                    vo.setCalc_cash(calculate_rentnotax);
                }
                if (vo.getStatus() != 3 && !UFDoubleUtils.isEqual((UFDouble)vo.getCalc_cash(), (UFDouble)UFDouble.ZERO_DBL) && (vo.getBegin_date().beforeDate(this.discountingBeginDate) || vo.getBegin_date().isSameDate(this.discountingBeginDate)) && (vo.getEnd_date().afterDate(this.discountingBeginDate) || vo.getEnd_date().isSameDate(this.discountingBeginDate)) && vo.getIsaccruedbymonth().booleanValue()) {
                    vo.setCalculate_renttax(calculate_renttax);
                    vo.setCalculate_rentnotax(calculate_rentnotax);
                    vo.setCalc_cash(calculate_rentnotax);
                }
            });
        }
    }

    private void backupStartDate(RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs) {
        if (this.interestBaseEnumMonth365OrMonth360) {
            this.splitDateBackup = new SplitDateBackup(addRentPaymentPlanViewVOs, this.discountingBeginDate, this.addUsufructVO);
            this.splitDateBackup.split();
        }
    }

    private void resumeStartDate(RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs) {
        if (this.interestBaseEnumMonth365OrMonth360) {
            this.splitDateBackup.resume();
        }
    }

    public void check(UFDate changeDate) throws BusinessException {
        if (this.interestBaseEnumMonth365OrMonth360) {
            DepAccrualViewVO depAccrualViewVO;
            UFDate begin_date;
            boolean satisfy;
            boolean discountModeDay365OrDay360 = UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(this.addUsufructVO);
            Optional<DepAccrualViewVO> findAnyInDeps = Stream.of(this.oldDepAccuralVOs).filter(o -> o.getStatus() != 3).filter(o -> {
                if (discountModeDay365OrDay360) {
                    return UFBoolean.FALSE.equals((Object)o.getIsaccruedbymonth());
                }
                return true;
            }).filter(o -> o.getBegin_date().beforeDate(changeDate)).findAny();
            if (!findAnyInDeps.isPresent()) {
                return;
            }
            if (this.willChangedDepAccrualViewVO.isPresent() && !(satisfy = LeaseLiabilitiesChangeCalculator.editSatisfyMinUnClose(begin_date = (depAccrualViewVO = this.willChangedDepAccrualViewVO.get()).getBegin_date(), this.minUnCloseBookPeriods))) {
                UFDate end_date = depAccrualViewVO.getEnd_date();
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0819", null, new String[]{changeDate.toLocalString(), begin_date.toLocalString(), end_date.toLocalString()}));
            }
        }
    }

    public static boolean editSatisfyMinUnClose(UFDate date, Map<String, AccperiodVO> minUnCloseBookPeriods) {
        boolean satisfy = true;
        for (Map.Entry<String, AccperiodVO> map : minUnCloseBookPeriods.entrySet()) {
            AccperiodVO accperiodVO = map.getValue();
            UFDate startdate = accperiodVO.getStartdate();
            UFDate enddate = accperiodVO.getEnddate();
            boolean in = !(!startdate.beforeDate(date) && !startdate.isSameDate(date) || !date.beforeDate(enddate) && !date.isSameDate(enddate));
            if (in) continue;
            satisfy = false;
            break;
        }
        return satisfy;
    }

    private UFDouble getRatioOfUnchangedSplitDaysOccupyTotalDays() {
        DepAccrualViewVO depAccrualViewVO = this.willChangedDepAccrualViewVO.get();
        UFDate begin_date = depAccrualViewVO.getBegin_date();
        UFDate end_date = depAccrualViewVO.getEnd_date();
        double unchangedSplitDays = UFDate.getDaysBetween((UFDate)begin_date, (UFDate)this.discountingBeginDate);
        double totalDays = UFDate.getDaysBetween((UFDate)begin_date, (UFDate)end_date) + 1;
        return new UFDouble(unchangedSplitDays / totalDays);
    }

    private UFDouble getRatioOfNewSplitDaysOccupyTotalDays() {
        DepAccrualViewVO depAccrualViewVO = this.willChangedDepAccrualViewVO.get();
        UFDate begin_date = depAccrualViewVO.getBegin_date();
        UFDate end_date = depAccrualViewVO.getEnd_date();
        double newSplitDays = UFDate.getDaysBetween((UFDate)this.discountingBeginDate, (UFDate)end_date) + 1;
        double totalDays = UFDate.getDaysBetween((UFDate)begin_date, (UFDate)end_date) + 1;
        return new UFDouble(newSplitDays / totalDays);
    }

    public Optional<DepAccrualViewVO> getWillChangedDepAccrualViewVO() {
        boolean discountModeDay365OrDay360 = UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(this.addUsufructVO);
        Optional<DepAccrualViewVO> findAny = Stream.of(this.oldDepAccuralVOs).filter(o -> o.getStatus() != 3).filter(o -> {
            if (discountModeDay365OrDay360) {
                return UFBoolean.FALSE.equals((Object)o.getIsaccruedbymonth());
            }
            return true;
        }).filter(o -> {
            UFDate begin_date = o.getBegin_date();
            UFDate end_date = o.getEnd_date();
            return !(!begin_date.isSameDate(this.discountingBeginDate) && !begin_date.beforeDate(this.discountingBeginDate) || !this.discountingBeginDate.isSameDate(end_date) && !this.discountingBeginDate.beforeDate(end_date));
        }).findAny();
        return findAny;
    }

    private void handleOldDepAccrualStatus() {
        DepAccrualViewVO depAccrualViewVO;
        UFDate locate_begin_date;
        this.setBeginLiability(this.oldDepAccuralVOs, BeginLiabilityEnum.OLD);
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(this.addUsufructVO) && this.willChangedDepAccrualViewVO.isPresent() && !(locate_begin_date = (depAccrualViewVO = this.willChangedDepAccrualViewVO.get()).getBegin_date()).isSameDate(this.discountingBeginDate)) {
            UFDouble ratioOfUnchangedSplitDaysOccupyTotalDays = this.getRatioOfUnchangedSplitDaysOccupyTotalDays();
            UFDouble interest = depAccrualViewVO.getInterest();
            UFDouble addInterest = UFDoubleUtils.multiply((UFDouble)ratioOfUnchangedSplitDaysOccupyTotalDays, (UFDouble)interest);
            UFDouble addInterestScale = FAScaleUtils.setScaleByCurrType((UFDouble)addInterest, (String)this.liabilityCalcParams.getPk_currency_origin(), (boolean)false);
            depAccrualViewVO.setInterest(addInterestScale);
        }
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(this.addUsufructVO)) {
            for (DepAccrualViewVO depAccrualViewVO2 : this.oldDepAccuralVOs) {
                end_date = depAccrualViewVO2.getEnd_date();
                if (!this.discountingBeginDate.beforeDate(end_date) && !this.discountingBeginDate.isSameDate(end_date)) continue;
                depAccrualViewVO2.setStatus(3);
            }
            if (this.willChangedDepAccrualViewVO.isPresent()) {
                DepAccrualViewVO depAccrualViewVO3 = this.willChangedDepAccrualViewVO.get();
                UFDate locate_begin_date2 = depAccrualViewVO3.getBegin_date();
                if (locate_begin_date2.isSameDate(this.discountingBeginDate)) {
                    depAccrualViewVO3.setStatus(3);
                } else {
                    depAccrualViewVO3.setStatus(1);
                }
            }
        } else if (UsufructAssetEnumJudge.isDiscountModeMonth(this.addUsufructVO)) {
            for (DepAccrualViewVO depAccrualViewVO2 : this.oldDepAccuralVOs) {
                end_date = depAccrualViewVO2.getEnd_date();
                if (!this.discountingBeginDate.beforeDate(end_date) && !this.discountingBeginDate.isSameDate(end_date)) continue;
                depAccrualViewVO2.setStatus(3);
            }
            DepAccrualViewVO depAccrualViewVO4 = this.oldDepAccuralVOs[this.oldDepAccuralVOs.length - 1];
            UFDate beforeOne = this.discountingBeginDate.getDateBefore(1);
            if (depAccrualViewVO4.getEnd_date().beforeDate(beforeOne)) {
                depAccrualViewVO4.setEnd_date(beforeOne);
                depAccrualViewVO4.setStatus(1);
            }
        } else {
            for (DepAccrualViewVO depAccrualViewVO2 : this.oldDepAccuralVOs) {
                end_date = depAccrualViewVO2.getEnd_date();
                if (this.discountingBeginDate.beforeDate(end_date) || this.discountingBeginDate.isSameDate(end_date)) {
                    depAccrualViewVO2.setStatus(3);
                }
                if (!UFBoolean.TRUE.equals((Object)depAccrualViewVO2.getIsaccruedbymonth())) continue;
                depAccrualViewVO2.setStatus(3);
            }
        }
    }

    private DepAccrualViewVO[] handleAddDepAccrualStatus(List<LiabilityPubVO> liabilityvos) throws BusinessException {
        DepAccrualViewVO[] addvos = liabilityvos.toArray(new DepAccrualViewVO[0]);
        this.setBeginLiability(addvos, BeginLiabilityEnum.NEW);
        if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(this.addUsufructVO)) {
            DepAccrualViewVO locateDepAccrualViewVO;
            UFDate locate_begin_date;
            Stream.of(addvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.TRUE);
                viewvo.setStatus(2);
            });
            if (this.willChangedDepAccrualViewVO.isPresent() && !(locate_begin_date = (locateDepAccrualViewVO = this.willChangedDepAccrualViewVO.get()).getBegin_date()).isSameDate(this.discountingBeginDate)) {
                UFDouble interest1 = locateDepAccrualViewVO.getInterest();
                DepAccrualViewVO firstDepAccrualViewVO = addvos[0];
                UFDouble interest2 = firstDepAccrualViewVO.getInterest();
                locateDepAccrualViewVO.setInterest(UFDoubleUtils.add((UFDouble)interest1, (UFDouble)interest2));
                locateDepAccrualViewVO.setEnd_date(firstDepAccrualViewVO.getEnd_date());
                locateDepAccrualViewVO.setEnd_liability(firstDepAccrualViewVO.getEnd_liability());
                locateDepAccrualViewVO.setCalculate_renttax(firstDepAccrualViewVO.getCalculate_renttax());
                locateDepAccrualViewVO.setCalculate_rentnotax(firstDepAccrualViewVO.getCalculate_rentnotax());
                locateDepAccrualViewVO.setCalc_cash(firstDepAccrualViewVO.getCalc_cash());
                addvos = (DepAccrualViewVO[])ArrayUtils.remove((Object[])addvos, (int)0);
            }
        } else if (UsufructAssetEnumJudge.isDiscountModeMonth(this.addUsufructVO)) {
            Stream.of(addvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.TRUE);
                viewvo.setStatus(2);
            });
        } else {
            Stream.of(addvos).forEach(viewvo -> {
                viewvo.setIsaccruedbymonth(UFBoolean.FALSE);
                viewvo.setStatus(2);
                viewvo.setDay_date(viewvo.getBegin_date());
            });
            DepAccrualViewVO[] oldvos = Stream.of(this.oldDepAccuralVOs).filter(vo -> 3 != vo.getStatus()).collect(Collectors.toList()).toArray(new DepAccrualViewVO[0]);
            DepAccrualViewVO[] monthViewVos = UsufructAssetCalculator.collectDayDataToMonth((DepAccrualViewVO[])ArrayUtils.mergeArrays((Object[])oldvos, (Object[])addvos), PayScheduleCalculateHelper.completeDates(this.addUsufructVO), this.addUsufructVO);
            addvos = (DepAccrualViewVO[])ArrayUtils.mergeArrays((Object[])addvos, (Object[])monthViewVos);
        }
        return UsufructAssetCalculator.fillEffInterestRate(this.addUsufructVO, null, addvos);
    }

    private void setBeginLiability(DepAccrualViewVO[] depAccrualViewVOs, BeginLiabilityEnum beginLiabilityEnum) {
        Optional<UFDouble> optional_begin_liability = Optional.of(UFDouble.ZERO_DBL);
        if (beginLiabilityEnum == BeginLiabilityEnum.OLD) {
            if (UsufructAssetEnumJudge.isDiscountModeMonth365OrMonth360(this.addUsufructVO)) {
                if (this.willChangedDepAccrualViewVO.isPresent()) {
                    DepAccrualViewVO locateDepAccrualViewVO = this.willChangedDepAccrualViewVO.get();
                    UFDate locate_begin_date = locateDepAccrualViewVO.getBegin_date();
                    UFDouble begin_liability = locateDepAccrualViewVO.getBegin_liability();
                    if (locate_begin_date.isSameDate(this.discountingBeginDate)) {
                        optional_begin_liability = Optional.of(begin_liability);
                    } else {
                        UFDouble ratioOfNewSplitDaysOccupyTotalDays = this.getRatioOfNewSplitDaysOccupyTotalDays();
                        UFDouble interest = locateDepAccrualViewVO.getInterest();
                        UFDouble addInterest = UFDoubleUtils.multiply((UFDouble)ratioOfNewSplitDaysOccupyTotalDays, (UFDouble)interest);
                        UFDouble addInterestScale = FAScaleUtils.setScaleByCurrType((UFDouble)addInterest, (String)this.liabilityCalcParams.getPk_currency_origin(), (boolean)false);
                        UFDouble end_liability = locateDepAccrualViewVO.getEnd_liability();
                        UFDouble calc_cash = locateDepAccrualViewVO.getCalc_cash();
                        if (UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(this.addUsufructVO)) {
                            UFDouble sub = UFDoubleUtils.sub((UFDouble)end_liability, (UFDouble)addInterestScale);
                            optional_begin_liability = Optional.of(sub);
                        } else {
                            UFDouble sub = UFDoubleUtils.sub((UFDouble)UFDoubleUtils.add((UFDouble)end_liability, (UFDouble)calc_cash), (UFDouble)addInterestScale);
                            optional_begin_liability = Optional.of(sub);
                        }
                    }
                }
            } else {
                Optional<DepAccrualViewVO> depAccrualViewVO = UsufructAssetEnumJudge.isDiscountModeMonth(this.addUsufructVO) ? Stream.of(depAccrualViewVOs).filter(vo -> vo.getStatus() != 3).filter(vo -> vo.getBegin_date().isSameDate(this.discountingBeginDate)).findFirst() : Stream.of(depAccrualViewVOs).filter(vo -> vo.getStatus() != 3).filter(vo -> vo.getBegin_date().isSameDate(this.discountingBeginDate) && UFBoolean.FALSE.equals((Object)vo.getIsaccruedbymonth())).findFirst();
                if (depAccrualViewVO.isPresent()) {
                    optional_begin_liability = Optional.of(depAccrualViewVO.get().getBegin_liability());
                }
            }
        } else if (ArrayUtils.isNotEmpty((Object[])depAccrualViewVOs)) {
            optional_begin_liability = Optional.of(depAccrualViewVOs[0].getBegin_liability());
        }
        UsufructAssetCalculator.setBeginLiability(optional_begin_liability.get(), beginLiabilityEnum, this.addUsufructVO);
    }

    private void reduceLiability(List<LiabilityPubVO> liabilityvos) {
        Iterator<LiabilityPubVO> it = liabilityvos.iterator();
        while (it.hasNext()) {
            LiabilityPubVO vo = it.next();
            UFDate begin_date = vo.getBegin_date();
            if (begin_date.beforeDate(this.discountingBeginDate)) {
                it.remove();
                continue;
            }
            return;
        }
    }

    private static class SplitDateBackup {
        private final RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs;
        private final UFDate discountingBeginDate;
        private final UsufructAssetViewVO addUsufructVO;
        int rentPaymentPlanViewVOBackupIndex;
        RentPaymentPlanViewVO backupSplitRentPaymentPlanViewVO;

        public SplitDateBackup(RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs, UFDate discountingBeginDate, UsufructAssetViewVO addUsufructVO) {
            this.addRentPaymentPlanViewVOs = addRentPaymentPlanViewVOs;
            this.discountingBeginDate = discountingBeginDate;
            this.addUsufructVO = addUsufructVO;
        }

        public void split() {
            this.rentPaymentPlanViewVOBackupIndex = 0;
            RentPaymentPlanViewVO splitRentPaymentPlanViewVO = this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex];
            if (UsufructAssetEnumJudge.isRentTypeEnumRent_advance(splitRentPaymentPlanViewVO)) {
                splitRentPaymentPlanViewVO = this.addRentPaymentPlanViewVOs[++this.rentPaymentPlanViewVOBackupIndex];
            }
            this.backupSplitRentPaymentPlanViewVO = (RentPaymentPlanViewVO)((Object)CloneUtil.clone((Object)((Object)splitRentPaymentPlanViewVO)));
            UFDate start_date = splitRentPaymentPlanViewVO.getStart_date();
            splitRentPaymentPlanViewVO.setStart_date(this.discountingBeginDate);
            if (!start_date.isSameDate(this.discountingBeginDate)) {
                splitRentPaymentPlanViewVO.setSubsection_type("not_full_period");
            }
            if (UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(this.addUsufructVO) && start_date.beforeDate(this.discountingBeginDate)) {
                splitRentPaymentPlanViewVO.setCalculate_renttax(UFDouble.ZERO_DBL);
                splitRentPaymentPlanViewVO.setCalculate_tax(UFDouble.ZERO_DBL);
                splitRentPaymentPlanViewVO.setCalculate_rentnotax(UFDouble.ZERO_DBL);
                splitRentPaymentPlanViewVO.setAdjustment_renttax(UFDouble.ZERO_DBL);
            }
        }

        public void resume() {
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex].setStart_date(this.backupSplitRentPaymentPlanViewVO.getStart_date());
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex].setCalculate_renttax(this.backupSplitRentPaymentPlanViewVO.getCalculate_renttax());
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex].setCalculate_tax(this.backupSplitRentPaymentPlanViewVO.getCalculate_tax());
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex].setCalculate_rentnotax(this.backupSplitRentPaymentPlanViewVO.getCalculate_rentnotax());
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex].setAdjustment_renttax(this.backupSplitRentPaymentPlanViewVO.getAdjustment_renttax());
            this.addRentPaymentPlanViewVOs[this.rentPaymentPlanViewVOBackupIndex] = this.backupSplitRentPaymentPlanViewVO;
        }
    }
}

